/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli.extensions;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.cli.extensions.ImmutableCollections;
import org.apache.maven.api.cli.extensions.InputLocation;
import org.apache.maven.api.cli.extensions.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CoreExtensions
implements Serializable,
InputLocationTracker {
    final String namespaceUri;
    final String modelEncoding;
    final List<CoreExtension> extensions;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected CoreExtensions(Builder builder) {
        String string = builder.namespaceUri != null ? builder.namespaceUri : (this.namespaceUri = builder.base != null ? builder.base.namespaceUri : null);
        String string2 = builder.modelEncoding != null ? builder.modelEncoding : (this.modelEncoding = builder.base != null ? builder.base.modelEncoding : "UTF-8");
        this.extensions = ImmutableCollections.copy(builder.extensions != null ? builder.extensions : (builder.base != null ? builder.base.extensions : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<CoreExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return CoreExtensions.newBuilder(this);
    }

    @Nonnull
    public CoreExtensions withExtensions(Collection<CoreExtension> extensions) {
        return CoreExtensions.newBuilder(this, true).extensions(extensions).build();
    }

    @Nonnull
    public static CoreExtensions newInstance() {
        return CoreExtensions.newInstance(true);
    }

    @Nonnull
    public static CoreExtensions newInstance(boolean withDefaults) {
        return CoreExtensions.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CoreExtensions.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtensions from) {
        return CoreExtensions.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtensions from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        CoreExtensions base;
        String namespaceUri;
        String modelEncoding;
        Collection<CoreExtension> extensions;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(CoreExtensions base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.extensions = base.extensions;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<CoreExtension> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public CoreExtensions build() {
            if (this.base != null && (this.extensions == null || this.extensions == this.base.extensions)) {
                return this.base;
            }
            return new CoreExtensions(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

