/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeStrategy;
import org.jdom2.Document;

public abstract class AbstractUpgradeStrategy
implements UpgradeStrategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UpgradeResult apply(UpgradeContext context, Map<Path, Document> pomMap) {
        context.info(this.getDescription());
        context.indent();
        try {
            UpgradeResult result = this.doApply(context, pomMap);
            this.logSummary(context, result);
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
        catch (Exception e) {
            context.failure("Strategy execution failed: " + e.getMessage());
            UpgradeResult upgradeResult = UpgradeResult.failure(pomMap.keySet(), Set.of());
            return upgradeResult;
        }
        finally {
            context.unindent();
        }
    }

    protected abstract UpgradeResult doApply(UpgradeContext var1, Map<Path, Document> var2);

    protected final UpgradeOptions getOptions(UpgradeContext context) {
        return context.options();
    }

    protected void logSummary(UpgradeContext context, UpgradeResult result) {
        context.println();
        context.info(this.getDescription() + " Summary:");
        context.indent();
        context.info(result.modifiedCount() + " POM(s) modified");
        context.info(result.unmodifiedCount() + " POM(s) needed no changes");
        if (result.errorCount() > 0) {
            context.info(result.errorCount() + " POM(s) had errors");
        }
        context.unindent();
    }
}

