/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.CacheUtils;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Named
@Singleton
public class DefaultPluginArtifactsCache
implements PluginArtifactsCache {
    protected final Map<PluginArtifactsCache.Key, PluginArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<PluginArtifactsCache.Key, PluginArtifactsCache.CacheRecord>();

    @Override
    public PluginArtifactsCache.Key createKey(Plugin plugin, DependencyFilter extensionFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return new CacheKey(plugin, extensionFilter, repositories, session);
    }

    @Override
    public PluginArtifactsCache.CacheRecord get(PluginArtifactsCache.Key key) throws PluginResolutionException {
        PluginArtifactsCache.CacheRecord cacheRecord = this.cache.get(key);
        if (cacheRecord != null && cacheRecord.getException() != null) {
            throw cacheRecord.getException();
        }
        return cacheRecord;
    }

    @Override
    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, List<Artifact> pluginArtifacts) {
        Objects.requireNonNull(pluginArtifacts, "pluginArtifacts cannot be null");
        this.assertUniqueKey(key);
        PluginArtifactsCache.CacheRecord record = new PluginArtifactsCache.CacheRecord(Collections.unmodifiableList(new ArrayList<Artifact>(pluginArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    protected void assertUniqueKey(PluginArtifactsCache.Key key) {
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate artifact resolution result for plugin " + String.valueOf(key));
        }
    }

    @Override
    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, PluginResolutionException exception) {
        Objects.requireNonNull(exception, "exception cannot be null");
        this.assertUniqueKey(key);
        PluginArtifactsCache.CacheRecord record = new PluginArtifactsCache.CacheRecord(exception);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project, PluginArtifactsCache.Key cacheKey, PluginArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements PluginArtifactsCache.Key {
        private final Plugin plugin;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final DependencyFilter filter;
        private final int hashCode;

        public CacheKey(Plugin plugin, DependencyFilter extensionFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.plugin = plugin.clone();
            this.workspace = RepositoryUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.filter = extensionFilter;
            int hash = 17;
            hash = hash * 31 + CacheUtils.pluginHashCode(plugin);
            hash = hash * 31 + Objects.hashCode(this.workspace);
            hash = hash * 31 + Objects.hashCode(this.localRepo);
            hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
            this.hashCode = hash = hash * 31 + Objects.hashCode(extensionFilter);
        }

        public String toString() {
            return this.plugin.getId();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CacheKey) {
                CacheKey that = (CacheKey)o;
                return CacheUtils.pluginEquals(this.plugin, that.plugin) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.localRepo, that.localRepo) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories) && Objects.equals(this.filter, that.filter);
            }
            return false;
        }
    }
}

