/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.SettingsBuilder;
import org.apache.maven.cling.extensions.BootstrapCoreExtensionManager;
import org.apache.maven.cling.extensions.ExtensionConfigurationModule;
import org.apache.maven.cling.extensions.LoadedCoreExtension;
import org.apache.maven.cling.invoker.CliUtils;
import org.apache.maven.cling.invoker.ContainerCapsule;
import org.apache.maven.cling.invoker.ContainerCapsuleFactory;
import org.apache.maven.cling.invoker.CoreExtensionSelector;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.PlexusContainerCapsule;
import org.apache.maven.cling.logging.Slf4jLoggerManager;
import org.apache.maven.di.Injector;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.internal.impl.DefaultLookup;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.LoggerManager;
import org.slf4j.ILoggerFactory;

public class PlexusContainerCapsuleFactory<C extends LookupContext>
implements ContainerCapsuleFactory<C> {
    @Override
    public ContainerCapsule createContainerCapsule(LookupInvoker<C> invoker, C context, CoreExtensionSelector<C> coreExtensionSelector) throws Exception {
        Objects.requireNonNull(invoker, "invoker");
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(coreExtensionSelector, "coreExtensionSelector");
        return new PlexusContainerCapsule((LookupContext)context, Thread.currentThread().getContextClassLoader(), this.container(invoker, context, coreExtensionSelector));
    }

    protected DefaultPlexusContainer container(LookupInvoker<C> invoker, C context, CoreExtensionSelector<C> coreExtensionSelector) throws Exception {
        ClassWorld classWorld = Objects.requireNonNull((ClassWorld)invoker.protoLookup.lookup(ClassWorld.class), "classWorld");
        ClassRealm coreRealm = classWorld.getClassRealm("plexus.core");
        List<Path> extClassPath = this.parseExtClasspath(context);
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<LoadedCoreExtension> loadedExtensions = this.loadCoreExtensions(invoker, context, coreRealm, coreEntry.getExportedArtifacts(), coreExtensionSelector.selectCoreExtensions(invoker, context));
        List<CoreExtensionEntry> loadedExtensionsEntries = loadedExtensions.stream().map(LoadedCoreExtension::entry).toList();
        ClassRealm containerRealm = this.setupContainerRealm(((LookupContext)context).logger, classWorld, coreRealm, extClassPath, loadedExtensionsEntries);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setStrictClassPathScanning(false).setName("maven");
        this.customizeContainerConfiguration(context, cc);
        CoreExports exports = new CoreExports(containerRealm, this.collectExportedArtifacts(coreEntry, loadedExtensionsEntries), this.collectExportedPackages(coreEntry, loadedExtensionsEntries));
        Thread.currentThread().setContextClassLoader((ClassLoader)containerRealm);
        final DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{this.getCustomModule(context, exports)});
        container.setLookupRealm(null);
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        container.setLoggerManager(this.createLoggerManager());
        ProtoSession protoSession = ((LookupContext)context).protoSession;
        UnaryOperator extensionSource = expression -> {
            String value = (String)protoSession.getUserProperties().get(expression);
            if (value == null) {
                value = (String)protoSession.getSystemProperties().get(expression);
            }
            return value;
        };
        final ArrayList failures = new ArrayList();
        for (final LoadedCoreExtension extension : loadedExtensions) {
            container.discoverComponents(extension.entry().getClassRealm(), new Module[]{new AbstractModule(this){
                final /* synthetic */ PlexusContainerCapsuleFactory this$0;
                {
                    this.this$0 = this$0;
                }

                protected void configure() {
                    try {
                        ((Injector)container.lookup(Injector.class)).discover((ClassLoader)extension.entry().getClassRealm());
                    }
                    catch (Throwable e) {
                        failures.add(new IllegalStateException("Injection failure in " + extension.coreExtension().getId(), e));
                    }
                }
            }, new SessionScopeModule((SessionScope)container.lookup(SessionScope.class)), new MojoExecutionScopeModule((MojoExecutionScope)container.lookup(MojoExecutionScope.class)), new ExtensionConfigurationModule(extension.entry(), extensionSource)});
        }
        if (!failures.isEmpty()) {
            IllegalStateException mavenDiFailed = new IllegalStateException("Maven dependency injection failed for at least one of the registered core extension");
            failures.forEach(mavenDiFailed::addSuppressed);
            throw mavenDiFailed;
        }
        container.getLoggerManager().setThresholds(CliUtils.toPlexusLoggingLevel(((LookupContext)context).loggerLevel));
        this.customizeContainer(context, (PlexusContainer)container);
        return container;
    }

    protected Set<String> collectExportedArtifacts(CoreExtensionEntry coreEntry, List<CoreExtensionEntry> extensionEntries) {
        HashSet<String> exportedArtifacts = new HashSet<String>(coreEntry.getExportedArtifacts());
        for (CoreExtensionEntry extension : extensionEntries) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
        }
        return exportedArtifacts;
    }

    protected Set<String> collectExportedPackages(CoreExtensionEntry coreEntry, List<CoreExtensionEntry> extensionEntries) {
        HashSet<String> exportedPackages = new HashSet<String>(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensionEntries) {
            exportedPackages.addAll(extension.getExportedPackages());
        }
        return exportedPackages;
    }

    protected Module getCustomModule(C context, CoreExports exports) {
        return new AbstractModule(this, (LookupContext)context, exports){
            final /* synthetic */ LookupContext val$context;
            final /* synthetic */ CoreExports val$exports;
            final /* synthetic */ PlexusContainerCapsuleFactory this$0;
            {
                this.val$context = lookupContext;
                this.val$exports = coreExports;
                this.this$0 = this$0;
            }

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)this.val$context.loggerFactory);
                this.bind(CoreExports.class).toInstance((Object)this.val$exports);
                this.bind(MessageBuilderFactory.class).toInstance((Object)this.val$context.invokerRequest.messageBuilderFactory());
            }
        };
    }

    protected LoggerManager createLoggerManager() {
        return new Slf4jLoggerManager();
    }

    protected void customizeContainerConfiguration(C context, ContainerConfiguration configuration) throws Exception {
    }

    protected void customizeContainer(C context, PlexusContainer container) throws Exception {
    }

    protected List<Path> parseExtClasspath(C context) throws Exception {
        ProtoSession protoSession = ((LookupContext)context).protoSession;
        String extClassPath = (String)protoSession.getUserProperties().get("maven.ext.class.path");
        if (extClassPath == null && (extClassPath = (String)protoSession.getSystemProperties().get("maven.ext.class.path")) != null) {
            ((LookupContext)context).logger.warn("The property 'maven.ext.class.path' has been set using a JVM system property which is deprecated. The property can be passed as a Maven argument or in the Maven project configuration file,usually located at ${session.rootDirectory}/.mvn/maven.properties.");
        }
        ArrayList<Path> jars = new ArrayList<Path>();
        if (extClassPath != null && !extClassPath.isEmpty()) {
            for (String jar : extClassPath.split(File.pathSeparator)) {
                Path file = ((LookupContext)context).cwd.resolve(jar);
                ((LookupContext)context).logger.debug("  included '" + String.valueOf(file) + "'");
                jars.add(file);
            }
        }
        return jars;
    }

    protected ClassRealm setupContainerRealm(Logger logger, ClassWorld classWorld, ClassRealm coreRealm, List<Path> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            logger.debug("Populating class realm '" + extRealm.getId() + "'");
            for (Path file : extClassPath) {
                logger.debug("  included '" + String.valueOf(file) + "'");
                extRealm.addURL(file.toUri().toURL());
            }
            ArrayList<CoreExtensionEntry> reversed = new ArrayList<CoreExtensionEntry>(extensions);
            Collections.reverse(reversed);
            for (CoreExtensionEntry entry : reversed) {
                Set exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom((ClassLoader)realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadedCoreExtension> loadCoreExtensions(LookupInvoker<C> invoker, C context, ClassRealm containerRealm, Set<String> providedArtifacts, List<CoreExtension> extensions) throws Exception {
        if (extensions.isEmpty()) {
            return List.of();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(containerRealm.getWorld()).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setStrictClassPathScanning(false).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(this, (LookupContext)context){
            final /* synthetic */ LookupContext val$context;
            final /* synthetic */ PlexusContainerCapsuleFactory this$0;
            {
                this.val$context = lookupContext;
                this.this$0 = this$0;
            }

            protected void configure() {
                this.bind(ILoggerFactory.class).toProvider(() -> context.loggerFactory);
            }
        }});
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Runnable settingsCleaner = null;
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(this.createLoggerManager());
            container.getLoggerManager().setThresholds(CliUtils.toPlexusLoggingLevel(((LookupContext)context).loggerLevel));
            Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
            settingsCleaner = invoker.settings(context, false, (SettingsBuilder)container.lookup(SettingsBuilder.class));
            DefaultMavenExecutionRequest mer = new DefaultMavenExecutionRequest();
            invoker.populateRequest(context, (Lookup)new DefaultLookup((PlexusContainer)container), (MavenExecutionRequest)mer);
            mer = ((MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class)).populateDefaults((MavenExecutionRequest)mer);
            List<LoadedCoreExtension> list = Collections.unmodifiableList(((BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class)).loadCoreExtensions((MavenExecutionRequest)mer, providedArtifacts, extensions));
            return list;
        }
        finally {
            if (settingsCleaner != null) {
                settingsCleaner.run();
            }
            try {
                container.dispose();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }
}

