/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;

@Experimental
@Immutable
public interface ArtifactCoordinatesFactoryRequest
extends Request<Session> {
    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public String getClassifier();

    public String getExtension();

    public String getType();

    public String getCoordinatesString();

    @Nonnull
    public static ArtifactCoordinatesFactoryRequest build(@Nonnull Session session, String groupId, String artifactId, String version, String extension) {
        return ArtifactCoordinatesFactoryRequest.builder().session(Objects.requireNonNull(session, "session")).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build();
    }

    @Nonnull
    public static ArtifactCoordinatesFactoryRequest build(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ArtifactCoordinatesFactoryRequest.builder().session(Objects.requireNonNull(session, "session")).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build();
    }

    @Nonnull
    public static ArtifactCoordinatesFactoryRequest build(@Nonnull Session session, @Nonnull String coordinateString) {
        return ArtifactCoordinatesFactoryRequest.builder().session(Objects.requireNonNull(session, "session")).coordinateString(Objects.requireNonNull(coordinateString, "coordinateString")).build();
    }

    @Nonnull
    public static ArtifactCoordinatesFactoryRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinates coordinates) {
        return ArtifactCoordinatesFactoryRequest.builder().session(Objects.requireNonNull(session, "session")).groupId(Objects.requireNonNull(coordinates, "coordinates").getGroupId()).artifactId(coordinates.getArtifactId()).classifier(coordinates.getClassifier()).version(coordinates.getVersionConstraint().toString()).extension(coordinates.getExtension()).build();
    }

    public static ArtifactFactoryRequestBuilder builder() {
        return new ArtifactFactoryRequestBuilder();
    }

    @NotThreadSafe
    public static class ArtifactFactoryRequestBuilder {
        private Session session;
        private RequestTrace trace;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String extension;
        private String type;
        private String coordinateString;

        ArtifactFactoryRequestBuilder() {
        }

        public ArtifactFactoryRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ArtifactFactoryRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public ArtifactFactoryRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ArtifactFactoryRequestBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public ArtifactFactoryRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ArtifactFactoryRequestBuilder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public ArtifactFactoryRequestBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public ArtifactFactoryRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ArtifactFactoryRequestBuilder coordinateString(String coordinateString) {
            this.coordinateString = coordinateString;
            return this;
        }

        public ArtifactCoordinatesFactoryRequest build() {
            return new DefaultArtifactFactoryRequestArtifact(this.session, this.trace, this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.type, this.coordinateString);
        }

        private static class DefaultArtifactFactoryRequestArtifact
        extends BaseRequest<Session>
        implements ArtifactCoordinatesFactoryRequest {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String classifier;
            private final String extension;
            private final String type;
            private final String coordinatesString;

            DefaultArtifactFactoryRequestArtifact(@Nonnull Session session, RequestTrace trace, String groupId, String artifactId, String version, String classifier, String extension, String type, String coordinatesString) {
                super(session, trace);
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.classifier = classifier;
                this.extension = extension;
                this.type = type;
                this.coordinatesString = coordinatesString;
            }

            @Override
            public String getGroupId() {
                return this.groupId;
            }

            @Override
            public String getArtifactId() {
                return this.artifactId;
            }

            @Override
            public String getVersion() {
                return this.version;
            }

            @Override
            public String getClassifier() {
                return this.classifier;
            }

            @Override
            public String getExtension() {
                return this.extension;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public String getCoordinatesString() {
                return this.coordinatesString;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultArtifactFactoryRequestArtifact)) return false;
                DefaultArtifactFactoryRequestArtifact that = (DefaultArtifactFactoryRequestArtifact)o;
                if (!Objects.equals(this.groupId, that.groupId)) return false;
                if (!Objects.equals(this.artifactId, that.artifactId)) return false;
                if (!Objects.equals(this.version, that.version)) return false;
                if (!Objects.equals(this.classifier, that.classifier)) return false;
                if (!Objects.equals(this.extension, that.extension)) return false;
                if (!Objects.equals(this.type, that.type)) return false;
                if (!Objects.equals(this.coordinatesString, that.coordinatesString)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.type, this.coordinatesString);
            }

            @Override
            public String toString() {
                return "ArtifactFactoryRequestArtifact[groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', classifier='" + this.classifier + "', extension='" + this.extension + "', type='" + this.type + "', coordinatesString='" + this.coordinatesString + "']";
            }
        }
    }
}

