%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  SPDX-FileCopyrightText: 1998-2026 Paulo Moura <pmoura@logtalk.org>
%  SPDX-License-Identifier: Apache-2.0
%
%  Licensed under the Apache License, Version 2.0 (the "License");
%  you may not use this file except in compliance with the License.
%  You may obtain a copy of the License at
%
%      http://www.apache.org/licenses/LICENSE-2.0
%
%  Unless required by applicable law or agreed to in writing, software
%  distributed under the License is distributed on an "AS IS" BASIS,
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%  See the License for the specific language governing permissions and
%  limitations under the License.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- if((
	current_logtalk_flag(prolog_dialect, Dialect),
	Dialect \== eclipse, Dialect \== gnu,
	Dialect \== sicstus, Dialect \== swi,
	Dialect \== trealla, Dialect \== xvm
)).

	:- initialization((
		write('(not applicable)'), nl
	)).

:- elif((
	current_logtalk_flag(prolog_dialect, trealla),
	current_prolog_flag(version_data, trealla(Major, Minor, Patch, _)),
	v(Major, Minor, Patch) @< v(2, 90, 3)
)).

	:- initialization((
		write('(not applicable)'), nl
	)).

:- else.

	:- initialization((
		set_logtalk_flag(report, warnings),
		logtalk_load(basic_types(loader)),
		logtalk_load(os(loader)),
		logtalk_load(sockets(loader)),
		logtalk_load(term_io(loader)),
		logtalk_load([amqp, amqp_pool], [source_data(on), debug(on)]),
		logtalk_load(lgtunit(loader)),
		logtalk_load([tests, tests_pool], [hook(lgtunit)]),
		lgtunit::run_test_sets([tests, tests_pool])
	)).

:- endif.
