/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.chars.CharComparator;
import java.io.Serializable;

public final class CharArrays {
    public static final char[] EMPTY_ARRAY = new char[0];
    public static final char[] DEFAULT_EMPTY_ARRAY = new char[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<char[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(char[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            CharArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c, CharComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(char[] a, int from2, int to, CharComparator comp) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            char u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(char[] a, int from2, int to, CharComparator comp) {
        int i = from2;
        while (++i < to) {
            char t = a[i];
            int j = i;
            char u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(char[] x, int from2, int to, CharComparator comp) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = CharArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = CharArrays.med3(x, m - s, m, m + s, comp);
            n = CharArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = CharArrays.med3(x, l, m, n, comp);
        char v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        CharArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        CharArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            CharArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(char[] x, int a, int b, int c) {
        int ab = Character.compare(x[a], x[b]);
        int ac = Character.compare(x[a], x[c]);
        int bc = Character.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(char[] a, int from2, int to) {
        for (int i = from2; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            char u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    public static void quickSort(char[] x, int from2, int to) {
        int c;
        int a;
        int len = to - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = CharArrays.med3(x, l, l + s, l + 2 * s);
            m = CharArrays.med3(x, m - s, m, m + s);
            n = CharArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = CharArrays.med3(x, l, m, n);
        char v = x[m];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Character.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Character.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from2, b - a);
        CharArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, to - d - 1);
        CharArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            CharArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(char[] a, int from2, int to) {
        if (to - from2 >= 2000) {
            CharArrays.radixSort(a, from2, to);
        } else {
            CharArrays.quickSort(a, from2, to);
        }
    }

    public static void unstableSort(char[] a) {
        CharArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(char[] a, int from2, int to, CharComparator comp) {
        CharArrays.quickSort(a, from2, to, comp);
    }

    public static void unstableSort(char[] a, CharComparator comp) {
        CharArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(char[] a, int from2, int to, CharComparator comp, char[] supp) {
        int len = to - from2;
        if (len < 16) {
            CharArrays.insertionSort(a, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from2 + to >>> 1;
        CharArrays.mergeSort(supp, from2, mid, comp, a);
        CharArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a, int from2, int to, CharComparator comp) {
        CharArrays.mergeSort(a, from2, to, comp, null);
    }

    public static void stableSort(char[] a, int from2, int to, CharComparator comp) {
        CharArrays.mergeSort(a, from2, to, comp);
    }

    public static void stableSort(char[] a, CharComparator comp) {
        CharArrays.stableSort(a, 0, a.length, comp);
    }

    public static void radixSort(char[] a, int from2, int to) {
        if (to - from2 < 1024) {
            CharArrays.quickSort(a, from2, to);
            return;
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            int shift = (1 - level % 2) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = a[i] >>> shift & 0xFF ^ 0;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            int end = first + length - count[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count[c]) {
                char t = a[i3];
                c = t >>> shift & 0xFF ^ 0;
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        char z = t;
                        t = a[d];
                        a[d] = z;
                        c = t >>> shift & 0xFF ^ 0;
                    }
                    a[i3] = t;
                }
                if (level < 1 && count[c] > 1) {
                    if (count[c] < 1024) {
                        CharArrays.quickSort(a, i3, i3 + count[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(char[] a, char[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

