/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.catalog.swid.SwidTag;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.catalog.swid.SwidTagAware;
import org.jreleaser.model.internal.common.ArchiveOptions;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;

public final class ArchiveAssembler
extends AbstractAssembler<ArchiveAssembler, org.jreleaser.model.api.assemble.ArchiveAssembler>
implements SwidTagAware,
MatrixAware {
    private static final long serialVersionUID = -2986681943336636474L;
    private final Set<Archive.Format> formats = new LinkedHashSet<Archive.Format>();
    private final ArchiveOptions options = new ArchiveOptions();
    private final Matrix matrix = new Matrix();
    private String archiveName;
    private Boolean applyDefaultMatrix;
    private Boolean attachPlatform;
    private Distribution.DistributionType distributionType;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.ArchiveAssembler immutable = new org.jreleaser.model.api.assemble.ArchiveAssembler(){
        private static final long serialVersionUID = 3508112065751072495L;
        private Set<? extends Artifact> artifacts;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private List<? extends Glob> files;
        private Set<? extends Artifact> outputs;

        public String getArchiveName() {
            return ArchiveAssembler.this.archiveName;
        }

        public boolean isApplyDefaultMatrix() {
            return ArchiveAssembler.this.isApplyDefaultMatrix();
        }

        public boolean isAttachPlatform() {
            return ArchiveAssembler.this.isAttachPlatform();
        }

        public Set<Archive.Format> getFormats() {
            return Collections.unmodifiableSet(ArchiveAssembler.this.formats);
        }

        public org.jreleaser.model.api.common.ArchiveOptions getOptions() {
            return ArchiveAssembler.this.options.asImmutable();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return ArchiveAssembler.this.matrix.asImmutable();
        }

        public Platform getPlatform() {
            return ArchiveAssembler.this.getPlatform().asImmutable();
        }

        public SwidTag getSwid() {
            return ArchiveAssembler.this.getSwid().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return ArchiveAssembler.this.getDistributionType();
        }

        public String getType() {
            return ArchiveAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return ArchiveAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return ArchiveAssembler.this.isExported();
        }

        public String getName() {
            return ArchiveAssembler.this.getName();
        }

        public String getTemplateDirectory() {
            return ArchiveAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(ArchiveAssembler.this.getSkipTemplates());
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = ArchiveAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = ArchiveAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = ArchiveAssembler.this.getFiles().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = ArchiveAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return ArchiveAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return ArchiveAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArchiveAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return ArchiveAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ArchiveAssembler.this.getExtraProperties());
        }
    };

    public ArchiveAssembler() {
        super("archive");
    }

    @Override
    public org.jreleaser.model.api.assemble.ArchiveAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(Distribution.DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public void setDistributionType(String distributionType) {
        this.distributionType = Distribution.DistributionType.of((String)distributionType);
    }

    @Override
    public void merge(ArchiveAssembler source) {
        super.merge(source);
        this.archiveName = this.merge(this.archiveName, source.archiveName);
        this.distributionType = this.merge(this.distributionType, source.distributionType);
        this.applyDefaultMatrix = this.merge(this.applyDefaultMatrix, source.applyDefaultMatrix);
        this.attachPlatform = this.merge(this.attachPlatform, source.attachPlatform);
        this.setFormats(this.merge(this.formats, source.formats));
        this.setOptions(source.options);
        this.setMatrix(source.matrix);
    }

    public String getResolvedArchiveName(JReleaserContext context, Map<String, String> matrix) {
        TemplateContext props = context.fullProps();
        props.setAll(this.props(context));
        if (null != matrix) {
            props.setAll(CollectionUtils.mapOf((Object[])new Object[]{"matrix", matrix}));
        }
        String result = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.archiveName, (TemplateContext)props);
        if (this.isAttachPlatform()) {
            result = result + "-" + this.getPlatform().applyReplacements(PlatformUtils.getCurrentFull());
        }
        return result;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    public boolean isAttachPlatformSet() {
        return null != this.attachPlatform;
    }

    public boolean isAttachPlatform() {
        return null != this.attachPlatform && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public Set<Archive.Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<Archive.Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public void addFormat(Archive.Format format) {
        this.formats.add(format);
    }

    public void addFormat(String str) {
        this.formats.add(Archive.Format.of((String)str));
    }

    public ArchiveOptions getOptions() {
        return this.options;
    }

    public void setOptions(ArchiveOptions options) {
        this.options.merge(options);
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("archiveName", this.archiveName);
        props.put("distributionType", this.distributionType);
        props.put("applyDefaultMatrix", this.isApplyDefaultMatrix());
        props.put("attachPlatform", this.isAttachPlatform());
        props.put("formats", this.formats);
        props.put("options", this.options.asMap(full));
        this.matrix.asMap(props);
    }
}

