/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog.sbom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.catalog.sbom.AbstractSbomCataloger;
import org.jreleaser.model.internal.catalog.sbom.CyclonedxSbomCataloger;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.catalog.sbom.SyftSbomCataloger;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.StringUtils;

public final class Sbom
extends AbstractActivatable<Sbom>
implements Domain,
Activatable {
    private static final long serialVersionUID = 8210488305115310708L;
    private final CyclonedxSbomCataloger cyclonedx = new CyclonedxSbomCataloger();
    private final SyftSbomCataloger syft = new SyftSbomCataloger();
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.sbom.Sbom immutable = new org.jreleaser.model.api.catalog.sbom.Sbom(){
        private static final long serialVersionUID = 5388790360937381329L;

        public org.jreleaser.model.api.catalog.sbom.CyclonedxSbomCataloger getCyclonedx() {
            return Sbom.this.cyclonedx.asImmutable();
        }

        public org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger getSyft() {
            return Sbom.this.syft.asImmutable();
        }

        public Active getActive() {
            return Sbom.this.getActive();
        }

        public boolean isEnabled() {
            return Sbom.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Sbom.this.asMap(full));
        }
    };

    public Sbom() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.catalog.sbom.Sbom asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Sbom source) {
        super.merge(source);
        this.setSyft(source.syft);
        this.setCyclonedx(source.cyclonedx);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.cyclonedx.isSet() || this.syft.isSet();
    }

    public CyclonedxSbomCataloger getCyclonedx() {
        return this.cyclonedx;
    }

    public void setCyclonedx(CyclonedxSbomCataloger cyclonedx) {
        this.cyclonedx.merge(cyclonedx);
    }

    public SyftSbomCataloger getSyft() {
        return this.syft;
    }

    public void setSyft(SyftSbomCataloger syft) {
        this.syft.merge(syft);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.putAll(this.cyclonedx.asMap(full));
        map.putAll(this.syft.asMap(full));
        return map;
    }

    public <A extends SbomCataloger<?>> A findSbomCataloger(String type) {
        if (StringUtils.isBlank((String)type)) {
            throw new JReleaserException("SbomCataloger type must not be blank");
        }
        return this.resolveSbomCataloger(type);
    }

    public List<? extends SbomCataloger<?>> findAllActiveSbomCatalogers() {
        ArrayList<AbstractSbomCataloger> list = new ArrayList<AbstractSbomCataloger>();
        if (this.cyclonedx.isEnabled()) {
            list.add(this.getCyclonedx());
        }
        if (this.syft.isEnabled()) {
            list.add(this.getSyft());
        }
        return list;
    }

    private <A extends SbomCataloger<?>> A resolveSbomCataloger(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "cyclonedx": {
                return (A)this.getCyclonedx();
            }
            case "syft": {
                return (A)this.getSyft();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_cataloger", (Object[])new Object[]{name}));
    }
}

