/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.validation.assemble.ArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.DebAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JavaArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JlinkAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JpackageAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.NativeImageAssemblerResolver;
import org.jreleaser.util.Errors;

public final class AssemblersResolver {
    private AssemblersResolver() {
    }

    public static void resolveAssemblers(JReleaserContext context, Errors errors) {
        Environment environment = context.getModel().getEnvironment();
        if (environment.getBooleanProperty("skipAssembleResolvers")) {
            return;
        }
        context.getLogger().debug("assemble");
        if (!environment.getBooleanProperty("skipArchiveResolver")) {
            ArchiveAssemblerResolver.resolveArchiveOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipDebResolver")) {
            DebAssemblerResolver.resolveDebOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipJavaArchiveResolver")) {
            JavaArchiveAssemblerResolver.resolveJavaArchiveOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipJlinkResolver")) {
            JlinkAssemblerResolver.resolveJlinkOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipJpackageResolver")) {
            JpackageAssemblerResolver.resolveJpackageOutputs(context, errors);
        }
        if (!environment.getBooleanProperty("skipNativeImageResolver")) {
            NativeImageAssemblerResolver.resolveNativeImageOutputs(context, errors);
        }
    }
}

