/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.api.common.ArchiveOptions;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.TimeUtils;

public class ArchiveOptions
extends AbstractModelObject<ArchiveOptions>
implements Domain {
    private static final long serialVersionUID = -2360394060904246488L;
    private ZonedDateTime timestamp;
    private ArchiveOptions.TarMode longFileMode = ArchiveOptions.TarMode.ERROR;
    private ArchiveOptions.TarMode bigNumberMode = ArchiveOptions.TarMode.ERROR;
    @JsonIgnore
    private final org.jreleaser.model.api.common.ArchiveOptions immutable = new org.jreleaser.model.api.common.ArchiveOptions(){
        private static final long serialVersionUID = -4559383384992086381L;

        public ZonedDateTime getTimestamp() {
            return ArchiveOptions.this.timestamp;
        }

        public ArchiveOptions.TarMode getLongFileMode() {
            return ArchiveOptions.this.longFileMode;
        }

        public ArchiveOptions.TarMode getBigNumberMode() {
            return ArchiveOptions.this.bigNumberMode;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArchiveOptions.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.common.ArchiveOptions asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ArchiveOptions source) {
        this.timestamp = this.merge(this.timestamp, source.timestamp);
        this.longFileMode = this.merge(this.longFileMode, source.longFileMode);
        this.bigNumberMode = this.merge(this.bigNumberMode, source.bigNumberMode);
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = ZonedDateTime.parse(timestamp, TimeUtils.TIMESTAMP_FORMATTER);
    }

    public ArchiveOptions.TarMode getLongFileMode() {
        return this.longFileMode;
    }

    public void setLongFileMode(ArchiveOptions.TarMode longFileMode) {
        this.longFileMode = longFileMode;
    }

    public void setLongFileMode(String longFileMode) {
        this.setLongFileMode(ArchiveOptions.TarMode.of((String)longFileMode));
    }

    public ArchiveOptions.TarMode getBigNumberMode() {
        return this.bigNumberMode;
    }

    public void setBigNumberMode(ArchiveOptions.TarMode bigNumberMode) {
        this.bigNumberMode = bigNumberMode;
    }

    public void setBigNumberMode(String bigNumberMode) {
        this.setBigNumberMode(ArchiveOptions.TarMode.of((String)bigNumberMode));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("timestamp", this.timestamp);
        map.put("longFileMode", this.longFileMode);
        map.put("bigNumberMode", this.bigNumberMode);
        return map;
    }

    public FileUtils.ArchiveOptions toOptions() {
        return new FileUtils.ArchiveOptions().withTimestamp(this.timestamp).withLongFileMode(FileUtils.ArchiveOptions.TarMode.of((String)this.longFileMode.name())).withBigNumberMode(FileUtils.ArchiveOptions.TarMode.of((String)this.bigNumberMode.name()));
    }
}

