/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class MacportsPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.MacportsPackager, MacportsPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 6339866408211084697L;
    private final List<String> categories = new ArrayList<String>();
    private final List<String> maintainers = new ArrayList<String>();
    private final MacportsRepository repository = new MacportsRepository();
    private String packageName;
    private Integer revision;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.MacportsPackager immutable = new org.jreleaser.model.api.packagers.MacportsPackager(){
        private static final long serialVersionUID = 1625817436978161466L;

        public String getPackageName() {
            return MacportsPackager.this.packageName;
        }

        public Integer getRevision() {
            return MacportsPackager.this.revision;
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return MacportsPackager.this.repository.asImmutable();
        }

        public List<String> getCategories() {
            return Collections.unmodifiableList(MacportsPackager.this.categories);
        }

        public List<String> getMaintainers() {
            return Collections.unmodifiableList(MacportsPackager.this.maintainers);
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return MacportsPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return MacportsPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(MacportsPackager.this.getSkipTemplates());
        }

        public String getType() {
            return MacportsPackager.this.getType();
        }

        public String getDownloadUrl() {
            return MacportsPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return MacportsPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return MacportsPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return MacportsPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return MacportsPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return MacportsPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return MacportsPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return MacportsPackager.this.getActive();
        }

        public boolean isEnabled() {
            return MacportsPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(MacportsPackager.this.asMap(full));
        }

        public String getPrefix() {
            return MacportsPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(MacportsPackager.this.getExtraProperties());
        }
    };

    public MacportsPackager() {
        super("macports");
    }

    @Override
    public org.jreleaser.model.api.packagers.MacportsPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(MacportsPackager source) {
        super.merge(source);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.revision = this.merge(this.revision, source.revision);
        this.setRepository(source.repository);
        this.setCategories(this.merge(this.categories, source.categories));
        this.setMaintainers(this.merge(this.maintainers, source.maintainers));
    }

    public List<String> getResolvedMaintainers(JReleaserContext context) {
        String maintainer;
        GithubReleaser github;
        if (this.maintainers.isEmpty() && null != (github = context.getModel().getRelease().getGithub()) && StringUtils.isNotBlank((String)(maintainer = github.getUsername()))) {
            this.maintainers.add("@" + maintainer);
        }
        return this.maintainers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public MacportsRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MacportsRepository repository) {
        this.repository.merge(repository);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<String> getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(List<String> maintainers) {
        this.maintainers.clear();
        this.maintainers.addAll(maintainers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("revision", this.revision);
        props.put("categories", this.categories);
        props.put("maintainers", this.maintainers);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) && PlatformUtils.isIntel((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipMacports"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.DMG.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class MacportsRepository
    extends PackagerRepository {
        private static final long serialVersionUID = 2162971034366096607L;

        public MacportsRepository() {
            super("macports", "macports");
        }
    }
}

