/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.model.internal.common.Http;
import org.jreleaser.model.internal.common.HttpDelegate;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class HttpAnnouncer
extends AbstractAnnouncer<HttpAnnouncer, org.jreleaser.model.api.announce.HttpAnnouncer>
implements Http {
    private static final long serialVersionUID = -8348542653717001938L;
    private final HttpDelegate delegate = new HttpDelegate();
    private String url;
    private String payload;
    private String payloadTemplate;
    private String bearerKeyword;
    @JsonIgnore
    private final org.jreleaser.model.api.announce.HttpAnnouncer immutable = new org.jreleaser.model.api.announce.HttpAnnouncer(){
        private static final long serialVersionUID = -2918111244399624143L;

        public String getType() {
            return "http";
        }

        public Http.Method getMethod() {
            return HttpAnnouncer.this.getMethod();
        }

        public String getUrl() {
            return HttpAnnouncer.this.url;
        }

        public String getPayload() {
            return HttpAnnouncer.this.payload;
        }

        public String getPayloadTemplate() {
            return HttpAnnouncer.this.payloadTemplate;
        }

        public String getUsername() {
            return HttpAnnouncer.this.getUsername();
        }

        public String getPassword() {
            return HttpAnnouncer.this.getPassword();
        }

        public Http.Authorization getAuthorization() {
            return HttpAnnouncer.this.getAuthorization();
        }

        public String getBearerKeyword() {
            return HttpAnnouncer.this.getBearerKeyword();
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(HttpAnnouncer.this.getHeaders());
        }

        public String getName() {
            return HttpAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return HttpAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return HttpAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return HttpAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return HttpAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return HttpAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return HttpAnnouncer.this.getReadTimeout();
        }
    };

    public HttpAnnouncer() {
        super("");
    }

    @Override
    public org.jreleaser.model.api.announce.HttpAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpAnnouncer source) {
        super.merge(source);
        this.delegate.merge(this.delegate);
        this.url = this.merge(this.url, source.url);
        this.bearerKeyword = this.merge(this.bearerKeyword, source.bearerKeyword);
        this.payload = this.merge(this.payload, source.payload);
        this.payloadTemplate = this.merge(this.payloadTemplate, source.payloadTemplate);
    }

    @Override
    public String prefix() {
        return "http";
    }

    public String getResolvedUrl(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)this.url, (TemplateContext)props);
    }

    public String getResolvedPayload(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getChangelog().apply(props);
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)this.payload, (TemplateContext)props);
    }

    public String getResolvedPayloadTemplate(JReleaserContext context, TemplateContext extraProps) {
        TemplateContext props = context.fullProps();
        context.getChangelog().apply(props);
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context.getModel()));
        props.setAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.payloadTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, (TemplateContext)props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public Http.Method getMethod() {
        return this.delegate.getMethod();
    }

    public void setMethod(Http.Method method) {
        this.delegate.setMethod(method);
    }

    public void setMethod(String method) {
        this.delegate.setMethod(method);
    }

    public Http.Authorization getAuthorization() {
        return this.delegate.getAuthorization();
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.delegate.setAuthorization(authorization);
    }

    @Override
    public void setAuthorization(String authorization) {
        this.delegate.setAuthorization(authorization);
    }

    public Map<String, String> getHeaders() {
        return this.delegate.getHeaders();
    }

    public void setHeaders(Map<String, String> headers) {
        this.delegate.setHeaders(headers);
    }

    public String getBearerKeyword() {
        return this.bearerKeyword;
    }

    public void setBearerKeyword(String bearerKeyword) {
        this.bearerKeyword = bearerKeyword;
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        return this.delegate.resolveAuthorization();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayloadTemplate() {
        return this.payloadTemplate;
    }

    public void setPayloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("url", this.url);
        this.delegate.asMap(props);
        props.put("bearerKeyword", this.bearerKeyword);
        props.put("payload", this.payload);
        props.put("payloadTemplate", this.payloadTemplate);
    }
}

