/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.telegram;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.telegram.TelegramException;
import org.jreleaser.sdk.telegram.api.Message;
import org.jreleaser.sdk.telegram.api.TelegramAPI;
import org.jreleaser.util.StringUtils;

public class TelegramSdk {
    private final JReleaserContext context;
    private final TelegramAPI api;
    private final boolean dryrun;

    private TelegramSdk(JReleaserContext context, String apiHost, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        this.context = context;
        this.dryrun = dryrun;
        this.api = (TelegramAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).target(TelegramAPI.class, apiHost);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void sendMessage(String chatId, String message) throws TelegramException {
        Message payload = Message.of(chatId, message);
        this.context.getLogger().debug("telegram.message: " + payload);
        this.wrap(() -> this.api.sendMessage(payload));
    }

    private void wrap(Runnable runnable) throws TelegramException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + ": " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new TelegramException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Telegram"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String apiHost;
        private String token;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder token(String token) {
            this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.token, (String)"'token' must not be blank");
            if (StringUtils.isBlank((String)this.apiHost)) {
                this.apiHost("https://api.telegram.org/bot");
            }
            if (!this.apiHost.endsWith(this.token)) {
                this.apiHost = this.apiHost + this.token;
            }
        }

        public TelegramSdk build() {
            this.validate();
            return new TelegramSdk(this.context, this.apiHost, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

