#!/bin/sh
if [ -d "imager-src-$1" ]; then
  echo "Moving to imager-src-$1"
elif [ -d "imager-$1" ]; then
  mv imager-$1 imager-src-$1
  source admin/imager-env.sh -o openmp
elif [ -f "imager-$1.tar.gz" ]; then
  tar -xvf imager-$1.tar.gz
  mv imager-$1 imager-src-$1
else 
  echo "No such version $1"
  return
fi
# Patch until imager-env.sh has been updated
export my_exedir=$PWD/imager-exe-$1 # Patch
cd imager-src-$1
source admin/imager-env.sh -o openmp
export gagexedir=$my_exedir         # Patch
echo $gagexedir # Patch
#
# get confirmation
read -t 10 -p "Ready to compile Imager in $gagsrcdir. Continue (y/N)? " answer
# if answer is yes within 10 seconds start updating cluster nodes ...
if [ "${answer}" == "y" ]
then
  make -j16
fi
#
unset answer
read -t 10 -p "Ready to install Imager on $gagexedir. Continue (y/N)? " answer
if [ "${answer}" == "y" ]
then
  make install
fi
cd ..
