!    
!> Tools that should be in SIC  
subroutine no_logstack
  !* 
  ! IMAGER -- Ensure that previous command is not written in the 
  !  Stack or LogFile.
  !  Some otherwise "normal" commands require this after some
  !  interactive use
  !!
  character(len=12) :: comm, argum
  logical :: error
  integer :: nc
  !
  !! The trick is to parse a command with a '*NAME' definition
  !! so that SIC\ considers nothing should be done.
  error = .false.
  argum = 'LOG' ! 'MASK' or any command with a '*COMM' definition
  nc = len_trim(argum)
  comm = ' '
  call sic_analyse(comm,argum,nc,error)
end subroutine no_logstack
!
subroutine log_stack_comm(line,error)
  use gkernel_interfaces, only : sic_ch, sic_insert, sic_log
  use imager_interfaces, only : map_message
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Support routine for command  
  !    [CLEAN\]LOG "Command Argums... /Option..." B|F|S
  !
  ! Insert a command line in Stack and/or Log file
  !!
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: line  !! Command line 
  logical, intent(inout) :: error       !! Logical Error Flag
  !
  character(len=1024) :: string
  character(len=1) :: code
  integer :: ns, nc
  !
  if (error) return ! In case called from a code with initial error
  call sic_ch(line,0,1,string,ns,.true.,error)
  if (error) return
  !
  code = 'B'
  call sic_ke(line,0,2,code,nc,.false.,error)
  select case (code)
  case ('B')
    call sic_insert(string(1:ns))
    call sic_log(string,ns,0)
  case ('S')
    call sic_insert(string(1:ns))
  case ('L')
    call sic_log(string,ns,0)
  case default
    call map_message(seve%e,'LOG','Invalid mode, should be B[oth] S[tack] or L[og]')
    error = .true.
  end select
end subroutine log_stack_comm
!
subroutine sic_insert_log(line)
  use gkernel_interfaces, only : sic_insert, sic_log
  !----------------------------------------------------------------------
  ! @ private
  !*
  !   IMAGER -- Utility routine for command LOG  
  !   Insert command line in Stack and Log file
  !!
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: line  !! Line to be inserted.
  !
  integer :: nl
  !
  nl = len_trim(line)
  call sic_insert(line(1:nl))
  call sic_log(line,nl,0)
end subroutine sic_insert_log
