/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.kotlin.dsl.support.EmbeddedKotlinCompilerWarning;
import org.gradle.kotlin.dsl.support.KotlinCompilerKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/gradle/kotlin/dsl/support/LoggingMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "log", "Lorg/slf4j/Logger;", "onCompilerWarning", "Lorg/gradle/kotlin/dsl/support/EmbeddedKotlinCompilerWarning;", "pathTranslation", "Lkotlin/Function1;", "", "<init>", "(Lorg/slf4j/Logger;Lorg/gradle/kotlin/dsl/support/EmbeddedKotlinCompilerWarning;Lkotlin/jvm/functions/Function1;)V", "getLog", "()Lorg/slf4j/Logger;", "errors", "Ljava/util/ArrayList;", "Lorg/gradle/kotlin/dsl/support/ScriptCompilationError;", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "hasErrors", "", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompiler.kt\norg/gradle/kotlin/dsl/support/LoggingMessageCollector\n+ 2 Logger.kt\norg/gradle/kotlin/dsl/support/LoggerKt\n*L\n1#1,670:1\n30#2,2:671\n42#2,2:673\n36#2,2:675\n54#2,2:677\n48#2,2:679\n36#2,2:681\n*S KotlinDebug\n*F\n+ 1 KotlinCompiler.kt\norg/gradle/kotlin/dsl/support/LoggingMessageCollector\n*L\n652#1:671,2\n655#1:673,2\n656#1:675,2\n639#1:677,2\n645#1:679,2\n646#1:681,2\n*E\n"})
final class LoggingMessageCollector
implements MessageCollector {
    @NotNull
    private final Logger log;
    @NotNull
    private final EmbeddedKotlinCompilerWarning onCompilerWarning;
    @NotNull
    private final Function1<String, String> pathTranslation;
    @NotNull
    private final ArrayList<ScriptCompilationError> errors;

    public LoggingMessageCollector(@NotNull Logger log, @NotNull EmbeddedKotlinCompilerWarning onCompilerWarning, @NotNull Function1<? super String, String> pathTranslation) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)((Object)onCompilerWarning), (String)"onCompilerWarning");
        Intrinsics.checkNotNullParameter(pathTranslation, (String)"pathTranslation");
        this.log = log;
        this.onCompilerWarning = onCompilerWarning;
        this.pathTranslation = pathTranslation;
        this.errors = new ArrayList();
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final ArrayList<ScriptCompilationError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    public void clear() {
        this.errors.clear();
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CompilerMessageSeverity compilerMessageSeverity = severity;
        if (compilerMessageSeverity == CompilerMessageSeverity.ERROR || compilerMessageSeverity == CompilerMessageSeverity.EXCEPTION) {
            LoggingMessageCollector.report$onError(this, message, location, severity);
        } else if (CompilerMessageSeverity.VERBOSE.contains(compilerMessageSeverity)) {
            Logger $this$trace$iv = this.log;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace(LoggingMessageCollector.report$msg(location, message, this));
            }
        } else if (compilerMessageSeverity == CompilerMessageSeverity.STRONG_WARNING) {
            LoggingMessageCollector.report$onWarning(this, message, location, severity);
        } else if (compilerMessageSeverity == CompilerMessageSeverity.WARNING) {
            LoggingMessageCollector.report$onWarning(this, message, location, severity);
        } else if (compilerMessageSeverity == CompilerMessageSeverity.INFO) {
            Logger $this$info$iv = this.log;
            boolean $i$f$info = false;
            if ($this$info$iv.isInfoEnabled()) {
                Logger logger3 = $this$info$iv;
                boolean bl = false;
                logger3.info(LoggingMessageCollector.report$msg(location, message, this));
            }
        } else {
            Logger $this$debug$iv = this.log;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger4 = $this$debug$iv;
                boolean bl = false;
                logger4.debug(LoggingMessageCollector.report$taggedMsg(severity, location, message, this));
            }
        }
    }

    private static final String report$msg(CompilerMessageSourceLocation $location, String $message, LoggingMessageCollector this$0) {
        Object object;
        block4: {
            block3: {
                object = $location;
                if (object == null) break block3;
                CompilerMessageSourceLocation $this$report_u24msg_u24lambda_u241 = object;
                boolean bl = false;
                String string = $this$report_u24msg_u24lambda_u241.getPath();
                String path = (String)this$0.pathTranslation.invoke((Object)string);
                boolean bl2 = false;
                String string2 = $this$report_u24msg_u24lambda_u241.getLine() >= 0 && $this$report_u24msg_u24lambda_u241.getColumn() >= 0 ? KotlinCompilerKt.compilerMessageFor(path, $this$report_u24msg_u24lambda_u241.getLine(), $this$report_u24msg_u24lambda_u241.getColumn(), $message) : KotlinCompilerKt.access$clickableFileUrlFor(path) + ": " + $message;
                object = string2;
                if (string2 != null) break block4;
            }
            object = $message;
        }
        return object;
    }

    private static final String report$taggedMsg(CompilerMessageSeverity $severity, CompilerMessageSourceLocation $location, String $message, LoggingMessageCollector this$0) {
        return $severity.getPresentableName().charAt(0) + ": " + LoggingMessageCollector.report$msg($location, $message, this$0);
    }

    private static final void report$onError(LoggingMessageCollector this$0, String $message, CompilerMessageSourceLocation $location, CompilerMessageSeverity $severity) {
        ((Collection)this$0.errors).add(new ScriptCompilationError($message, $location));
        Logger $this$error$iv = this$0.log;
        boolean $i$f$error = false;
        if ($this$error$iv.isErrorEnabled()) {
            Logger logger2 = $this$error$iv;
            boolean bl = false;
            logger2.error(LoggingMessageCollector.report$taggedMsg($severity, $location, $message, this$0));
        }
    }

    private static final void report$onWarning(LoggingMessageCollector this$0, String $message, CompilerMessageSourceLocation $location, CompilerMessageSeverity $severity) {
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.onCompilerWarning.ordinal()]) {
            case 1: {
                LoggingMessageCollector.report$onError(this$0, $message, $location, $severity);
                break;
            }
            case 2: {
                Logger $this$warn$iv = this$0.log;
                boolean $i$f$warn = false;
                if (!$this$warn$iv.isWarnEnabled()) break;
                Logger logger2 = $this$warn$iv;
                boolean bl = false;
                logger2.warn(LoggingMessageCollector.report$taggedMsg($severity, $location, $message, this$0));
                break;
            }
            case 3: {
                Logger $this$debug$iv = this$0.log;
                boolean $i$f$debug = false;
                if (!$this$debug$iv.isDebugEnabled()) break;
                Logger logger3 = $this$debug$iv;
                boolean bl = false;
                logger3.debug(LoggingMessageCollector.report$taggedMsg($severity, $location, $message, this$0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmbeddedKotlinCompilerWarning.values().length];
            try {
                nArray[EmbeddedKotlinCompilerWarning.FAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmbeddedKotlinCompilerWarning.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmbeddedKotlinCompilerWarning.DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

