/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.metadata.MetadataUtilsKt;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataFrontendPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataSerializationArtifact;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirKLibSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.FirKlibSerializationKt;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibSerializerPhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataFrontendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataSerializationArtifact;", "<init>", "()V", "executePhase", "input", "cli"})
@SourceDebugExtension(value={"SMAP\nMetadataKlibSerializerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataKlibSerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibSerializerPhase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n382#2,7:87\n1056#3:94\n*S KotlinDebug\n*F\n+ 1 MetadataKlibSerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibSerializerPhase\n*L\n53#1:87,7\n67#1:94\n*E\n"})
public final class MetadataKlibSerializerPhase
extends PipelinePhase<MetadataFrontendPipelineArtifact, MetadataSerializationArtifact> {
    @NotNull
    public static final MetadataKlibSerializerPhase INSTANCE = new MetadataKlibSerializerPhase();

    private MetadataKlibSerializerPhase() {
        Object[] objectArray = new Function3[]{PerformanceNotifications.BackendFinished.INSTANCE, CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE};
        super("MetadataKlibSerializerPhase", SetsKt.setOf((Object)PerformanceNotifications.BackendStarted.INSTANCE), SetsKt.setOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public MetadataSerializationArtifact executePhase(@NotNull MetadataFrontendPipelineArtifact input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        FirResult firResult = input.component1();
        CompilerConfiguration configuration2 = input.component2();
        BuiltInsBinaryVersion metadataVersion = input.getMetadataVersion();
        File file = CLIConfigurationKeysKt.getMetadataDestinationDirectory(configuration2);
        Intrinsics.checkNotNull((Object)file);
        File destDir = file;
        Map fragments = new LinkedHashMap();
        List<ModuleCompilerAnalyzedOutput> analysisResult = firResult.getOutputs();
        for (ModuleCompilerAnalyzedOutput output2 : analysisResult) {
            FirSession session2 = output2.component1();
            ScopeSession scopeSession = output2.component2();
            List<FirFile> fir = output2.component3();
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2);
            for (FirFile firFile : fir) {
                Object object;
                void $this$getOrPut$iv;
                ProtoBuf.PackageFragment packageFragment = FirKlibSerializationKt.serializeSingleFirFile$default(firFile, session2, scopeSession, null, new FirKLibSerializerExtension(session2, scopeSession, FirProviderKt.getFirProvider(session2), metadataVersion, null, false, null), languageVersionSettings, false, 64, null);
                Map map = fragments;
                String key$iv = UtilsKt.getPackageFqName(firFile).asString();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List list = (List)object;
                byte[] byArray = packageFragment.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                list.add(byArray);
            }
        }
        KlibMetadataProtoBuf.Header.Builder header = KlibMetadataProtoBuf.Header.newBuilder();
        header.setModuleName(FirModuleDataKt.getModuleData(((ModuleCompilerAnalyzedOutput)CollectionsKt.last(analysisResult)).getSession()).getName().asString());
        if (CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2).isPreRelease()) {
            header.setFlags(2);
        }
        List fragmentNames = new ArrayList();
        List fragmentParts = new ArrayList();
        Object $this$sortedBy$iv2 = fragments.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Map.Entry it = (Map.Entry)a2;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        })) {
            String fqName = (String)$this$sortedBy$iv2.getKey();
            List fragment = (List)$this$sortedBy$iv2.getValue();
            ((Collection)fragmentNames).add(fqName);
            ((Collection)fragmentParts).add(fragment);
            header.addPackageFragmentName(fqName);
        }
        byte[] module2 = header.build().toByteArray();
        Intrinsics.checkNotNull((Object)module2);
        SerializedMetadata serializedMetadata = new SerializedMetadata(module2, fragmentParts, fragmentNames);
        MetadataUtilsKt.buildKotlinMetadataLibrary(configuration2, serializedMetadata, destDir);
        String string = destDir.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        return new MetadataSerializationArtifact(null, configuration2, string);
    }
}

