/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.internal.component.model.DelegatingDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultProjectDependencyMetadata
extends DelegatingDependencyMetadata
implements ForcingDependencyMetadata {
    private final ProjectComponentSelector selector;
    private final DependencyMetadata delegate;

    public DefaultProjectDependencyMetadata(ProjectComponentSelector selector, DependencyMetadata delegate) {
        super(delegate);
        this.selector = selector;
        this.delegate = delegate;
    }

    public ProjectComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return Collections.emptyList();
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target.equals(this.selector)) {
            return this;
        }
        return this.delegate.withTarget(target);
    }

    @Override
    public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
        if (target.equals(this.selector) && this.delegate.getArtifacts().equals(artifacts)) {
            return this;
        }
        return this.delegate.withTargetAndArtifacts(target, artifacts);
    }

    @Override
    public boolean isForce() {
        if (this.delegate instanceof ForcingDependencyMetadata) {
            return ((ForcingDependencyMetadata)this.delegate).isForce();
        }
        return false;
    }

    @Override
    public ForcingDependencyMetadata forced() {
        if (this.delegate instanceof ForcingDependencyMetadata) {
            return ((ForcingDependencyMetadata)this.delegate).forced();
        }
        return this;
    }

    public String toString() {
        return "ProjectDependencyMetadata: " + this.selector;
    }
}

