/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.CaseSensitivity;
import net.rubygrapefruit.platform.file.FileSystemInfo;

public class DefaultFileSystemInfo
implements FileSystemInfo {
    private final File mountPoint;
    private final String fileSystemType;
    private final String deviceName;
    private final boolean remote;
    private final CaseSensitivity caseSensitivity;

    public DefaultFileSystemInfo(File mountPoint, String fileSystemType, String deviceName, boolean remote, @Nullable CaseSensitivity caseSensitivity) {
        this.mountPoint = mountPoint;
        this.fileSystemType = fileSystemType;
        this.deviceName = deviceName;
        this.remote = remote;
        this.caseSensitivity = caseSensitivity;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public File getMountPoint() {
        return this.mountPoint;
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    @Nullable
    public CaseSensitivity getCaseSensitivity() {
        return this.caseSensitivity;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isCaseSensitive() {
        return this.getCaseSensitivityOrThrow().isCaseSensitive();
    }

    public boolean isCasePreserving() {
        return this.getCaseSensitivityOrThrow().isCasePreserving();
    }

    private CaseSensitivity getCaseSensitivityOrThrow() {
        if (this.caseSensitivity == null) {
            throw new NativeException("Could get file system attributes for file system at " + this.mountPoint);
        }
        return this.caseSensitivity;
    }

    public String toString() {
        return "FileSystemInfo{mountPoint=" + this.mountPoint + ", fileSystemType='" + this.fileSystemType + '\'' + ", deviceName='" + this.deviceName + '\'' + ", remote=" + this.remote + ", caseSensitivity=" + this.caseSensitivity + '}';
    }
}

