/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.util.Collection;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleIterable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterators;

public interface DoubleCollection
extends DoubleIterable,
Collection<Double> {
    @Override
    public DoubleIterator iterator();

    @Override
    default public DoubleSpliterator spliterator() {
        return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(double var1);

    public boolean contains(double var1);

    public boolean rem(double var1);

    @Override
    @Deprecated
    default public boolean add(Double key) {
        return this.add((double)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Double)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Double)key);
    }

    public double[] toDoubleArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Double> filter) {
        return this.removeIf(filter instanceof DoublePredicate ? (DoublePredicate)((Object)filter) : key -> filter.test(key));
    }

    default public boolean removeIf(DoublePredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        DoubleIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextDouble())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Double> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Double> parallelStream() {
        return Collection.super.parallelStream();
    }
}

