/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;

@PhaseDescription(name="TypeAliasAnnotationMethodsLowering", description="Generate method stubs for type alias annotations")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0011\u001a\u00020\t*\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeAliasAnnotationMethodsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "syntheticAnnotationMethodName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "getSyntheticAnnotationMethodName", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;)Lorg/jetbrains/kotlin/name/Name;", "visitTypeAliases", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nTypeAliasAnnotationMethodsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeAliasAnnotationMethodsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeAliasAnnotationMethodsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,51:1\n808#2,11:52\n774#2:63\n865#2,2:64\n249#3:66\n243#3:67\n237#3,10:68\n*S KotlinDebug\n*F\n+ 1 TypeAliasAnnotationMethodsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeAliasAnnotationMethodsLowering\n*L\n34#1:52,11\n35#1:63\n35#1:64,2\n38#1:66\n38#1:67\n38#1:68,10\n*E\n"})
public final class TypeAliasAnnotationMethodsLowering
implements ClassLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public TypeAliasAnnotationMethodsLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.visitTypeAliases(irClass);
    }

    private final Name getSyntheticAnnotationMethodName(IrTypeAlias $this$syntheticAnnotationMethodName) {
        Name name2 = Name.identifier(JvmAbi.getSyntheticMethodNameForAnnotatedTypeAlias($this$syntheticAnnotationMethodName.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final void visitTypeAliases(IrClass $this$visitTypeAliases) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$visitTypeAliases.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrTypeAlias)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrTypeAlias it = (IrTypeAlias)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getAnnotations()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List annotatedAliases = (List)destination$iv$iv;
        for (IrTypeAlias alias : annotatedAliases) {
            IrSimpleFunction irSimpleFunction;
            IrClass $this$addFunction$iv = $this$visitTypeAliases;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$visitTypeAliases_u24lambda_u241 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
            boolean bl3 = false;
            $this$visitTypeAliases_u24lambda_u241.setName(this.getSyntheticAnnotationMethodName(alias));
            $this$visitTypeAliases_u24lambda_u241.setVisibility(alias.getVisibility());
            $this$visitTypeAliases_u24lambda_u241.setReturnType(this.context.getIrBuiltIns().getUnitType());
            $this$visitTypeAliases_u24lambda_u241.setModality(Modality.OPEN);
            $this$visitTypeAliases_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS());
            IrSimpleFunction function$iv$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
            boolean bl4 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object $this$visitTypeAliases_u24lambda_u242 = object = irSimpleFunction;
            boolean bl5 = false;
            ((IrFunction)$this$visitTypeAliases_u24lambda_u242).setBody(this.context.getIrFactory().createBlockBody(-1, -1));
            $this$visitTypeAliases_u24lambda_u242.setAnnotations(CollectionsKt.plus((Collection)$this$visitTypeAliases_u24lambda_u242.getAnnotations(), (Iterable)alias.getAnnotations()));
        }
    }
}

