# -*- coding: utf-8 -*- #
# Copyright 2016 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The group for the Cloud Resource Manager Operations CLI."""


from googlecloudsdk.api_lib.resource_manager import operations
from googlecloudsdk.calliope import base


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class Operations(base.Group):
  """Query Cloud Resource Manager long-running operations.

  Commands to query long-running operations created in Cloud Resource Manager.
  """

  @staticmethod
  def Args(parser):
    parser.display_info.AddUriFunc(operations.GetUri)
