
# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The operations command group for the App Hub CLI."""
from googlecloudsdk.calliope import base


# NOTE: Release track decorators can be used here as well, and would propagate
# to this group's children.
@base.ReleaseTracks(base.ReleaseTrack.GA)
@base.UniverseCompatible
class OperationsGA(base.Group):
  """Manage App Hub Operations (long-running operations).

  Commands for managing App Hub Operations (long-running operations).
  """


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
@base.UniverseCompatible
class OperationsAlpha(base.Group):
  """Manage App Hub Operations (long-running operations).

  Commands for managing App Hub Operations (long-running operations).
  """
