# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Command group for Vertex AI persistent resources."""


from googlecloudsdk.calliope import base


@base.ReleaseTracks(base.ReleaseTrack.GA)
class PersistentResourceGA(base.Group):
  """Create and manage Vertex AI persistent resources."""

  category = base.VERTEX_AI_CATEGORY


@base.ReleaseTracks(base.ReleaseTrack.ALPHA, base.ReleaseTrack.BETA)
class PersistentResourcePreGA(base.Group):
  """Create and manage Vertex AI rersistent resources."""

  category = base.VERTEX_AI_CATEGORY

