# -*- coding: utf-8 -*- #
# Copyright 2020 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Command group for Access Approval requests."""


from googlecloudsdk.calliope import base


class AccessApproval(base.Group):
  """Manage Access Approval requests.

  Approval requests are created by Google personnel to request approval from
  Access Approval customers prior to making administrative accesses to their
  resources. Customers can act on these requests using the commands in this
  command group.
  """
