# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Cloud Speech-to-text locations list command."""


from googlecloudsdk.api_lib.ml.speech import client
from googlecloudsdk.calliope import base


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class Create(base.ListCommand):
  """List Speech-to-text locations."""

  @staticmethod
  def Args(parser):
    parser.display_info.AddUriFunc(lambda location: location.name)

  def Run(self, args):
    speech_client = client.SpeechV2Client()
    return speech_client.ListLocations(
        filter_str=args.filter, limit=args.limit, page_size=args.page_size
    )
