# -*- coding: utf-8 -*- #
# Copyright 2024 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The command group for the Resource Settings CLI."""


from googlecloudsdk.calliope import base


@base.Hidden
@base.DefaultUniverseOnly
@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class ResourceSettings(base.Group):
  """Create and manage Resource Settings.

  The gcloud Resource Settings command group lets you create and manipulate
  Resource Settings.

  The Resource Settings Service is a hierarchy-aware service with a
  public-facing API for end-users to store settings that modify the behavior of
  their Google Cloud Platform resources (e.g., VM, firewall, Project, etc.).
  The settings are attached at the project level and above and can influence CRM
  resources as well as sub-project resources that are descendants of the setting
  attachment point.
  """
