# -*- coding: utf-8 -*- #
# Copyright 2020 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The super-group for the IAP CLI."""


from googlecloudsdk.calliope import base


@base.Deprecate(
    is_removed=False,
    warning=(
        'This command is deprecated and will be non-functional after the IAP'
        ' OAuth Admin APIs are turned down. Jan 19, 2026: Google will'
        ' discontinue support for the IAP OAuth Admin APIs. New projects will'
        ' not be able to use these APIs. March 19, 2026: The IAP OAuth Admin'
        ' APIs will be permanently shut down. Access to this feature will no'
        ' longer be available.'
    ),
)
@base.DefaultUniverseOnly
@base.ReleaseTracks(
    base.ReleaseTrack.ALPHA, base.ReleaseTrack.BETA, base.ReleaseTrack.GA
)
class Iap(base.Group):
  """Manage IAP OAuth clients.

  Manage OAuth clients that are used by Cloud Identity-Aware Proxy. Note this
  API cannot be used as a generic management API for all OAuth clients in your
  project.
  """

  category = 'Identity and Security'
