# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Command to query Anthos on bare metal standalone cluster version configuration."""


from googlecloudsdk.api_lib.container.gkeonprem import standalone_clusters as apis
from googlecloudsdk.calliope import base
from googlecloudsdk.calliope import parser_arguments
from googlecloudsdk.command_lib.container.bare_metal import cluster_flags
from googlecloudsdk.command_lib.container.bare_metal import standalone_cluster_flags as flags

_EXAMPLES = """
To query versions for upgrading a standalone cluster named `my-cluster` in
location `us-west1`, run:

$ {command} --location=us-west1 --cluster=my-cluster
"""


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class QueryVersionConfig(base.Command):
  """Query versions for upgrading an Anthos on bare metal standalone cluster."""

  detailed_help = {'EXAMPLES': _EXAMPLES}

  @staticmethod
  def Args(parser: parser_arguments.ArgumentInterceptor):
    """Registers flags for this command."""
    cluster_flags.AddLocationResourceArg(parser, 'to query versions')
    flags.AddStandaloneConfigType(parser)

  def Run(self, args):
    """Runs the query-version-config command."""
    client = apis.StandaloneClustersClient()
    return client.QueryVersionConfig(args)
