# -*- coding: utf-8 -*- #
# Copyright 2021 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Command to enable virtualenv environment."""



from googlecloudsdk.calliope import base
from googlecloudsdk.command_lib.config.virtualenv import util
from googlecloudsdk.core import config


@base.Hidden
class Enable(base.Command):
  """Enable a virtualenv environment."""

  def Run(self, args):
    ve_dir = config.Paths().virtualenv_dir
    util.EnableVirtualEnv(ve_dir)


