"""Generated client library for biglake version v1beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.biglake.v1beta import biglake_v1beta_messages as messages


class BiglakeV1beta(base_api.BaseApiClient):
  """Generated client library for service biglake version v1beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://biglake.googleapis.com/'
  MTLS_BASE_URL = 'https://biglake.mtls.googleapis.com/'

  _PACKAGE = 'biglake'
  _SCOPES = ['https://www.googleapis.com/auth/bigquery', 'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BiglakeV1beta'
  _URL_VERSION = 'v1beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new biglake handle."""
    url = url or self.BASE_URL
    super(BiglakeV1beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.hive_v1beta_projects_catalogs_databases_tables_partitions = self.HiveV1betaProjectsCatalogsDatabasesTablesPartitionsService(self)
    self.hive_v1beta_projects_catalogs_databases_tables = self.HiveV1betaProjectsCatalogsDatabasesTablesService(self)
    self.hive_v1beta_projects_catalogs_databases = self.HiveV1betaProjectsCatalogsDatabasesService(self)
    self.hive_v1beta_projects_catalogs = self.HiveV1betaProjectsCatalogsService(self)
    self.hive_v1beta_projects = self.HiveV1betaProjectsService(self)
    self.hive_v1beta = self.HiveV1betaService(self)
    self.hive = self.HiveService(self)
    self.projects_catalogs_namespaces_tables = self.ProjectsCatalogsNamespacesTablesService(self)
    self.projects_catalogs_namespaces = self.ProjectsCatalogsNamespacesService(self)
    self.projects_catalogs = self.ProjectsCatalogsService(self)
    self.projects = self.ProjectsService(self)

  class HiveV1betaProjectsCatalogsDatabasesTablesPartitionsService(base_api.BaseApiService):
    """Service class for the hive_v1beta_projects_catalogs_databases_tables_partitions resource."""

    _NAME = 'hive_v1beta_projects_catalogs_databases_tables_partitions'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaProjectsCatalogsDatabasesTablesPartitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchCreate(self, request, global_params=None):
      r"""Adds partitions to a table.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchCreatePartitionsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}/partitions:batchCreate',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.partitions.batchCreate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='hive/v1beta/{+parent}/partitions:batchCreate',
        request_field='batchCreatePartitionsRequest',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchCreateRequest',
        response_type_name='BatchCreatePartitionsResponse',
        supports_download=False,
    )

    def BatchDelete(self, request, global_params=None):
      r"""Deletes partitions from a table.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('BatchDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}/partitions:batchDelete',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.partitions.batchDelete',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='hive/v1beta/{+parent}/partitions:batchDelete',
        request_field='batchDeletePartitionsRequest',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def BatchUpdate(self, request, global_params=None):
      r"""Updates partitions in a table.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchUpdatePartitionsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}/partitions:batchUpdate',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.partitions.batchUpdate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='hive/v1beta/{+parent}/partitions:batchUpdate',
        request_field='batchUpdatePartitionsRequest',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchUpdateRequest',
        response_type_name='BatchUpdatePartitionsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Streams list of partitions from a table.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPartitionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}/partitions:list',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.partitions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter'],
        relative_path='hive/v1beta/{+parent}/partitions:list',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsListRequest',
        response_type_name='ListPartitionsResponse',
        supports_download=False,
    )

  class HiveV1betaProjectsCatalogsDatabasesTablesService(base_api.BaseApiService):
    """Service class for the hive_v1beta_projects_catalogs_databases_tables resource."""

    _NAME = 'hive_v1beta_projects_catalogs_databases_tables'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaProjectsCatalogsDatabasesTablesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new hive table.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveTable) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['hiveTableId'],
        relative_path='hive/v1beta/{+parent}/tables',
        request_field='hiveTable',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesCreateRequest',
        response_type_name='HiveTable',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing table specified by the table name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}',
        http_method='DELETE',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the table specified by the resource name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveTable) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesGetRequest',
        response_type_name='HiveTable',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all hive tables in a specified project under the hive catalog and database.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHiveTablesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='hive/v1beta/{+parent}/tables',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesListRequest',
        response_type_name='ListHiveTablesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing table specified by the table name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveTable) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}/tables/{tablesId}',
        http_method='PATCH',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.tables.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='hive/v1beta/{+name}',
        request_field='hiveTable',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPatchRequest',
        response_type_name='HiveTable',
        supports_download=False,
    )

  class HiveV1betaProjectsCatalogsDatabasesService(base_api.BaseApiService):
    """Service class for the hive_v1beta_projects_catalogs_databases resource."""

    _NAME = 'hive_v1beta_projects_catalogs_databases'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaProjectsCatalogsDatabasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new database.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveDatabase) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['hiveDatabaseId'],
        relative_path='hive/v1beta/{+parent}/databases',
        request_field='hiveDatabase',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesCreateRequest',
        response_type_name='HiveDatabase',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing database specified by the database name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}',
        http_method='DELETE',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the database specified by the resource name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveDatabase) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesGetRequest',
        response_type_name='HiveDatabase',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all databases in a specified catalog.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHiveDatabasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='hive/v1beta/{+parent}/databases',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesListRequest',
        response_type_name='ListHiveDatabasesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing database specified by the database name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDatabasesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveDatabase) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}/databases/{databasesId}',
        http_method='PATCH',
        method_id='biglake.hive.v1beta.projects.catalogs.databases.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='hive/v1beta/{+name}',
        request_field='hiveDatabase',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDatabasesPatchRequest',
        response_type_name='HiveDatabase',
        supports_download=False,
    )

  class HiveV1betaProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the hive_v1beta_projects_catalogs resource."""

    _NAME = 'hive_v1beta_projects_catalogs'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new hive catalog.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveCatalog) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs',
        http_method='POST',
        method_id='biglake.hive.v1beta.projects.catalogs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['hiveCatalogId', 'primaryLocation'],
        relative_path='hive/v1beta/{+parent}/catalogs',
        request_field='hiveCatalog',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsCreateRequest',
        response_type_name='HiveCatalog',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing catalog specified by the catalog ID. Delete will fail if the catalog is not empty.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='DELETE',
        method_id='biglake.hive.v1beta.projects.catalogs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the catalog specified by the resource name.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveCatalog) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='hive/v1beta/{+name}',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsGetRequest',
        response_type_name='HiveCatalog',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all catalogs in a specified project.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHiveCatalogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs',
        http_method='GET',
        method_id='biglake.hive.v1beta.projects.catalogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='hive/v1beta/{+parent}/catalogs',
        request_field='',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsListRequest',
        response_type_name='ListHiveCatalogsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing catalog.

      Args:
        request: (BiglakeHiveV1betaProjectsCatalogsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HiveCatalog) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='hive/v1beta/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='PATCH',
        method_id='biglake.hive.v1beta.projects.catalogs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='hive/v1beta/{+name}',
        request_field='hiveCatalog',
        request_type_name='BiglakeHiveV1betaProjectsCatalogsPatchRequest',
        response_type_name='HiveCatalog',
        supports_download=False,
    )

  class HiveV1betaProjectsService(base_api.BaseApiService):
    """Service class for the hive_v1beta_projects resource."""

    _NAME = 'hive_v1beta_projects'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class HiveV1betaService(base_api.BaseApiService):
    """Service class for the hive_v1beta resource."""

    _NAME = 'hive_v1beta'

    def __init__(self, client):
      super(BiglakeV1beta.HiveV1betaService, self).__init__(client)
      self._upload_configs = {
          }

  class HiveService(base_api.BaseApiService):
    """Service class for the hive resource."""

    _NAME = 'hive'

    def __init__(self, client):
      super(BiglakeV1beta.HiveService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsCatalogsNamespacesTablesService(base_api.BaseApiService):
    """Service class for the projects_catalogs_namespaces_tables resource."""

    _NAME = 'projects_catalogs_namespaces_tables'

    def __init__(self, client):
      super(BiglakeV1beta.ProjectsCatalogsNamespacesTablesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.namespaces.tables.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.tables.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the IAM permissions for the specified table.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTablesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}:testIamPermissions',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.tables.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesTablesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsCatalogsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_catalogs_namespaces resource."""

    _NAME = 'projects_catalogs_namespaces'

    def __init__(self, client):
      super(BiglakeV1beta.ProjectsCatalogsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.namespaces.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the IAM permissions for the specified namespace.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}:testIamPermissions',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the projects_catalogs resource."""

    _NAME = 'projects_catalogs'

    def __init__(self, client):
      super(BiglakeV1beta.ProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the IAM permissions for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/catalogs/{catalogsId}:testIamPermissions',
        http_method='POST',
        method_id='biglake.projects.catalogs.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='BiglakeProjectsCatalogsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(BiglakeV1beta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
