"""Generated client library for compute version alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.compute.alpha import compute_alpha_messages as messages


class ComputeAlpha(base_api.BaseApiClient):
  """Generated client library for service compute version alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://compute.googleapis.com/compute/alpha/'
  MTLS_BASE_URL = 'https://compute.mtls.googleapis.com/compute/alpha/'

  _PACKAGE = 'compute'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/compute', 'https://www.googleapis.com/auth/compute.readonly', 'https://www.googleapis.com/auth/devstorage.full_control', 'https://www.googleapis.com/auth/devstorage.read_only', 'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = 'alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ComputeAlpha'
  _URL_VERSION = 'alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new compute handle."""
    url = url or self.BASE_URL
    super(ComputeAlpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.acceleratorTypes = self.AcceleratorTypesService(self)
    self.addresses = self.AddressesService(self)
    self.advice = self.AdviceService(self)
    self.autoscalers = self.AutoscalersService(self)
    self.backendBuckets = self.BackendBucketsService(self)
    self.backendServices = self.BackendServicesService(self)
    self.crossSiteNetworks = self.CrossSiteNetworksService(self)
    self.diskSettings = self.DiskSettingsService(self)
    self.diskTypes = self.DiskTypesService(self)
    self.disks = self.DisksService(self)
    self.externalVpnGateways = self.ExternalVpnGatewaysService(self)
    self.firewallPolicies = self.FirewallPoliciesService(self)
    self.firewalls = self.FirewallsService(self)
    self.forwardingRules = self.ForwardingRulesService(self)
    self.futureReservations = self.FutureReservationsService(self)
    self.globalAddresses = self.GlobalAddressesService(self)
    self.globalFolderOperations = self.GlobalFolderOperationsService(self)
    self.globalForwardingRules = self.GlobalForwardingRulesService(self)
    self.globalNetworkEndpointGroups = self.GlobalNetworkEndpointGroupsService(self)
    self.globalOperations = self.GlobalOperationsService(self)
    self.globalOrganizationOperations = self.GlobalOrganizationOperationsService(self)
    self.globalPublicDelegatedPrefixes = self.GlobalPublicDelegatedPrefixesService(self)
    self.globalVmExtensionPolicies = self.GlobalVmExtensionPoliciesService(self)
    self.haControllers = self.HaControllersService(self)
    self.healthChecks = self.HealthChecksService(self)
    self.httpHealthChecks = self.HttpHealthChecksService(self)
    self.httpsHealthChecks = self.HttpsHealthChecksService(self)
    self.imageFamilyViews = self.ImageFamilyViewsService(self)
    self.images = self.ImagesService(self)
    self.instanceGroupManagerResizeRequests = self.InstanceGroupManagerResizeRequestsService(self)
    self.instanceGroupManagers = self.InstanceGroupManagersService(self)
    self.instanceGroups = self.InstanceGroupsService(self)
    self.instanceSettings = self.InstanceSettingsService(self)
    self.instanceTemplates = self.InstanceTemplatesService(self)
    self.instances = self.InstancesService(self)
    self.instantSnapshotGroups = self.InstantSnapshotGroupsService(self)
    self.instantSnapshots = self.InstantSnapshotsService(self)
    self.interconnectAttachmentGroups = self.InterconnectAttachmentGroupsService(self)
    self.interconnectAttachments = self.InterconnectAttachmentsService(self)
    self.interconnectGroups = self.InterconnectGroupsService(self)
    self.interconnectLocations = self.InterconnectLocationsService(self)
    self.interconnectRemoteLocations = self.InterconnectRemoteLocationsService(self)
    self.interconnects = self.InterconnectsService(self)
    self.licenseCodes = self.LicenseCodesService(self)
    self.licenses = self.LicensesService(self)
    self.machineImages = self.MachineImagesService(self)
    self.machineTypes = self.MachineTypesService(self)
    self.networkAttachments = self.NetworkAttachmentsService(self)
    self.networkEdgeSecurityServices = self.NetworkEdgeSecurityServicesService(self)
    self.networkEndpointGroups = self.NetworkEndpointGroupsService(self)
    self.networkFirewallPolicies = self.NetworkFirewallPoliciesService(self)
    self.networkProfiles = self.NetworkProfilesService(self)
    self.networks = self.NetworksService(self)
    self.nodeGroups = self.NodeGroupsService(self)
    self.nodeTemplates = self.NodeTemplatesService(self)
    self.nodeTypes = self.NodeTypesService(self)
    self.organizationSecurityPolicies = self.OrganizationSecurityPoliciesService(self)
    self.packetMirrorings = self.PacketMirroringsService(self)
    self.previewFeatures = self.PreviewFeaturesService(self)
    self.projects = self.ProjectsService(self)
    self.publicAdvertisedPrefixes = self.PublicAdvertisedPrefixesService(self)
    self.publicDelegatedPrefixes = self.PublicDelegatedPrefixesService(self)
    self.recoverableSnapshots = self.RecoverableSnapshotsService(self)
    self.regionAutoscalers = self.RegionAutoscalersService(self)
    self.regionBackendBuckets = self.RegionBackendBucketsService(self)
    self.regionBackendServices = self.RegionBackendServicesService(self)
    self.regionCommitments = self.RegionCommitmentsService(self)
    self.regionCompositeHealthChecks = self.RegionCompositeHealthChecksService(self)
    self.regionDiskSettings = self.RegionDiskSettingsService(self)
    self.regionDiskTypes = self.RegionDiskTypesService(self)
    self.regionDisks = self.RegionDisksService(self)
    self.regionHealthAggregationPolicies = self.RegionHealthAggregationPoliciesService(self)
    self.regionHealthCheckServices = self.RegionHealthCheckServicesService(self)
    self.regionHealthChecks = self.RegionHealthChecksService(self)
    self.regionHealthSources = self.RegionHealthSourcesService(self)
    self.regionInstanceGroupManagerResizeRequests = self.RegionInstanceGroupManagerResizeRequestsService(self)
    self.regionInstanceGroupManagers = self.RegionInstanceGroupManagersService(self)
    self.regionInstanceGroups = self.RegionInstanceGroupsService(self)
    self.regionInstanceTemplates = self.RegionInstanceTemplatesService(self)
    self.regionInstances = self.RegionInstancesService(self)
    self.regionInstantSnapshotGroups = self.RegionInstantSnapshotGroupsService(self)
    self.regionInstantSnapshots = self.RegionInstantSnapshotsService(self)
    self.regionMultiMigMembers = self.RegionMultiMigMembersService(self)
    self.regionMultiMigs = self.RegionMultiMigsService(self)
    self.regionNetworkEndpointGroups = self.RegionNetworkEndpointGroupsService(self)
    self.regionNetworkFirewallPolicies = self.RegionNetworkFirewallPoliciesService(self)
    self.regionNetworkPolicies = self.RegionNetworkPoliciesService(self)
    self.regionNotificationEndpoints = self.RegionNotificationEndpointsService(self)
    self.regionOperations = self.RegionOperationsService(self)
    self.regionSecurityPolicies = self.RegionSecurityPoliciesService(self)
    self.regionSnapshotSettings = self.RegionSnapshotSettingsService(self)
    self.regionSnapshots = self.RegionSnapshotsService(self)
    self.regionSslCertificates = self.RegionSslCertificatesService(self)
    self.regionSslPolicies = self.RegionSslPoliciesService(self)
    self.regionTargetHttpProxies = self.RegionTargetHttpProxiesService(self)
    self.regionTargetHttpsProxies = self.RegionTargetHttpsProxiesService(self)
    self.regionTargetTcpProxies = self.RegionTargetTcpProxiesService(self)
    self.regionUrlMaps = self.RegionUrlMapsService(self)
    self.regionZones = self.RegionZonesService(self)
    self.regions = self.RegionsService(self)
    self.reliabilityRisks = self.ReliabilityRisksService(self)
    self.reservationBlocks = self.ReservationBlocksService(self)
    self.reservationSubBlocks = self.ReservationSubBlocksService(self)
    self.reservations = self.ReservationsService(self)
    self.resourcePolicies = self.ResourcePoliciesService(self)
    self.routers = self.RoutersService(self)
    self.routes = self.RoutesService(self)
    self.securityPolicies = self.SecurityPoliciesService(self)
    self.serviceAttachments = self.ServiceAttachmentsService(self)
    self.snapshotGroups = self.SnapshotGroupsService(self)
    self.snapshotSettings = self.SnapshotSettingsService(self)
    self.snapshots = self.SnapshotsService(self)
    self.sslCertificates = self.SslCertificatesService(self)
    self.sslPolicies = self.SslPoliciesService(self)
    self.storagePoolTypes = self.StoragePoolTypesService(self)
    self.storagePools = self.StoragePoolsService(self)
    self.subnetworks = self.SubnetworksService(self)
    self.targetGrpcProxies = self.TargetGrpcProxiesService(self)
    self.targetHttpProxies = self.TargetHttpProxiesService(self)
    self.targetHttpsProxies = self.TargetHttpsProxiesService(self)
    self.targetInstances = self.TargetInstancesService(self)
    self.targetPools = self.TargetPoolsService(self)
    self.targetSslProxies = self.TargetSslProxiesService(self)
    self.targetTcpProxies = self.TargetTcpProxiesService(self)
    self.targetVpnGateways = self.TargetVpnGatewaysService(self)
    self.urlMaps = self.UrlMapsService(self)
    self.vpnGateways = self.VpnGatewaysService(self)
    self.vpnTunnels = self.VpnTunnelsService(self)
    self.wireGroups = self.WireGroupsService(self)
    self.zoneOperations = self.ZoneOperationsService(self)
    self.zoneQueuedResources = self.ZoneQueuedResourcesService(self)
    self.zoneVmExtensionPolicies = self.ZoneVmExtensionPoliciesService(self)
    self.zones = self.ZonesService(self)

  class AcceleratorTypesService(base_api.BaseApiService):
    """Service class for the acceleratorTypes resource."""

    _NAME = 'acceleratorTypes'

    def __init__(self, client):
      super(ComputeAlpha.AcceleratorTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of accelerator types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeAcceleratorTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/acceleratorTypes',
        request_field='',
        request_type_name='ComputeAcceleratorTypesAggregatedListRequest',
        response_type_name='AcceleratorTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified accelerator type.

      Args:
        request: (ComputeAcceleratorTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.get',
        ordered_params=['project', 'zone', 'acceleratorType'],
        path_params=['acceleratorType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/acceleratorTypes/{acceleratorType}',
        request_field='',
        request_type_name='ComputeAcceleratorTypesGetRequest',
        response_type_name='AcceleratorType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of accelerator types that are available to the specified project.

      Args:
        request: (ComputeAcceleratorTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/acceleratorTypes',
        request_field='',
        request_type_name='ComputeAcceleratorTypesListRequest',
        response_type_name='AcceleratorTypeList',
        supports_download=False,
    )

  class AddressesService(base_api.BaseApiService):
    """Service class for the addresses resource."""

    _NAME = 'addresses'

    def __init__(self, client):
      super(ComputeAlpha.AddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of addresses. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeAddressesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/addresses',
        request_field='',
        request_type_name='ComputeAddressesAggregatedListRequest',
        response_type_name='AddressAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.addresses.delete',
        ordered_params=['project', 'region', 'address'],
        path_params=['address', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name='ComputeAddressesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource.

      Args:
        request: (ComputeAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.get',
        ordered_params=['project', 'region', 'address'],
        path_params=['address', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name='ComputeAddressesGetRequest',
        response_type_name='Address',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses',
        request_field='address',
        request_type_name='ComputeAddressesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of addresses contained within the specified region.

      Args:
        request: (ComputeAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/addresses',
        request_field='',
        request_type_name='ComputeAddressesListRequest',
        response_type_name='AddressList',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified address resource.

      Args:
        request: (ComputeAddressesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.move',
        ordered_params=['project', 'region', 'address'],
        path_params=['address', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses/{address}/move',
        request_field='regionAddressesMoveRequest',
        request_type_name='ComputeAddressesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeAddressesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/addresses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeAddressesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class AdviceService(base_api.BaseApiService):
    """Service class for the advice resource."""

    _NAME = 'advice'

    def __init__(self, client):
      super(ComputeAlpha.AdviceService, self).__init__(client)
      self._upload_configs = {
          }

    def CalendarMode(self, request, global_params=None):
      r"""Advise how, where and when to create the requested amount of instances with specified accelerators, within the specified time and location limits. The method recommends creating future reservations for the requested resources.

      Args:
        request: (ComputeAdviceCalendarModeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CalendarModeAdviceResponse) The response message.
      """
      config = self.GetMethodConfig('CalendarMode')
      return self._RunMethod(
          config, request, global_params=global_params)

    CalendarMode.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.advice.calendarMode',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/advice/calendarMode',
        request_field='calendarModeAdviceRequest',
        request_type_name='ComputeAdviceCalendarModeRequest',
        response_type_name='CalendarModeAdviceResponse',
        supports_download=False,
    )

    def Capacity(self, request, global_params=None):
      r"""Advice on making real-time decisions (such as choosing zone or machine types) during deployment to maximize your chances of obtaining capacity.

      Args:
        request: (ComputeAdviceCapacityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CapacityAdviceResponse) The response message.
      """
      config = self.GetMethodConfig('Capacity')
      return self._RunMethod(
          config, request, global_params=global_params)

    Capacity.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.advice.capacity',
        ordered_params=['project', 'region', 'size'],
        path_params=['project', 'region'],
        query_params=['size'],
        relative_path='projects/{project}/regions/{region}/advice/capacity',
        request_field='capacityAdviceRequest',
        request_type_name='ComputeAdviceCapacityRequest',
        response_type_name='CapacityAdviceResponse',
        supports_download=False,
    )

  class AutoscalersService(base_api.BaseApiService):
    """Service class for the autoscalers resource."""

    _NAME = 'autoscalers'

    def __init__(self, client):
      super(ComputeAlpha.AutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of autoscalers. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeAutoscalersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/autoscalers',
        request_field='',
        request_type_name='ComputeAutoscalersAggregatedListRequest',
        response_type_name='AutoscalerAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.autoscalers.delete',
        ordered_params=['project', 'zone', 'autoscaler'],
        path_params=['autoscaler', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeAutoscalersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler resource.

      Args:
        request: (ComputeAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.get',
        ordered_params=['project', 'zone', 'autoscaler'],
        path_params=['autoscaler', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeAutoscalersGetRequest',
        response_type_name='Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.autoscalers.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscaler',
        request_type_name='ComputeAutoscalersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified zone.

      Args:
        request: (ComputeAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='',
        request_type_name='ComputeAutoscalersListRequest',
        response_type_name='AutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.autoscalers.patch',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeAutoscalersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.autoscalers.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeAutoscalersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.autoscalers.update',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeAutoscalersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class BackendBucketsService(base_api.BaseApiService):
    """Service class for the backendBuckets resource."""

    _NAME = 'backendBuckets'

    def __init__(self, client):
      super(ComputeAlpha.BackendBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.addSignedUrlKey',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/addSignedUrlKey',
        request_field='signedUrlKey',
        request_type_name='ComputeBackendBucketsAddSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all BackendBucket resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeBackendBucketsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/backendBuckets',
        request_field='',
        request_type_name='ComputeBackendBucketsAggregatedListRequest',
        response_type_name='BackendBucketAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendBucket resource.

      Args:
        request: (ComputeBackendBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.backendBuckets.delete',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeBackendBucketsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.deleteSignedUrlKey',
        ordered_params=['project', 'backendBucket', 'keyName'],
        path_params=['backendBucket', 'project'],
        query_params=['keyName', 'requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/deleteSignedUrlKey',
        request_field='',
        request_type_name='ComputeBackendBucketsDeleteSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendBucket resource.

      Args:
        request: (ComputeBackendBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.get',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeBackendBucketsGetRequest',
        response_type_name='BackendBucket',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeBackendBucketsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/backendBuckets/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeBackendBucketsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendBucket resource in the specified project using the data included in the request.

      Args:
        request: (ComputeBackendBucketsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets',
        request_field='backendBucket',
        request_type_name='ComputeBackendBucketsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendBucket resources available to the specified project.

      Args:
        request: (ComputeBackendBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendBuckets',
        request_field='',
        request_type_name='ComputeBackendBucketsListRequest',
        response_type_name='BackendBucketList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves a list of all usable backend buckets in the specified project.

      Args:
        request: (ComputeBackendBucketsListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketListUsable) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.listUsable',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendBuckets/listUsable',
        request_field='',
        request_type_name='ComputeBackendBucketsListUsableRequest',
        response_type_name='BackendBucketListUsable',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.backendBuckets.patch',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='backendBucketResource',
        request_type_name='ComputeBackendBucketsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetEdgeSecurityPolicy(self, request, global_params=None):
      r"""Sets the edge security policy for the specified backend bucket.

      Args:
        request: (ComputeBackendBucketsSetEdgeSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetEdgeSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetEdgeSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.setEdgeSecurityPolicy',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/setEdgeSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendBucketsSetEdgeSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeBackendBucketsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeBackendBucketsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeBackendBucketsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeBackendBucketsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request.

      Args:
        request: (ComputeBackendBucketsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.backendBuckets.update',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='backendBucketResource',
        request_type_name='ComputeBackendBucketsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class BackendServicesService(base_api.BaseApiService):
    """Service class for the backendServices resource."""

    _NAME = 'backendServices'

    def __init__(self, client):
      super(ComputeAlpha.BackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.addSignedUrlKey',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/addSignedUrlKey',
        request_field='signedUrlKey',
        request_type_name='ComputeBackendServicesAddSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all BackendService resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeBackendServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/backendServices',
        request_field='',
        request_type_name='ComputeBackendServicesAggregatedListRequest',
        response_type_name='BackendServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendService resource.

      Args:
        request: (ComputeBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.backendServices.delete',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeBackendServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.deleteSignedUrlKey',
        ordered_params=['project', 'backendService', 'keyName'],
        path_params=['backendService', 'project'],
        query_params=['keyName', 'requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/deleteSignedUrlKey',
        request_field='',
        request_type_name='ComputeBackendServicesDeleteSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendService resource.

      Args:
        request: (ComputeBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.get',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeBackendServicesGetRequest',
        response_type_name='BackendService',
        supports_download=False,
    )

    def GetEffectiveSecurityPolicies(self, request, global_params=None):
      r"""Returns effective security policies applied to this backend service.

      Args:
        request: (ComputeBackendServicesGetEffectiveSecurityPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServicesGetEffectiveSecurityPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveSecurityPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveSecurityPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.getEffectiveSecurityPolicies',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{backendService}/getEffectiveSecurityPolicies',
        request_field='',
        request_type_name='ComputeBackendServicesGetEffectiveSecurityPoliciesRequest',
        response_type_name='BackendServicesGetEffectiveSecurityPoliciesResponse',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this BackendService. Example request body: { "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }.

      Args:
        request: (ComputeBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.getHealth',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{backendService}/getHealth',
        request_field='resourceGroupReference',
        request_type_name='ComputeBackendServicesGetHealthRequest',
        response_type_name='BackendServiceGroupHealth',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeBackendServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/backendServices/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeBackendServicesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview .

      Args:
        request: (ComputeBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices',
        request_field='backendService',
        request_type_name='ComputeBackendServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendService resources available to the specified project.

      Args:
        request: (ComputeBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendServices',
        request_field='',
        request_type_name='ComputeBackendServicesListRequest',
        response_type_name='BackendServiceList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves a list of all usable backend services in the specified project.

      Args:
        request: (ComputeBackendServicesListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceListUsable) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.listUsable',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendServices/listUsable',
        request_field='',
        request_type_name='ComputeBackendServicesListUsableRequest',
        response_type_name='BackendServiceListUsable',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified BackendService resource with the data included in the request. For more information, see Backend services overview. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.backendServices.patch',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeBackendServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetEdgeSecurityPolicy(self, request, global_params=None):
      r"""Sets the edge security policy for the specified backend service.

      Args:
        request: (ComputeBackendServicesSetEdgeSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetEdgeSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetEdgeSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setEdgeSecurityPolicy',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/setEdgeSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendServicesSetEdgeSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeBackendServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeBackendServicesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetSecurityPolicy(self, request, global_params=None):
      r"""Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview.

      Args:
        request: (ComputeBackendServicesSetSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setSecurityPolicy',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/setSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendServicesSetSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeBackendServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendService resource with the data included in the request. For more information, see Backend services overview.

      Args:
        request: (ComputeBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.backendServices.update',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeBackendServicesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class CrossSiteNetworksService(base_api.BaseApiService):
    """Service class for the crossSiteNetworks resource."""

    _NAME = 'crossSiteNetworks'

    def __init__(self, client):
      super(ComputeAlpha.CrossSiteNetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified cross-site network in the given scope.

      Args:
        request: (ComputeCrossSiteNetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.crossSiteNetworks.delete',
        ordered_params=['project', 'crossSiteNetwork'],
        path_params=['crossSiteNetwork', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/crossSiteNetworks/{crossSiteNetwork}',
        request_field='',
        request_type_name='ComputeCrossSiteNetworksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified cross-site network in the given scope.

      Args:
        request: (ComputeCrossSiteNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CrossSiteNetwork) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.crossSiteNetworks.get',
        ordered_params=['project', 'crossSiteNetwork'],
        path_params=['crossSiteNetwork', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/crossSiteNetworks/{crossSiteNetwork}',
        request_field='',
        request_type_name='ComputeCrossSiteNetworksGetRequest',
        response_type_name='CrossSiteNetwork',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a cross-site network in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeCrossSiteNetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.crossSiteNetworks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/global/crossSiteNetworks',
        request_field='crossSiteNetwork',
        request_type_name='ComputeCrossSiteNetworksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the cross-site networks for a project in the given scope.

      Args:
        request: (ComputeCrossSiteNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CrossSiteNetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.crossSiteNetworks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/crossSiteNetworks',
        request_field='',
        request_type_name='ComputeCrossSiteNetworksListRequest',
        response_type_name='CrossSiteNetworkList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified cross-site network with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeCrossSiteNetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.crossSiteNetworks.patch',
        ordered_params=['project', 'crossSiteNetwork'],
        path_params=['crossSiteNetwork', 'project'],
        query_params=['requestId', 'updateMask', 'validateOnly'],
        relative_path='projects/{project}/global/crossSiteNetworks/{crossSiteNetwork}',
        request_field='crossSiteNetworkResource',
        request_type_name='ComputeCrossSiteNetworksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class DiskSettingsService(base_api.BaseApiService):
    """Service class for the diskSettings resource."""

    _NAME = 'diskSettings'

    def __init__(self, client):
      super(ComputeAlpha.DiskSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get Zonal Disk Settings.

      Args:
        request: (ComputeDiskSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskSettings) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskSettings.get',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/diskSettings',
        request_field='',
        request_type_name='ComputeDiskSettingsGetRequest',
        response_type_name='DiskSettings',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patch Zonal Disk Settings.

      Args:
        request: (ComputeDiskSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.diskSettings.patch',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/diskSettings',
        request_field='diskSettings',
        request_type_name='ComputeDiskSettingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class DiskTypesService(base_api.BaseApiService):
    """Service class for the diskTypes resource."""

    _NAME = 'diskTypes'

    def __init__(self, client):
      super(ComputeAlpha.DiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of disk types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeDiskTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/diskTypes',
        request_field='',
        request_type_name='ComputeDiskTypesAggregatedListRequest',
        response_type_name='DiskTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified disk type.

      Args:
        request: (ComputeDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.get',
        ordered_params=['project', 'zone', 'diskType'],
        path_params=['diskType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/diskTypes/{diskType}',
        request_field='',
        request_type_name='ComputeDiskTypesGetRequest',
        response_type_name='DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of disk types available to the specified project.

      Args:
        request: (ComputeDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/diskTypes',
        request_field='',
        request_type_name='ComputeDiskTypesListRequest',
        response_type_name='DiskTypeList',
        supports_download=False,
    )

  class DisksService(base_api.BaseApiService):
    """Service class for the disks resource."""

    _NAME = 'disks'

    def __init__(self, client):
      super(ComputeAlpha.DisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.addResourcePolicies',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/addResourcePolicies',
        request_field='disksAddResourcePoliciesRequest',
        request_type_name='ComputeDisksAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of persistent disks. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeDisksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/disks',
        request_field='',
        request_type_name='ComputeDisksAggregatedListRequest',
        response_type_name='DiskAggregatedList',
        supports_download=False,
    )

    def BulkInsert(self, request, global_params=None):
      r"""Bulk create a set of disks.

      Args:
        request: (ComputeDisksBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.bulkInsert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/bulkInsert',
        request_field='bulkInsertDiskResource',
        request_type_name='ComputeDisksBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def BulkSetLabels(self, request, global_params=None):
      r"""Sets the labels on many disks at once. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeDisksBulkSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkSetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkSetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.bulkSetLabels',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'resource'],
        relative_path='projects/{project}/zones/{zone}/disks/bulkSetLabels',
        request_field='bulkZoneSetLabelsRequest',
        request_type_name='ComputeDisksBulkSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.

      Args:
        request: (ComputeDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.createSnapshot',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['guestFlush', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/createSnapshot',
        request_field='snapshot',
        request_type_name='ComputeDisksCreateSnapshotRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.disks.delete',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name='ComputeDisksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified persistent disk.

      Args:
        request: (ComputeDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.get',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name='ComputeDisksGetRequest',
        response_type_name='Disk',
        supports_download=False,
    )

    def GetAsyncReplicationStatus(self, request, global_params=None):
      r"""Gets the status of current async replication for a given device.

      Args:
        request: (ComputeDisksGetAsyncReplicationStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetAsyncReplicationStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetAsyncReplicationStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAsyncReplicationStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.getAsyncReplicationStatus',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/getAsyncReplicationStatus',
        request_field='',
        request_type_name='ComputeDisksGetAsyncReplicationStatusRequest',
        response_type_name='GetAsyncReplicationStatusResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeDisksGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent disk in the specified project using the data in the request. You can create a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.

      Args:
        request: (ComputeDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'sourceImage'],
        relative_path='projects/{project}/zones/{zone}/disks',
        request_field='disk',
        request_type_name='ComputeDisksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of persistent disks contained within the specified zone.

      Args:
        request: (ComputeDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/disks',
        request_field='',
        request_type_name='ComputeDisksListRequest',
        response_type_name='DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a disk.

      Args:
        request: (ComputeDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.removeResourcePolicies',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/removeResourcePolicies',
        request_field='disksRemoveResourcePoliciesRequest',
        request_type_name='ComputeDisksRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified persistent disk. You can only increase the size of the disk.

      Args:
        request: (ComputeDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.resize',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/resize',
        request_field='disksResizeRequest',
        request_type_name='ComputeDisksResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeDisksSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.setLabels',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/setLabels',
        request_field='zoneSetLabelsRequest',
        request_type_name='ComputeDisksSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartAsyncReplication(self, request, global_params=None):
      r"""Starts asynchronous replication. Must be invoked on the primary disk.

      Args:
        request: (ComputeDisksStartAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.startAsyncReplication',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/startAsyncReplication',
        request_field='disksStartAsyncReplicationRequest',
        request_type_name='ComputeDisksStartAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopAsyncReplication(self, request, global_params=None):
      r"""Stops asynchronous replication. Can be invoked either on the primary or on the secondary disk.

      Args:
        request: (ComputeDisksStopAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.stopAsyncReplication',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/stopAsyncReplication',
        request_field='',
        request_type_name='ComputeDisksStopAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopGroupAsyncReplication(self, request, global_params=None):
      r"""Stops asynchronous replication for a consistency group of disks. Can be invoked either in the primary or secondary scope.

      Args:
        request: (ComputeDisksStopGroupAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopGroupAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopGroupAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.stopGroupAsyncReplication',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/stopGroupAsyncReplication',
        request_field='disksStopGroupAsyncReplicationResource',
        request_type_name='ComputeDisksStopGroupAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeDisksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified disk with the data included in the request. The update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.

      Args:
        request: (ComputeDisksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.disks.update',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='diskResource',
        request_type_name='ComputeDisksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateKmskey(self, request, global_params=None):
      r"""Rotates the customer-managed encryption key to the latest version for the specified persistent disk.

      Args:
        request: (ComputeDisksUpdateKmskeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateKmskey')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateKmskey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.updateKmskey',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/updateKmsKey',
        request_field='',
        request_type_name='ComputeDisksUpdateKmskeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def WaitForReplicationCatchUp(self, request, global_params=None):
      r"""Wait for replication to catch up on the secondary disk.

      Args:
        request: (ComputeDisksWaitForReplicationCatchUpRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('WaitForReplicationCatchUp')
      return self._RunMethod(
          config, request, global_params=global_params)

    WaitForReplicationCatchUp.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.waitForReplicationCatchUp',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/waitForReplicationCatchUp',
        request_field='waitForReplicationCatchUpRequest',
        request_type_name='ComputeDisksWaitForReplicationCatchUpRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ExternalVpnGatewaysService(base_api.BaseApiService):
    """Service class for the externalVpnGateways resource."""

    _NAME = 'externalVpnGateways'

    def __init__(self, client):
      super(ComputeAlpha.ExternalVpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified externalVpnGateway.

      Args:
        request: (ComputeExternalVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.externalVpnGateways.delete',
        ordered_params=['project', 'externalVpnGateway'],
        path_params=['externalVpnGateway', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.

      Args:
        request: (ComputeExternalVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.externalVpnGateways.get',
        ordered_params=['project', 'externalVpnGateway'],
        path_params=['externalVpnGateway', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysGetRequest',
        response_type_name='ExternalVpnGateway',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ExternalVpnGateway in the specified project using the data included in the request.

      Args:
        request: (ComputeExternalVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/externalVpnGateways',
        request_field='externalVpnGateway',
        request_type_name='ComputeExternalVpnGatewaysInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of ExternalVpnGateway available to the specified project.

      Args:
        request: (ComputeExternalVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.externalVpnGateways.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/externalVpnGateways',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysListRequest',
        response_type_name='ExternalVpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeExternalVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeExternalVpnGatewaysSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeExternalVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeExternalVpnGatewaysTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class FirewallPoliciesService(base_api.BaseApiService):
    """Service class for the firewallPolicies resource."""

    _NAME = 'firewallPolicies'

    def __init__(self, client):
      super(ComputeAlpha.FirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.addAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddPacketMirroringRule(self, request, global_params=None):
      r"""Inserts a packet mirroring rule into a firewall policy.

      Args:
        request: (ComputeFirewallPoliciesAddPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.addPacketMirroringRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/addPacketMirroringRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesAddPacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a firewall policy.

      Args:
        request: (ComputeFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.addRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.cloneRules',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.firewallPolicies.delete',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ForceStartProgressiveRollout(self, request, global_params=None):
      r"""Starts a brand new progressive rollout of hierarchical firewall policy. This API will return an error when there is an ongoing progressive rollout.

      Args:
        request: (ComputeFirewallPoliciesForceStartProgressiveRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ForceStartProgressiveRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    ForceStartProgressiveRollout.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.forceStartProgressiveRollout',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/forceStartProgressiveRollout',
        request_field='',
        request_type_name='ComputeFirewallPoliciesForceStartProgressiveRolloutRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.get',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['name'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='locations/global/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetPacketMirroringRule(self, request, global_params=None):
      r"""Gets a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesGetPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getPacketMirroringRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/getPacketMirroringRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetPacketMirroringRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.insert',
        ordered_params=[],
        path_params=[],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the policies that have been configured for the specified folder or organization.

      Args:
        request: (ComputeFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/firewallPolicies',
        request_field='',
        request_type_name='ComputeFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def ListAssociations(self, request, global_params=None):
      r"""Lists associations of a specified target, i.e., organization or folder.

      Args:
        request: (ComputeFirewallPoliciesListAssociationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPoliciesListAssociationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAssociations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAssociations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.listAssociations',
        ordered_params=[],
        path_params=[],
        query_params=['includeInheritedPolicies', 'targetResource'],
        relative_path='locations/global/firewallPolicies/listAssociations',
        request_field='',
        request_type_name='ComputeFirewallPoliciesListAssociationsRequest',
        response_type_name='FirewallPoliciesListAssociationsResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.move',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/move',
        request_field='',
        request_type_name='ComputeFirewallPoliciesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.firewallPolicies.patch',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPacketMirroringRule(self, request, global_params=None):
      r"""Patches a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesPatchPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.patchPacketMirroringRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/patchPacketMirroringRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesPatchPacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.patchRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.removeAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['name', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemovePacketMirroringRule(self, request, global_params=None):
      r"""Deletes a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesRemovePacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemovePacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemovePacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.removePacketMirroringRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/removePacketMirroringRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesRemovePacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.removeRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{resource}/setIamPolicy',
        request_field='globalOrganizationSetPolicyRequest',
        request_type_name='ComputeFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class FirewallsService(base_api.BaseApiService):
    """Service class for the firewalls resource."""

    _NAME = 'firewalls'

    def __init__(self, client):
      super(ComputeAlpha.FirewallsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified firewall.

      Args:
        request: (ComputeFirewallsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.firewalls.delete',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name='ComputeFirewallsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified firewall.

      Args:
        request: (ComputeFirewallsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Firewall) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewalls.get',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name='ComputeFirewallsGetRequest',
        response_type_name='Firewall',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a firewall rule in the specified project using the data included in the request.

      Args:
        request: (ComputeFirewallsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewalls.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls',
        request_field='firewall',
        request_type_name='ComputeFirewallsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of firewall rules available to the specified project.

      Args:
        request: (ComputeFirewallsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewalls.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/firewalls',
        request_field='',
        request_type_name='ComputeFirewallsListRequest',
        response_type_name='FirewallList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeFirewallsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.firewalls.patch',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='firewallResource',
        request_type_name='ComputeFirewallsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeFirewallsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewalls.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewalls/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeFirewallsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. Note that all fields will be updated if using PUT, even fields that are not specified. To update individual fields, please use PATCH instead.

      Args:
        request: (ComputeFirewallsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.firewalls.update',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='firewallResource',
        request_type_name='ComputeFirewallsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ForwardingRulesService(base_api.BaseApiService):
    """Service class for the forwardingRules resource."""

    _NAME = 'forwardingRules'

    def __init__(self, client):
      super(ComputeAlpha.ForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of forwarding rules. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeForwardingRulesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/forwardingRules',
        request_field='',
        request_type_name='ComputeForwardingRulesAggregatedListRequest',
        response_type_name='ForwardingRuleAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.forwardingRules.delete',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeForwardingRulesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.get',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeForwardingRulesGetRequest',
        response_type_name='ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ForwardingRule resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules',
        request_field='forwardingRule',
        request_type_name='ComputeForwardingRulesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of ForwardingRule resources available to the specified project and region.

      Args:
        request: (ComputeForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/forwardingRules',
        request_field='',
        request_type_name='ComputeForwardingRulesListRequest',
        response_type_name='ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.forwardingRules.patch',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='forwardingRuleResource',
        request_type_name='ComputeForwardingRulesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeForwardingRulesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for forwarding rule. The new target should be of the same type as the old target.

      Args:
        request: (ComputeForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.setTarget',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget',
        request_field='targetReference',
        request_type_name='ComputeForwardingRulesSetTargetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeForwardingRulesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class FutureReservationsService(base_api.BaseApiService):
    """Service class for the futureReservations resource."""

    _NAME = 'futureReservations'

    def __init__(self, client):
      super(ComputeAlpha.FutureReservationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of future reservations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeFutureReservationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FutureReservationsAggregatedListResponse) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.futureReservations.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/futureReservations',
        request_field='',
        request_type_name='ComputeFutureReservationsAggregatedListRequest',
        response_type_name='FutureReservationsAggregatedListResponse',
        supports_download=False,
    )

    def Cancel(self, request, global_params=None):
      r"""Cancel the specified future reservation.

      Args:
        request: (ComputeFutureReservationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.futureReservations.cancel',
        ordered_params=['project', 'zone', 'futureReservation'],
        path_params=['futureReservation', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/futureReservations/{futureReservation}/cancel',
        request_field='',
        request_type_name='ComputeFutureReservationsCancelRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified future reservation.

      Args:
        request: (ComputeFutureReservationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.futureReservations.delete',
        ordered_params=['project', 'zone', 'futureReservation'],
        path_params=['futureReservation', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/futureReservations/{futureReservation}',
        request_field='',
        request_type_name='ComputeFutureReservationsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves information about the specified future reservation.

      Args:
        request: (ComputeFutureReservationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FutureReservation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.futureReservations.get',
        ordered_params=['project', 'zone', 'futureReservation'],
        path_params=['futureReservation', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/futureReservations/{futureReservation}',
        request_field='',
        request_type_name='ComputeFutureReservationsGetRequest',
        response_type_name='FutureReservation',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new Future Reservation.

      Args:
        request: (ComputeFutureReservationsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.futureReservations.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/futureReservations',
        request_field='futureReservation',
        request_type_name='ComputeFutureReservationsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""A list of all the future reservations that have been configured for the specified project in specified zone.

      Args:
        request: (ComputeFutureReservationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FutureReservationsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.futureReservations.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/futureReservations',
        request_field='',
        request_type_name='ComputeFutureReservationsListRequest',
        response_type_name='FutureReservationsListResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified future reservation.

      Args:
        request: (ComputeFutureReservationsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.futureReservations.update',
        ordered_params=['project', 'zone', 'futureReservation'],
        path_params=['futureReservation', 'project', 'zone'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/futureReservations/{futureReservation}',
        request_field='futureReservationResource',
        request_type_name='ComputeFutureReservationsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class GlobalAddressesService(base_api.BaseApiService):
    """Service class for the globalAddresses resource."""

    _NAME = 'globalAddresses'

    def __init__(self, client):
      super(ComputeAlpha.GlobalAddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeGlobalAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalAddresses.delete',
        ordered_params=['project', 'address'],
        path_params=['address', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name='ComputeGlobalAddressesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource.

      Args:
        request: (ComputeGlobalAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalAddresses.get',
        ordered_params=['project', 'address'],
        path_params=['address', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name='ComputeGlobalAddressesGetRequest',
        response_type_name='Address',
        supports_download=False,
    )

    def GetOwnerInstance(self, request, global_params=None):
      r"""Find owner instance from given ip address.

      Args:
        request: (ComputeGlobalAddressesGetOwnerInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetOwnerInstanceResponse) The response message.
      """
      config = self.GetMethodConfig('GetOwnerInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOwnerInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalAddresses.getOwnerInstance',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['ipAddress'],
        relative_path='projects/{project}/global/addresses/getOwnerInstance',
        request_field='',
        request_type_name='ComputeGlobalAddressesGetOwnerInstanceRequest',
        response_type_name='GetOwnerInstanceResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeGlobalAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/addresses',
        request_field='address',
        request_type_name='ComputeGlobalAddressesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of global addresses.

      Args:
        request: (ComputeGlobalAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalAddresses.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/addresses',
        request_field='',
        request_type_name='ComputeGlobalAddressesListRequest',
        response_type_name='AddressList',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified address resource from one project to another project.

      Args:
        request: (ComputeGlobalAddressesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.move',
        ordered_params=['project', 'address'],
        path_params=['address', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/addresses/{address}/move',
        request_field='globalAddressesMoveRequest',
        request_type_name='ComputeGlobalAddressesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a GlobalAddress. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeGlobalAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeGlobalAddressesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeGlobalAddressesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalFolderOperationsService(base_api.BaseApiService):
    """Service class for the globalFolderOperations resource."""

    _NAME = 'globalFolderOperations'

    def __init__(self, client):
      super(ComputeAlpha.GlobalFolderOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource.

      Args:
        request: (ComputeGlobalFolderOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='folders/{foldersId}/global/operations/{operation}',
        http_method='GET',
        method_id='compute.globalFolderOperations.get',
        ordered_params=['folder', 'operation'],
        path_params=['folder', 'operation'],
        query_params=[],
        relative_path='{+folder}/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalFolderOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified folder.

      Args:
        request: (ComputeGlobalFolderOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='folders/{foldersId}/global/operations',
        http_method='GET',
        method_id='compute.globalFolderOperations.list',
        ordered_params=['folder'],
        path_params=['folder'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='{+folder}/global/operations',
        request_field='',
        request_type_name='ComputeGlobalFolderOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

  class GlobalForwardingRulesService(base_api.BaseApiService):
    """Service class for the globalForwardingRules resource."""

    _NAME = 'globalForwardingRules'

    def __init__(self, client):
      super(ComputeAlpha.GlobalForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified GlobalForwardingRule resource.

      Args:
        request: (ComputeGlobalForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalForwardingRules.delete',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.

      Args:
        request: (ComputeGlobalForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalForwardingRules.get',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesGetRequest',
        response_type_name='ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a GlobalForwardingRule resource in the specified project using the data included in the request.

      Args:
        request: (ComputeGlobalForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules',
        request_field='forwardingRule',
        request_type_name='ComputeGlobalForwardingRulesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of GlobalForwardingRule resources available to the specified project.

      Args:
        request: (ComputeGlobalForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalForwardingRules.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/forwardingRules',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesListRequest',
        response_type_name='ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeGlobalForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalForwardingRules.patch',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='forwardingRuleResource',
        request_type_name='ComputeGlobalForwardingRulesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling resources documentation.

      Args:
        request: (ComputeGlobalForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeGlobalForwardingRulesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.

      Args:
        request: (ComputeGlobalForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.setTarget',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}/setTarget',
        request_field='targetReference',
        request_type_name='ComputeGlobalForwardingRulesSetTargetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeGlobalForwardingRulesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalNetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the globalNetworkEndpointGroups resource."""

    _NAME = 'globalNetworkEndpointGroups'

    def __init__(self, client):
      super(ComputeAlpha.GlobalNetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a network endpoint to the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.attachNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field='globalNetworkEndpointGroupsAttachEndpointsRequest',
        request_type_name='ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group.Note that the NEG cannot be deleted if there are backend services referencing it.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalNetworkEndpointGroups.delete',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach the network endpoint from the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.detachNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field='globalNetworkEndpointGroupsDetachEndpointsRequest',
        request_type_name='ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalNetworkEndpointGroups.get',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeGlobalNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups that are located in the specified project.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalNetworkEndpointGroups.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.listNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name='NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

  class GlobalOperationsService(base_api.BaseApiService):
    """Service class for the globalOperations resource."""

    _NAME = 'globalOperations'

    def __init__(self, client):
      super(ComputeAlpha.GlobalOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all operations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeGlobalOperationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/operations',
        request_field='',
        request_type_name='ComputeGlobalOperationsAggregatedListRequest',
        response_type_name='OperationAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Operations resource.

      Args:
        request: (ComputeGlobalOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeGlobalOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalOperations.delete',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOperationsDeleteRequest',
        response_type_name='ComputeGlobalOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource.

      Args:
        request: (ComputeGlobalOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.get',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified project.

      Args:
        request: (ComputeGlobalOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/operations',
        request_field='',
        request_type_name='ComputeGlobalOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

    def Wait(self, request, global_params=None):
      r"""Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. .

      Args:
        request: (ComputeGlobalOperationsWaitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wait')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wait.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalOperations.wait',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}/wait',
        request_field='',
        request_type_name='ComputeGlobalOperationsWaitRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class GlobalOrganizationOperationsService(base_api.BaseApiService):
    """Service class for the globalOrganizationOperations resource."""

    _NAME = 'globalOrganizationOperations'

    def __init__(self, client):
      super(ComputeAlpha.GlobalOrganizationOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Operations resource.

      Args:
        request: (ComputeGlobalOrganizationOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeGlobalOrganizationOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalOrganizationOperations.delete',
        ordered_params=['operation'],
        path_params=['operation'],
        query_params=['parentId'],
        relative_path='locations/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsDeleteRequest',
        response_type_name='ComputeGlobalOrganizationOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource. Gets a list of operations by making a `list()` request.

      Args:
        request: (ComputeGlobalOrganizationOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOrganizationOperations.get',
        ordered_params=['operation'],
        path_params=['operation'],
        query_params=['parentId'],
        relative_path='locations/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified organization.

      Args:
        request: (ComputeGlobalOrganizationOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOrganizationOperations.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/operations',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

  class GlobalPublicDelegatedPrefixesService(base_api.BaseApiService):
    """Service class for the globalPublicDelegatedPrefixes resource."""

    _NAME = 'globalPublicDelegatedPrefixes'

    def __init__(self, client):
      super(ComputeAlpha.GlobalPublicDelegatedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified global PublicDelegatedPrefix.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalPublicDelegatedPrefixes.delete',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified global PublicDelegatedPrefix resource.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalPublicDelegatedPrefixes.get',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=[],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesGetRequest',
        response_type_name='PublicDelegatedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a global PublicDelegatedPrefix in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalPublicDelegatedPrefixes.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes',
        request_field='publicDelegatedPrefix',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the global PublicDelegatedPrefixes for a project.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalPublicDelegatedPrefixes.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesListRequest',
        response_type_name='PublicDelegatedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified global PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalPublicDelegatedPrefixes.patch',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='publicDelegatedPrefixResource',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class GlobalVmExtensionPoliciesService(base_api.BaseApiService):
    """Service class for the globalVmExtensionPolicies resource."""

    _NAME = 'globalVmExtensionPolicies'

    def __init__(self, client):
      super(ComputeAlpha.GlobalVmExtensionPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all VM Extension Policy resources available to the specified project. To prevent failure, it's recommended that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VmExtensionPolicyAggregatedListResponse) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalVmExtensionPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/vmExtensionPolicies',
        request_field='',
        request_type_name='ComputeGlobalVmExtensionPoliciesAggregatedListRequest',
        response_type_name='VmExtensionPolicyAggregatedListResponse',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Purge scoped resources (zonal policies) from a global VM extension policy, and then delete the global VM extension policy. Purge of the scoped resources is a pre-condition of the global VM extension policy deletion. The deletion of the global VM extension policy happens after the purge rollout is done, so it's not a part of the LRO. It's an automatic process that triggers in the backend.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalVmExtensionPolicies.delete',
        ordered_params=['project', 'globalVmExtensionPolicy'],
        path_params=['globalVmExtensionPolicy', 'project'],
        query_params=['requestId', 'rolloutInput_conflictBehavior', 'rolloutInput_name', 'rolloutInput_predefinedRolloutPlan', 'rolloutInput_retryUuid'],
        relative_path='projects/{project}/global/vmExtensionPolicies/{globalVmExtensionPolicy}',
        request_field='',
        request_type_name='ComputeGlobalVmExtensionPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a global VM extension policy.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GlobalVmExtensionPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalVmExtensionPolicies.get',
        ordered_params=['project', 'globalVmExtensionPolicy'],
        path_params=['globalVmExtensionPolicy', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/vmExtensionPolicies/{globalVmExtensionPolicy}',
        request_field='',
        request_type_name='ComputeGlobalVmExtensionPoliciesGetRequest',
        response_type_name='GlobalVmExtensionPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new project level GlobalVmExtensionPolicy.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalVmExtensionPolicies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/vmExtensionPolicies',
        request_field='globalVmExtensionPolicy',
        request_type_name='ComputeGlobalVmExtensionPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists global VM extension policies.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GlobalVmExtensionPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalVmExtensionPolicies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/vmExtensionPolicies',
        request_field='',
        request_type_name='ComputeGlobalVmExtensionPoliciesListRequest',
        response_type_name='GlobalVmExtensionPolicyList',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a global VM extension policy.

      Args:
        request: (ComputeGlobalVmExtensionPoliciesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalVmExtensionPolicies.update',
        ordered_params=['project', 'globalVmExtensionPolicy'],
        path_params=['globalVmExtensionPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/vmExtensionPolicies/{globalVmExtensionPolicy}',
        request_field='globalVmExtensionPolicyResource',
        request_type_name='ComputeGlobalVmExtensionPoliciesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HaControllersService(base_api.BaseApiService):
    """Service class for the haControllers resource."""

    _NAME = 'haControllers'

    def __init__(self, client):
      super(ComputeAlpha.HaControllersService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes an HaController in the specified project.

      Args:
        request: (ComputeHaControllersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.haControllers.delete',
        ordered_params=['project', 'region', 'haController'],
        path_params=['haController', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/haControllers/{haController}',
        request_field='',
        request_type_name='ComputeHaControllersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Failover(self, request, global_params=None):
      r"""Fails over a VM targeted by the specified HaController to the selected zone.

      Args:
        request: (ComputeHaControllersFailoverRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Failover')
      return self._RunMethod(
          config, request, global_params=global_params)

    Failover.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.haControllers.failover',
        ordered_params=['project', 'region', 'haController'],
        path_params=['haController', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/haControllers/{haController}/failover',
        request_field='haControllersFailoverRequest',
        request_type_name='ComputeHaControllersFailoverRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all the details of a specific HaController.

      Args:
        request: (ComputeHaControllersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HaController) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.haControllers.get',
        ordered_params=['project', 'region', 'haController'],
        path_params=['haController', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/haControllers/{haController}',
        request_field='',
        request_type_name='ComputeHaControllersGetRequest',
        response_type_name='HaController',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates HaController in the specified project.

      Args:
        request: (ComputeHaControllersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.haControllers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/haControllers',
        request_field='haController',
        request_type_name='ComputeHaControllersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all HaControllers in the specified project in the specified region.

      Args:
        request: (ComputeHaControllersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HaControllersList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.haControllers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/haControllers',
        request_field='',
        request_type_name='ComputeHaControllersListRequest',
        response_type_name='HaControllersList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates HaController in the specified project.

      Args:
        request: (ComputeHaControllersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.haControllers.patch',
        ordered_params=['project', 'region', 'haController'],
        path_params=['haController', 'project', 'region'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/haControllers/{haController}',
        request_field='haControllerResource',
        request_type_name='ComputeHaControllersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HealthChecksService(base_api.BaseApiService):
    """Service class for the healthChecks resource."""

    _NAME = 'healthChecks'

    def __init__(self, client):
      super(ComputeAlpha.HealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthCheck resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeHealthChecksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthChecksAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/healthChecks',
        request_field='',
        request_type_name='ComputeHealthChecksAggregatedListRequest',
        response_type_name='HealthChecksAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.healthChecks.delete',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource.

      Args:
        request: (ComputeHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.get',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeHealthChecksGetRequest',
        response_type_name='HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.healthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks',
        request_field='healthCheck',
        request_type_name='ComputeHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/healthChecks',
        request_field='',
        request_type_name='ComputeHealthChecksListRequest',
        response_type_name='HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.healthChecks.patch',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.healthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/healthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.healthChecks.update',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HttpHealthChecksService(base_api.BaseApiService):
    """Service class for the httpHealthChecks resource."""

    _NAME = 'httpHealthChecks'

    def __init__(self, client):
      super(ComputeAlpha.HttpHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpHealthCheck resource.

      Args:
        request: (ComputeHttpHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.httpHealthChecks.delete',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpHealthCheck resource.

      Args:
        request: (ComputeHttpHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpHealthChecks.get',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpHealthChecksGetRequest',
        response_type_name='HttpHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpHealthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks',
        request_field='httpHealthCheck',
        request_type_name='ComputeHttpHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpHealthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/httpHealthChecks',
        request_field='',
        request_type_name='ComputeHttpHealthChecksListRequest',
        response_type_name='HttpHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.httpHealthChecks.patch',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='httpHealthCheckResource',
        request_type_name='ComputeHttpHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpHealthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/httpHealthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHttpHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.httpHealthChecks.update',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='httpHealthCheckResource',
        request_type_name='ComputeHttpHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HttpsHealthChecksService(base_api.BaseApiService):
    """Service class for the httpsHealthChecks resource."""

    _NAME = 'httpsHealthChecks'

    def __init__(self, client):
      super(ComputeAlpha.HttpsHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpsHealthCheck resource.

      Args:
        request: (ComputeHttpsHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.httpsHealthChecks.delete',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpsHealthCheck resource.

      Args:
        request: (ComputeHttpsHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpsHealthChecks.get',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksGetRequest',
        response_type_name='HttpsHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpsHealthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks',
        request_field='httpsHealthCheck',
        request_type_name='ComputeHttpsHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpsHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpsHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpsHealthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/httpsHealthChecks',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksListRequest',
        response_type_name='HttpsHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpsHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.httpsHealthChecks.patch',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='httpsHealthCheckResource',
        request_type_name='ComputeHttpsHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpsHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpsHealthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/httpsHealthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHttpsHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.httpsHealthChecks.update',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='httpsHealthCheckResource',
        request_type_name='ComputeHttpsHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ImageFamilyViewsService(base_api.BaseApiService):
    """Service class for the imageFamilyViews resource."""

    _NAME = 'imageFamilyViews'

    def __init__(self, client):
      super(ComputeAlpha.ImageFamilyViewsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the latest image that is part of an image family, is not deprecated and is rolled out in the specified zone.

      Args:
        request: (ComputeImageFamilyViewsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageFamilyView) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.imageFamilyViews.get',
        ordered_params=['project', 'zone', 'family'],
        path_params=['family', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/imageFamilyViews/{family}',
        request_field='',
        request_type_name='ComputeImageFamilyViewsGetRequest',
        response_type_name='ImageFamilyView',
        supports_download=False,
    )

  class ImagesService(base_api.BaseApiService):
    """Service class for the images resource."""

    _NAME = 'images'

    def __init__(self, client):
      super(ComputeAlpha.ImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified image.

      Args:
        request: (ComputeImagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.images.delete',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}',
        request_field='',
        request_type_name='ComputeImagesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Deprecate(self, request, global_params=None):
      r"""Sets the deprecation status of an image. If an empty request body is given, clears the deprecation status instead.

      Args:
        request: (ComputeImagesDeprecateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deprecate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deprecate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.deprecate',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}/deprecate',
        request_field='deprecationStatus',
        request_type_name='ComputeImagesDeprecateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified image.

      Args:
        request: (ComputeImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.get',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/images/{image}',
        request_field='',
        request_type_name='ComputeImagesGetRequest',
        response_type_name='Image',
        supports_download=False,
    )

    def GetFromFamily(self, request, global_params=None):
      r"""Returns the latest image that is part of an image family and is not deprecated. For more information on image families, see Public image families documentation.

      Args:
        request: (ComputeImagesGetFromFamilyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('GetFromFamily')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetFromFamily.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.getFromFamily',
        ordered_params=['project', 'family'],
        path_params=['family', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/images/family/{family}',
        request_field='',
        request_type_name='ComputeImagesGetFromFamilyRequest',
        response_type_name='Image',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeImagesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/images/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeImagesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an image in the specified project using the data included in the request.

      Args:
        request: (ComputeImagesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['forceCreate', 'requestId'],
        relative_path='projects/{project}/global/images',
        request_field='image',
        request_type_name='ComputeImagesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of custom images available to the specified project. Custom images are images you create that belong to your project. This method does not get any images that belong to other projects, including publicly-available images, like Debian 8. If you want to get a list of publicly-available images, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.

      Args:
        request: (ComputeImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'zone'],
        relative_path='projects/{project}/global/images',
        request_field='',
        request_type_name='ComputeImagesListRequest',
        response_type_name='ImageList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified image with the data included in the request. Only the following fields can be modified: family, description, deprecation status.

      Args:
        request: (ComputeImagesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.images.patch',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}',
        request_field='imageResource',
        request_type_name='ComputeImagesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeImagesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeImagesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an image. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeImagesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeImagesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeImagesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeImagesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceGroupManagerResizeRequestsService(base_api.BaseApiService):
    """Service class for the instanceGroupManagerResizeRequests resource."""

    _NAME = 'instanceGroupManagerResizeRequests'

    def __init__(self, client):
      super(ComputeAlpha.InstanceGroupManagerResizeRequestsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified resize request and removes it from the queue. Cancelled resize request does no longer wait for the resources to be provisioned. Cancel is only possible for requests that are accepted in the queue.

      Args:
        request: (ComputeInstanceGroupManagerResizeRequestsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagerResizeRequests.cancel',
        ordered_params=['project', 'zone', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'resizeRequest', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}/cancel',
        request_field='',
        request_type_name='ComputeInstanceGroupManagerResizeRequestsCancelRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified, inactive resize request. Requests that are still active cannot be deleted. Deleting request does not delete instances that were provisioned previously.

      Args:
        request: (ComputeInstanceGroupManagerResizeRequestsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceGroupManagerResizeRequests.delete',
        ordered_params=['project', 'zone', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'resizeRequest', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagerResizeRequestsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified resize request.

      Args:
        request: (ComputeInstanceGroupManagerResizeRequestsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerResizeRequest) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagerResizeRequests.get',
        ordered_params=['project', 'zone', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'resizeRequest', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagerResizeRequestsGetRequest',
        response_type_name='InstanceGroupManagerResizeRequest',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new resize request that starts provisioning VMs immediately or queues VM creation.

      Args:
        request: (ComputeInstanceGroupManagerResizeRequestsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagerResizeRequests.insert',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests',
        request_field='instanceGroupManagerResizeRequest',
        request_type_name='ComputeInstanceGroupManagerResizeRequestsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of resize requests that are contained in the managed instance group.

      Args:
        request: (ComputeInstanceGroupManagerResizeRequestsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerResizeRequestsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagerResizeRequests.list',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests',
        request_field='',
        request_type_name='ComputeInstanceGroupManagerResizeRequestsListRequest',
        response_type_name='InstanceGroupManagerResizeRequestsListResponse',
        supports_download=False,
    )

  class InstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the instanceGroupManagers resource."""

    _NAME = 'instanceGroupManagers'

    def __init__(self, client):
      super(ComputeAlpha.InstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.abandonInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field='instanceGroupManagersAbandonInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersAbandonInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups and groups them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInstanceGroupManagersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersAggregatedListRequest',
        response_type_name='InstanceGroupManagerAggregatedList',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Applies changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.

      Args:
        request: (ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.applyUpdatesToInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field='instanceGroupManagersApplyUpdatesRequest',
        request_type_name='ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateInstances(self, request, global_params=None):
      r"""Creates instances with per-instance configurations in this managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.

      Args:
        request: (ComputeInstanceGroupManagersCreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.createInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/createInstances',
        request_field='instanceGroupManagersCreateInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersCreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceGroupManagers.delete',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.deleteInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field='instanceGroupManagersDeleteInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersDeleteInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeletePerInstanceConfigs(self, request, global_params=None):
      r"""Deletes selected per-instance configurations for the managed instance group.

      Args:
        request: (ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeletePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeletePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.deletePerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs',
        request_field='instanceGroupManagersDeletePerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group.

      Args:
        request: (ComputeInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.get',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersGetRequest',
        response_type_name='InstanceGroupManager',
        supports_download=False,
    )

    def GetAvailableAcceleratorTopologies(self, request, global_params=None):
      r"""Returns information about available accelerator topologies for a given MIG.

      Args:
        request: (ComputeInstanceGroupManagersGetAvailableAcceleratorTopologiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersGetAvailableAcceleratorTopologiesResponse) The response message.
      """
      config = self.GetMethodConfig('GetAvailableAcceleratorTopologies')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAvailableAcceleratorTopologies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.getAvailableAcceleratorTopologies',
        ordered_params=['project', 'zone', 'resourceId'],
        path_params=['project', 'resourceId', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{resourceId}/getAvailableAcceleratorTopologies',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersGetAvailableAcceleratorTopologiesRequest',
        response_type_name='InstanceGroupManagersGetAvailableAcceleratorTopologiesResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.

      Args:
        request: (ComputeInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field='instanceGroupManager',
        request_type_name='ComputeInstanceGroupManagersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of managed instance groups that are contained within the specified project and zone.

      Args:
        request: (ComputeInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListRequest',
        response_type_name='InstanceGroupManagerList',
        supports_download=False,
    )

    def ListErrors(self, request, global_params=None):
      r"""Lists all errors thrown by actions on instances for a given managed instance group. The filter and orderBy query parameters are not supported.

      Args:
        request: (ComputeInstanceGroupManagersListErrorsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListErrorsResponse) The response message.
      """
      config = self.GetMethodConfig('ListErrors')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListErrors.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.listErrors',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listErrors',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListErrorsRequest',
        response_type_name='InstanceGroupManagersListErrorsResponse',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.

      Args:
        request: (ComputeInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListManagedInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.listManagedInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListManagedInstancesRequest',
        response_type_name='InstanceGroupManagersListManagedInstancesResponse',
        supports_download=False,
    )

    def ListPerInstanceConfigs(self, request, global_params=None):
      r"""Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.

      Args:
        request: (ComputeInstanceGroupManagersListPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListPerInstanceConfigsResp) The response message.
      """
      config = self.GetMethodConfig('ListPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.listPerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListPerInstanceConfigsRequest',
        response_type_name='InstanceGroupManagersListPerInstanceConfigsResp',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instanceGroupManagers.patch',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeInstanceGroupManagersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.patchPerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs',
        request_field='instanceGroupManagersPatchPerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.recreateInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field='instanceGroupManagersRecreateInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersRecreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including: + The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance. This list is subject to change. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.resize',
        ordered_params=['project', 'zone', 'instanceGroupManager', 'size'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId', 'size'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResizeAdvanced(self, request, global_params=None):
      r"""Resizes the managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size of the instance group, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating, creatingWithoutRetries, or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeAdvancedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResizeAdvanced')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResizeAdvanced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.resizeAdvanced',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced',
        request_field='instanceGroupManagersResizeAdvancedRequest',
        request_type_name='ComputeInstanceGroupManagersResizeAdvancedRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResumeInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be resumed. This method increases the targetSize and decreases the targetSuspendedSize of the managed instance group by the number of instances that you resume. The resumeInstances operation is marked DONE if the resumeInstances request is successful. The underlying actions take additional time. You must separately verify the status of the RESUMING action with the listmanagedinstances method. In this request, you can only specify instances that are suspended. For example, if an instance was previously suspended using the suspendInstances method, it can be resumed using the resumeInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are resumed. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersResumeInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResumeInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResumeInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.resumeInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resumeInstances',
        request_field='instanceGroupManagersResumeInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersResumeInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Motifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use instanceGroupManagers.patch instead.

      Args:
        request: (ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setAutoHealingPolicies',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field='instanceGroupManagersSetAutoHealingRequest',
        request_type_name='ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.

      Args:
        request: (ComputeInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setInstanceTemplate',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field='instanceGroupManagersSetInstanceTemplateRequest',
        request_type_name='ComputeInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.

      Args:
        request: (ComputeInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setTargetPools',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field='instanceGroupManagersSetTargetPoolsRequest',
        request_type_name='ComputeInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be started. This method increases the targetSize and decreases the targetStoppedSize of the managed instance group by the number of instances that you start. The startInstances operation is marked DONE if the startInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STARTING action with the listmanagedinstances method. In this request, you can only specify instances that are stopped. For example, if an instance was previously stopped using the stopInstances method, it can be started using the startInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are started. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersStartInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.startInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/startInstances',
        request_field='instanceGroupManagersStartInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersStartInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately stopped. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetStoppedSize of the managed instance group by the number of instances that you stop. The stopInstances operation is marked DONE if the stopInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STOPPING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays stopping the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is stopped. Stopped instances can be started using the startInstances method. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersStopInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.stopInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/stopInstances',
        request_field='instanceGroupManagersStopInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersStopInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SuspendInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately suspended. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetSuspendedSize of the managed instance group by the number of instances that you suspend. The suspendInstances operation is marked DONE if the suspendInstances request is successful. The underlying actions take additional time. You must separately verify the status of the SUSPENDING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays suspension of the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is suspended. Suspended instances can be resumed using the resumeInstances method. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersSuspendInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SuspendInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SuspendInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.suspendInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/suspendInstances',
        request_field='instanceGroupManagersSuspendInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersSuspendInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listManagedInstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.instanceGroupManagers.update',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeInstanceGroupManagersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdatePerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.updatePerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs',
        request_field='instanceGroupManagersUpdatePerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class InstanceGroupsService(base_api.BaseApiService):
    """Service class for the instanceGroups resource."""

    _NAME = 'instanceGroups'

    def __init__(self, client):
      super(ComputeAlpha.InstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddInstances(self, request, global_params=None):
      r"""Adds a list of instances to the specified instance group. All of the instances in the instance group must be in the same network/subnetwork. Read Adding instances for more information.

      Args:
        request: (ComputeInstanceGroupsAddInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.addInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances',
        request_field='instanceGroupsAddInstancesRequest',
        request_type_name='ComputeInstanceGroupsAddInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of instance groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInstanceGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/instanceGroups',
        request_field='',
        request_type_name='ComputeInstanceGroupsAggregatedListRequest',
        response_type_name='InstanceGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance group. The instances in the group are not deleted. Note that instance group must not belong to a backend service. Read Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceGroups.delete',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeInstanceGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified zonal instance group. Get a list of available zonal instance groups by making a list() request. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.

      Args:
        request: (ComputeInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.get',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeInstanceGroupsGetRequest',
        response_type_name='InstanceGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeInstanceGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups',
        request_field='instanceGroup',
        request_type_name='ComputeInstanceGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of zonal instance group resources contained within the specified zone. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.

      Args:
        request: (ComputeInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups',
        request_field='',
        request_type_name='ComputeInstanceGroupsListRequest',
        response_type_name='InstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group. The orderBy query parameter is not supported. The filter query parameter is supported, but only for expressions that use `eq` (equal) or `ne` (not equal) operators.

      Args:
        request: (ComputeInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.listInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances',
        request_field='instanceGroupsListInstancesRequest',
        request_type_name='ComputeInstanceGroupsListInstancesRequest',
        response_type_name='InstanceGroupsListInstances',
        supports_download=False,
    )

    def RemoveInstances(self, request, global_params=None):
      r"""Removes one or more instances from the specified instance group, but does not delete those instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupsRemoveInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.removeInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances',
        request_field='instanceGroupsRemoveInstancesRequest',
        request_type_name='ComputeInstanceGroupsRemoveInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified instance group.

      Args:
        request: (ComputeInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.setNamedPorts',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field='instanceGroupsSetNamedPortsRequest',
        request_type_name='ComputeInstanceGroupsSetNamedPortsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceSettingsService(base_api.BaseApiService):
    """Service class for the instanceSettings resource."""

    _NAME = 'instanceSettings'

    def __init__(self, client):
      super(ComputeAlpha.InstanceSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get Instance settings.

      Args:
        request: (ComputeInstanceSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceSettings) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceSettings.get',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceSettings',
        request_field='',
        request_type_name='ComputeInstanceSettingsGetRequest',
        response_type_name='InstanceSettings',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patch Instance settings.

      Args:
        request: (ComputeInstanceSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instanceSettings.patch',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/instanceSettings',
        request_field='instanceSettings',
        request_type_name='ComputeInstanceSettingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class InstanceTemplatesService(base_api.BaseApiService):
    """Service class for the instanceTemplates resource."""

    _NAME = 'instanceTemplates'

    def __init__(self, client):
      super(ComputeAlpha.InstanceTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all InstanceTemplates resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInstanceTemplatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/instanceTemplates',
        request_field='',
        request_type_name='ComputeInstanceTemplatesAggregatedListRequest',
        response_type_name='InstanceTemplateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.

      Args:
        request: (ComputeInstanceTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceTemplates.delete',
        ordered_params=['project', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeInstanceTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified instance template.

      Args:
        request: (ComputeInstanceTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.get',
        ordered_params=['project', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project'],
        query_params=['view'],
        relative_path='projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeInstanceTemplatesGetRequest',
        response_type_name='InstanceTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstanceTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstanceTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.

      Args:
        request: (ComputeInstanceTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/instanceTemplates',
        request_field='instanceTemplate',
        request_type_name='ComputeInstanceTemplatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of instance templates that are contained within the specified project.

      Args:
        request: (ComputeInstanceTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'view'],
        relative_path='projects/{project}/global/instanceTemplates',
        request_field='',
        request_type_name='ComputeInstanceTemplatesListRequest',
        response_type_name='InstanceTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstanceTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeInstanceTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceTemplatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstancesService(base_api.BaseApiService):
    """Service class for the instances resource."""

    _NAME = 'instances'

    def __init__(self, client):
      super(ComputeAlpha.InstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAccessConfig(self, request, global_params=None):
      r"""Adds an access config to an instance's network interface.

      Args:
        request: (ComputeInstancesAddAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.addAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/addAccessConfig',
        request_field='accessConfig',
        request_type_name='ComputeInstancesAddAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddNetworkInterface(self, request, global_params=None):
      r"""Adds one dynamic network interface to an active instance.

      Args:
        request: (ComputeInstancesAddNetworkInterfaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddNetworkInterface')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddNetworkInterface.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.addNetworkInterface',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/addNetworkInterface',
        request_field='networkInterface',
        request_type_name='ComputeInstancesAddNetworkInterfaceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.

      Args:
        request: (ComputeInstancesAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.addResourcePolicies',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/addResourcePolicies',
        request_field='instancesAddResourcePoliciesRequest',
        request_type_name='ComputeInstancesAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInstancesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/instances',
        request_field='',
        request_type_name='ComputeInstancesAggregatedListRequest',
        response_type_name='InstanceAggregatedList',
        supports_download=False,
    )

    def AttachDisk(self, request, global_params=None):
      r"""Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.

      Args:
        request: (ComputeInstancesAttachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.attachDisk',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['forceAttach', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/attachDisk',
        request_field='attachedDisk',
        request_type_name='ComputeInstancesAttachDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def BulkInsert(self, request, global_params=None):
      r"""Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.

      Args:
        request: (ComputeInstancesBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.bulkInsert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/bulkInsert',
        request_field='bulkInsertInstanceResource',
        request_type_name='ComputeInstancesBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Instance resource. For more information, see Deleting an instance.

      Args:
        request: (ComputeInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instances.delete',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['noGracefulShutdown', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name='ComputeInstancesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteAccessConfig(self, request, global_params=None):
      r"""Deletes an access config from an instance's network interface.

      Args:
        request: (ComputeInstancesDeleteAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.deleteAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'accessConfig', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['accessConfig', 'networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/deleteAccessConfig',
        request_field='',
        request_type_name='ComputeInstancesDeleteAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteNetworkInterface(self, request, global_params=None):
      r"""Deletes one dynamic network interface from an active instance. InstancesDeleteNetworkInterfaceRequest indicates: - instance from which to delete, using project+zone+resource_id fields; - dynamic network interface to be deleted, using network_interface_name field;.

      Args:
        request: (ComputeInstancesDeleteNetworkInterfaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteNetworkInterface')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteNetworkInterface.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.deleteNetworkInterface',
        ordered_params=['project', 'zone', 'instance', 'networkInterfaceName'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterfaceName', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/deleteNetworkInterface',
        request_field='',
        request_type_name='ComputeInstancesDeleteNetworkInterfaceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachDisk(self, request, global_params=None):
      r"""Detaches a disk from an instance.

      Args:
        request: (ComputeInstancesDetachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.detachDisk',
        ordered_params=['project', 'zone', 'instance', 'deviceName'],
        path_params=['instance', 'project', 'zone'],
        query_params=['deviceName', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/detachDisk',
        request_field='',
        request_type_name='ComputeInstancesDetachDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Instance resource.

      Args:
        request: (ComputeInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.get',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['view'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name='ComputeInstancesGetRequest',
        response_type_name='Instance',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns effective firewalls applied to an interface of the instance.

      Args:
        request: (ComputeInstancesGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstancesGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getEffectiveFirewalls',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeInstancesGetEffectiveFirewallsRequest',
        response_type_name='InstancesGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def GetGuestAttributes(self, request, global_params=None):
      r"""Returns the specified guest attributes entry.

      Args:
        request: (ComputeInstancesGetGuestAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GuestAttributes) The response message.
      """
      config = self.GetMethodConfig('GetGuestAttributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetGuestAttributes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getGuestAttributes',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['queryPath', 'variableKey'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getGuestAttributes',
        request_field='',
        request_type_name='ComputeInstancesGetGuestAttributesRequest',
        response_type_name='GuestAttributes',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstancesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetPartnerMetadata(self, request, global_params=None):
      r"""Gets partner metadata of the specified instance and namespaces.

      Args:
        request: (ComputeInstancesGetPartnerMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartnerMetadata) The response message.
      """
      config = self.GetMethodConfig('GetPartnerMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetPartnerMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getPartnerMetadata',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['namespaces'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getPartnerMetadata',
        request_field='',
        request_type_name='ComputeInstancesGetPartnerMetadataRequest',
        response_type_name='PartnerMetadata',
        supports_download=False,
    )

    def GetScreenshot(self, request, global_params=None):
      r"""Returns the screenshot from the specified instance.

      Args:
        request: (ComputeInstancesGetScreenshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Screenshot) The response message.
      """
      config = self.GetMethodConfig('GetScreenshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScreenshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getScreenshot',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/screenshot',
        request_field='',
        request_type_name='ComputeInstancesGetScreenshotRequest',
        response_type_name='Screenshot',
        supports_download=False,
    )

    def GetSerialPortOutput(self, request, global_params=None):
      r"""Returns the last 1 MB of serial port output from the specified instance.

      Args:
        request: (ComputeInstancesGetSerialPortOutputRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SerialPortOutput) The response message.
      """
      config = self.GetMethodConfig('GetSerialPortOutput')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSerialPortOutput.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getSerialPortOutput',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['port', 'start'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/serialPort',
        request_field='',
        request_type_name='ComputeInstancesGetSerialPortOutputRequest',
        response_type_name='SerialPortOutput',
        supports_download=False,
    )

    def GetShieldedInstanceIdentity(self, request, global_params=None):
      r"""Returns the Shielded Instance Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedInstanceIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedInstanceIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedInstanceIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedInstanceIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getShieldedInstanceIdentity',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getShieldedInstanceIdentity',
        request_field='',
        request_type_name='ComputeInstancesGetShieldedInstanceIdentityRequest',
        response_type_name='ShieldedInstanceIdentity',
        supports_download=False,
    )

    def GetShieldedVmIdentity(self, request, global_params=None):
      r"""Returns the Shielded VM Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedVmIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedVmIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedVmIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedVmIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getShieldedVmIdentity',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getShieldedVmIdentity',
        request_field='',
        request_type_name='ComputeInstancesGetShieldedVmIdentityRequest',
        response_type_name='ShieldedVmIdentity',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance resource in the specified project using the data included in the request.

      Args:
        request: (ComputeInstancesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'sourceInstanceTemplate', 'sourceMachineImage'],
        relative_path='projects/{project}/zones/{zone}/instances',
        request_field='instance',
        request_type_name='ComputeInstancesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instances contained within the specified zone.

      Args:
        request: (ComputeInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'view'],
        relative_path='projects/{project}/zones/{zone}/instances',
        request_field='',
        request_type_name='ComputeInstancesListRequest',
        response_type_name='InstanceList',
        supports_download=False,
    )

    def ListReferrers(self, request, global_params=None):
      r"""Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.

      Args:
        request: (ComputeInstancesListReferrersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceListReferrers) The response message.
      """
      config = self.GetMethodConfig('ListReferrers')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListReferrers.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.listReferrers',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/referrers',
        request_field='',
        request_type_name='ComputeInstancesListReferrersRequest',
        response_type_name='InstanceListReferrers',
        supports_download=False,
    )

    def PatchPartnerMetadata(self, request, global_params=None):
      r"""Patches partner metadata of the specified instance.

      Args:
        request: (ComputeInstancesPatchPartnerMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPartnerMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPartnerMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.patchPartnerMetadata',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/patchPartnerMetadata',
        request_field='partnerMetadata',
        request_type_name='ComputeInstancesPatchPartnerMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PerformMaintenance(self, request, global_params=None):
      r"""Perform a manual maintenance on the instance.

      Args:
        request: (ComputeInstancesPerformMaintenanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PerformMaintenance')
      return self._RunMethod(
          config, request, global_params=global_params)

    PerformMaintenance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.performMaintenance',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/performMaintenance',
        request_field='',
        request_type_name='ComputeInstancesPerformMaintenanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from an instance.

      Args:
        request: (ComputeInstancesRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.removeResourcePolicies',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/removeResourcePolicies',
        request_field='instancesRemoveResourcePoliciesRequest',
        request_type_name='ComputeInstancesRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ReportHostAsFaulty(self, request, global_params=None):
      r"""Mark the host as faulty and try to restart the instance on a new host.

      Args:
        request: (ComputeInstancesReportHostAsFaultyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ReportHostAsFaulty')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReportHostAsFaulty.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.reportHostAsFaulty',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/reportHostAsFaulty',
        request_field='instancesReportHostAsFaultyRequest',
        request_type_name='ComputeInstancesReportHostAsFaultyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Reset(self, request, global_params=None):
      r"""Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.

      Args:
        request: (ComputeInstancesResetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Reset')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reset.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.reset',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/reset',
        request_field='',
        request_type_name='ComputeInstancesResetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resume(self, request, global_params=None):
      r"""Resumes an instance that was suspended using the instances().suspend method.

      Args:
        request: (ComputeInstancesResumeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resume')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resume.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.resume',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/resume',
        request_field='instancesResumeRequest',
        request_type_name='ComputeInstancesResumeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SendDiagnosticInterrupt(self, request, global_params=None):
      r"""Sends diagnostic interrupt to the instance.

      Args:
        request: (ComputeInstancesSendDiagnosticInterruptRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeInstancesSendDiagnosticInterruptResponse) The response message.
      """
      config = self.GetMethodConfig('SendDiagnosticInterrupt')
      return self._RunMethod(
          config, request, global_params=global_params)

    SendDiagnosticInterrupt.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.sendDiagnosticInterrupt',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/sendDiagnosticInterrupt',
        request_field='',
        request_type_name='ComputeInstancesSendDiagnosticInterruptRequest',
        response_type_name='ComputeInstancesSendDiagnosticInterruptResponse',
        supports_download=False,
    )

    def SetDeletionProtection(self, request, global_params=None):
      r"""Sets deletion protection on the instance.

      Args:
        request: (ComputeInstancesSetDeletionProtectionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDeletionProtection')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDeletionProtection.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setDeletionProtection',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['deletionProtection', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/setDeletionProtection',
        request_field='',
        request_type_name='ComputeInstancesSetDeletionProtectionRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetDiskAutoDelete(self, request, global_params=None):
      r"""Sets the auto-delete flag for a disk attached to an instance.

      Args:
        request: (ComputeInstancesSetDiskAutoDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDiskAutoDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDiskAutoDelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setDiskAutoDelete',
        ordered_params=['project', 'zone', 'instance', 'autoDelete', 'deviceName'],
        path_params=['instance', 'project', 'zone'],
        query_params=['autoDelete', 'deviceName', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete',
        request_field='',
        request_type_name='ComputeInstancesSetDiskAutoDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeInstancesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInstancesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setLabels',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setLabels',
        request_field='instancesSetLabelsRequest',
        request_type_name='ComputeInstancesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMachineResources(self, request, global_params=None):
      r"""Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.

      Args:
        request: (ComputeInstancesSetMachineResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMachineResources',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMachineResources',
        request_field='instancesSetMachineResourcesRequest',
        request_type_name='ComputeInstancesSetMachineResourcesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMachineType(self, request, global_params=None):
      r"""Changes the machine type for a stopped instance to the machine type specified in the request.

      Args:
        request: (ComputeInstancesSetMachineTypeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineType')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineType.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMachineType',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMachineType',
        request_field='instancesSetMachineTypeRequest',
        request_type_name='ComputeInstancesSetMachineTypeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMetadata(self, request, global_params=None):
      r"""Sets metadata for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMetadata',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMetadata',
        request_field='metadata',
        request_type_name='ComputeInstancesSetMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMinCpuPlatform(self, request, global_params=None):
      r"""Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.

      Args:
        request: (ComputeInstancesSetMinCpuPlatformRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMinCpuPlatform')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMinCpuPlatform.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMinCpuPlatform',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMinCpuPlatform',
        request_field='instancesSetMinCpuPlatformRequest',
        request_type_name='ComputeInstancesSetMinCpuPlatformRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetName(self, request, global_params=None):
      r"""Sets name of an instance.

      Args:
        request: (ComputeInstancesSetNameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetName')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetName.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setName',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setName',
        request_field='instancesSetNameRequest',
        request_type_name='ComputeInstancesSetNameRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetScheduling(self, request, global_params=None):
      r"""Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.

      Args:
        request: (ComputeInstancesSetSchedulingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetScheduling')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetScheduling.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setScheduling',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setScheduling',
        request_field='scheduling',
        request_type_name='ComputeInstancesSetSchedulingRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSecurityPolicy(self, request, global_params=None):
      r"""Sets the Google Cloud Armor security policy for the specified instance. For more information, see Google Cloud Armor Overview.

      Args:
        request: (ComputeInstancesSetSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setSecurityPolicy',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setSecurityPolicy',
        request_field='instancesSetSecurityPolicyRequest',
        request_type_name='ComputeInstancesSetSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetServiceAccount(self, request, global_params=None):
      r"""Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.

      Args:
        request: (ComputeInstancesSetServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setServiceAccount',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setServiceAccount',
        request_field='instancesSetServiceAccountRequest',
        request_type_name='ComputeInstancesSetServiceAccountRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetShieldedInstanceIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedInstanceIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedInstanceIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.setShieldedInstanceIntegrityPolicy',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setShieldedInstanceIntegrityPolicy',
        request_field='shieldedInstanceIntegrityPolicy',
        request_type_name='ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetShieldedVmIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded VM integrity policy for a VM instance. You can only use this method on a running VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedVmIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedVmIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedVmIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.setShieldedVmIntegrityPolicy',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setShieldedVmIntegrityPolicy',
        request_field='shieldedVmIntegrityPolicy',
        request_type_name='ComputeInstancesSetShieldedVmIntegrityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTags(self, request, global_params=None):
      r"""Sets network tags for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetTagsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTags')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTags.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setTags',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setTags',
        request_field='tags',
        request_type_name='ComputeInstancesSetTagsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SimulateMaintenanceEvent(self, request, global_params=None):
      r"""Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.

      Args:
        request: (ComputeInstancesSimulateMaintenanceEventRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SimulateMaintenanceEvent')
      return self._RunMethod(
          config, request, global_params=global_params)

    SimulateMaintenanceEvent.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.simulateMaintenanceEvent',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId', 'withExtendedNotifications'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/simulateMaintenanceEvent',
        request_field='',
        request_type_name='ComputeInstancesSimulateMaintenanceEventRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.start',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/start',
        request_field='',
        request_type_name='ComputeInstancesStartRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartWithEncryptionKey(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartWithEncryptionKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartWithEncryptionKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartWithEncryptionKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.startWithEncryptionKey',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/startWithEncryptionKey',
        request_field='instancesStartWithEncryptionKeyRequest',
        request_type_name='ComputeInstancesStartWithEncryptionKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Stop(self, request, global_params=None):
      r"""Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.

      Args:
        request: (ComputeInstancesStopRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(
          config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.stop',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['discardLocalSsd', 'noGracefulShutdown', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/stop',
        request_field='',
        request_type_name='ComputeInstancesStopRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Suspend(self, request, global_params=None):
      r"""This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.

      Args:
        request: (ComputeInstancesSuspendRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Suspend')
      return self._RunMethod(
          config, request, global_params=global_params)

    Suspend.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.suspend',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['discardLocalSsd', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/suspend',
        request_field='',
        request_type_name='ComputeInstancesSuspendRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstancesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.

      Args:
        request: (ComputeInstancesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.instances.update',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['clearSecureTag', 'minimalAction', 'mostDisruptiveAllowedAction', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='instanceResource',
        request_type_name='ComputeInstancesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateAccessConfig(self, request, global_params=None):
      r"""Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.updateAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateAccessConfig',
        request_field='accessConfig',
        request_type_name='ComputeInstancesUpdateAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateDisplayDevice(self, request, global_params=None):
      r"""Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateDisplayDeviceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateDisplayDevice')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDisplayDevice.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateDisplayDevice',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateDisplayDevice',
        request_field='displayDevice',
        request_type_name='ComputeInstancesUpdateDisplayDeviceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateNetworkInterface(self, request, global_params=None):
      r"""Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.

      Args:
        request: (ComputeInstancesUpdateNetworkInterfaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateNetworkInterface')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateNetworkInterface.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateNetworkInterface',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateNetworkInterface',
        request_field='networkInterfaceResource',
        request_type_name='ComputeInstancesUpdateNetworkInterfaceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateShieldedInstanceConfig(self, request, global_params=None):
      r"""Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedInstanceConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedInstanceConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedInstanceConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateShieldedInstanceConfig',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateShieldedInstanceConfig',
        request_field='shieldedInstanceConfig',
        request_type_name='ComputeInstancesUpdateShieldedInstanceConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateShieldedVmConfig(self, request, global_params=None):
      r"""Updates the Shielded VM config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedVmConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedVmConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedVmConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateShieldedVmConfig',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateShieldedVmConfig',
        request_field='shieldedVmConfig',
        request_type_name='ComputeInstancesUpdateShieldedVmConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class InstantSnapshotGroupsService(base_api.BaseApiService):
    """Service class for the instantSnapshotGroups resource."""

    _NAME = 'instantSnapshotGroups'

    def __init__(self, client):
      super(ComputeAlpha.InstantSnapshotGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""deletes a Zonal InstantSnapshotGroup resource.

      Args:
        request: (ComputeInstantSnapshotGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instantSnapshotGroups.delete',
        ordered_params=['project', 'zone', 'instantSnapshotGroup'],
        path_params=['instantSnapshotGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups/{instantSnapshotGroup}',
        request_field='',
        request_type_name='ComputeInstantSnapshotGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""returns the specified InstantSnapshotGroup resource in the specified zone.

      Args:
        request: (ComputeInstantSnapshotGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshotGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshotGroups.get',
        ordered_params=['project', 'zone', 'instantSnapshotGroup'],
        path_params=['instantSnapshotGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups/{instantSnapshotGroup}',
        request_field='',
        request_type_name='ComputeInstantSnapshotGroupsGetRequest',
        response_type_name='InstantSnapshotGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstantSnapshotGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshotGroups.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstantSnapshotGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""inserts a Zonal InstantSnapshotGroup resource.

      Args:
        request: (ComputeInstantSnapshotGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshotGroups.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'sourceConsistencyGroup'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups',
        request_field='instantSnapshotGroup',
        request_type_name='ComputeInstantSnapshotGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""retrieves the list of InstantSnapshotGroup resources contained within the specified zone.

      Args:
        request: (ComputeInstantSnapshotGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstantSnapshotGroups) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshotGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups',
        request_field='',
        request_type_name='ComputeInstantSnapshotGroupsListRequest',
        response_type_name='ListInstantSnapshotGroups',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstantSnapshotGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshotGroups.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeInstantSnapshotGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstantSnapshotGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshotGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshotGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstantSnapshotGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstantSnapshotsService(base_api.BaseApiService):
    """Service class for the instantSnapshots resource."""

    _NAME = 'instantSnapshots'

    def __init__(self, client):
      super(ComputeAlpha.InstantSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of instantSnapshots. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInstantSnapshotsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshotAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshots.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/instantSnapshots',
        request_field='',
        request_type_name='ComputeInstantSnapshotsAggregatedListRequest',
        response_type_name='InstantSnapshotAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.

      Args:
        request: (ComputeInstantSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instantSnapshots.delete',
        ordered_params=['project', 'zone', 'instantSnapshot'],
        path_params=['instantSnapshot', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{instantSnapshot}',
        request_field='',
        request_type_name='ComputeInstantSnapshotsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified InstantSnapshot resource in the specified zone.

      Args:
        request: (ComputeInstantSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshots.get',
        ordered_params=['project', 'zone', 'instantSnapshot'],
        path_params=['instantSnapshot', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{instantSnapshot}',
        request_field='',
        request_type_name='ComputeInstantSnapshotsGetRequest',
        response_type_name='InstantSnapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstantSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshots.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstantSnapshotsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instant snapshot in the specified zone.

      Args:
        request: (ComputeInstantSnapshotsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshots.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots',
        request_field='instantSnapshot',
        request_type_name='ComputeInstantSnapshotsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of InstantSnapshot resources contained within the specified zone.

      Args:
        request: (ComputeInstantSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instantSnapshots.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots',
        request_field='',
        request_type_name='ComputeInstantSnapshotsListRequest',
        response_type_name='InstantSnapshotList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstantSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshots.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeInstantSnapshotsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a instantSnapshot in the given zone. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInstantSnapshotsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshots.setLabels',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{resource}/setLabels',
        request_field='zoneSetLabelsRequest',
        request_type_name='ComputeInstantSnapshotsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstantSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instantSnapshots.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instantSnapshots/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstantSnapshotsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectAttachmentGroupsService(base_api.BaseApiService):
    """Service class for the interconnectAttachmentGroups resource."""

    _NAME = 'interconnectAttachmentGroups'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectAttachmentGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def CreateMembers(self, request, global_params=None):
      r"""Create Interconnect Attachments with redundancy by creating them in a specified interconnect attachment group.

      Args:
        request: (ComputeInterconnectAttachmentGroupsCreateMembersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateMembers')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateMembers.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachmentGroups.createMembers',
        ordered_params=['project', 'interconnectAttachmentGroup'],
        path_params=['interconnectAttachmentGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}/createMembers',
        request_field='interconnectAttachmentGroupsCreateMembersRequest',
        request_type_name='ComputeInterconnectAttachmentGroupsCreateMembersRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified InterconnectAttachmentGroup in the given scope.

      Args:
        request: (ComputeInterconnectAttachmentGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnectAttachmentGroups.delete',
        ordered_params=['project', 'interconnectAttachmentGroup'],
        path_params=['interconnectAttachmentGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified InterconnectAttachmentGroup resource in the given scope.

      Args:
        request: (ComputeInterconnectAttachmentGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachmentGroups.get',
        ordered_params=['project', 'interconnectAttachmentGroup'],
        path_params=['interconnectAttachmentGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentGroupsGetRequest',
        response_type_name='InterconnectAttachmentGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInterconnectAttachmentGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachmentGroups.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetOperationalStatus(self, request, global_params=None):
      r"""Returns the InterconnectAttachmentStatuses for the specified InterconnectAttachmentGroup resource.

      Args:
        request: (ComputeInterconnectAttachmentGroupsGetOperationalStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentGroupsGetOperationalStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetOperationalStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOperationalStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachmentGroups.getOperationalStatus',
        ordered_params=['project', 'interconnectAttachmentGroup'],
        path_params=['interconnectAttachmentGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}/getOperationalStatus',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentGroupsGetOperationalStatusRequest',
        response_type_name='InterconnectAttachmentGroupsGetOperationalStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a InterconnectAttachmentGroup in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeInterconnectAttachmentGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachmentGroups.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnectAttachmentGroups',
        request_field='interconnectAttachmentGroup',
        request_type_name='ComputeInterconnectAttachmentGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the InterconnectAttachmentGroups for a project in the given scope.

      Args:
        request: (ComputeInterconnectAttachmentGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentGroupsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachmentGroups.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnectAttachmentGroups',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentGroupsListRequest',
        response_type_name='InterconnectAttachmentGroupsListResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified InterconnectAttachmentGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectAttachmentGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnectAttachmentGroups.patch',
        ordered_params=['project', 'interconnectAttachmentGroup'],
        path_params=['interconnectAttachmentGroup', 'project'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}',
        request_field='interconnectAttachmentGroupResource',
        request_type_name='ComputeInterconnectAttachmentGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInterconnectAttachmentGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachmentGroups.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeInterconnectAttachmentGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectAttachmentGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachmentGroups.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectAttachmentGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectAttachmentGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectAttachmentsService(base_api.BaseApiService):
    """Service class for the interconnectAttachments resource."""

    _NAME = 'interconnectAttachments'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of interconnect attachments. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeInterconnectAttachmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/interconnectAttachments',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsAggregatedListRequest',
        response_type_name='InterconnectAttachmentAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnectAttachments.delete',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.get',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsGetRequest',
        response_type_name='InterconnectAttachment',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInterconnectAttachmentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an InterconnectAttachment in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectAttachmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments',
        request_field='interconnectAttachment',
        request_type_name='ComputeInterconnectAttachmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect attachments contained within the specified region.

      Args:
        request: (ComputeInterconnectAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsListRequest',
        response_type_name='InterconnectAttachmentList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnectAttachments.patch',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='interconnectAttachmentResource',
        request_type_name='ComputeInterconnectAttachmentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInterconnectAttachmentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeInterconnectAttachmentsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectAttachmentsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeInterconnectAttachmentsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectAttachmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectAttachmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectGroupsService(base_api.BaseApiService):
    """Service class for the interconnectGroups resource."""

    _NAME = 'interconnectGroups'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def CreateMembers(self, request, global_params=None):
      r"""Create Interconnects with redundancy by creating them in a specified interconnect group.

      Args:
        request: (ComputeInterconnectGroupsCreateMembersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateMembers')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateMembers.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectGroups.createMembers',
        ordered_params=['project', 'interconnectGroup'],
        path_params=['interconnectGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectGroups/{interconnectGroup}/createMembers',
        request_field='interconnectGroupsCreateMembersRequest',
        request_type_name='ComputeInterconnectGroupsCreateMembersRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified InterconnectGroup in the given scope.

      Args:
        request: (ComputeInterconnectGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnectGroups.delete',
        ordered_params=['project', 'interconnectGroup'],
        path_params=['interconnectGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnectGroups/{interconnectGroup}',
        request_field='',
        request_type_name='ComputeInterconnectGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified InterconnectGroup resource in the given scope.

      Args:
        request: (ComputeInterconnectGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectGroups.get',
        ordered_params=['project', 'interconnectGroup'],
        path_params=['interconnectGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectGroups/{interconnectGroup}',
        request_field='',
        request_type_name='ComputeInterconnectGroupsGetRequest',
        response_type_name='InterconnectGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInterconnectGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectGroups.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/interconnectGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInterconnectGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetOperationalStatus(self, request, global_params=None):
      r"""Returns the interconnectStatuses for the specified InterconnectGroup.

      Args:
        request: (ComputeInterconnectGroupsGetOperationalStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectGroupsGetOperationalStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetOperationalStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOperationalStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectGroups.getOperationalStatus',
        ordered_params=['project', 'interconnectGroup'],
        path_params=['interconnectGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectGroups/{interconnectGroup}/getOperationalStatus',
        request_field='',
        request_type_name='ComputeInterconnectGroupsGetOperationalStatusRequest',
        response_type_name='InterconnectGroupsGetOperationalStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a InterconnectGroup in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeInterconnectGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectGroups.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnectGroups',
        request_field='interconnectGroup',
        request_type_name='ComputeInterconnectGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the InterconnectGroups for a project in the given scope.

      Args:
        request: (ComputeInterconnectGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectGroupsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectGroups.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnectGroups',
        request_field='',
        request_type_name='ComputeInterconnectGroupsListRequest',
        response_type_name='InterconnectGroupsListResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified InterconnectGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnectGroups.patch',
        ordered_params=['project', 'interconnectGroup'],
        path_params=['interconnectGroup', 'project'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/global/interconnectGroups/{interconnectGroup}',
        request_field='interconnectGroupResource',
        request_type_name='ComputeInterconnectGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInterconnectGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectGroups.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectGroups/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeInterconnectGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectGroups.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectLocationsService(base_api.BaseApiService):
    """Service class for the interconnectLocations resource."""

    _NAME = 'interconnectLocations'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.

      Args:
        request: (ComputeInterconnectLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectLocations.get',
        ordered_params=['project', 'interconnectLocation'],
        path_params=['interconnectLocation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectLocations/{interconnectLocation}',
        request_field='',
        request_type_name='ComputeInterconnectLocationsGetRequest',
        response_type_name='InterconnectLocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect locations available to the specified project.

      Args:
        request: (ComputeInterconnectLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectLocations.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnectLocations',
        request_field='',
        request_type_name='ComputeInterconnectLocationsListRequest',
        response_type_name='InterconnectLocationList',
        supports_download=False,
    )

  class InterconnectRemoteLocationsService(base_api.BaseApiService):
    """Service class for the interconnectRemoteLocations resource."""

    _NAME = 'interconnectRemoteLocations'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectRemoteLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the details for the specified interconnect remote location. Gets a list of available interconnect remote locations by making a list() request.

      Args:
        request: (ComputeInterconnectRemoteLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectRemoteLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectRemoteLocations.get',
        ordered_params=['project', 'interconnectRemoteLocation'],
        path_params=['interconnectRemoteLocation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectRemoteLocations/{interconnectRemoteLocation}',
        request_field='',
        request_type_name='ComputeInterconnectRemoteLocationsGetRequest',
        response_type_name='InterconnectRemoteLocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect remote locations available to the specified project.

      Args:
        request: (ComputeInterconnectRemoteLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectRemoteLocationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectRemoteLocations.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnectRemoteLocations',
        request_field='',
        request_type_name='ComputeInterconnectRemoteLocationsListRequest',
        response_type_name='InterconnectRemoteLocationList',
        supports_download=False,
    )

  class InterconnectsService(base_api.BaseApiService):
    """Service class for the interconnects resource."""

    _NAME = 'interconnects'

    def __init__(self, client):
      super(ComputeAlpha.InterconnectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Interconnect.

      Args:
        request: (ComputeInterconnectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnects.delete',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name='ComputeInterconnectsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Interconnect. Get a list of available Interconnects by making a list() request.

      Args:
        request: (ComputeInterconnectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Interconnect) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.get',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name='ComputeInterconnectsGetRequest',
        response_type_name='Interconnect',
        supports_download=False,
    )

    def GetDiagnostics(self, request, global_params=None):
      r"""Returns the interconnectDiagnostics for the specified Interconnect. In the event of a global outage, do not use this API to make decisions about where to redirect your network traffic. Unlike a VLAN attachment, which is regional, a Cloud Interconnect connection is a global resource. A global outage can prevent this API from functioning properly.

      Args:
        request: (ComputeInterconnectsGetDiagnosticsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectsGetDiagnosticsResponse) The response message.
      """
      config = self.GetMethodConfig('GetDiagnostics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDiagnostics.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.getDiagnostics',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{interconnect}/getDiagnostics',
        request_field='',
        request_type_name='ComputeInterconnectsGetDiagnosticsRequest',
        response_type_name='InterconnectsGetDiagnosticsResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInterconnectsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/interconnects/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInterconnectsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetMacsecConfig(self, request, global_params=None):
      r"""Returns the interconnectMacsecConfig for the specified Interconnect.

      Args:
        request: (ComputeInterconnectsGetMacsecConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectsGetMacsecConfigResponse) The response message.
      """
      config = self.GetMethodConfig('GetMacsecConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetMacsecConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.getMacsecConfig',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{interconnect}/getMacsecConfig',
        request_field='',
        request_type_name='ComputeInterconnectsGetMacsecConfigRequest',
        response_type_name='InterconnectsGetMacsecConfigResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an Interconnect in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects',
        request_field='interconnect',
        request_type_name='ComputeInterconnectsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Interconnects available to the specified project.

      Args:
        request: (ComputeInterconnectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnects',
        request_field='',
        request_type_name='ComputeInterconnectsListRequest',
        response_type_name='InterconnectList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified Interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnects.patch',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='interconnectResource',
        request_type_name='ComputeInterconnectsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInterconnectsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeInterconnectsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeInterconnectsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class LicenseCodesService(base_api.BaseApiService):
    """Service class for the licenseCodes resource."""

    _NAME = 'licenseCodes'

    def __init__(self, client):
      super(ComputeAlpha.LicenseCodesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicenseCode) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenseCodes.get',
        ordered_params=['project', 'licenseCode'],
        path_params=['licenseCode', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/licenseCodes/{licenseCode}',
        request_field='',
        request_type_name='ComputeLicenseCodesGetRequest',
        response_type_name='LicenseCode',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenseCodes.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/licenseCodes/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeLicenseCodesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenseCodes.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenseCodes/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeLicenseCodesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenseCodes.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenseCodes/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeLicenseCodesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class LicensesService(base_api.BaseApiService):
    """Service class for the licenses resource."""

    _NAME = 'licenses'

    def __init__(self, client):
      super(ComputeAlpha.LicensesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified license. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.licenses.delete',
        ordered_params=['project', 'license'],
        path_params=['license', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name='ComputeLicensesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified License resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (License) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.get',
        ordered_params=['project', 'license'],
        path_params=['license', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name='ComputeLicensesGetRequest',
        response_type_name='License',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/licenses/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeLicensesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/licenses',
        request_field='license',
        request_type_name='ComputeLicensesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicensesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/licenses',
        request_field='',
        request_type_name='ComputeLicensesListRequest',
        response_type_name='LicensesListResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeLicensesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeLicensesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.licenses.update',
        ordered_params=['project', 'license'],
        path_params=['license', 'project'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/global/licenses/{license}',
        request_field='licenseResource',
        request_type_name='ComputeLicensesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class MachineImagesService(base_api.BaseApiService):
    """Service class for the machineImages resource."""

    _NAME = 'machineImages'

    def __init__(self, client):
      super(ComputeAlpha.MachineImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified machine image. Deleting a machine image is permanent and cannot be undone.

      Args:
        request: (ComputeMachineImagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.machineImages.delete',
        ordered_params=['project', 'machineImage'],
        path_params=['machineImage', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/machineImages/{machineImage}',
        request_field='',
        request_type_name='ComputeMachineImagesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified machine image.

      Args:
        request: (ComputeMachineImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineImage) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.get',
        ordered_params=['project', 'machineImage'],
        path_params=['machineImage', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{machineImage}',
        request_field='',
        request_type_name='ComputeMachineImagesGetRequest',
        response_type_name='MachineImage',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeMachineImagesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/machineImages/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeMachineImagesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a machine image in the specified project using the data that is included in the request. If you are creating a new machine image to update an existing instance, your new machine image should use the same network or, if applicable, the same subnetwork as the original instance.

      Args:
        request: (ComputeMachineImagesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId', 'sourceInstance'],
        relative_path='projects/{project}/global/machineImages',
        request_field='machineImage',
        request_type_name='ComputeMachineImagesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of machine images that are contained within the specified project.

      Args:
        request: (ComputeMachineImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineImageList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/machineImages',
        request_field='',
        request_type_name='ComputeMachineImagesListRequest',
        response_type_name='MachineImageList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeMachineImagesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeMachineImagesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a machine image. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeMachineImagesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeMachineImagesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeMachineImagesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeMachineImagesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class MachineTypesService(base_api.BaseApiService):
    """Service class for the machineTypes resource."""

    _NAME = 'machineTypes'

    def __init__(self, client):
      super(ComputeAlpha.MachineTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of machine types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeMachineTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/machineTypes',
        request_field='',
        request_type_name='ComputeMachineTypesAggregatedListRequest',
        response_type_name='MachineTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified machine type.

      Args:
        request: (ComputeMachineTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.get',
        ordered_params=['project', 'zone', 'machineType'],
        path_params=['machineType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/machineTypes/{machineType}',
        request_field='',
        request_type_name='ComputeMachineTypesGetRequest',
        response_type_name='MachineType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of machine types available to the specified project.

      Args:
        request: (ComputeMachineTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/machineTypes',
        request_field='',
        request_type_name='ComputeMachineTypesListRequest',
        response_type_name='MachineTypeList',
        supports_download=False,
    )

  class NetworkAttachmentsService(base_api.BaseApiService):
    """Service class for the networkAttachments resource."""

    _NAME = 'networkAttachments'

    def __init__(self, client):
      super(ComputeAlpha.NetworkAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all NetworkAttachment resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNetworkAttachmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkAttachmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkAttachments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/networkAttachments',
        request_field='',
        request_type_name='ComputeNetworkAttachmentsAggregatedListRequest',
        response_type_name='NetworkAttachmentAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NetworkAttachment in the given scope.

      Args:
        request: (ComputeNetworkAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkAttachments.delete',
        ordered_params=['project', 'region', 'networkAttachment'],
        path_params=['networkAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{networkAttachment}',
        request_field='',
        request_type_name='ComputeNetworkAttachmentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NetworkAttachment resource in the given scope.

      Args:
        request: (ComputeNetworkAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkAttachments.get',
        ordered_params=['project', 'region', 'networkAttachment'],
        path_params=['networkAttachment', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{networkAttachment}',
        request_field='',
        request_type_name='ComputeNetworkAttachmentsGetRequest',
        response_type_name='NetworkAttachment',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNetworkAttachmentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkAttachments.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNetworkAttachmentsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NetworkAttachment in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeNetworkAttachmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkAttachments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkAttachments',
        request_field='networkAttachment',
        request_type_name='ComputeNetworkAttachmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the NetworkAttachments for a project in the given scope.

      Args:
        request: (ComputeNetworkAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkAttachmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkAttachments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/networkAttachments',
        request_field='',
        request_type_name='ComputeNetworkAttachmentsListRequest',
        response_type_name='NetworkAttachmentList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified NetworkAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeNetworkAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networkAttachments.patch',
        ordered_params=['project', 'region', 'networkAttachment'],
        path_params=['networkAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{networkAttachment}',
        request_field='networkAttachmentResource',
        request_type_name='ComputeNetworkAttachmentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNetworkAttachmentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkAttachments.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeNetworkAttachmentsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkAttachmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkAttachments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkAttachments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworkAttachmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NetworkEdgeSecurityServicesService(base_api.BaseApiService):
    """Service class for the networkEdgeSecurityServices resource."""

    _NAME = 'networkEdgeSecurityServices'

    def __init__(self, client):
      super(ComputeAlpha.NetworkEdgeSecurityServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all NetworkEdgeSecurityService resources available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEdgeSecurityServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEdgeSecurityServices.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/networkEdgeSecurityServices',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesAggregatedListRequest',
        response_type_name='NetworkEdgeSecurityServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified service.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkEdgeSecurityServices.delete',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a specified NetworkEdgeSecurityService.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEdgeSecurityService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEdgeSecurityServices.get',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesGetRequest',
        response_type_name='NetworkEdgeSecurityService',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new service in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEdgeSecurityServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices',
        request_field='networkEdgeSecurityService',
        request_type_name='ComputeNetworkEdgeSecurityServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networkEdgeSecurityServices.patch',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='networkEdgeSecurityServiceResource',
        request_type_name='ComputeNetworkEdgeSecurityServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class NetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the networkEndpointGroups resource."""

    _NAME = 'networkEndpointGroups'

    def __init__(self, client):
      super(ComputeAlpha.NetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNetworkEndpointGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsAggregatedListRequest',
        response_type_name='NetworkEndpointGroupAggregatedList',
        supports_download=False,
    )

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a list of network endpoints to the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.attachNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field='networkEndpointGroupsAttachEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.

      Args:
        request: (ComputeNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkEndpointGroups.delete',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach a list of network endpoints from the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.detachNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field='networkEndpointGroupsDetachEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.get',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups that are located in the specified project and zone.

      Args:
        request: (ComputeNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.listNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field='networkEndpointGroupsListEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name='NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkEndpointGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworkEndpointGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NetworkFirewallPoliciesService(base_api.BaseApiService):
    """Service class for the networkFirewallPolicies resource."""

    _NAME = 'networkFirewallPolicies'

    def __init__(self, client):
      super(ComputeAlpha.NetworkFirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.addAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['associatedPolicyToBeReplaced', 'replaceExistingAssociation', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeNetworkFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddPacketMirroringRule(self, request, global_params=None):
      r"""Inserts a packet mirroring rule into a firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesAddPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.addPacketMirroringRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['maxPriority', 'minPriority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/addPacketMirroringRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesAddPacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.addRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['maxPriority', 'minPriority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of network firewall policies, listing network firewall policies from all applicable scopes (global and regional) and grouping the results per scope. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNetworkFirewallPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkFirewallPolicyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/firewallPolicies',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesAggregatedListRequest',
        response_type_name='NetworkFirewallPolicyAggregatedList',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.cloneRules',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkFirewallPolicies.delete',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.get',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['name'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetPacketMirroringRule(self, request, global_params=None):
      r"""Gets a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getPacketMirroringRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/getPacketMirroringRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetPacketMirroringRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworkFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeNetworkFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the policies that have been configured for the specified project.

      Args:
        request: (ComputeNetworkFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/firewallPolicies',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networkFirewallPolicies.patch',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeNetworkFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchAssociation(self, request, global_params=None):
      r"""Updates an association for the specified network firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.patchAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/patchAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeNetworkFirewallPoliciesPatchAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPacketMirroringRule(self, request, global_params=None):
      r"""Patches a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchPacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.patchPacketMirroringRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/patchPacketMirroringRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesPatchPacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.patchRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.removeAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['name', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemovePacketMirroringRule(self, request, global_params=None):
      r"""Deletes a packet mirroring rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesRemovePacketMirroringRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemovePacketMirroringRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemovePacketMirroringRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.removePacketMirroringRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/removePacketMirroringRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesRemovePacketMirroringRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.removeRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeNetworkFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworkFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NetworkProfilesService(base_api.BaseApiService):
    """Service class for the networkProfiles resource."""

    _NAME = 'networkProfiles'

    def __init__(self, client):
      super(ComputeAlpha.NetworkProfilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified network profile.

      Args:
        request: (ComputeNetworkProfilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkProfile) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkProfiles.get',
        ordered_params=['project', 'networkProfile'],
        path_params=['networkProfile', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networkProfiles/{networkProfile}',
        request_field='',
        request_type_name='ComputeNetworkProfilesGetRequest',
        response_type_name='NetworkProfile',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of network profiles available to the specified project.

      Args:
        request: (ComputeNetworkProfilesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkProfilesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkProfiles.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networkProfiles',
        request_field='',
        request_type_name='ComputeNetworkProfilesListRequest',
        response_type_name='NetworkProfilesListResponse',
        supports_download=False,
    )

  class NetworksService(base_api.BaseApiService):
    """Service class for the networks resource."""

    _NAME = 'networks'

    def __init__(self, client):
      super(ComputeAlpha.NetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddPeering(self, request, global_params=None):
      r"""Adds a peering to the specified network.

      Args:
        request: (ComputeNetworksAddPeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddPeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddPeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.addPeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/addPeering',
        request_field='networksAddPeeringRequest',
        request_type_name='ComputeNetworksAddPeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CancelRequestRemovePeering(self, request, global_params=None):
      r"""Cancel requests to remove a peering from the specified network. Applicable only for PeeringConnection with update_strategy=CONSENSUS. Cancels a request to remove a peering from the specified network.

      Args:
        request: (ComputeNetworksCancelRequestRemovePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CancelRequestRemovePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    CancelRequestRemovePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.cancelRequestRemovePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/cancelRequestRemovePeering',
        request_field='networksCancelRequestRemovePeeringRequest',
        request_type_name='ComputeNetworksCancelRequestRemovePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network.

      Args:
        request: (ComputeNetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networks.delete',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name='ComputeNetworksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network.

      Args:
        request: (ComputeNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Network) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.get',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name='ComputeNetworksGetRequest',
        response_type_name='Network',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns the effective firewalls on a given network.

      Args:
        request: (ComputeNetworksGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworksGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.getEffectiveFirewalls',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{network}/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeNetworksGetEffectiveFirewallsRequest',
        response_type_name='NetworksGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks',
        request_field='network',
        request_type_name='ComputeNetworksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of networks available to the specified project.

      Args:
        request: (ComputeNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networks',
        request_field='',
        request_type_name='ComputeNetworksListRequest',
        response_type_name='NetworkList',
        supports_download=False,
    )

    def ListIpAddresses(self, request, global_params=None):
      r"""Lists the internal IP addresses in the specified network.

      Args:
        request: (ComputeNetworksListIpAddressesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IpAddressesList) The response message.
      """
      config = self.GetMethodConfig('ListIpAddresses')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListIpAddresses.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.listIpAddresses',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'types'],
        relative_path='projects/{project}/global/networks/{network}/listIpAddresses',
        request_field='',
        request_type_name='ComputeNetworksListIpAddressesRequest',
        response_type_name='IpAddressesList',
        supports_download=False,
    )

    def ListIpOwners(self, request, global_params=None):
      r"""Lists the internal IP owners in the specified network.

      Args:
        request: (ComputeNetworksListIpOwnersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IpOwnerList) The response message.
      """
      config = self.GetMethodConfig('ListIpOwners')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListIpOwners.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.listIpOwners',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['filter', 'ipCidrRange', 'maxResults', 'orderBy', 'ownerProjects', 'ownerTypes', 'pageToken', 'returnPartialSuccess', 'subnetName', 'subnetRegion'],
        relative_path='projects/{project}/global/networks/{network}/listIpOwners',
        request_field='',
        request_type_name='ComputeNetworksListIpOwnersRequest',
        response_type_name='IpOwnerList',
        supports_download=False,
    )

    def ListPeeringRoutes(self, request, global_params=None):
      r"""Lists the peering routes exchanged over peering connection.

      Args:
        request: (ComputeNetworksListPeeringRoutesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExchangedPeeringRoutesList) The response message.
      """
      config = self.GetMethodConfig('ListPeeringRoutes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPeeringRoutes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.listPeeringRoutes',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['direction', 'filter', 'maxResults', 'orderBy', 'pageToken', 'peeringName', 'region', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networks/{network}/listPeeringRoutes',
        request_field='',
        request_type_name='ComputeNetworksListPeeringRoutesRequest',
        response_type_name='ExchangedPeeringRoutesList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified network with the data included in the request. Only routingConfig can be modified.

      Args:
        request: (ComputeNetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networks.patch',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='networkResource',
        request_type_name='ComputeNetworksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemovePeering(self, request, global_params=None):
      r"""Removes a peering from the specified network.

      Args:
        request: (ComputeNetworksRemovePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemovePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemovePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.removePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/removePeering',
        request_field='networksRemovePeeringRequest',
        request_type_name='ComputeNetworksRemovePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RequestRemovePeering(self, request, global_params=None):
      r"""Requests to remove a peering from the specified network. Applicable only for PeeringConnection with update_strategy=CONSENSUS.

      Args:
        request: (ComputeNetworksRequestRemovePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RequestRemovePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    RequestRemovePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.requestRemovePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/requestRemovePeering',
        request_field='networksRequestRemovePeeringRequest',
        request_type_name='ComputeNetworksRequestRemovePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SwitchToCustomMode(self, request, global_params=None):
      r"""Switches the network mode from auto subnet mode to custom subnet mode.

      Args:
        request: (ComputeNetworksSwitchToCustomModeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SwitchToCustomMode')
      return self._RunMethod(
          config, request, global_params=global_params)

    SwitchToCustomMode.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.switchToCustomMode',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/switchToCustomMode',
        request_field='',
        request_type_name='ComputeNetworksSwitchToCustomModeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def UpdatePeering(self, request, global_params=None):
      r"""Updates the specified network peering with the data included in the request. You can only modify the NetworkPeering.export_custom_routes field and the NetworkPeering.import_custom_routes field.

      Args:
        request: (ComputeNetworksUpdatePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networks.updatePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/updatePeering',
        request_field='networksUpdatePeeringRequest',
        request_type_name='ComputeNetworksUpdatePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class NodeGroupsService(base_api.BaseApiService):
    """Service class for the nodeGroups resource."""

    _NAME = 'nodeGroups'

    def __init__(self, client):
      super(ComputeAlpha.NodeGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddNodes(self, request, global_params=None):
      r"""Adds specified number of nodes to the node group.

      Args:
        request: (ComputeNodeGroupsAddNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.addNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/addNodes',
        request_field='nodeGroupsAddNodesRequest',
        request_type_name='ComputeNodeGroupsAddNodesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNodeGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/nodeGroups',
        request_field='',
        request_type_name='ComputeNodeGroupsAggregatedListRequest',
        response_type_name='NodeGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeGroup resource.

      Args:
        request: (ComputeNodeGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.nodeGroups.delete',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name='ComputeNodeGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteNodes(self, request, global_params=None):
      r"""Deletes specified nodes from the node group.

      Args:
        request: (ComputeNodeGroupsDeleteNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.deleteNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/deleteNodes',
        request_field='nodeGroupsDeleteNodesRequest',
        request_type_name='ComputeNodeGroupsDeleteNodesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the "nodes" field should not be used. Use nodeGroups.listNodes instead.

      Args:
        request: (ComputeNodeGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.get',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name='ComputeNodeGroupsGetRequest',
        response_type_name='NodeGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNodeGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeGroup resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.insert',
        ordered_params=['project', 'zone', 'initialNodeCount'],
        path_params=['project', 'zone'],
        query_params=['initialNodeCount', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups',
        request_field='nodeGroup',
        request_type_name='ComputeNodeGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.

      Args:
        request: (ComputeNodeGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups',
        request_field='',
        request_type_name='ComputeNodeGroupsListRequest',
        response_type_name='NodeGroupList',
        supports_download=False,
    )

    def ListNodes(self, request, global_params=None):
      r"""Lists nodes in the node group.

      Args:
        request: (ComputeNodeGroupsListNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupsListNodes) The response message.
      """
      config = self.GetMethodConfig('ListNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.listNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/listNodes',
        request_field='',
        request_type_name='ComputeNodeGroupsListNodesRequest',
        response_type_name='NodeGroupsListNodes',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified node group.

      Args:
        request: (ComputeNodeGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.nodeGroups.patch',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='nodeGroupResource',
        request_type_name='ComputeNodeGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PerformMaintenance(self, request, global_params=None):
      r"""Perform maintenance on a subset of nodes in the node group.

      Args:
        request: (ComputeNodeGroupsPerformMaintenanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PerformMaintenance')
      return self._RunMethod(
          config, request, global_params=global_params)

    PerformMaintenance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.performMaintenance',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/performMaintenance',
        request_field='nodeGroupsPerformMaintenanceRequest',
        request_type_name='ComputeNodeGroupsPerformMaintenanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeNodeGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetNodeTemplate(self, request, global_params=None):
      r"""Updates the node template of the node group.

      Args:
        request: (ComputeNodeGroupsSetNodeTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNodeTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNodeTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.setNodeTemplate',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/setNodeTemplate',
        request_field='nodeGroupsSetNodeTemplateRequest',
        request_type_name='ComputeNodeGroupsSetNodeTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SimulateMaintenanceEvent(self, request, global_params=None):
      r"""Simulates maintenance event on specified nodes from the node group.

      Args:
        request: (ComputeNodeGroupsSimulateMaintenanceEventRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SimulateMaintenanceEvent')
      return self._RunMethod(
          config, request, global_params=global_params)

    SimulateMaintenanceEvent.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.simulateMaintenanceEvent',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/simulateMaintenanceEvent',
        request_field='nodeGroupsSimulateMaintenanceEventRequest',
        request_type_name='ComputeNodeGroupsSimulateMaintenanceEventRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNodeGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTemplatesService(base_api.BaseApiService):
    """Service class for the nodeTemplates resource."""

    _NAME = 'nodeTemplates'

    def __init__(self, client):
      super(ComputeAlpha.NodeTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node templates. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNodeTemplatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/nodeTemplates',
        request_field='',
        request_type_name='ComputeNodeTemplatesAggregatedListRequest',
        response_type_name='NodeTemplateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeTemplate resource.

      Args:
        request: (ComputeNodeTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.nodeTemplates.delete',
        ordered_params=['project', 'region', 'nodeTemplate'],
        path_params=['nodeTemplate', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name='ComputeNodeTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node template.

      Args:
        request: (ComputeNodeTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.get',
        ordered_params=['project', 'region', 'nodeTemplate'],
        path_params=['nodeTemplate', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name='ComputeNodeTemplatesGetRequest',
        response_type_name='NodeTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNodeTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeTemplate resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates',
        request_field='nodeTemplate',
        request_type_name='ComputeNodeTemplatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node templates available to the specified project.

      Args:
        request: (ComputeNodeTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates',
        request_field='',
        request_type_name='ComputeNodeTemplatesListRequest',
        response_type_name='NodeTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeNodeTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNodeTemplatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTypesService(base_api.BaseApiService):
    """Service class for the nodeTypes resource."""

    _NAME = 'nodeTypes'

    def __init__(self, client):
      super(ComputeAlpha.NodeTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeNodeTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/nodeTypes',
        request_field='',
        request_type_name='ComputeNodeTypesAggregatedListRequest',
        response_type_name='NodeTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node type.

      Args:
        request: (ComputeNodeTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.get',
        ordered_params=['project', 'zone', 'nodeType'],
        path_params=['nodeType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeTypes/{nodeType}',
        request_field='',
        request_type_name='ComputeNodeTypesGetRequest',
        response_type_name='NodeType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node types available to the specified project.

      Args:
        request: (ComputeNodeTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeTypes',
        request_field='',
        request_type_name='ComputeNodeTypesListRequest',
        response_type_name='NodeTypeList',
        supports_download=False,
    )

  class OrganizationSecurityPoliciesService(base_api.BaseApiService):
    """Service class for the organizationSecurityPolicies resource."""

    _NAME = 'organizationSecurityPolicies'

    def __init__(self, client):
      super(ComputeAlpha.OrganizationSecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified security policy. This has billing implications. Projects in the hierarchy with effective hierarchical security policies will be automatically enrolled into Cloud Armor Enterprise if not already enrolled. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.addAssociation instead if possible.

      Args:
        request: (ComputeOrganizationSecurityPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.addAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/addAssociation',
        request_field='securityPolicyAssociation',
        request_type_name='ComputeOrganizationSecurityPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.addRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/addRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeOrganizationSecurityPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CopyRules(self, request, global_params=None):
      r"""Copies rules to the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.copyRules instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesCopyRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CopyRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CopyRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.copyRules',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId', 'sourceSecurityPolicy'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/copyRules',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesCopyRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy. Use of this API to remove firewall policies is deprecated. Use firewallPolicies.delete instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.organizationSecurityPolicies.delete',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy. Use of this API to read firewall policies is deprecated. Use firewallPolicies.get instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.get',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=[],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetRequest',
        response_type_name='SecurityPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getAssociation instead if possible.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.getAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['name'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetAssociationRequest',
        response_type_name='SecurityPolicyAssociation',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule at the specified priority. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getRule instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.getRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/getRule',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetRuleRequest',
        response_type_name='SecurityPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request. Use of this API to insert firewall policies is deprecated. Use firewallPolicies.insert instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.insert',
        ordered_params=[],
        path_params=[],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/securityPolicies',
        request_field='securityPolicy',
        request_type_name='ComputeOrganizationSecurityPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project. Use of this API to read firewall policies is deprecated. Use firewallPolicies.list instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/securityPolicies',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesListRequest',
        response_type_name='SecurityPolicyList',
        supports_download=False,
    )

    def ListAssociations(self, request, global_params=None):
      r"""Lists associations of a specified target, i.e., organization or folder. Use of this API to read firewall policies is deprecated. Use firewallPolicies.listAssociations instead if possible.

      Args:
        request: (ComputeOrganizationSecurityPoliciesListAssociationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSecurityPoliciesListAssociationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAssociations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAssociations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.listAssociations',
        ordered_params=[],
        path_params=[],
        query_params=['targetResource'],
        relative_path='locations/global/securityPolicies/listAssociations',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesListAssociationsRequest',
        response_type_name='OrganizationSecurityPoliciesListAssociationsResponse',
        supports_download=False,
    )

    def ListPreconfiguredExpressionSets(self, request, global_params=None):
      r"""Gets the current list of preconfigured Web Application Firewall (WAF) expressions.

      Args:
        request: (ComputeOrganizationSecurityPoliciesListPreconfiguredExpressionSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPoliciesListPreconfiguredExpressionSetsResponse) The response message.
      """
      config = self.GetMethodConfig('ListPreconfiguredExpressionSets')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPreconfiguredExpressionSets.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.listPreconfiguredExpressionSets',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/securityPolicies/listPreconfiguredExpressionSets',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesListPreconfiguredExpressionSetsRequest',
        response_type_name='SecurityPoliciesListPreconfiguredExpressionSetsResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.move instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.move',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/move',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patch instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.organizationSecurityPolicies.patch',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId', 'updateMask'],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='securityPolicyResource',
        request_type_name='ComputeOrganizationSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule at the specified priority. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patchRule instead.

      Args:
        request: (ComputeOrganizationSecurityPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.patchRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority', 'requestId', 'updateMask'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/patchRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeOrganizationSecurityPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.removeAssociation instead if possible.

      Args:
        request: (ComputeOrganizationSecurityPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.removeAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['name', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule at the specified priority.

      Args:
        request: (ComputeOrganizationSecurityPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.removeRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PacketMirroringsService(base_api.BaseApiService):
    """Service class for the packetMirrorings resource."""

    _NAME = 'packetMirrorings'

    def __init__(self, client):
      super(ComputeAlpha.PacketMirroringsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of packetMirrorings. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputePacketMirroringsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroringAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/packetMirrorings',
        request_field='',
        request_type_name='ComputePacketMirroringsAggregatedListRequest',
        response_type_name='PacketMirroringAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PacketMirroring resource.

      Args:
        request: (ComputePacketMirroringsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.packetMirrorings.delete',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='',
        request_type_name='ComputePacketMirroringsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PacketMirroring resource.

      Args:
        request: (ComputePacketMirroringsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroring) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.get',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='',
        request_type_name='ComputePacketMirroringsGetRequest',
        response_type_name='PacketMirroring',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PacketMirroring resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputePacketMirroringsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.packetMirrorings.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings',
        request_field='packetMirroring',
        request_type_name='ComputePacketMirroringsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of PacketMirroring resources available to the specified project and region.

      Args:
        request: (ComputePacketMirroringsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroringList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings',
        request_field='',
        request_type_name='ComputePacketMirroringsListRequest',
        response_type_name='PacketMirroringList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified PacketMirroring resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePacketMirroringsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.packetMirrorings.patch',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='packetMirroringResource',
        request_type_name='ComputePacketMirroringsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputePacketMirroringsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.packetMirrorings.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputePacketMirroringsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class PreviewFeaturesService(base_api.BaseApiService):
    """Service class for the previewFeatures resource."""

    _NAME = 'previewFeatures'

    def __init__(self, client):
      super(ComputeAlpha.PreviewFeaturesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the details of the given PreviewFeature.

      Args:
        request: (ComputePreviewFeaturesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewFeature) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.previewFeatures.get',
        ordered_params=['project', 'previewFeature'],
        path_params=['previewFeature', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/previewFeatures/{previewFeature}',
        request_field='',
        request_type_name='ComputePreviewFeaturesGetRequest',
        response_type_name='PreviewFeature',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the details of the given PreviewFeature.

      Args:
        request: (ComputePreviewFeaturesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PreviewFeatureList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.previewFeatures.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/previewFeatures',
        request_field='',
        request_type_name='ComputePreviewFeaturesListRequest',
        response_type_name='PreviewFeatureList',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Patches the given PreviewFeature. This method is used to enable or disable a PreviewFeature.

      Args:
        request: (ComputePreviewFeaturesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.previewFeatures.update',
        ordered_params=['project', 'previewFeature'],
        path_params=['previewFeature', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/previewFeatures/{previewFeature}',
        request_field='previewFeatureResource',
        request_type_name='ComputePreviewFeaturesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ComputeAlpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def DisableXpnHost(self, request, global_params=None):
      r"""Disable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsDisableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.disableXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/disableXpnHost',
        request_field='',
        request_type_name='ComputeProjectsDisableXpnHostRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DisableXpnResource(self, request, global_params=None):
      r"""Disable a service resource (also known as service project) associated with this host project.

      Args:
        request: (ComputeProjectsDisableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.disableXpnResource',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/disableXpnResource',
        request_field='projectsDisableXpnResourceRequest',
        request_type_name='ComputeProjectsDisableXpnResourceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def EnableXpnHost(self, request, global_params=None):
      r"""Enable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsEnableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.enableXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/enableXpnHost',
        request_field='',
        request_type_name='ComputeProjectsEnableXpnHostRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def EnableXpnResource(self, request, global_params=None):
      r"""Enable service resource (a.k.a service project) for a host project, so that subnets in the host project can be used by instances in the service project.

      Args:
        request: (ComputeProjectsEnableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.enableXpnResource',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/enableXpnResource',
        request_field='projectsEnableXpnResourceRequest',
        request_type_name='ComputeProjectsEnableXpnResourceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Project resource. To decrease latency for this method, you can optionally omit any unneeded information from the response by using a field mask. This practice is especially recommended for unused quota information (the `quotas` field). To exclude one or more fields, set your request's `fields` query parameter to only include the fields you need. For example, to only include the `id` and `selfLink` fields, add the query parameter `?fields=id,selfLink` to your request.

      Args:
        request: (ComputeProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.get',
        ordered_params=['project'],
        path_params=['project'],
        query_params=[],
        relative_path='projects/{project}',
        request_field='',
        request_type_name='ComputeProjectsGetRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetXpnHost(self, request, global_params=None):
      r"""Gets the shared VPC host project that this project links to. May be empty if no link exists.

      Args:
        request: (ComputeProjectsGetXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('GetXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.getXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=[],
        relative_path='projects/{project}/getXpnHost',
        request_field='',
        request_type_name='ComputeProjectsGetXpnHostRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetXpnResources(self, request, global_params=None):
      r"""Gets service resources (a.k.a service project) associated with this host project.

      Args:
        request: (ComputeProjectsGetXpnResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ProjectsGetXpnResources) The response message.
      """
      config = self.GetMethodConfig('GetXpnResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.getXpnResources',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/getXpnResources',
        request_field='',
        request_type_name='ComputeProjectsGetXpnResourcesRequest',
        response_type_name='ProjectsGetXpnResources',
        supports_download=False,
    )

    def ListXpnHosts(self, request, global_params=None):
      r"""Lists all shared VPC host projects visible to the user in an organization.

      Args:
        request: (ComputeProjectsListXpnHostsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (XpnHostList) The response message.
      """
      config = self.GetMethodConfig('ListXpnHosts')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListXpnHosts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.listXpnHosts',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/listXpnHosts',
        request_field='projectsListXpnHostsRequest',
        request_type_name='ComputeProjectsListXpnHostsRequest',
        response_type_name='XpnHostList',
        supports_download=False,
    )

    def MoveDisk(self, request, global_params=None):
      r"""Starting September 29, 2025, you can't use the moveDisk API on new projects. To move a disk to a different region or zone, follow the steps in [Change the location of a disk](https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/migrate-to-hyperdisk#migrate-to-hd). Projects that already use the moveDisk API can continue usage until September 29, 2026. Starting November 1, 2025, API responses will include a warning message in the response body about the upcoming deprecation. You can skip the message to continue using the service without interruption.

      Args:
        request: (ComputeProjectsMoveDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.moveDisk',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/moveDisk',
        request_field='diskMoveRequest',
        request_type_name='ComputeProjectsMoveDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def MoveInstance(self, request, global_params=None):
      r"""Moves an instance and its attached persistent disks from one zone to another. *Note*: Moving VMs or disks by using this method might cause unexpected behavior. For more information, see the [known issue](/compute/docs/troubleshooting/known-issues#moving_vms_or_disks_using_the_moveinstance_api_or_the_causes_unexpected_behavior). [Deprecated] This method is deprecated. See [moving instance across zones](/compute/docs/instances/moving-instance-across-zones) instead.

      Args:
        request: (ComputeProjectsMoveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.moveInstance',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/moveInstance',
        request_field='instanceMoveRequest',
        request_type_name='ComputeProjectsMoveInstanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetCloudArmorTier(self, request, global_params=None):
      r"""Sets the Cloud Armor tier of the project. To set ENTERPRISE or above the billing account of the project must be subscribed to Cloud Armor Enterprise. See Subscribing to Cloud Armor Enterprise for more information.

      Args:
        request: (ComputeProjectsSetCloudArmorTierRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCloudArmorTier')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCloudArmorTier.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setCloudArmorTier',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setCloudArmorTier',
        request_field='projectsSetCloudArmorTierRequest',
        request_type_name='ComputeProjectsSetCloudArmorTierRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetCommonInstanceMetadata(self, request, global_params=None):
      r"""Sets metadata common to all instances within the specified project using the data included in the request.

      Args:
        request: (ComputeProjectsSetCommonInstanceMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCommonInstanceMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCommonInstanceMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setCommonInstanceMetadata',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setCommonInstanceMetadata',
        request_field='metadata',
        request_type_name='ComputeProjectsSetCommonInstanceMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetDefaultNetworkTier(self, request, global_params=None):
      r"""Sets the default network tier of the project. The default network tier is used when an address/forwardingRule/instance is created without specifying the network tier field.

      Args:
        request: (ComputeProjectsSetDefaultNetworkTierRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDefaultNetworkTier')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDefaultNetworkTier.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setDefaultNetworkTier',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setDefaultNetworkTier',
        request_field='projectsSetDefaultNetworkTierRequest',
        request_type_name='ComputeProjectsSetDefaultNetworkTierRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetDefaultServiceAccount(self, request, global_params=None):
      r"""Sets the default service account of the project. The default service account is used when a VM instance is created with the service account email address set to "default".

      Args:
        request: (ComputeProjectsSetDefaultServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDefaultServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDefaultServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setDefaultServiceAccount',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setDefaultServiceAccount',
        request_field='projectsSetDefaultServiceAccountRequest',
        request_type_name='ComputeProjectsSetDefaultServiceAccountRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetManagedProtectionTier(self, request, global_params=None):
      r"""Sets the Cloud Armor Managed Protection (CAMP) tier of the project. To set PLUS or above the billing account of the project must be subscribed to Managed Protection Plus. See Subscribing to Managed Protection Plus for more information.

      Args:
        request: (ComputeProjectsSetManagedProtectionTierRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetManagedProtectionTier')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetManagedProtectionTier.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setManagedProtectionTier',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setManagedProtectionTier',
        request_field='projectsSetManagedProtectionTierRequest',
        request_type_name='ComputeProjectsSetManagedProtectionTierRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUsageExportBucket(self, request, global_params=None):
      r"""Enables the usage export feature and sets the usage export bucket where reports are stored. If you provide an empty request body using this method, the usage export feature will be disabled.

      Args:
        request: (ComputeProjectsSetUsageExportBucketRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUsageExportBucket')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUsageExportBucket.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setUsageExportBucket',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setUsageExportBucket',
        request_field='usageExportLocation',
        request_type_name='ComputeProjectsSetUsageExportBucketRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PublicAdvertisedPrefixesService(base_api.BaseApiService):
    """Service class for the publicAdvertisedPrefixes resource."""

    _NAME = 'publicAdvertisedPrefixes'

    def __init__(self, client):
      super(ComputeAlpha.PublicAdvertisedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def Announce(self, request, global_params=None):
      r"""Announces the specified PublicAdvertisedPrefix.

      Args:
        request: (ComputePublicAdvertisedPrefixesAnnounceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Announce')
      return self._RunMethod(
          config, request, global_params=global_params)

    Announce.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicAdvertisedPrefixes.announce',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}/announce',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesAnnounceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PublicAdvertisedPrefix.

      Args:
        request: (ComputePublicAdvertisedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.publicAdvertisedPrefixes.delete',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PublicAdvertisedPrefix resource.

      Args:
        request: (ComputePublicAdvertisedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicAdvertisedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicAdvertisedPrefixes.get',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=[],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesGetRequest',
        response_type_name='PublicAdvertisedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PublicAdvertisedPrefix in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputePublicAdvertisedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicAdvertisedPrefixes.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes',
        request_field='publicAdvertisedPrefix',
        request_type_name='ComputePublicAdvertisedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the PublicAdvertisedPrefixes for a project.

      Args:
        request: (ComputePublicAdvertisedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicAdvertisedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicAdvertisedPrefixes.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesListRequest',
        response_type_name='PublicAdvertisedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified Router resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePublicAdvertisedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.publicAdvertisedPrefixes.patch',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='publicAdvertisedPrefixResource',
        request_type_name='ComputePublicAdvertisedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Withdraw(self, request, global_params=None):
      r"""Withdraws the specified PublicAdvertisedPrefix.

      Args:
        request: (ComputePublicAdvertisedPrefixesWithdrawRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Withdraw')
      return self._RunMethod(
          config, request, global_params=global_params)

    Withdraw.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicAdvertisedPrefixes.withdraw',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}/withdraw',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesWithdrawRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PublicDelegatedPrefixesService(base_api.BaseApiService):
    """Service class for the publicDelegatedPrefixes resource."""

    _NAME = 'publicDelegatedPrefixes'

    def __init__(self, client):
      super(ComputeAlpha.PublicDelegatedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Lists all PublicDelegatedPrefix resources owned by the specific project across all scopes. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputePublicDelegatedPrefixesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesAggregatedListRequest',
        response_type_name='PublicDelegatedPrefixAggregatedList',
        supports_download=False,
    )

    def Announce(self, request, global_params=None):
      r"""Announces the specified PublicDelegatedPrefix in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesAnnounceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Announce')
      return self._RunMethod(
          config, request, global_params=global_params)

    Announce.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicDelegatedPrefixes.announce',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}/announce',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesAnnounceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PublicDelegatedPrefix in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.publicDelegatedPrefixes.delete',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PublicDelegatedPrefix resource in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.get',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesGetRequest',
        response_type_name='PublicDelegatedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PublicDelegatedPrefix in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputePublicDelegatedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicDelegatedPrefixes.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes',
        request_field='publicDelegatedPrefix',
        request_type_name='ComputePublicDelegatedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the PublicDelegatedPrefixes for a project in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesListRequest',
        response_type_name='PublicDelegatedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePublicDelegatedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.publicDelegatedPrefixes.patch',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='publicDelegatedPrefixResource',
        request_type_name='ComputePublicDelegatedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Withdraw(self, request, global_params=None):
      r"""Withdraws the specified PublicDelegatedPrefix in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesWithdrawRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Withdraw')
      return self._RunMethod(
          config, request, global_params=global_params)

    Withdraw.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicDelegatedPrefixes.withdraw',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}/withdraw',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesWithdrawRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RecoverableSnapshotsService(base_api.BaseApiService):
    """Service class for the recoverableSnapshots resource."""

    _NAME = 'recoverableSnapshots'

    def __init__(self, client):
      super(ComputeAlpha.RecoverableSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all of the RecoverableSnapshots in your project across all regions and global scope.

      Args:
        request: (ComputeRecoverableSnapshotsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RecoverableSnapshotAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.recoverableSnapshots.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/recoverableSnapshots',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsAggregatedListRequest',
        response_type_name='RecoverableSnapshotAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified RecoverableSnapshot. Deleting a recoverable snapshot will delete the underlying PD snapshot and is irreversible.

      Args:
        request: (ComputeRecoverableSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.recoverableSnapshots.delete',
        ordered_params=['project', 'recoverableSnapshot'],
        path_params=['project', 'recoverableSnapshot'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/recoverableSnapshots/{recoverableSnapshot}',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified RecoverableSnapshot resource.

      Args:
        request: (ComputeRecoverableSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RecoverableSnapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.recoverableSnapshots.get',
        ordered_params=['project', 'recoverableSnapshot'],
        path_params=['project', 'recoverableSnapshot'],
        query_params=[],
        relative_path='projects/{project}/global/recoverableSnapshots/{recoverableSnapshot}',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsGetRequest',
        response_type_name='RecoverableSnapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRecoverableSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.recoverableSnapshots.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/recoverableSnapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of all of the RecoverableSnapshots in your project.

      Args:
        request: (ComputeRecoverableSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RecoverableSnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.recoverableSnapshots.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/recoverableSnapshots',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsListRequest',
        response_type_name='RecoverableSnapshotList',
        supports_download=False,
    )

    def Recover(self, request, global_params=None):
      r"""Recovers the specified RecoverableSnapshot.

      Args:
        request: (ComputeRecoverableSnapshotsRecoverRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Recover')
      return self._RunMethod(
          config, request, global_params=global_params)

    Recover.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.recoverableSnapshots.recover',
        ordered_params=['project', 'recoverableSnapshot'],
        path_params=['project', 'recoverableSnapshot'],
        query_params=['requestId', 'snapshotName'],
        relative_path='projects/{project}/global/recoverableSnapshots/{recoverableSnapshot}/recover',
        request_field='',
        request_type_name='ComputeRecoverableSnapshotsRecoverRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRecoverableSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.recoverableSnapshots.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/recoverableSnapshots/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeRecoverableSnapshotsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRecoverableSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.recoverableSnapshots.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/recoverableSnapshots/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRecoverableSnapshotsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionAutoscalersService(base_api.BaseApiService):
    """Service class for the regionAutoscalers resource."""

    _NAME = 'regionAutoscalers'

    def __init__(self, client):
      super(ComputeAlpha.RegionAutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionAutoscalers.delete',
        ordered_params=['project', 'region', 'autoscaler'],
        path_params=['autoscaler', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeRegionAutoscalersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionAutoscalers.get',
        ordered_params=['project', 'region', 'autoscaler'],
        path_params=['autoscaler', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeRegionAutoscalersGetRequest',
        response_type_name='Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionAutoscalers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscaler',
        request_type_name='ComputeRegionAutoscalersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified region.

      Args:
        request: (ComputeRegionAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionAutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionAutoscalers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='',
        request_type_name='ComputeRegionAutoscalersListRequest',
        response_type_name='RegionAutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionAutoscalers.patch',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeRegionAutoscalersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionAutoscalers.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/autoscalers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionAutoscalersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionAutoscalers.update',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeRegionAutoscalersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionBackendBucketsService(base_api.BaseApiService):
    """Service class for the regionBackendBuckets resource."""

    _NAME = 'regionBackendBuckets'

    def __init__(self, client):
      super(ComputeAlpha.RegionBackendBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional BackendBucket resource.

      Args:
        request: (ComputeRegionBackendBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionBackendBuckets.delete',
        ordered_params=['project', 'region', 'backendBucket'],
        path_params=['backendBucket', 'project', 'region'],
        query_params=['forceDelete', 'requestId'],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeRegionBackendBucketsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional BackendBucket resource.

      Args:
        request: (ComputeRegionBackendBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendBuckets.get',
        ordered_params=['project', 'region', 'backendBucket'],
        path_params=['backendBucket', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeRegionBackendBucketsGetRequest',
        response_type_name='BackendBucket',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionBackendBucketsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendBuckets.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionBackendBucketsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a RegionBackendBucket in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeRegionBackendBucketsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendBuckets.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendBuckets',
        request_field='backendBucket',
        request_type_name='ComputeRegionBackendBucketsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendBucket resources available to the specified project in the given region.

      Args:
        request: (ComputeRegionBackendBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendBuckets.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/backendBuckets',
        request_field='',
        request_type_name='ComputeRegionBackendBucketsListRequest',
        response_type_name='BackendBucketList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves a list of all usable backend buckets in the specified project in the given region.

      Args:
        request: (ComputeRegionBackendBucketsListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketListUsable) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendBuckets.listUsable',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/backendBuckets/listUsable',
        request_field='',
        request_type_name='ComputeRegionBackendBucketsListUsableRequest',
        response_type_name='BackendBucketListUsable',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionBackendBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionBackendBuckets.patch',
        ordered_params=['project', 'region', 'backendBucket'],
        path_params=['backendBucket', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{backendBucket}',
        request_field='backendBucketResource',
        request_type_name='ComputeRegionBackendBucketsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionBackendBucketsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendBuckets.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionBackendBucketsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionBackendBucketsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendBuckets.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendBuckets/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionBackendBucketsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionBackendServicesService(base_api.BaseApiService):
    """Service class for the regionBackendServices resource."""

    _NAME = 'regionBackendServices'

    def __init__(self, client):
      super(ComputeAlpha.RegionBackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionBackendServices.delete',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeRegionBackendServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.get',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeRegionBackendServicesGetRequest',
        response_type_name='BackendService',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this regional BackendService.

      Args:
        request: (ComputeRegionBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.getHealth',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}/getHealth',
        request_field='resourceGroupReference',
        request_type_name='ComputeRegionBackendServicesGetHealthRequest',
        response_type_name='BackendServiceGroupHealth',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionBackendServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionBackendServicesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a regional BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview.

      Args:
        request: (ComputeRegionBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices',
        request_field='backendService',
        request_type_name='ComputeRegionBackendServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of regional BackendService resources available to the specified project in the given region.

      Args:
        request: (ComputeRegionBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/backendServices',
        request_field='',
        request_type_name='ComputeRegionBackendServicesListRequest',
        response_type_name='BackendServiceList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves a list of all usable backend services in the specified project in the given region.

      Args:
        request: (ComputeRegionBackendServicesListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceListUsable) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.listUsable',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/backendServices/listUsable',
        request_field='',
        request_type_name='ComputeRegionBackendServicesListUsableRequest',
        response_type_name='BackendServiceListUsable',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. For more information, see Understanding backend services This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionBackendServices.patch',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeRegionBackendServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionBackendServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionBackendServicesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetSecurityPolicy(self, request, global_params=None):
      r"""Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview.

      Args:
        request: (ComputeRegionBackendServicesSetSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.setSecurityPolicy',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}/setSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeRegionBackendServicesSetSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionBackendServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. For more information, see Backend services overview .

      Args:
        request: (ComputeRegionBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionBackendServices.update',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeRegionBackendServicesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionCommitmentsService(base_api.BaseApiService):
    """Service class for the regionCommitments resource."""

    _NAME = 'regionCommitments'

    def __init__(self, client):
      super(ComputeAlpha.RegionCommitmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of commitments by region. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionCommitmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/commitments',
        request_field='',
        request_type_name='ComputeRegionCommitmentsAggregatedListRequest',
        response_type_name='CommitmentAggregatedList',
        supports_download=False,
    )

    def CalculateCancellationFee(self, request, global_params=None):
      r"""Calculate cancellation fee for the specified commitment.

      Args:
        request: (ComputeRegionCommitmentsCalculateCancellationFeeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CalculateCancellationFee')
      return self._RunMethod(
          config, request, global_params=global_params)

    CalculateCancellationFee.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.calculateCancellationFee',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}/calculateCancellationFee',
        request_field='',
        request_type_name='ComputeRegionCommitmentsCalculateCancellationFeeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Cancel(self, request, global_params=None):
      r"""Cancel the specified commitment.

      Args:
        request: (ComputeRegionCommitmentsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.cancel',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}/cancel',
        request_field='',
        request_type_name='ComputeRegionCommitmentsCancelRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified commitment resource.

      Args:
        request: (ComputeRegionCommitmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Commitment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.get',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}',
        request_field='',
        request_type_name='ComputeRegionCommitmentsGetRequest',
        response_type_name='Commitment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a commitment in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionCommitmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments',
        request_field='commitment',
        request_type_name='ComputeRegionCommitmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of commitments contained within the specified region.

      Args:
        request: (ComputeRegionCommitmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/commitments',
        request_field='',
        request_type_name='ComputeRegionCommitmentsListRequest',
        response_type_name='CommitmentList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionCommitmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/commitments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionCommitmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified commitment with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be updated: auto_renew and plan.

      Args:
        request: (ComputeRegionCommitmentsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionCommitments.update',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}',
        request_field='commitmentResource',
        request_type_name='ComputeRegionCommitmentsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateReservations(self, request, global_params=None):
      r"""Transfers GPUs or Local SSD disks between reservations that are attached to the same commitment.

      Args:
        request: (ComputeRegionCommitmentsUpdateReservationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateReservations')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateReservations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.updateReservations',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}/updateReservations',
        request_field='regionCommitmentsUpdateReservationsRequest',
        request_type_name='ComputeRegionCommitmentsUpdateReservationsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionCompositeHealthChecksService(base_api.BaseApiService):
    """Service class for the regionCompositeHealthChecks resource."""

    _NAME = 'regionCompositeHealthChecks'

    def __init__(self, client):
      super(ComputeAlpha.RegionCompositeHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all CompositeHealthCheck resources (all regional) available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionCompositeHealthChecksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CompositeHealthCheckAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCompositeHealthChecks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/compositeHealthChecks',
        request_field='',
        request_type_name='ComputeRegionCompositeHealthChecksAggregatedListRequest',
        response_type_name='CompositeHealthCheckAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified CompositeHealthCheck in the given region.

      Args:
        request: (ComputeRegionCompositeHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionCompositeHealthChecks.delete',
        ordered_params=['project', 'region', 'compositeHealthCheck'],
        path_params=['compositeHealthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks/{compositeHealthCheck}',
        request_field='',
        request_type_name='ComputeRegionCompositeHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified CompositeHealthCheck resource in the given region.

      Args:
        request: (ComputeRegionCompositeHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CompositeHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCompositeHealthChecks.get',
        ordered_params=['project', 'region', 'compositeHealthCheck'],
        path_params=['compositeHealthCheck', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks/{compositeHealthCheck}',
        request_field='',
        request_type_name='ComputeRegionCompositeHealthChecksGetRequest',
        response_type_name='CompositeHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a CompositeHealthCheck in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputeRegionCompositeHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCompositeHealthChecks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks',
        request_field='compositeHealthCheck',
        request_type_name='ComputeRegionCompositeHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the CompositeHealthChecks for a project in the given region.

      Args:
        request: (ComputeRegionCompositeHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CompositeHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCompositeHealthChecks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks',
        request_field='',
        request_type_name='ComputeRegionCompositeHealthChecksListRequest',
        response_type_name='CompositeHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional CompositeHealthCheck resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionCompositeHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionCompositeHealthChecks.patch',
        ordered_params=['project', 'region', 'compositeHealthCheck'],
        path_params=['compositeHealthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks/{compositeHealthCheck}',
        request_field='compositeHealthCheckResource',
        request_type_name='ComputeRegionCompositeHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionCompositeHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCompositeHealthChecks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/compositeHealthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionCompositeHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionDiskSettingsService(base_api.BaseApiService):
    """Service class for the regionDiskSettings resource."""

    _NAME = 'regionDiskSettings'

    def __init__(self, client):
      super(ComputeAlpha.RegionDiskSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get Regional Disk Settings.

      Args:
        request: (ComputeRegionDiskSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskSettings) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDiskSettings.get',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/diskSettings',
        request_field='',
        request_type_name='ComputeRegionDiskSettingsGetRequest',
        response_type_name='DiskSettings',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patch Regional Disk Settings.

      Args:
        request: (ComputeRegionDiskSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionDiskSettings.patch',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/diskSettings',
        request_field='diskSettings',
        request_type_name='ComputeRegionDiskSettingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionDiskTypesService(base_api.BaseApiService):
    """Service class for the regionDiskTypes resource."""

    _NAME = 'regionDiskTypes'

    def __init__(self, client):
      super(ComputeAlpha.RegionDiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified regional disk type.

      Args:
        request: (ComputeRegionDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDiskTypes.get',
        ordered_params=['project', 'region', 'diskType'],
        path_params=['diskType', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/diskTypes/{diskType}',
        request_field='',
        request_type_name='ComputeRegionDiskTypesGetRequest',
        response_type_name='DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of regional disk types available to the specified project.

      Args:
        request: (ComputeRegionDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionDiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDiskTypes.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/diskTypes',
        request_field='',
        request_type_name='ComputeRegionDiskTypesListRequest',
        response_type_name='RegionDiskTypeList',
        supports_download=False,
    )

  class RegionDisksService(base_api.BaseApiService):
    """Service class for the regionDisks resource."""

    _NAME = 'regionDisks'

    def __init__(self, client):
      super(ComputeAlpha.RegionDisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a regional disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeRegionDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.addResourcePolicies',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies',
        request_field='regionDisksAddResourcePoliciesRequest',
        request_type_name='ComputeRegionDisksAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def BulkInsert(self, request, global_params=None):
      r"""Bulk create a set of disks.

      Args:
        request: (ComputeRegionDisksBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.bulkInsert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/bulkInsert',
        request_field='bulkInsertDiskResource',
        request_type_name='ComputeRegionDisksBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.

      Args:
        request: (ComputeRegionDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.createSnapshot',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['guestFlush', 'requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/createSnapshot',
        request_field='snapshot',
        request_type_name='ComputeRegionDisksCreateSnapshotRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional persistent disk. Deleting a regional disk removes all the replicas of its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeRegionDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionDisks.delete',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name='ComputeRegionDisksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.get',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name='ComputeRegionDisksGetRequest',
        response_type_name='Disk',
        supports_download=False,
    )

    def GetAsyncReplicationStatus(self, request, global_params=None):
      r"""Gets the status of current async replication for a given device.

      Args:
        request: (ComputeRegionDisksGetAsyncReplicationStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetAsyncReplicationStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetAsyncReplicationStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAsyncReplicationStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.getAsyncReplicationStatus',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/getAsyncReplicationStatus',
        request_field='',
        request_type_name='ComputeRegionDisksGetAsyncReplicationStatusRequest',
        response_type_name='GetAsyncReplicationStatusResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionDisksGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent regional disk in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'sourceImage'],
        relative_path='projects/{project}/regions/{region}/disks',
        request_field='disk',
        request_type_name='ComputeRegionDisksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of persistent disks contained within the specified region.

      Args:
        request: (ComputeRegionDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/disks',
        request_field='',
        request_type_name='ComputeRegionDisksListRequest',
        response_type_name='DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a regional disk.

      Args:
        request: (ComputeRegionDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.removeResourcePolicies',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies',
        request_field='regionDisksRemoveResourcePoliciesRequest',
        request_type_name='ComputeRegionDisksRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.resize',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/resize',
        request_field='regionDisksResizeRequest',
        request_type_name='ComputeRegionDisksResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionDisksSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the target regional disk.

      Args:
        request: (ComputeRegionDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeRegionDisksSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartAsyncReplication(self, request, global_params=None):
      r"""Starts asynchronous replication. Must be invoked on the primary disk.

      Args:
        request: (ComputeRegionDisksStartAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.startAsyncReplication',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/startAsyncReplication',
        request_field='regionDisksStartAsyncReplicationRequest',
        request_type_name='ComputeRegionDisksStartAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopAsyncReplication(self, request, global_params=None):
      r"""Stops asynchronous replication. Can be invoked either on the primary or on the secondary disk.

      Args:
        request: (ComputeRegionDisksStopAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.stopAsyncReplication',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/stopAsyncReplication',
        request_field='',
        request_type_name='ComputeRegionDisksStopAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopGroupAsyncReplication(self, request, global_params=None):
      r"""Stops asynchronous replication for a consistency group of disks. Can be invoked either in the primary or secondary scope.

      Args:
        request: (ComputeRegionDisksStopGroupAsyncReplicationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopGroupAsyncReplication')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopGroupAsyncReplication.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.stopGroupAsyncReplication',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/stopGroupAsyncReplication',
        request_field='disksStopGroupAsyncReplicationResource',
        request_type_name='ComputeRegionDisksStopGroupAsyncReplicationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionDisksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update the specified disk with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.

      Args:
        request: (ComputeRegionDisksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionDisks.update',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='diskResource',
        request_type_name='ComputeRegionDisksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateKmsKey(self, request, global_params=None):
      r"""Rotates the customer-managed encryption key to the latest version for the specified persistent disk.

      Args:
        request: (ComputeRegionDisksUpdateKmsKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateKmsKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateKmsKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.updateKmsKey',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/updateKmsKey',
        request_field='',
        request_type_name='ComputeRegionDisksUpdateKmsKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def WaitForReplicationCatchUp(self, request, global_params=None):
      r"""Wait for replication to catch up on the secondary disk.

      Args:
        request: (ComputeRegionDisksWaitForReplicationCatchUpRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('WaitForReplicationCatchUp')
      return self._RunMethod(
          config, request, global_params=global_params)

    WaitForReplicationCatchUp.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.waitForReplicationCatchUp',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/waitForReplicationCatchUp',
        request_field='regionWaitForReplicationCatchUpRequest',
        request_type_name='ComputeRegionDisksWaitForReplicationCatchUpRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionHealthAggregationPoliciesService(base_api.BaseApiService):
    """Service class for the regionHealthAggregationPolicies resource."""

    _NAME = 'regionHealthAggregationPolicies'

    def __init__(self, client):
      super(ComputeAlpha.RegionHealthAggregationPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthAggregationPolicy resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthAggregationPolicyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthAggregationPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/healthAggregationPolicies',
        request_field='',
        request_type_name='ComputeRegionHealthAggregationPoliciesAggregatedListRequest',
        response_type_name='HealthAggregationPolicyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthAggregationPolicy in the given region.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthAggregationPolicies.delete',
        ordered_params=['project', 'region', 'healthAggregationPolicy'],
        path_params=['healthAggregationPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}',
        request_field='',
        request_type_name='ComputeRegionHealthAggregationPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthAggregationPolicy resource in the given region.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthAggregationPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthAggregationPolicies.get',
        ordered_params=['project', 'region', 'healthAggregationPolicy'],
        path_params=['healthAggregationPolicy', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}',
        request_field='',
        request_type_name='ComputeRegionHealthAggregationPoliciesGetRequest',
        response_type_name='HealthAggregationPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a HealthAggregationPolicy in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthAggregationPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies',
        request_field='healthAggregationPolicy',
        request_type_name='ComputeRegionHealthAggregationPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the HealthAggregationPolicies for a project in the given region.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthAggregationPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthAggregationPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies',
        request_field='',
        request_type_name='ComputeRegionHealthAggregationPoliciesListRequest',
        response_type_name='HealthAggregationPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional HealthAggregationPolicy resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthAggregationPolicies.patch',
        ordered_params=['project', 'region', 'healthAggregationPolicy'],
        path_params=['healthAggregationPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}',
        request_field='healthAggregationPolicyResource',
        request_type_name='ComputeRegionHealthAggregationPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthAggregationPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthAggregationPolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthAggregationPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthAggregationPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionHealthCheckServicesService(base_api.BaseApiService):
    """Service class for the regionHealthCheckServices resource."""

    _NAME = 'regionHealthCheckServices'

    def __init__(self, client):
      super(ComputeAlpha.RegionHealthCheckServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthCheckService resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionHealthCheckServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthCheckServices.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/healthCheckServices',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesAggregatedListRequest',
        response_type_name='HealthCheckServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional HealthCheckService.

      Args:
        request: (ComputeRegionHealthCheckServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthCheckServices.delete',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional HealthCheckService resource.

      Args:
        request: (ComputeRegionHealthCheckServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthCheckServices.get',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesGetRequest',
        response_type_name='HealthCheckService',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a regional HealthCheckService resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionHealthCheckServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthCheckServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices',
        request_field='healthCheckService',
        request_type_name='ComputeRegionHealthCheckServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the HealthCheckService resources that have been configured for the specified project in the given region.

      Args:
        request: (ComputeRegionHealthCheckServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckServicesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthCheckServices.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesListRequest',
        response_type_name='HealthCheckServicesList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional HealthCheckService resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthCheckServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthCheckServices.patch',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='healthCheckServiceResource',
        request_type_name='ComputeRegionHealthCheckServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthCheckServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthCheckServices.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthCheckServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionHealthChecksService(base_api.BaseApiService):
    """Service class for the regionHealthChecks resource."""

    _NAME = 'regionHealthChecks'

    def __init__(self, client):
      super(ComputeAlpha.RegionHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeRegionHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthChecks.delete',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeRegionHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource.

      Args:
        request: (ComputeRegionHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthChecks.get',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeRegionHealthChecksGetRequest',
        response_type_name='HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthChecks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks',
        request_field='healthCheck',
        request_type_name='ComputeRegionHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeRegionHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthChecks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthChecks',
        request_field='',
        request_type_name='ComputeRegionHealthChecksListRequest',
        response_type_name='HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthChecks.patch',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeRegionHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthChecks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionHealthChecks.update',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeRegionHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionHealthSourcesService(base_api.BaseApiService):
    """Service class for the regionHealthSources resource."""

    _NAME = 'regionHealthSources'

    def __init__(self, client):
      super(ComputeAlpha.RegionHealthSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthSource resources (all regional) available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionHealthSourcesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthSourceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthSources.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/healthSources',
        request_field='',
        request_type_name='ComputeRegionHealthSourcesAggregatedListRequest',
        response_type_name='HealthSourceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthSource in the given region.

      Args:
        request: (ComputeRegionHealthSourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthSources.delete',
        ordered_params=['project', 'region', 'healthSource'],
        path_params=['healthSource', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthSources/{healthSource}',
        request_field='',
        request_type_name='ComputeRegionHealthSourcesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthSource resource in the given region.

      Args:
        request: (ComputeRegionHealthSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthSources.get',
        ordered_params=['project', 'region', 'healthSource'],
        path_params=['healthSource', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthSources/{healthSource}',
        request_field='',
        request_type_name='ComputeRegionHealthSourcesGetRequest',
        response_type_name='HealthSource',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a HealthSource in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputeRegionHealthSourcesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthSources.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthSources',
        request_field='healthSource',
        request_type_name='ComputeRegionHealthSourcesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the HealthSources for a project in the given region.

      Args:
        request: (ComputeRegionHealthSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthSourceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthSources.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthSources',
        request_field='',
        request_type_name='ComputeRegionHealthSourcesListRequest',
        response_type_name='HealthSourceList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional HealthSource resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthSourcesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthSources.patch',
        ordered_params=['project', 'region', 'healthSource'],
        path_params=['healthSource', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthSources/{healthSource}',
        request_field='healthSourceResource',
        request_type_name='ComputeRegionHealthSourcesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthSourcesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthSources.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthSources/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthSourcesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionInstanceGroupManagerResizeRequestsService(base_api.BaseApiService):
    """Service class for the regionInstanceGroupManagerResizeRequests resource."""

    _NAME = 'regionInstanceGroupManagerResizeRequests'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstanceGroupManagerResizeRequestsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified resize request. Cancelled resize request no longer waits for the resources to be provisioned. Cancel is only possible for requests that are in accepted state.

      Args:
        request: (ComputeRegionInstanceGroupManagerResizeRequestsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagerResizeRequests.cancel',
        ordered_params=['project', 'region', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'region', 'resizeRequest'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}/cancel',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagerResizeRequestsCancelRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified, inactive resize request. Requests that are still active cannot be deleted. Deleting request does not delete instances that were provisioned previously.

      Args:
        request: (ComputeRegionInstanceGroupManagerResizeRequestsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstanceGroupManagerResizeRequests.delete',
        ordered_params=['project', 'region', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'region', 'resizeRequest'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagerResizeRequestsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified resize request.

      Args:
        request: (ComputeRegionInstanceGroupManagerResizeRequestsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerResizeRequest) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagerResizeRequests.get',
        ordered_params=['project', 'region', 'instanceGroupManager', 'resizeRequest'],
        path_params=['instanceGroupManager', 'project', 'region', 'resizeRequest'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagerResizeRequestsGetRequest',
        response_type_name='InstanceGroupManagerResizeRequest',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new Resize Request that starts provisioning VMs immediately or queues VM creation.

      Args:
        request: (ComputeRegionInstanceGroupManagerResizeRequestsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagerResizeRequests.insert',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests',
        request_field='instanceGroupManagerResizeRequest',
        request_type_name='ComputeRegionInstanceGroupManagerResizeRequestsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Resize Requests that are contained in the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagerResizeRequestsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagerResizeRequestsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagerResizeRequests.list',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagerResizeRequestsListRequest',
        response_type_name='RegionInstanceGroupManagerResizeRequestsListResponse',
        supports_download=False,
    )

  class RegionInstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the regionInstanceGroupManagers resource."""

    _NAME = 'regionInstanceGroupManagers'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be immediately removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.abandonInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field='regionInstanceGroupManagersAbandonInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersAbandonInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Apply updates to selected instances the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.applyUpdatesToInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field='regionInstanceGroupManagersApplyUpdatesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateInstances(self, request, global_params=None):
      r"""Creates instances with per-instance configurations in this regional managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.

      Args:
        request: (ComputeRegionInstanceGroupManagersCreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.createInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/createInstances',
        request_field='regionInstanceGroupManagersCreateInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersCreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstanceGroupManagers.delete',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately deleted. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. The deleteInstances operation is marked DONE if the deleteInstances request is successful. The underlying actions take additional time. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.deleteInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field='regionInstanceGroupManagersDeleteInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersDeleteInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeletePerInstanceConfigs(self, request, global_params=None):
      r"""Deletes selected per-instance configurations for the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeletePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeletePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.deletePerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs',
        request_field='regionInstanceGroupManagerDeleteInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.get',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersGetRequest',
        response_type_name='InstanceGroupManager',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A regional managed instance group can contain up to 2000 instances.

      Args:
        request: (ComputeRegionInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers',
        request_field='instanceGroupManager',
        request_type_name='ComputeRegionInstanceGroupManagersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups that are contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListRequest',
        response_type_name='RegionInstanceGroupManagerList',
        supports_download=False,
    )

    def ListErrors(self, request, global_params=None):
      r"""Lists all errors thrown by actions on instances for a given regional managed instance group. The filter and orderBy query parameters are not supported.

      Args:
        request: (ComputeRegionInstanceGroupManagersListErrorsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListErrorsResponse) The response message.
      """
      config = self.GetMethodConfig('ListErrors')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListErrors.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.listErrors',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listErrors',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListErrorsRequest',
        response_type_name='RegionInstanceGroupManagersListErrorsResponse',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists the instances in the managed instance group and instances that are scheduled to be created. The list includes any current actions that the group has scheduled for its instances. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.

      Args:
        request: (ComputeRegionInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.listManagedInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListManagedInstancesRequest',
        response_type_name='RegionInstanceGroupManagersListInstancesResponse',
        supports_download=False,
    )

    def ListPerInstanceConfigs(self, request, global_params=None):
      r"""Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.

      Args:
        request: (ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListInstanceConfigsResp) The response message.
      """
      config = self.GetMethodConfig('ListPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.listPerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest',
        response_type_name='RegionInstanceGroupManagersListInstanceConfigsResp',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listmanagedinstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeRegionInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionInstanceGroupManagers.patch',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeRegionInstanceGroupManagersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.patchPerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs',
        request_field='regionInstanceGroupManagerPatchInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.recreateInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field='regionInstanceGroupManagersRecreateRequest',
        request_type_name='ComputeRegionInstanceGroupManagersRecreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Changes the intended size of the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeRegionInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.resize',
        ordered_params=['project', 'region', 'instanceGroupManager', 'size'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId', 'size'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResizeAdvanced(self, request, global_params=None):
      r"""Resizes the regional managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeRegionInstanceGroupManagersResizeAdvancedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResizeAdvanced')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResizeAdvanced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.resizeAdvanced',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced',
        request_field='regionInstanceGroupManagersResizeAdvancedRequest',
        request_type_name='ComputeRegionInstanceGroupManagersResizeAdvancedRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResumeInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be resumed. This method increases the targetSize and decreases the targetSuspendedSize of the managed instance group by the number of instances that you resume. The resumeInstances operation is marked DONE if the resumeInstances request is successful. The underlying actions take additional time. You must separately verify the status of the RESUMING action with the listmanagedinstances method. In this request, you can only specify instances that are suspended. For example, if an instance was previously suspended using the suspendInstances method, it can be resumed using the resumeInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are resumed. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersResumeInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResumeInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResumeInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.resumeInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resumeInstances',
        request_field='regionInstanceGroupManagersResumeInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersResumeInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Modifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use regionInstanceGroupManagers.patch instead.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setAutoHealingPolicies',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field='regionInstanceGroupManagersSetAutoHealingRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Sets the instance template to use when creating new instances or recreating instances in this group. Existing instances are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setInstanceTemplate',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field='regionInstanceGroupManagersSetTemplateRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all new instances in this group are assigned. Existing instances in the group are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setTargetPools',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field='regionInstanceGroupManagersSetTargetPoolsRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be started. This method increases the targetSize and decreases the targetStoppedSize of the managed instance group by the number of instances that you start. The startInstances operation is marked DONE if the startInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STARTING action with the listmanagedinstances method. In this request, you can only specify instances that are stopped. For example, if an instance was previously stopped using the stopInstances method, it can be started using the startInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are started. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersStartInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.startInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/startInstances',
        request_field='regionInstanceGroupManagersStartInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersStartInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StopInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately stopped. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetStoppedSize of the managed instance group by the number of instances that you stop. The stopInstances operation is marked DONE if the stopInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STOPPING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays stopping the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is stopped. Stopped instances can be started using the startInstances method. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersStopInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.stopInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/stopInstances',
        request_field='regionInstanceGroupManagersStopInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersStopInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SuspendInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately suspended. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetSuspendedSize of the managed instance group by the number of instances that you suspend. The suspendInstances operation is marked DONE if the suspendInstances request is successful. The underlying actions take additional time. You must separately verify the status of the SUSPENDING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays suspension of the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is suspended. Suspended instances can be resumed using the resumeInstances method. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersSuspendInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SuspendInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    SuspendInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.suspendInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/suspendInstances',
        request_field='regionInstanceGroupManagersSuspendInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSuspendInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listmanagedinstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeRegionInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionInstanceGroupManagers.update',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeRegionInstanceGroupManagersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdatePerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.updatePerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs',
        request_field='regionInstanceGroupManagerUpdateInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionInstanceGroupsService(base_api.BaseApiService):
    """Service class for the regionInstanceGroups resource."""

    _NAME = 'regionInstanceGroups'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified instance group resource.

      Args:
        request: (ComputeRegionInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroups.get',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupsGetRequest',
        response_type_name='InstanceGroup',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instance group resources contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroups.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroups',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupsListRequest',
        response_type_name='RegionInstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group and displays information about the named ports. Depending on the specified options, this method can list all instances or only the instances that are running. The orderBy query parameter is not supported.

      Args:
        request: (ComputeRegionInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.listInstances',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/listInstances',
        request_field='regionInstanceGroupsListInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupsListInstancesRequest',
        response_type_name='RegionInstanceGroupsListInstances',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified regional instance group.

      Args:
        request: (ComputeRegionInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.setNamedPorts',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field='regionInstanceGroupsSetNamedPortsRequest',
        request_type_name='ComputeRegionInstanceGroupsSetNamedPortsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstanceGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionInstanceTemplatesService(base_api.BaseApiService):
    """Service class for the regionInstanceTemplates resource."""

    _NAME = 'regionInstanceTemplates'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstanceTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone.

      Args:
        request: (ComputeRegionInstanceTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstanceTemplates.delete',
        ordered_params=['project', 'region', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeRegionInstanceTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified instance template.

      Args:
        request: (ComputeRegionInstanceTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceTemplates.get',
        ordered_params=['project', 'region', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project', 'region'],
        query_params=['view'],
        relative_path='projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeRegionInstanceTemplatesGetRequest',
        response_type_name='InstanceTemplate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance template in the specified project and region using the global instance template whose URL is included in the request.

      Args:
        request: (ComputeRegionInstanceTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceTemplates.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceTemplates',
        request_field='instanceTemplate',
        request_type_name='ComputeRegionInstanceTemplatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of instance templates that are contained within the specified project and region.

      Args:
        request: (ComputeRegionInstanceTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceTemplates.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'view'],
        relative_path='projects/{project}/regions/{region}/instanceTemplates',
        request_field='',
        request_type_name='ComputeRegionInstanceTemplatesListRequest',
        response_type_name='InstanceTemplateList',
        supports_download=False,
    )

  class RegionInstancesService(base_api.BaseApiService):
    """Service class for the regionInstances resource."""

    _NAME = 'regionInstances'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def BulkInsert(self, request, global_params=None):
      r"""Creates multiple instances in a given region. Count specifies the number of instances to create.

      Args:
        request: (ComputeRegionInstancesBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstances.bulkInsert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instances/bulkInsert',
        request_field='bulkInsertInstanceResource',
        request_type_name='ComputeRegionInstancesBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionInstantSnapshotGroupsService(base_api.BaseApiService):
    """Service class for the regionInstantSnapshotGroups resource."""

    _NAME = 'regionInstantSnapshotGroups'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstantSnapshotGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""deletes a Regional InstantSnapshotGroup resource.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstantSnapshotGroups.delete',
        ordered_params=['project', 'region', 'instantSnapshotGroup'],
        path_params=['instantSnapshotGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups/{instantSnapshotGroup}',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""returns the specified InstantSnapshotGroup resource in the specified region.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshotGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshotGroups.get',
        ordered_params=['project', 'region', 'instantSnapshotGroup'],
        path_params=['instantSnapshotGroup', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups/{instantSnapshotGroup}',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotGroupsGetRequest',
        response_type_name='InstantSnapshotGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshotGroups.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""creates a Regional InstantSnapshotGroup resource.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshotGroups.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'sourceConsistencyGroup'],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups',
        request_field='instantSnapshotGroup',
        request_type_name='ComputeRegionInstantSnapshotGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""retrieves the list of InstantSnapshotGroup resources contained within the specified region.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstantSnapshotGroups) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshotGroups.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotGroupsListRequest',
        response_type_name='ListInstantSnapshotGroups',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshotGroups.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionInstantSnapshotGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstantSnapshotGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshotGroups.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstantSnapshotGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionInstantSnapshotsService(base_api.BaseApiService):
    """Service class for the regionInstantSnapshots resource."""

    _NAME = 'regionInstantSnapshots'

    def __init__(self, client):
      super(ComputeAlpha.RegionInstantSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.

      Args:
        request: (ComputeRegionInstantSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstantSnapshots.delete',
        ordered_params=['project', 'region', 'instantSnapshot'],
        path_params=['instantSnapshot', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified InstantSnapshot resource in the specified region.

      Args:
        request: (ComputeRegionInstantSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshots.get',
        ordered_params=['project', 'region', 'instantSnapshot'],
        path_params=['instantSnapshot', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotsGetRequest',
        response_type_name='InstantSnapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionInstantSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshots.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instant snapshot in the specified region.

      Args:
        request: (ComputeRegionInstantSnapshotsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshots.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instantSnapshots',
        request_field='instantSnapshot',
        request_type_name='ComputeRegionInstantSnapshotsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of InstantSnapshot resources contained within the specified region.

      Args:
        request: (ComputeRegionInstantSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstantSnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstantSnapshots.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instantSnapshots',
        request_field='',
        request_type_name='ComputeRegionInstantSnapshotsListRequest',
        response_type_name='InstantSnapshotList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionInstantSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshots.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionInstantSnapshotsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a instantSnapshot in the given region. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeRegionInstantSnapshotsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshots.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeRegionInstantSnapshotsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstantSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstantSnapshots.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instantSnapshots/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstantSnapshotsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionMultiMigMembersService(base_api.BaseApiService):
    """Service class for the regionMultiMigMembers resource."""

    _NAME = 'regionMultiMigMembers'

    def __init__(self, client):
      super(ComputeAlpha.RegionMultiMigMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieves information about the specified multi-MIG member.

      Args:
        request: (ComputeRegionMultiMigMembersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MultiMigMember) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionMultiMigMembers.get',
        ordered_params=['project', 'region', 'multiMig', 'multiMigMember'],
        path_params=['multiMig', 'multiMigMember', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/multiMigs/{multiMig}/multiMigMembers/{multiMigMember}',
        request_field='',
        request_type_name='ComputeRegionMultiMigMembersGetRequest',
        response_type_name='MultiMigMember',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of members of a specific multi-MIG.

      Args:
        request: (ComputeRegionMultiMigMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MultiMigMemberList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionMultiMigMembers.list',
        ordered_params=['project', 'region', 'multiMig'],
        path_params=['multiMig', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/multiMigs/{multiMig}/multiMigMembers',
        request_field='',
        request_type_name='ComputeRegionMultiMigMembersListRequest',
        response_type_name='MultiMigMemberList',
        supports_download=False,
    )

  class RegionMultiMigsService(base_api.BaseApiService):
    """Service class for the regionMultiMigs resource."""

    _NAME = 'regionMultiMigs'

    def __init__(self, client):
      super(ComputeAlpha.RegionMultiMigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a multi-MIG in the specified project.

      Args:
        request: (ComputeRegionMultiMigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionMultiMigs.delete',
        ordered_params=['project', 'region', 'multiMig'],
        path_params=['multiMig', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/multiMigs/{multiMig}',
        request_field='',
        request_type_name='ComputeRegionMultiMigsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all the details of a specific multi-MIG.

      Args:
        request: (ComputeRegionMultiMigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MultiMig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionMultiMigs.get',
        ordered_params=['project', 'region', 'multiMig'],
        path_params=['multiMig', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/multiMigs/{multiMig}',
        request_field='',
        request_type_name='ComputeRegionMultiMigsGetRequest',
        response_type_name='MultiMig',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a multi-MIG in the specified project.

      Args:
        request: (ComputeRegionMultiMigsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionMultiMigs.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/multiMigs',
        request_field='multiMig',
        request_type_name='ComputeRegionMultiMigsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of multi-MIGs in a project and region.

      Args:
        request: (ComputeRegionMultiMigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MultiMigsList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionMultiMigs.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/multiMigs',
        request_field='',
        request_type_name='ComputeRegionMultiMigsListRequest',
        response_type_name='MultiMigsList',
        supports_download=False,
    )

  class RegionNetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the regionNetworkEndpointGroups resource."""

    _NAME = 'regionNetworkEndpointGroups'

    def __init__(self, client):
      super(ComputeAlpha.RegionNetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a list of network endpoints to the specified network endpoint group.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkEndpointGroups.attachNetworkEndpoints',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field='regionNetworkEndpointGroupsAttachEndpointsRequest',
        request_type_name='ComputeRegionNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group. Note that the NEG cannot be deleted if it is configured as a backend of a backend service.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNetworkEndpointGroups.delete',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach the network endpoint from the specified network endpoint group.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkEndpointGroups.detachNetworkEndpoints',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field='regionNetworkEndpointGroupsDetachEndpointsRequest',
        request_type_name='ComputeRegionNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkEndpointGroups.get',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkEndpointGroups.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeRegionNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of regional network endpoint groups available to the specified project in the given region.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkEndpointGroups.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkEndpointGroups.listNetworkEndpoints',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name='NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

  class RegionNetworkFirewallPoliciesService(base_api.BaseApiService):
    """Service class for the regionNetworkFirewallPolicies resource."""

    _NAME = 'regionNetworkFirewallPolicies'

    def __init__(self, client):
      super(ComputeAlpha.RegionNetworkFirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.addAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['associatedPolicyToBeReplaced', 'replaceExistingAssociation', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeRegionNetworkFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.addRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['maxPriority', 'minPriority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeRegionNetworkFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.cloneRules',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNetworkFirewallPolicies.delete',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.get',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['name'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns the effective firewalls on a given network.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getEffectiveFirewalls',
        ordered_params=['project', 'region', 'network'],
        path_params=['project', 'region'],
        query_params=['network'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetEffectiveFirewallsRequest',
        response_type_name='RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new network firewall policy in the specified project and region.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeRegionNetworkFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the network firewall policies that have been configured for the specified project in the given region.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionNetworkFirewallPolicies.patch',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeRegionNetworkFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchAssociation(self, request, global_params=None):
      r"""Updates an association for the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesPatchAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.patchAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeRegionNetworkFirewallPoliciesPatchAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.patchRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeRegionNetworkFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.removeAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['name', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.removeRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionNetworkFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionNetworkFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionNetworkPoliciesService(base_api.BaseApiService):
    """Service class for the regionNetworkPolicies resource."""

    _NAME = 'regionNetworkPolicies'

    def __init__(self, client):
      super(ComputeAlpha.RegionNetworkPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified network policy.

      Args:
        request: (ComputeRegionNetworkPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.addAssociation',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/addAssociation',
        request_field='networkPolicyAssociation',
        request_type_name='ComputeRegionNetworkPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddTrafficClassificationRule(self, request, global_params=None):
      r"""Inserts a rule into a network policy.

      Args:
        request: (ComputeRegionNetworkPoliciesAddTrafficClassificationRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddTrafficClassificationRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddTrafficClassificationRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.addTrafficClassificationRule',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/addTrafficClassificationRule',
        request_field='networkPolicyTrafficClassificationRule',
        request_type_name='ComputeRegionNetworkPoliciesAddTrafficClassificationRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of network policies. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.

      Args:
        request: (ComputeRegionNetworkPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPolicyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/networkPolicies',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesAggregatedListRequest',
        response_type_name='NetworkPolicyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeRegionNetworkPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNetworkPolicies.delete',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network policy.

      Args:
        request: (ComputeRegionNetworkPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkPolicies.get',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesGetRequest',
        response_type_name='NetworkPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeRegionNetworkPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkPolicies.getAssociation',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['name'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesGetAssociationRequest',
        response_type_name='NetworkPolicyAssociation',
        supports_download=False,
    )

    def GetTrafficClassificationRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkPoliciesGetTrafficClassificationRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPolicyTrafficClassificationRule) The response message.
      """
      config = self.GetMethodConfig('GetTrafficClassificationRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetTrafficClassificationRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkPolicies.getTrafficClassificationRule',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['priority'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/getTrafficClassificationRule',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesGetTrafficClassificationRuleRequest',
        response_type_name='NetworkPolicyTrafficClassificationRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionNetworkPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies',
        request_field='networkPolicy',
        request_type_name='ComputeRegionNetworkPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the policies that have been configured for the specified project in the given region.

      Args:
        request: (ComputeRegionNetworkPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/networkPolicies',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesListRequest',
        response_type_name='NetworkPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeRegionNetworkPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionNetworkPolicies.patch',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}',
        request_field='networkPolicyResource',
        request_type_name='ComputeRegionNetworkPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchTrafficClassificationRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkPoliciesPatchTrafficClassificationRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchTrafficClassificationRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchTrafficClassificationRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.patchTrafficClassificationRule',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/patchTrafficClassificationRule',
        request_field='networkPolicyTrafficClassificationRule',
        request_type_name='ComputeRegionNetworkPoliciesPatchTrafficClassificationRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified network policy.

      Args:
        request: (ComputeRegionNetworkPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.removeAssociation',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['name', 'requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveTrafficClassificationRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkPoliciesRemoveTrafficClassificationRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveTrafficClassificationRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveTrafficClassificationRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkPolicies.removeTrafficClassificationRule',
        ordered_params=['project', 'region', 'networkPolicy'],
        path_params=['networkPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/removeTrafficClassificationRule',
        request_field='',
        request_type_name='ComputeRegionNetworkPoliciesRemoveTrafficClassificationRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionNotificationEndpointsService(base_api.BaseApiService):
    """Service class for the regionNotificationEndpoints resource."""

    _NAME = 'regionNotificationEndpoints'

    def __init__(self, client):
      super(ComputeAlpha.RegionNotificationEndpointsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all NotificationEndpoint resources, regional and global, available to the specified project.

      Args:
        request: (ComputeRegionNotificationEndpointsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationEndpointAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNotificationEndpoints.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProjectNumber'],
        relative_path='projects/{project}/aggregated/notificationEndpoints',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsAggregatedListRequest',
        response_type_name='NotificationEndpointAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NotificationEndpoint in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNotificationEndpoints.delete',
        ordered_params=['project', 'region', 'notificationEndpoint'],
        path_params=['notificationEndpoint', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NotificationEndpoint resource in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationEndpoint) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNotificationEndpoints.get',
        ordered_params=['project', 'region', 'notificationEndpoint'],
        path_params=['notificationEndpoint', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsGetRequest',
        response_type_name='NotificationEndpoint',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a NotificationEndpoint in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputeRegionNotificationEndpointsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNotificationEndpoints.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints',
        request_field='notificationEndpoint',
        request_type_name='ComputeRegionNotificationEndpointsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the NotificationEndpoints for a project in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationEndpointList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNotificationEndpoints.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsListRequest',
        response_type_name='NotificationEndpointList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionNotificationEndpointsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNotificationEndpoints.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionNotificationEndpointsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionOperationsService(base_api.BaseApiService):
    """Service class for the regionOperations resource."""

    _NAME = 'regionOperations'

    def __init__(self, client):
      super(ComputeAlpha.RegionOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeRegionOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionOperations.delete',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name='ComputeRegionOperationsDeleteRequest',
        response_type_name='ComputeRegionOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionOperations.get',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name='ComputeRegionOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified region.

      Args:
        request: (ComputeRegionOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionOperations.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/operations',
        request_field='',
        request_type_name='ComputeRegionOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

    def Wait(self, request, global_params=None):
      r"""Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. .

      Args:
        request: (ComputeRegionOperationsWaitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wait')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wait.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionOperations.wait',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}/wait',
        request_field='',
        request_type_name='ComputeRegionOperationsWaitRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSecurityPoliciesService(base_api.BaseApiService):
    """Service class for the regionSecurityPolicies resource."""

    _NAME = 'regionSecurityPolicies'

    def __init__(self, client):
      super(ComputeAlpha.RegionSecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a security policy.

      Args:
        request: (ComputeRegionSecurityPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.addRule',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['validateOnly'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/addRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeRegionSecurityPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeRegionSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSecurityPolicies.delete',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeRegionSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSecurityPolicies.get',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesGetRequest',
        response_type_name='SecurityPolicy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule at the specified priority.

      Args:
        request: (ComputeRegionSecurityPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSecurityPolicies.getRule',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['priority'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/getRule',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesGetRuleRequest',
        response_type_name='SecurityPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/securityPolicies',
        request_field='securityPolicy',
        request_type_name='ComputeRegionSecurityPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project and region.

      Args:
        request: (ComputeRegionSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSecurityPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/securityPolicies',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesListRequest',
        response_type_name='SecurityPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request. To clear fields in the policy, leave the fields empty and specify them in the updateMask. This cannot be used to be update the rules in the policy. Please use the per rule methods like addRule, patchRule, and removeRule instead.

      Args:
        request: (ComputeRegionSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionSecurityPolicies.patch',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='securityPolicyResource',
        request_type_name='ComputeRegionSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule at the specified priority. To clear fields in the rule, leave the fields empty and specify them in the updateMask.

      Args:
        request: (ComputeRegionSecurityPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.patchRule',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['priority', 'updateMask', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/patchRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeRegionSecurityPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule at the specified priority.

      Args:
        request: (ComputeRegionSecurityPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.removeRule',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['priority'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a security policy. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeRegionSecurityPoliciesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeRegionSecurityPoliciesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSnapshotSettingsService(base_api.BaseApiService):
    """Service class for the regionSnapshotSettings resource."""

    _NAME = 'regionSnapshotSettings'

    def __init__(self, client):
      super(ComputeAlpha.RegionSnapshotSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get region snapshot settings.

      Args:
        request: (ComputeRegionSnapshotSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotSettings) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSnapshotSettings.get',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/snapshotSettings',
        request_field='',
        request_type_name='ComputeRegionSnapshotSettingsGetRequest',
        response_type_name='SnapshotSettings',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patch region snapshot settings.

      Args:
        request: (ComputeRegionSnapshotSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionSnapshotSettings.patch',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/snapshotSettings',
        request_field='snapshotSettings',
        request_type_name='ComputeRegionSnapshotSettingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSnapshotsService(base_api.BaseApiService):
    """Service class for the regionSnapshots resource."""

    _NAME = 'regionSnapshots'

    def __init__(self, client):
      super(ComputeAlpha.RegionSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Snapshot resource. Keep in mind that deleting a single snapshot might not necessarily delete all the data on that snapshot. If any data on the snapshot that is marked for deletion is needed for subsequent snapshots, the data will be moved to the next corresponding snapshot. For more information, see Deleting snapshots.

      Args:
        request: (ComputeRegionSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSnapshots.delete',
        ordered_params=['project', 'region', 'snapshot'],
        path_params=['project', 'region', 'snapshot'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/snapshots/{snapshot}',
        request_field='',
        request_type_name='ComputeRegionSnapshotsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Snapshot resource.

      Args:
        request: (ComputeRegionSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSnapshots.get',
        ordered_params=['project', 'region', 'snapshot'],
        path_params=['project', 'region', 'snapshot'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/snapshots/{snapshot}',
        request_field='',
        request_type_name='ComputeRegionSnapshotsGetRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSnapshots.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/snapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionSnapshotsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a snapshot in the specified region using the data included in the request.

      Args:
        request: (ComputeRegionSnapshotsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSnapshots.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/snapshots',
        request_field='snapshot',
        request_type_name='ComputeRegionSnapshotsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Snapshot resources contained within the specified region.

      Args:
        request: (ComputeRegionSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSnapshots.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/snapshots',
        request_field='',
        request_type_name='ComputeRegionSnapshotsListRequest',
        response_type_name='SnapshotList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSnapshots.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/snapshots/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionSnapshotsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a regional snapshot. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeRegionSnapshotsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSnapshots.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/snapshots/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeRegionSnapshotsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSnapshots.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/snapshots/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionSnapshotsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def UpdateKmsKey(self, request, global_params=None):
      r"""Rotates the customer-managed encryption key to the latest version for the specified snapshot.

      Args:
        request: (ComputeRegionSnapshotsUpdateKmsKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateKmsKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateKmsKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSnapshots.updateKmsKey',
        ordered_params=['project', 'region', 'snapshot'],
        path_params=['project', 'region', 'snapshot'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/snapshots/{snapshot}/updateKmsKey',
        request_field='',
        request_type_name='ComputeRegionSnapshotsUpdateKmsKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSslCertificatesService(base_api.BaseApiService):
    """Service class for the regionSslCertificates resource."""

    _NAME = 'regionSslCertificates'

    def __init__(self, client):
      super(ComputeAlpha.RegionSslCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SslCertificate resource in the region.

      Args:
        request: (ComputeRegionSslCertificatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSslCertificates.delete',
        ordered_params=['project', 'region', 'sslCertificate'],
        path_params=['project', 'region', 'sslCertificate'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified SslCertificate resource in the specified region. Get a list of available SSL certificates by making a list() request.

      Args:
        request: (ComputeRegionSslCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslCertificates.get',
        ordered_params=['project', 'region', 'sslCertificate'],
        path_params=['project', 'region', 'sslCertificate'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesGetRequest',
        response_type_name='SslCertificate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a SslCertificate resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionSslCertificatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslCertificates.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslCertificates',
        request_field='sslCertificate',
        request_type_name='ComputeRegionSslCertificatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of SslCertificate resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionSslCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslCertificates.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslCertificates',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesListRequest',
        response_type_name='SslCertificateList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource and region.

      Args:
        request: (ComputeRegionSslCertificatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslCertificates.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionSslCertificatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionSslPoliciesService(base_api.BaseApiService):
    """Service class for the regionSslPolicies resource."""

    _NAME = 'regionSslPolicies'

    def __init__(self, client):
      super(ComputeAlpha.RegionSslPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.

      Args:
        request: (ComputeRegionSslPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSslPolicies.delete',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Lists all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeRegionSslPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.get',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesGetRequest',
        response_type_name='SslPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionSslPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies',
        request_field='sslPolicy',
        request_type_name='ComputeRegionSslPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the SSL policies that have been configured for the specified project and region.

      Args:
        request: (ComputeRegionSslPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslPolicies',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesListRequest',
        response_type_name='SslPoliciesList',
        supports_download=False,
    )

    def ListAvailableFeatures(self, request, global_params=None):
      r"""Lists all features that can be specified in the SSL policy when using custom profile.

      Args:
        request: (ComputeRegionSslPoliciesListAvailableFeaturesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesListAvailableFeaturesResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableFeatures')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableFeatures.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.listAvailableFeatures',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/listAvailableFeatures',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesListAvailableFeaturesRequest',
        response_type_name='SslPoliciesListAvailableFeaturesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified SSL policy with the data included in the request.

      Args:
        request: (ComputeRegionSslPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionSslPolicies.patch',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='sslPolicyResource',
        request_type_name='ComputeRegionSslPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionSslPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslPolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionSslPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetHttpProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpProxies resource."""

    _NAME = 'regionTargetHttpProxies'

    def __init__(self, client):
      super(ComputeAlpha.RegionTargetHttpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpProxy resource.

      Args:
        request: (ComputeRegionTargetHttpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetHttpProxies.delete',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpProxy resource in the specified region.

      Args:
        request: (ComputeRegionTargetHttpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpProxies.get',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesGetRequest',
        response_type_name='TargetHttpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies',
        request_field='targetHttpProxy',
        request_type_name='ComputeRegionTargetHttpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesListRequest',
        response_type_name='TargetHttpProxyList',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpProxy.

      Args:
        request: (ComputeRegionTargetHttpProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.setUrlMap',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeRegionTargetHttpProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetHttpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetHttpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetHttpsProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpsProxies resource."""

    _NAME = 'regionTargetHttpsProxies'

    def __init__(self, client):
      super(ComputeAlpha.RegionTargetHttpsProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpsProxy resource.

      Args:
        request: (ComputeRegionTargetHttpsProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetHttpsProxies.delete',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpsProxy resource in the specified region.

      Args:
        request: (ComputeRegionTargetHttpsProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpsProxies.get',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesGetRequest',
        response_type_name='TargetHttpsProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpsProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpsProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies',
        request_field='targetHttpsProxy',
        request_type_name='ComputeRegionTargetHttpsProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpsProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpsProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpsProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesListRequest',
        response_type_name='TargetHttpsProxyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified regional TargetHttpsProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionTargetHttpsProxiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionTargetHttpsProxies.patch',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='targetHttpsProxyResource',
        request_type_name='ComputeRegionTargetHttpsProxiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Replaces SslCertificates for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.setSslCertificates',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates',
        request_field='regionTargetHttpsProxiesSetSslCertificatesRequest',
        request_type_name='ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.setUrlMap',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeRegionTargetHttpsProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetHttpsProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetHttpsProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetTcpProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetTcpProxies resource."""

    _NAME = 'regionTargetTcpProxies'

    def __init__(self, client):
      super(ComputeAlpha.RegionTargetTcpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetTcpProxy resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetTcpProxies.delete',
        ordered_params=['project', 'region', 'targetTcpProxy'],
        path_params=['project', 'region', 'targetTcpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetTcpProxy resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetTcpProxies.get',
        ordered_params=['project', 'region', 'targetTcpProxy'],
        path_params=['project', 'region', 'targetTcpProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesGetRequest',
        response_type_name='TargetTcpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetTcpProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetTcpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetTcpProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies',
        request_field='targetTcpProxy',
        request_type_name='ComputeRegionTargetTcpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of TargetTcpProxy resources available to the specified project in a given region.

      Args:
        request: (ComputeRegionTargetTcpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetTcpProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesListRequest',
        response_type_name='TargetTcpProxyList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetTcpProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetTcpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionUrlMapsService(base_api.BaseApiService):
    """Service class for the regionUrlMaps resource."""

    _NAME = 'regionUrlMaps'

    def __init__(self, client):
      super(ComputeAlpha.RegionUrlMapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified UrlMap resource.

      Args:
        request: (ComputeRegionUrlMapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionUrlMaps.delete',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='',
        request_type_name='ComputeRegionUrlMapsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified UrlMap resource.

      Args:
        request: (ComputeRegionUrlMapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMap) The response message.
   