"""Generated message classes for dataform version v1beta1.

Service to develop, version control, and operationalize SQL pipelines in
BigQuery.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dataform'


class Assertion(_messages.Message):
  r"""Represents an assertion upon a SQL query which is required return zero
  rows.

  Fields:
    dependencyTargets: A list of actions that this action depends on.
    disabled: Whether this action is disabled (i.e. should not be run).
    parentAction: The parent action of this assertion. Only set if this
      assertion was automatically generated.
    relationDescriptor: Descriptor for the assertion's automatically-generated
      view and its columns.
    selectQuery: The SELECT query which must return zero rows in order for
      this assertion to succeed.
    tags: Arbitrary, user-defined tags on this action.
  """

  dependencyTargets = _messages.MessageField('Target', 1, repeated=True)
  disabled = _messages.BooleanField(2)
  parentAction = _messages.MessageField('Target', 3)
  relationDescriptor = _messages.MessageField('RelationDescriptor', 4)
  selectQuery = _messages.StringField(5)
  tags = _messages.StringField(6, repeated=True)


class BigQueryAction(_messages.Message):
  r"""Represents a workflow action that will run against BigQuery.

  Fields:
    jobId: Output only. The ID of the BigQuery job that executed the SQL in
      sql_script. Only set once the job has started to run.
    sqlScript: Output only. The generated BigQuery SQL script that will be
      executed.
  """

  jobId = _messages.StringField(1)
  sqlScript = _messages.StringField(2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelWorkflowInvocationRequest(_messages.Message):
  r"""`CancelWorkflowInvocation` request message."""


class CodeCompilationConfig(_messages.Message):
  r"""Configures various aspects of Dataform code compilation.

  Messages:
    VarsValue: Optional. User-defined variables that are made available to
      project code during compilation.

  Fields:
    assertionSchema: Optional. The default schema (BigQuery dataset ID) for
      assertions.
    databaseSuffix: Optional. The suffix that should be appended to all
      database (Google Cloud project ID) names.
    defaultDatabase: Optional. The default database (Google Cloud project ID).
    defaultLocation: Optional. The default BigQuery location to use. Defaults
      to "US". See the BigQuery docs for a full list of locations:
      https://cloud.google.com/bigquery/docs/locations.
    defaultNotebookRuntimeOptions: A NotebookRuntimeOptions attribute.
    defaultSchema: Optional. The default schema (BigQuery dataset ID).
    schemaSuffix: Optional. The suffix that should be appended to all schema
      (BigQuery dataset ID) names.
    tablePrefix: Optional. The prefix that should be prepended to all table
      names.
    vars: Optional. User-defined variables that are made available to project
      code during compilation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VarsValue(_messages.Message):
    r"""Optional. User-defined variables that are made available to project
    code during compilation.

    Messages:
      AdditionalProperty: An additional property for a VarsValue object.

    Fields:
      additionalProperties: Additional properties of type VarsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VarsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assertionSchema = _messages.StringField(1)
  databaseSuffix = _messages.StringField(2)
  defaultDatabase = _messages.StringField(3)
  defaultLocation = _messages.StringField(4)
  defaultNotebookRuntimeOptions = _messages.MessageField('NotebookRuntimeOptions', 5)
  defaultSchema = _messages.StringField(6)
  schemaSuffix = _messages.StringField(7)
  tablePrefix = _messages.StringField(8)
  vars = _messages.MessageField('VarsValue', 9)


class ColumnDescriptor(_messages.Message):
  r"""Describes a column.

  Fields:
    bigqueryPolicyTags: A list of BigQuery policy tags that will be applied to
      the column.
    description: A textual description of the column.
    path: The identifier for the column. Each entry in `path` represents one
      level of nesting.
  """

  bigqueryPolicyTags = _messages.StringField(1, repeated=True)
  description = _messages.StringField(2)
  path = _messages.StringField(3, repeated=True)


class CommitAuthor(_messages.Message):
  r"""Represents the author of a Git commit.

  Fields:
    emailAddress: Required. The commit author's email address.
    name: Required. The commit author's name.
  """

  emailAddress = _messages.StringField(1)
  name = _messages.StringField(2)


class CommitLogEntry(_messages.Message):
  r"""Represents a single commit log.

  Fields:
    author: The commit author for this commit log entry.
    commitMessage: The commit message for this commit log entry.
    commitSha: The commit SHA for this commit log entry.
    commitTime: Commit timestamp.
  """

  author = _messages.MessageField('CommitAuthor', 1)
  commitMessage = _messages.StringField(2)
  commitSha = _messages.StringField(3)
  commitTime = _messages.StringField(4)


class CommitMetadata(_messages.Message):
  r"""Represents a Dataform Git commit.

  Fields:
    author: Required. The commit's author.
    commitMessage: Optional. The commit's message.
  """

  author = _messages.MessageField('CommitAuthor', 1)
  commitMessage = _messages.StringField(2)


class CommitRepositoryChangesRequest(_messages.Message):
  r"""`CommitRepositoryChanges` request message.

  Messages:
    FileOperationsValue: A map to the path of the file to the operation. The
      path is the full file path including filename, from repository root.

  Fields:
    commitMetadata: Required. The changes to commit to the repository.
    fileOperations: A map to the path of the file to the operation. The path
      is the full file path including filename, from repository root.
    requiredHeadCommitSha: Optional. The commit SHA which must be the
      repository's current HEAD before applying this commit; otherwise this
      request will fail. If unset, no validation on the current HEAD commit
      SHA is performed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileOperationsValue(_messages.Message):
    r"""A map to the path of the file to the operation. The path is the full
    file path including filename, from repository root.

    Messages:
      AdditionalProperty: An additional property for a FileOperationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type FileOperationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileOperationsValue object.

      Fields:
        key: Name of the additional property.
        value: A FileOperation attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileOperation', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  commitMetadata = _messages.MessageField('CommitMetadata', 1)
  fileOperations = _messages.MessageField('FileOperationsValue', 2)
  requiredHeadCommitSha = _messages.StringField(3)


class CommitRepositoryChangesResponse(_messages.Message):
  r"""`CommitRepositoryChanges` response message.

  Fields:
    commitSha: The commit SHA of the current commit.
  """

  commitSha = _messages.StringField(1)


class CommitWorkspaceChangesRequest(_messages.Message):
  r"""`CommitWorkspaceChanges` request message.

  Fields:
    author: Required. The commit's author.
    commitMessage: Optional. The commit's message.
    paths: Optional. Full file paths to commit including filename, rooted at
      workspace root. If left empty, all files will be committed.
  """

  author = _messages.MessageField('CommitAuthor', 1)
  commitMessage = _messages.StringField(2)
  paths = _messages.StringField(3, repeated=True)


class CompilationError(_messages.Message):
  r"""An error encountered when attempting to compile a Dataform project.

  Fields:
    actionTarget: Output only. The identifier of the action where this error
      occurred, if available.
    message: Output only. The error's top level message.
    path: Output only. The path of the file where this error occurred, if
      available, relative to the project root.
    stack: Output only. The error's full stack trace.
  """

  actionTarget = _messages.MessageField('Target', 1)
  message = _messages.StringField(2)
  path = _messages.StringField(3)
  stack = _messages.StringField(4)


class CompilationResult(_messages.Message):
  r"""Represents the result of compiling a Dataform project.

  Fields:
    codeCompilationConfig: Immutable. If set, fields of
      `code_compilation_config` override the default compilation settings that
      are specified in dataform.json.
    compilationErrors: Output only. Errors encountered during project
      compilation.
    createTime: Output only. The timestamp of when the compilation result was
      created.
    dataEncryptionState: Output only. Only set if the repository has a KMS
      Key.
    dataformCoreVersion: Output only. The version of `@dataform/core` that was
      used for compilation.
    gitCommitish: Immutable. Git commit/tag/branch name at which the
      repository should be compiled. Must exist in the remote repository.
      Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name:
      `branch1`
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    name: Output only. The compilation result's name.
    releaseConfig: Immutable. The name of the release config to compile. Must
      be in the format
      `projects/*/locations/*/repositories/*/releaseConfigs/*`.
    resolvedGitCommitSha: Output only. The fully resolved Git commit SHA of
      the code that was compiled. Not set for compilation results whose source
      is a workspace.
    workspace: Immutable. The name of the workspace to compile. Must be in the
      format `projects/*/locations/*/repositories/*/workspaces/*`.
  """

  codeCompilationConfig = _messages.MessageField('CodeCompilationConfig', 1)
  compilationErrors = _messages.MessageField('CompilationError', 2, repeated=True)
  createTime = _messages.StringField(3)
  dataEncryptionState = _messages.MessageField('DataEncryptionState', 4)
  dataformCoreVersion = _messages.StringField(5)
  gitCommitish = _messages.StringField(6)
  internalMetadata = _messages.StringField(7)
  name = _messages.StringField(8)
  releaseConfig = _messages.StringField(9)
  resolvedGitCommitSha = _messages.StringField(10)
  workspace = _messages.StringField(11)


class CompilationResultAction(_messages.Message):
  r"""Represents a single Dataform action in a compilation result.

  Fields:
    assertion: The assertion executed by this action.
    canonicalTarget: The action's identifier if the project had been compiled
      without any overrides configured. Unique within the compilation result.
    declaration: The declaration declared by this action.
    filePath: The full path including filename in which this action is
      located, relative to the workspace root.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    notebook: The notebook executed by this action.
    operations: The database operations executed by this action.
    relation: The database relation created/updated by this action.
    target: This action's identifier. Unique within the compilation result.
  """

  assertion = _messages.MessageField('Assertion', 1)
  canonicalTarget = _messages.MessageField('Target', 2)
  declaration = _messages.MessageField('Declaration', 3)
  filePath = _messages.StringField(4)
  internalMetadata = _messages.StringField(5)
  notebook = _messages.MessageField('Notebook', 6)
  operations = _messages.MessageField('Operations', 7)
  relation = _messages.MessageField('Relation', 8)
  target = _messages.MessageField('Target', 9)


class ComputeRepositoryAccessTokenStatusResponse(_messages.Message):
  r"""`ComputeRepositoryAccessTokenStatus` response message.

  Enums:
    TokenStatusValueValuesEnum: Indicates the status of the Git access token.

  Fields:
    tokenStatus: Indicates the status of the Git access token.
  """

  class TokenStatusValueValuesEnum(_messages.Enum):
    r"""Indicates the status of the Git access token.

    Values:
      TOKEN_STATUS_UNSPECIFIED: Default value. This value is unused.
      NOT_FOUND: The token could not be found in Secret Manager (or the
        Dataform Service Account did not have permission to access it).
      INVALID: The token could not be used to authenticate against the Git
        remote.
      VALID: The token was used successfully to authenticate against the Git
        remote.
    """
    TOKEN_STATUS_UNSPECIFIED = 0
    NOT_FOUND = 1
    INVALID = 2
    VALID = 3

  tokenStatus = _messages.EnumField('TokenStatusValueValuesEnum', 1)


class Config(_messages.Message):
  r"""Config for all repositories in a given project and location.

  Fields:
    defaultKmsKeyName: Optional. The default KMS key that is used if no
      encryption key is provided when a repository is created.
    name: Identifier. The config name.
  """

  defaultKmsKeyName = _messages.StringField(1)
  name = _messages.StringField(2)


class DataEncryptionState(_messages.Message):
  r"""Describes encryption state of a resource.

  Fields:
    kmsKeyVersionName: The KMS key version name with which data of a resource
      is encrypted.
  """

  kmsKeyVersionName = _messages.StringField(1)


class DataformProjectsLocationsGetConfigRequest(_messages.Message):
  r"""A DataformProjectsLocationsGetConfigRequest object.

  Fields:
    name: Required. The config name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsListRequest(_messages.Message):
  r"""A DataformProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataformProjectsLocationsRepositoriesCommitRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCommitRequest object.

  Fields:
    commitRepositoryChangesRequest: A CommitRepositoryChangesRequest resource
      to be passed as the request body.
    name: Required. The repository's name.
  """

  commitRepositoryChangesRequest = _messages.MessageField('CommitRepositoryChangesRequest', 1)
  name = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesCompilationResultsCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCompilationResultsCreateRequest
  object.

  Fields:
    compilationResult: A CompilationResult resource to be passed as the
      request body.
    parent: Required. The repository in which to create the compilation
      result. Must be in the format `projects/*/locations/*/repositories/*`.
  """

  compilationResult = _messages.MessageField('CompilationResult', 1)
  parent = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesCompilationResultsGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCompilationResultsGetRequest
  object.

  Fields:
    name: Required. The compilation result's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesCompilationResultsListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCompilationResultsListRequest
  object.

  Fields:
    filter: Optional. Filter for the returned list.
    orderBy: Optional. This field only supports ordering by `name` and
      `create_time`. If unspecified, the server will choose the ordering. If
      specified, the default order is ascending for the `name` field.
    pageSize: Optional. Maximum number of compilation results to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `ListCompilationResults` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListCompilationResults`, with the exception of `page_size`, must match
      the call that provided the page token.
    parent: Required. The repository in which to list compilation results.
      Must be in the format `projects/*/locations/*/repositories/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataformProjectsLocationsRepositoriesCompilationResultsQueryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCompilationResultsQueryRequest
  object.

  Fields:
    filter: Optional. Optional filter for the returned list. Filtering is only
      currently supported on the `file_path` field.
    name: Required. The compilation result's name.
    pageSize: Optional. Maximum number of compilation results to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `QueryCompilationResultActions` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `QueryCompilationResultActions`, with the exception of `page_size`, must
      match the call that provided the page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataformProjectsLocationsRepositoriesComputeAccessTokenStatusRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesComputeAccessTokenStatusRequest
  object.

  Fields:
    name: Required. The repository's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesCreateRequest object.

  Fields:
    parent: Required. The location in which to create the repository. Must be
      in the format `projects/*/locations/*`.
    repository: A Repository resource to be passed as the request body.
    repositoryId: Required. The ID to use for the repository, which will
      become the final component of the repository's resource name.
  """

  parent = _messages.StringField(1, required=True)
  repository = _messages.MessageField('Repository', 2)
  repositoryId = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesDeleteRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesDeleteRequest object.

  Fields:
    force: If set to true, any child resources of this repository will also be
      deleted. (Otherwise, the request will only succeed if the repository has
      no child resources.)
    name: Required. The repository's name.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesFetchHistoryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesFetchHistoryRequest object.

  Fields:
    name: Required. The repository's name.
    pageSize: Optional. Maximum number of commits to return. The server may
      return fewer items than requested. If unspecified, the server will pick
      an appropriate default.
    pageToken: Optional. Page token received from a previous
      `FetchRepositoryHistory` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `FetchRepositoryHistory`, with the exception of `page_size`, must match
      the call that provided the page token.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesFetchRemoteBranchesRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesFetchRemoteBranchesRequest
  object.

  Fields:
    name: Required. The repository's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesGetIamPolicyRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesGetRequest object.

  Fields:
    name: Required. The repository's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesListRequest object.

  Fields:
    filter: Optional. Filter for the returned list.
    orderBy: Optional. This field only supports ordering by `name`. If
      unspecified, the server will choose the ordering. If specified, the
      default order is ascending for the `name` field.
    pageSize: Optional. Maximum number of repositories to return. The server
      may return fewer items than requested. If unspecified, the server will
      pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `ListRepositories` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListRepositories`,
      with the exception of `page_size`, must match the call that provided the
      page token.
    parent: Required. The location in which to list repositories. Must be in
      the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataformProjectsLocationsRepositoriesPatchRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesPatchRequest object.

  Fields:
    name: Identifier. The repository's name.
    repository: A Repository resource to be passed as the request body.
    updateMask: Optional. Specifies the fields to be updated in the
      repository. If left unset, all fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  repository = _messages.MessageField('Repository', 2)
  updateMask = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesQueryDirectoryContentsRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesQueryDirectoryContentsRequest
  object.

  Fields:
    commitSha: Optional. The Commit SHA for the commit to query from. If
      unset, the directory will be queried from HEAD.
    name: Required. The repository's name.
    pageSize: Optional. Maximum number of paths to return. The server may
      return fewer items than requested. If unspecified, the server will pick
      an appropriate default.
    pageToken: Optional. Page token received from a previous
      `QueryRepositoryDirectoryContents` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `QueryRepositoryDirectoryContents`, with the exception of `page_size`,
      must match the call that provided the page token.
    path: Optional. The directory's full path including directory name,
      relative to root. If left unset, the root is used.
  """

  commitSha = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  path = _messages.StringField(5)


class DataformProjectsLocationsRepositoriesReadFileRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReadFileRequest object.

  Fields:
    commitSha: Optional. The commit SHA for the commit to read from. If unset,
      the file will be read from HEAD.
    name: Required. The repository's name.
    path: Required. Full file path to read including filename, from repository
      root.
  """

  commitSha = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  path = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesReleaseConfigsCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReleaseConfigsCreateRequest
  object.

  Fields:
    parent: Required. The repository in which to create the release config.
      Must be in the format `projects/*/locations/*/repositories/*`.
    releaseConfig: A ReleaseConfig resource to be passed as the request body.
    releaseConfigId: Required. The ID to use for the release config, which
      will become the final component of the release config's resource name.
  """

  parent = _messages.StringField(1, required=True)
  releaseConfig = _messages.MessageField('ReleaseConfig', 2)
  releaseConfigId = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesReleaseConfigsDeleteRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReleaseConfigsDeleteRequest
  object.

  Fields:
    name: Required. The release config's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesReleaseConfigsGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReleaseConfigsGetRequest object.

  Fields:
    name: Required. The release config's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesReleaseConfigsListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReleaseConfigsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of release configs to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `ListReleaseConfigs` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListReleaseConfigs`,
      with the exception of `page_size`, must match the call that provided the
      page token.
    parent: Required. The repository in which to list release configs. Must be
      in the format `projects/*/locations/*/repositories/*`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataformProjectsLocationsRepositoriesReleaseConfigsPatchRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesReleaseConfigsPatchRequest
  object.

  Fields:
    name: Identifier. The release config's name.
    releaseConfig: A ReleaseConfig resource to be passed as the request body.
    updateMask: Optional. Specifies the fields to be updated in the release
      config. If left unset, all fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  releaseConfig = _messages.MessageField('ReleaseConfig', 2)
  updateMask = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesSetIamPolicyRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataformProjectsLocationsRepositoriesTestIamPermissionsRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataformProjectsLocationsRepositoriesWorkflowConfigsCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowConfigsCreateRequest
  object.

  Fields:
    parent: Required. The repository in which to create the workflow config.
      Must be in the format `projects/*/locations/*/repositories/*`.
    workflowConfig: A WorkflowConfig resource to be passed as the request
      body.
    workflowConfigId: Required. The ID to use for the workflow config, which
      will become the final component of the workflow config's resource name.
  """

  parent = _messages.StringField(1, required=True)
  workflowConfig = _messages.MessageField('WorkflowConfig', 2)
  workflowConfigId = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesWorkflowConfigsDeleteRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowConfigsDeleteRequest
  object.

  Fields:
    name: Required. The workflow config's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkflowConfigsGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowConfigsGetRequest object.

  Fields:
    name: Required. The workflow config's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkflowConfigsListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowConfigsListRequest
  object.

  Fields:
    pageSize: Optional. Maximum number of workflow configs to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `ListWorkflowConfigs` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListWorkflowConfigs`, with the exception of `page_size`, must match the
      call that provided the page token.
    parent: Required. The repository in which to list workflow configs. Must
      be in the format `projects/*/locations/*/repositories/*`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataformProjectsLocationsRepositoriesWorkflowConfigsPatchRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowConfigsPatchRequest
  object.

  Fields:
    name: Identifier. The workflow config's name.
    updateMask: Optional. Specifies the fields to be updated in the workflow
      config. If left unset, all fields will be updated.
    workflowConfig: A WorkflowConfig resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  workflowConfig = _messages.MessageField('WorkflowConfig', 3)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsCancelRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsCancelRequest
  object.

  Fields:
    cancelWorkflowInvocationRequest: A CancelWorkflowInvocationRequest
      resource to be passed as the request body.
    name: Required. The workflow invocation resource's name.
  """

  cancelWorkflowInvocationRequest = _messages.MessageField('CancelWorkflowInvocationRequest', 1)
  name = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsCreateRequest
  object.

  Fields:
    parent: Required. The repository in which to create the workflow
      invocation. Must be in the format
      `projects/*/locations/*/repositories/*`.
    workflowInvocation: A WorkflowInvocation resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  workflowInvocation = _messages.MessageField('WorkflowInvocation', 2)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsDeleteRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsDeleteRequest
  object.

  Fields:
    name: Required. The workflow invocation resource's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsGetRequest
  object.

  Fields:
    name: Required. The workflow invocation resource's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsListRequest
  object.

  Fields:
    filter: Optional. Filter for the returned list.
    orderBy: Optional. This field only supports ordering by `name`. If
      unspecified, the server will choose the ordering. If specified, the
      default order is ascending for the `name` field.
    pageSize: Optional. Maximum number of workflow invocations to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `ListWorkflowInvocations` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListWorkflowInvocations`, with the exception of `page_size`, must match
      the call that provided the page token.
    parent: Required. The parent resource of the WorkflowInvocation type. Must
      be in the format `projects/*/locations/*/repositories/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataformProjectsLocationsRepositoriesWorkflowInvocationsQueryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkflowInvocationsQueryRequest
  object.

  Fields:
    name: Required. The workflow invocation's name.
    pageSize: Optional. Maximum number of workflow invocations to return. The
      server may return fewer items than requested. If unspecified, the server
      will pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `QueryWorkflowInvocationActions` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `QueryWorkflowInvocationActions`, with the exception of `page_size`,
      must match the call that provided the page token.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesWorkspacesCommitRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesCommitRequest object.

  Fields:
    commitWorkspaceChangesRequest: A CommitWorkspaceChangesRequest resource to
      be passed as the request body.
    name: Required. The workspace's name.
  """

  commitWorkspaceChangesRequest = _messages.MessageField('CommitWorkspaceChangesRequest', 1)
  name = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesCreateRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesCreateRequest object.

  Fields:
    parent: Required. The repository in which to create the workspace. Must be
      in the format `projects/*/locations/*/repositories/*`.
    workspace: A Workspace resource to be passed as the request body.
    workspaceId: Required. The ID to use for the workspace, which will become
      the final component of the workspace's resource name.
  """

  parent = _messages.StringField(1, required=True)
  workspace = _messages.MessageField('Workspace', 2)
  workspaceId = _messages.StringField(3)


class DataformProjectsLocationsRepositoriesWorkspacesDeleteRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesDeleteRequest object.

  Fields:
    name: Required. The workspace resource's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesFetchFileDiffRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesFetchFileDiffRequest
  object.

  Fields:
    path: Required. The file's full path including filename, relative to the
      workspace root.
    workspace: Required. The workspace's name.
  """

  path = _messages.StringField(1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesFetchFileGitStatusesRequest(_messages.Message):
  r"""A
  DataformProjectsLocationsRepositoriesWorkspacesFetchFileGitStatusesRequest
  object.

  Fields:
    name: Required. The workspace's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesFetchGitAheadBehindRequest(_messages.Message):
  r"""A
  DataformProjectsLocationsRepositoriesWorkspacesFetchGitAheadBehindRequest
  object.

  Fields:
    name: Required. The workspace's name.
    remoteBranch: Optional. The name of the branch in the Git remote against
      which this workspace should be compared. If left unset, the repository's
      default branch name will be used.
  """

  name = _messages.StringField(1, required=True)
  remoteBranch = _messages.StringField(2)


class DataformProjectsLocationsRepositoriesWorkspacesGetIamPolicyRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesGetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesGetRequest object.

  Fields:
    name: Required. The workspace's name.
  """

  name = _messages.StringField(1, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesInstallNpmPackagesRequest(_messages.Message):
  r"""A
  DataformProjectsLocationsRepositoriesWorkspacesInstallNpmPackagesRequest
  object.

  Fields:
    installNpmPackagesRequest: A InstallNpmPackagesRequest resource to be
      passed as the request body.
    workspace: Required. The workspace's name.
  """

  installNpmPackagesRequest = _messages.MessageField('InstallNpmPackagesRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesListRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesListRequest object.

  Fields:
    filter: Optional. Filter for the returned list.
    orderBy: Optional. This field only supports ordering by `name`. If
      unspecified, the server will choose the ordering. If specified, the
      default order is ascending for the `name` field.
    pageSize: Optional. Maximum number of workspaces to return. The server may
      return fewer items than requested. If unspecified, the server will pick
      an appropriate default.
    pageToken: Optional. Page token received from a previous `ListWorkspaces`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListWorkspaces`, with the exception of
      `page_size`, must match the call that provided the page token.
    parent: Required. The repository in which to list workspaces. Must be in
      the format `projects/*/locations/*/repositories/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesMakeDirectoryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesMakeDirectoryRequest
  object.

  Fields:
    makeDirectoryRequest: A MakeDirectoryRequest resource to be passed as the
      request body.
    workspace: Required. The workspace's name.
  """

  makeDirectoryRequest = _messages.MessageField('MakeDirectoryRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesMoveDirectoryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesMoveDirectoryRequest
  object.

  Fields:
    moveDirectoryRequest: A MoveDirectoryRequest resource to be passed as the
      request body.
    workspace: Required. The workspace's name.
  """

  moveDirectoryRequest = _messages.MessageField('MoveDirectoryRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesMoveFileRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesMoveFileRequest object.

  Fields:
    moveFileRequest: A MoveFileRequest resource to be passed as the request
      body.
    workspace: Required. The workspace's name.
  """

  moveFileRequest = _messages.MessageField('MoveFileRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesPullRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesPullRequest object.

  Fields:
    name: Required. The workspace's name.
    pullGitCommitsRequest: A PullGitCommitsRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  pullGitCommitsRequest = _messages.MessageField('PullGitCommitsRequest', 2)


class DataformProjectsLocationsRepositoriesWorkspacesPushRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesPushRequest object.

  Fields:
    name: Required. The workspace's name.
    pushGitCommitsRequest: A PushGitCommitsRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  pushGitCommitsRequest = _messages.MessageField('PushGitCommitsRequest', 2)


class DataformProjectsLocationsRepositoriesWorkspacesQueryDirectoryContentsRequest(_messages.Message):
  r"""A
  DataformProjectsLocationsRepositoriesWorkspacesQueryDirectoryContentsRequest
  object.

  Fields:
    pageSize: Optional. Maximum number of paths to return. The server may
      return fewer items than requested. If unspecified, the server will pick
      an appropriate default.
    pageToken: Optional. Page token received from a previous
      `QueryDirectoryContents` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `QueryDirectoryContents`, with the exception of `page_size`, must match
      the call that provided the page token.
    path: Optional. The directory's full path including directory name,
      relative to the workspace root. If left unset, the workspace root is
      used.
    workspace: Required. The workspace's name.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  path = _messages.StringField(3)
  workspace = _messages.StringField(4, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesReadFileRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesReadFileRequest object.

  Fields:
    path: Required. The file's full path including filename, relative to the
      workspace root.
    revision: Optional. The Git revision of the file to return. If left empty,
      the current contents of `path` will be returned.
    workspace: Required. The workspace's name.
  """

  path = _messages.StringField(1)
  revision = _messages.StringField(2)
  workspace = _messages.StringField(3, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesRemoveDirectoryRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesRemoveDirectoryRequest
  object.

  Fields:
    removeDirectoryRequest: A RemoveDirectoryRequest resource to be passed as
      the request body.
    workspace: Required. The workspace's name.
  """

  removeDirectoryRequest = _messages.MessageField('RemoveDirectoryRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesRemoveFileRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesRemoveFileRequest
  object.

  Fields:
    removeFileRequest: A RemoveFileRequest resource to be passed as the
      request body.
    workspace: Required. The workspace's name.
  """

  removeFileRequest = _messages.MessageField('RemoveFileRequest', 1)
  workspace = _messages.StringField(2, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesResetRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesResetRequest object.

  Fields:
    name: Required. The workspace's name.
    resetWorkspaceChangesRequest: A ResetWorkspaceChangesRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  resetWorkspaceChangesRequest = _messages.MessageField('ResetWorkspaceChangesRequest', 2)


class DataformProjectsLocationsRepositoriesWorkspacesSearchFilesRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesSearchFilesRequest
  object.

  Fields:
    filter: Optional. Optional filter for the returned list in filtering
      format. Filtering is only currently supported on the `path` field. See
      https://google.aip.dev/160 for details.
    pageSize: Optional. Maximum number of search results to return. The server
      may return fewer items than requested. If unspecified, the server will
      pick an appropriate default.
    pageToken: Optional. Page token received from a previous
      `SearchFilesRequest` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `SearchFilesRequest`,
      with the exception of `page_size`, must match the call that provided the
      page token.
    workspace: Required. The workspace's name.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  workspace = _messages.StringField(4, required=True)


class DataformProjectsLocationsRepositoriesWorkspacesSetIamPolicyRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataformProjectsLocationsRepositoriesWorkspacesTestIamPermissionsRequest(_messages.Message):
  r"""A
  DataformProjectsLocationsRepositoriesWorkspacesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataformProjectsLocationsRepositoriesWorkspacesWriteFileRequest(_messages.Message):
  r"""A DataformProjectsLocationsRepositoriesWorkspacesWriteFileRequest
  object.

  Fields:
    workspace: Required. The workspace's name.
    writeFileRequest: A WriteFileRequest resource to be passed as the request
      body.
  """

  workspace = _messages.StringField(1, required=True)
  writeFileRequest = _messages.MessageField('WriteFileRequest', 2)


class DataformProjectsLocationsUpdateConfigRequest(_messages.Message):
  r"""A DataformProjectsLocationsUpdateConfigRequest object.

  Fields:
    config: A Config resource to be passed as the request body.
    name: Identifier. The config name.
    updateMask: Optional. Specifies the fields to be updated in the config.
  """

  config = _messages.MessageField('Config', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class Declaration(_messages.Message):
  r"""Represents a relation which is not managed by Dataform but which may be
  referenced by Dataform actions.

  Fields:
    relationDescriptor: Descriptor for the relation and its columns. Used as
      documentation only, i.e. values here will result in no changes to the
      relation's metadata.
  """

  relationDescriptor = _messages.MessageField('RelationDescriptor', 1)


class DeleteFile(_messages.Message):
  r"""Represents the delete file operation."""


class DirectoryEntry(_messages.Message):
  r"""Represents a single entry in a directory.

  Fields:
    directory: A child directory in the directory.
    file: A file in the directory.
  """

  directory = _messages.StringField(1)
  file = _messages.StringField(2)


class DirectorySearchResult(_messages.Message):
  r"""Client-facing representation of a directory entry in search results.

  Fields:
    path: File system path relative to the workspace root.
  """

  path = _messages.StringField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FetchFileDiffResponse(_messages.Message):
  r"""`FetchFileDiff` response message.

  Fields:
    formattedDiff: The raw formatted Git diff for the file.
  """

  formattedDiff = _messages.StringField(1)


class FetchFileGitStatusesResponse(_messages.Message):
  r"""`FetchFileGitStatuses` response message.

  Fields:
    uncommittedFileChanges: A list of all files which have uncommitted Git
      changes. There will only be a single entry for any given file.
  """

  uncommittedFileChanges = _messages.MessageField('UncommittedFileChange', 1, repeated=True)


class FetchGitAheadBehindResponse(_messages.Message):
  r"""`FetchGitAheadBehind` response message.

  Fields:
    commitsAhead: The number of commits in the remote branch that are not in
      the workspace.
    commitsBehind: The number of commits in the workspace that are not in the
      remote branch.
  """

  commitsAhead = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  commitsBehind = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class FetchRemoteBranchesResponse(_messages.Message):
  r"""`FetchRemoteBranches` response message.

  Fields:
    branches: The remote repository's branch names.
  """

  branches = _messages.StringField(1, repeated=True)


class FetchRepositoryHistoryResponse(_messages.Message):
  r"""`FetchRepositoryHistory` response message.

  Fields:
    commits: A list of commit logs, ordered by 'git log' default order.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  commits = _messages.MessageField('CommitLogEntry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class FileOperation(_messages.Message):
  r"""Represents a single file operation to the repository.

  Fields:
    deleteFile: Represents the delete operation.
    writeFile: Represents the write operation.
  """

  deleteFile = _messages.MessageField('DeleteFile', 1)
  writeFile = _messages.MessageField('WriteFile', 2)


class FileSearchResult(_messages.Message):
  r"""Client-facing representation of a file entry in search results.

  Fields:
    path: File system path relative to the workspace root.
  """

  path = _messages.StringField(1)


class GitRemoteSettings(_messages.Message):
  r"""Controls Git remote configuration for a repository.

  Enums:
    TokenStatusValueValuesEnum: Output only. Deprecated: The field does not
      contain any token status information. Instead use https://cloud.google.c
      om/dataform/reference/rest/v1beta1/projects.locations.repositories/compu
      teAccessTokenStatus

  Fields:
    authenticationTokenSecretVersion: Optional. The name of the Secret Manager
      secret version to use as an authentication token for Git operations.
      Must be in the format `projects/*/secrets/*/versions/*`.
    defaultBranch: Required. The Git remote's default branch name.
    sshAuthenticationConfig: Optional. Authentication fields for remote uris
      using SSH protocol.
    tokenStatus: Output only. Deprecated: The field does not contain any token
      status information. Instead use https://cloud.google.com/dataform/refere
      nce/rest/v1beta1/projects.locations.repositories/computeAccessTokenStatu
      s
    url: Required. The Git remote's URL.
  """

  class TokenStatusValueValuesEnum(_messages.Enum):
    r"""Output only. Deprecated: The field does not contain any token status
    information. Instead use https://cloud.google.com/dataform/reference/rest/
    v1beta1/projects.locations.repositories/computeAccessTokenStatus

    Values:
      TOKEN_STATUS_UNSPECIFIED: Default value. This value is unused.
      NOT_FOUND: The token could not be found in Secret Manager (or the
        Dataform Service Account did not have permission to access it).
      INVALID: The token could not be used to authenticate against the Git
        remote.
      VALID: The token was used successfully to authenticate against the Git
        remote.
    """
    TOKEN_STATUS_UNSPECIFIED = 0
    NOT_FOUND = 1
    INVALID = 2
    VALID = 3

  authenticationTokenSecretVersion = _messages.StringField(1)
  defaultBranch = _messages.StringField(2)
  sshAuthenticationConfig = _messages.MessageField('SshAuthenticationConfig', 3)
  tokenStatus = _messages.EnumField('TokenStatusValueValuesEnum', 4)
  url = _messages.StringField(5)


class IncrementalTableConfig(_messages.Message):
  r"""Contains settings for relations of type `INCREMENTAL_TABLE`.

  Fields:
    incrementalPostOperations: SQL statements to be executed after inserting
      new rows into the relation.
    incrementalPreOperations: SQL statements to be executed before inserting
      new rows into the relation.
    incrementalSelectQuery: The SELECT query which returns rows which should
      be inserted into the relation if it already exists and is not being
      refreshed.
    refreshDisabled: Whether this table should be protected from being
      refreshed.
    uniqueKeyParts: A set of columns or SQL expressions used to define row
      uniqueness. If any duplicates are discovered (as defined by
      `unique_key_parts`), only the newly selected rows (as defined by
      `incremental_select_query`) will be included in the relation.
    updatePartitionFilter: A SQL expression conditional used to limit the set
      of existing rows considered for a merge operation (see
      `unique_key_parts` for more information).
  """

  incrementalPostOperations = _messages.StringField(1, repeated=True)
  incrementalPreOperations = _messages.StringField(2, repeated=True)
  incrementalSelectQuery = _messages.StringField(3)
  refreshDisabled = _messages.BooleanField(4)
  uniqueKeyParts = _messages.StringField(5, repeated=True)
  updatePartitionFilter = _messages.StringField(6)


class InstallNpmPackagesRequest(_messages.Message):
  r"""`InstallNpmPackages` request message."""


class InstallNpmPackagesResponse(_messages.Message):
  r"""`InstallNpmPackages` response message."""


class Interval(_messages.Message):
  r"""Represents a time interval, encoded as a Timestamp start (inclusive) and
  a Timestamp end (exclusive). The start must be less than or equal to the
  end. When the start equals the end, the interval is empty (matches no time).
  When both start and end are unspecified, the interval matches any time.

  Fields:
    endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    startTime: Optional. Inclusive start of the interval. If specified, a
      Timestamp matching this interval will have to be the same or after the
      start.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class InvocationConfig(_messages.Message):
  r"""Includes various configuration options for a workflow invocation. If
  both `included_targets` and `included_tags` are unset, all actions will be
  included.

  Fields:
    fullyRefreshIncrementalTablesEnabled: Optional. When set to true, any
      incremental tables will be fully refreshed.
    includedTags: Optional. The set of tags to include.
    includedTargets: Optional. The set of action identifiers to include.
    serviceAccount: Optional. The service account to run workflow invocations
      under.
    transitiveDependenciesIncluded: Optional. When set to true, transitive
      dependencies of included actions will be executed.
    transitiveDependentsIncluded: Optional. When set to true, transitive
      dependents of included actions will be executed.
  """

  fullyRefreshIncrementalTablesEnabled = _messages.BooleanField(1)
  includedTags = _messages.StringField(2, repeated=True)
  includedTargets = _messages.MessageField('Target', 3, repeated=True)
  serviceAccount = _messages.StringField(4)
  transitiveDependenciesIncluded = _messages.BooleanField(5)
  transitiveDependentsIncluded = _messages.BooleanField(6)


class ListCompilationResultsResponse(_messages.Message):
  r"""`ListCompilationResults` response message.

  Fields:
    compilationResults: List of compilation results.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations which could not be reached.
  """

  compilationResults = _messages.MessageField('CompilationResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListReleaseConfigsResponse(_messages.Message):
  r"""`ListReleaseConfigs` response message.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    releaseConfigs: List of release configs.
    unreachable: Locations which could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  releaseConfigs = _messages.MessageField('ReleaseConfig', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListRepositoriesResponse(_messages.Message):
  r"""`ListRepositories` response message.

  Fields:
    nextPageToken: A token which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    repositories: List of repositories.
    unreachable: Locations which could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  repositories = _messages.MessageField('Repository', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListWorkflowConfigsResponse(_messages.Message):
  r"""`ListWorkflowConfigs` response message.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations which could not be reached.
    workflowConfigs: List of workflow configs.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  workflowConfigs = _messages.MessageField('WorkflowConfig', 3, repeated=True)


class ListWorkflowInvocationsResponse(_messages.Message):
  r"""`ListWorkflowInvocations` response message.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations which could not be reached.
    workflowInvocations: List of workflow invocations.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  workflowInvocations = _messages.MessageField('WorkflowInvocation', 3, repeated=True)


class ListWorkspacesResponse(_messages.Message):
  r"""`ListWorkspaces` response message.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations which could not be reached.
    workspaces: List of workspaces.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  workspaces = _messages.MessageField('Workspace', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MakeDirectoryRequest(_messages.Message):
  r"""`MakeDirectory` request message.

  Fields:
    path: Required. The directory's full path including directory name,
      relative to the workspace root.
  """

  path = _messages.StringField(1)


class MakeDirectoryResponse(_messages.Message):
  r"""`MakeDirectory` response message."""


class MoveDirectoryRequest(_messages.Message):
  r"""`MoveDirectory` request message.

  Fields:
    newPath: Required. The new path for the directory including directory
      name, rooted at workspace root.
    path: Required. The directory's full path including directory name,
      relative to the workspace root.
  """

  newPath = _messages.StringField(1)
  path = _messages.StringField(2)


class MoveDirectoryResponse(_messages.Message):
  r"""`MoveDirectory` response message."""


class MoveFileRequest(_messages.Message):
  r"""`MoveFile` request message.

  Fields:
    newPath: Required. The file's new path including filename, relative to the
      workspace root.
    path: Required. The file's full path including filename, relative to the
      workspace root.
  """

  newPath = _messages.StringField(1)
  path = _messages.StringField(2)


class MoveFileResponse(_messages.Message):
  r"""`MoveFile` response message."""


class Notebook(_messages.Message):
  r"""A Notebook object.

  Fields:
    contents: The contents of the notebook.
    dependencyTargets: A list of actions that this action depends on.
    disabled: Whether this action is disabled (i.e. should not be run).
    tags: Arbitrary, user-defined tags on this action.
  """

  contents = _messages.StringField(1)
  dependencyTargets = _messages.MessageField('Target', 2, repeated=True)
  disabled = _messages.BooleanField(3)
  tags = _messages.StringField(4, repeated=True)


class NotebookAction(_messages.Message):
  r"""Represents a workflow action that will run against a Notebook runtime.

  Fields:
    contents: Output only. The code contents of a Notebook to be run.
    jobId: Output only. The ID of the Vertex job that executed the notebook in
      contents and also the ID used for the outputs created in Google Cloud
      Storage buckets. Only set once the job has started to run.
  """

  contents = _messages.StringField(1)
  jobId = _messages.StringField(2)


class NotebookRuntimeOptions(_messages.Message):
  r"""A NotebookRuntimeOptions object.

  Fields:
    gcsOutputBucket: Optional. The Google Cloud Storage location to upload the
      result to. Format: `gs://bucket-name`.
  """

  gcsOutputBucket = _messages.StringField(1)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have been cancelled
      successfully have google.longrunning.Operation.error value with a
      google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Operations(_messages.Message):
  r"""Represents a list of arbitrary database operations.

  Fields:
    dependencyTargets: A list of actions that this action depends on.
    disabled: Whether this action is disabled (i.e. should not be run).
    hasOutput: Whether these operations produce an output relation.
    queries: A list of arbitrary SQL statements that will be executed without
      alteration.
    relationDescriptor: Descriptor for any output relation and its columns.
      Only set if `has_output` is true.
    tags: Arbitrary, user-defined tags on this action.
  """

  dependencyTargets = _messages.MessageField('Target', 1, repeated=True)
  disabled = _messages.BooleanField(2)
  hasOutput = _messages.BooleanField(3)
  queries = _messages.StringField(4, repeated=True)
  relationDescriptor = _messages.MessageField('RelationDescriptor', 5)
  tags = _messages.StringField(6, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class PullGitCommitsRequest(_messages.Message):
  r"""`PullGitCommits` request message.

  Fields:
    author: Required. The author of any merge commit which may be created as a
      result of merging fetched Git commits into this workspace.
    remoteBranch: Optional. The name of the branch in the Git remote from
      which to pull commits. If left unset, the repository's default branch
      name will be used.
  """

  author = _messages.MessageField('CommitAuthor', 1)
  remoteBranch = _messages.StringField(2)


class PushGitCommitsRequest(_messages.Message):
  r"""`PushGitCommits` request message.

  Fields:
    remoteBranch: Optional. The name of the branch in the Git remote to which
      commits should be pushed. If left unset, the repository's default branch
      name will be used.
  """

  remoteBranch = _messages.StringField(1)


class QueryCompilationResultActionsResponse(_messages.Message):
  r"""`QueryCompilationResultActions` response message.

  Fields:
    compilationResultActions: List of compilation result actions.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  compilationResultActions = _messages.MessageField('CompilationResultAction', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class QueryDirectoryContentsResponse(_messages.Message):
  r"""`QueryDirectoryContents` response message.

  Fields:
    directoryEntries: List of entries in the directory.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  directoryEntries = _messages.MessageField('DirectoryEntry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class QueryRepositoryDirectoryContentsResponse(_messages.Message):
  r"""`QueryRepositoryDirectoryContents` response message.

  Fields:
    directoryEntries: List of entries in the directory.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  directoryEntries = _messages.MessageField('DirectoryEntry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class QueryWorkflowInvocationActionsResponse(_messages.Message):
  r"""`QueryWorkflowInvocationActions` response message.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    workflowInvocationActions: List of workflow invocation actions.
  """

  nextPageToken = _messages.StringField(1)
  workflowInvocationActions = _messages.MessageField('WorkflowInvocationAction', 2, repeated=True)


class ReadFileResponse(_messages.Message):
  r"""`ReadFile` response message.

  Fields:
    fileContents: The file's contents.
  """

  fileContents = _messages.BytesField(1)


class ReadRepositoryFileResponse(_messages.Message):
  r"""`ReadRepositoryFile` response message.

  Fields:
    contents: The file's contents.
  """

  contents = _messages.BytesField(1)


class Relation(_messages.Message):
  r"""Represents a database relation.

  Enums:
    RelationTypeValueValuesEnum: The type of this relation.

  Messages:
    AdditionalOptionsValue: Additional options that will be provided as
      key/value pairs into the options clause of a create table/view
      statement. See
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      definition-language for more information on which options are supported.

  Fields:
    additionalOptions: Additional options that will be provided as key/value
      pairs into the options clause of a create table/view statement. See
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      definition-language for more information on which options are supported.
    clusterExpressions: A list of columns or SQL expressions used to cluster
      the table.
    dependencyTargets: A list of actions that this action depends on.
    disabled: Whether this action is disabled (i.e. should not be run).
    incrementalTableConfig: Configures `INCREMENTAL_TABLE` settings for this
      relation. Only set if `relation_type` is `INCREMENTAL_TABLE`.
    partitionExpirationDays: Sets the partition expiration in days.
    partitionExpression: The SQL expression used to partition the relation.
    postOperations: SQL statements to be executed after creating the relation.
    preOperations: SQL statements to be executed before creating the relation.
    relationDescriptor: Descriptor for the relation and its columns.
    relationType: The type of this relation.
    requirePartitionFilter: Specifies whether queries on this table must
      include a predicate filter that filters on the partitioning column.
    selectQuery: The SELECT query which returns rows which this relation
      should contain.
    tags: Arbitrary, user-defined tags on this action.
  """

  class RelationTypeValueValuesEnum(_messages.Enum):
    r"""The type of this relation.

    Values:
      RELATION_TYPE_UNSPECIFIED: Default value. This value is unused.
      TABLE: The relation is a table.
      VIEW: The relation is a view.
      INCREMENTAL_TABLE: The relation is an incrementalized table.
      MATERIALIZED_VIEW: The relation is a materialized view.
    """
    RELATION_TYPE_UNSPECIFIED = 0
    TABLE = 1
    VIEW = 2
    INCREMENTAL_TABLE = 3
    MATERIALIZED_VIEW = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalOptionsValue(_messages.Message):
    r"""Additional options that will be provided as key/value pairs into the
    options clause of a create table/view statement. See
    https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
    definition-language for more information on which options are supported.

    Messages:
      AdditionalProperty: An additional property for a AdditionalOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AdditionalOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalOptions = _messages.MessageField('AdditionalOptionsValue', 1)
  clusterExpressions = _messages.StringField(2, repeated=True)
  dependencyTargets = _messages.MessageField('Target', 3, repeated=True)
  disabled = _messages.BooleanField(4)
  incrementalTableConfig = _messages.MessageField('IncrementalTableConfig', 5)
  partitionExpirationDays = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  partitionExpression = _messages.StringField(7)
  postOperations = _messages.StringField(8, repeated=True)
  preOperations = _messages.StringField(9, repeated=True)
  relationDescriptor = _messages.MessageField('RelationDescriptor', 10)
  relationType = _messages.EnumField('RelationTypeValueValuesEnum', 11)
  requirePartitionFilter = _messages.BooleanField(12)
  selectQuery = _messages.StringField(13)
  tags = _messages.StringField(14, repeated=True)


class RelationDescriptor(_messages.Message):
  r"""Describes a relation and its columns.

  Messages:
    BigqueryLabelsValue: A set of BigQuery labels that should be applied to
      the relation.

  Fields:
    bigqueryLabels: A set of BigQuery labels that should be applied to the
      relation.
    columns: A list of descriptions of columns within the relation.
    description: A text description of the relation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BigqueryLabelsValue(_messages.Message):
    r"""A set of BigQuery labels that should be applied to the relation.

    Messages:
      AdditionalProperty: An additional property for a BigqueryLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BigqueryLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BigqueryLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigqueryLabels = _messages.MessageField('BigqueryLabelsValue', 1)
  columns = _messages.MessageField('ColumnDescriptor', 2, repeated=True)
  description = _messages.StringField(3)


class ReleaseConfig(_messages.Message):
  r"""Represents a Dataform release configuration.

  Fields:
    codeCompilationConfig: Optional. If set, fields of
      `code_compilation_config` override the default compilation settings that
      are specified in dataform.json.
    cronSchedule: Optional. Optional schedule (in cron format) for automatic
      creation of compilation results.
    disabled: Optional. Disables automatic creation of compilation results.
    gitCommitish: Required. Git commit/tag/branch name at which the repository
      should be compiled. Must exist in the remote repository. Examples: - a
      commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    name: Identifier. The release config's name.
    recentScheduledReleaseRecords: Output only. Records of the 10 most recent
      scheduled release attempts, ordered in descending order of
      `release_time`. Updated whenever automatic creation of a compilation
      result is triggered by cron_schedule.
    releaseCompilationResult: Optional. The name of the currently released
      compilation result for this release config. This value is updated when a
      compilation result is automatically created from this release config
      (using cron_schedule), or when this resource is updated by API call
      (perhaps to roll back to an earlier release). The compilation result
      must have been created using this release config. Must be in the format
      `projects/*/locations/*/repositories/*/compilationResults/*`.
    timeZone: Optional. Specifies the time zone to be used when interpreting
      cron_schedule. Must be a time zone name from the time zone database
      (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
      unspecified, the default is UTC.
  """

  codeCompilationConfig = _messages.MessageField('CodeCompilationConfig', 1)
  cronSchedule = _messages.StringField(2)
  disabled = _messages.BooleanField(3)
  gitCommitish = _messages.StringField(4)
  internalMetadata = _messages.StringField(5)
  name = _messages.StringField(6)
  recentScheduledReleaseRecords = _messages.MessageField('ScheduledReleaseRecord', 7, repeated=True)
  releaseCompilationResult = _messages.StringField(8)
  timeZone = _messages.StringField(9)


class RemoveDirectoryRequest(_messages.Message):
  r"""`RemoveDirectory` request message.

  Fields:
    path: Required. The directory's full path including directory name,
      relative to the workspace root.
  """

  path = _messages.StringField(1)


class RemoveFileRequest(_messages.Message):
  r"""`RemoveFile` request message.

  Fields:
    path: Required. The file's full path including filename, relative to the
      workspace root.
  """

  path = _messages.StringField(1)


class Repository(_messages.Message):
  r"""Represents a Dataform Git repository.

  Messages:
    LabelsValue: Optional. Repository user labels.

  Fields:
    createTime: Output only. The timestamp of when the repository was created.
    dataEncryptionState: Output only. A data encryption state of a Git
      repository if this Repository is protected by a KMS key.
    displayName: Optional. The repository's user-friendly name.
    gitRemoteSettings: Optional. If set, configures this repository to be
      linked to a Git remote.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    kmsKeyName: Optional. The reference to a KMS encryption key. If provided,
      it will be used to encrypt user data in the repository and all child
      resources. It is not possible to add or update the encryption key after
      the repository is created. Example: `projects/{kms_project}/locations/{l
      ocation}/keyRings/{key_location}/cryptoKeys/{key}`
    labels: Optional. Repository user labels.
    name: Identifier. The repository's name.
    npmrcEnvironmentVariablesSecretVersion: Optional. The name of the Secret
      Manager secret version to be used to interpolate variables into the
      .npmrc file for package installation operations. Must be in the format
      `projects/*/secrets/*/versions/*`. The file itself must be in a JSON
      format.
    serviceAccount: Optional. The service account to run workflow invocations
      under.
    setAuthenticatedUserAdmin: Optional. Input only. If set to true, the
      authenticated user will be granted the roles/dataform.admin role on the
      created repository. To modify access to the created repository later
      apply setIamPolicy from
      https://cloud.google.com/dataform/reference/rest#rest-
      resource:-v1beta1.projects.locations.repositories
    workspaceCompilationOverrides: Optional. If set, fields of
      `workspace_compilation_overrides` override the default compilation
      settings that are specified in dataform.json when creating workspace-
      scoped compilation results. See documentation for
      `WorkspaceCompilationOverrides` for more information.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Repository user labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dataEncryptionState = _messages.MessageField('DataEncryptionState', 2)
  displayName = _messages.StringField(3)
  gitRemoteSettings = _messages.MessageField('GitRemoteSettings', 4)
  internalMetadata = _messages.StringField(5)
  kmsKeyName = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  npmrcEnvironmentVariablesSecretVersion = _messages.StringField(9)
  serviceAccount = _messages.StringField(10)
  setAuthenticatedUserAdmin = _messages.BooleanField(11)
  workspaceCompilationOverrides = _messages.MessageField('WorkspaceCompilationOverrides', 12)


class ResetWorkspaceChangesRequest(_messages.Message):
  r"""`ResetWorkspaceChanges` request message.

  Fields:
    clean: Optional. If set to true, untracked files will be deleted.
    paths: Optional. Full file paths to reset back to their committed state
      including filename, rooted at workspace root. If left empty, all files
      will be reset.
  """

  clean = _messages.BooleanField(1)
  paths = _messages.StringField(2, repeated=True)


class ScheduledExecutionRecord(_messages.Message):
  r"""A record of an attempt to create a workflow invocation for this workflow
  config.

  Fields:
    errorStatus: The error status encountered upon this attempt to create the
      workflow invocation, if the attempt was unsuccessful.
    executionTime: The timestamp of this execution attempt.
    workflowInvocation: The name of the created workflow invocation, if one
      was successfully created. Must be in the format
      `projects/*/locations/*/repositories/*/workflowInvocations/*`.
  """

  errorStatus = _messages.MessageField('Status', 1)
  executionTime = _messages.StringField(2)
  workflowInvocation = _messages.StringField(3)


class ScheduledReleaseRecord(_messages.Message):
  r"""A record of an attempt to create a compilation result for this release
  config.

  Fields:
    compilationResult: The name of the created compilation result, if one was
      successfully created. Must be in the format
      `projects/*/locations/*/repositories/*/compilationResults/*`.
    errorStatus: The error status encountered upon this attempt to create the
      compilation result, if the attempt was unsuccessful.
    releaseTime: The timestamp of this release attempt.
  """

  compilationResult = _messages.StringField(1)
  errorStatus = _messages.MessageField('Status', 2)
  releaseTime = _messages.StringField(3)


class SearchFilesResponse(_messages.Message):
  r"""Client-facing representation of a file search response.

  Fields:
    nextPageToken: Optional. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    searchResults: List of matched results.
  """

  nextPageToken = _messages.StringField(1)
  searchResults = _messages.MessageField('SearchResult', 2, repeated=True)


class SearchResult(_messages.Message):
  r"""Client-facing representation of a search result entry.

  Fields:
    directory: Details when search result is a directory.
    file: Details when search result is a file.
  """

  directory = _messages.MessageField('DirectorySearchResult', 1)
  file = _messages.MessageField('FileSearchResult', 2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class SshAuthenticationConfig(_messages.Message):
  r"""Configures fields for performing SSH authentication.

  Fields:
    hostPublicKey: Required. Content of a public SSH key to verify an identity
      of a remote Git host.
    userPrivateKeySecretVersion: Required. The name of the Secret Manager
      secret version to use as a ssh private key for Git operations. Must be
      in the format `projects/*/secrets/*/versions/*`.
  """

  hostPublicKey = _messages.StringField(1)
  userPrivateKeySecretVersion = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Target(_messages.Message):
  r"""Represents an action identifier. If the action writes output, the output
  will be written to the referenced database object.

  Fields:
    database: The action's database (Google Cloud project ID) .
    name: The action's name, within `database` and `schema`.
    schema: The action's schema (BigQuery dataset ID), within `database`.
  """

  database = _messages.StringField(1)
  name = _messages.StringField(2)
  schema = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UncommittedFileChange(_messages.Message):
  r"""Represents the Git state of a file with uncommitted changes.

  Enums:
    StateValueValuesEnum: Indicates the status of the file.

  Fields:
    path: The file's full path including filename, relative to the workspace
      root.
    state: Indicates the status of the file.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Indicates the status of the file.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      ADDED: The file has been newly added.
      DELETED: The file has been deleted.
      MODIFIED: The file has been modified.
      HAS_CONFLICTS: The file contains merge conflicts.
    """
    STATE_UNSPECIFIED = 0
    ADDED = 1
    DELETED = 2
    MODIFIED = 3
    HAS_CONFLICTS = 4

  path = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class WorkflowConfig(_messages.Message):
  r"""Represents a Dataform workflow configuration.

  Fields:
    createTime: Output only. The timestamp of when the WorkflowConfig was
      created.
    cronSchedule: Optional. Optional schedule (in cron format) for automatic
      execution of this workflow config.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    invocationConfig: Optional. If left unset, a default InvocationConfig will
      be used.
    name: Identifier. The workflow config's name.
    recentScheduledExecutionRecords: Output only. Records of the 10 most
      recent scheduled execution attempts, ordered in descending order of
      `execution_time`. Updated whenever automatic creation of a workflow
      invocation is triggered by cron_schedule.
    releaseConfig: Required. The name of the release config whose
      release_compilation_result should be executed. Must be in the format
      `projects/*/locations/*/repositories/*/releaseConfigs/*`.
    timeZone: Optional. Specifies the time zone to be used when interpreting
      cron_schedule. Must be a time zone name from the time zone database
      (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
      unspecified, the default is UTC.
    updateTime: Output only. The timestamp of when the WorkflowConfig was last
      updated.
  """

  createTime = _messages.StringField(1)
  cronSchedule = _messages.StringField(2)
  internalMetadata = _messages.StringField(3)
  invocationConfig = _messages.MessageField('InvocationConfig', 4)
  name = _messages.StringField(5)
  recentScheduledExecutionRecords = _messages.MessageField('ScheduledExecutionRecord', 6, repeated=True)
  releaseConfig = _messages.StringField(7)
  timeZone = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class WorkflowInvocation(_messages.Message):
  r"""Represents a single invocation of a compilation result.

  Enums:
    StateValueValuesEnum: Output only. This workflow invocation's current
      state.

  Fields:
    compilationResult: Immutable. The name of the compilation result to use
      for this invocation. Must be in the format
      `projects/*/locations/*/repositories/*/compilationResults/*`.
    dataEncryptionState: Output only. Only set if the repository has a KMS
      Key.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    invocationConfig: Immutable. If left unset, a default InvocationConfig
      will be used.
    invocationTiming: Output only. This workflow invocation's timing details.
    name: Output only. The workflow invocation's name.
    resolvedCompilationResult: Output only. The resolved compilation result
      that was used to create this invocation. Will be in the format
      `projects/*/locations/*/repositories/*/compilationResults/*`.
    state: Output only. This workflow invocation's current state.
    workflowConfig: Immutable. The name of the workflow config to invoke. Must
      be in the format
      `projects/*/locations/*/repositories/*/workflowConfigs/*`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. This workflow invocation's current state.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      RUNNING: The workflow invocation is currently running.
      SUCCEEDED: The workflow invocation succeeded. A terminal state.
      CANCELLED: The workflow invocation was cancelled. A terminal state.
      FAILED: The workflow invocation failed. A terminal state.
      CANCELING: The workflow invocation is being cancelled, but some actions
        are still running.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCEEDED = 2
    CANCELLED = 3
    FAILED = 4
    CANCELING = 5

  compilationResult = _messages.StringField(1)
  dataEncryptionState = _messages.MessageField('DataEncryptionState', 2)
  internalMetadata = _messages.StringField(3)
  invocationConfig = _messages.MessageField('InvocationConfig', 4)
  invocationTiming = _messages.MessageField('Interval', 5)
  name = _messages.StringField(6)
  resolvedCompilationResult = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  workflowConfig = _messages.StringField(9)


class WorkflowInvocationAction(_messages.Message):
  r"""Represents a single action in a workflow invocation.

  Enums:
    StateValueValuesEnum: Output only. This action's current state.

  Fields:
    bigqueryAction: Output only. The workflow action's bigquery action
      details.
    canonicalTarget: Output only. The action's identifier if the project had
      been compiled without any overrides configured. Unique within the
      compilation result.
    failureReason: Output only. If and only if action's state is FAILED a
      failure reason is set.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    invocationTiming: Output only. This action's timing details. `start_time`
      will be set if the action is in [RUNNING, SUCCEEDED, CANCELLED, FAILED]
      state. `end_time` will be set if the action is in [SUCCEEDED, CANCELLED,
      FAILED] state.
    notebookAction: Output only. The workflow action's notebook action
      details.
    state: Output only. This action's current state.
    target: Output only. This action's identifier. Unique within the workflow
      invocation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. This action's current state.

    Values:
      PENDING: The action has not yet been considered for invocation.
      RUNNING: The action is currently running.
      SKIPPED: Execution of the action was skipped because upstream
        dependencies did not all complete successfully. A terminal state.
      DISABLED: Execution of the action was disabled as per the configuration
        of the corresponding compilation result action. A terminal state.
      SUCCEEDED: The action succeeded. A terminal state.
      CANCELLED: The action was cancelled. A terminal state.
      FAILED: The action failed. A terminal state.
    """
    PENDING = 0
    RUNNING = 1
    SKIPPED = 2
    DISABLED = 3
    SUCCEEDED = 4
    CANCELLED = 5
    FAILED = 6

  bigqueryAction = _messages.MessageField('BigQueryAction', 1)
  canonicalTarget = _messages.MessageField('Target', 2)
  failureReason = _messages.StringField(3)
  internalMetadata = _messages.StringField(4)
  invocationTiming = _messages.MessageField('Interval', 5)
  notebookAction = _messages.MessageField('NotebookAction', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  target = _messages.MessageField('Target', 8)


class Workspace(_messages.Message):
  r"""Represents a Dataform Git workspace.

  Fields:
    createTime: Output only. The timestamp of when the workspace was created.
    dataEncryptionState: Output only. A data encryption state of a Git
      repository if this Workspace is protected by a KMS key.
    internalMetadata: Output only. All the metadata information that is used
      internally to serve the resource. For example: timestamps, flags, status
      fields, etc. The format of this field is a JSON string.
    name: Identifier. The workspace's name.
  """

  createTime = _messages.StringField(1)
  dataEncryptionState = _messages.MessageField('DataEncryptionState', 2)
  internalMetadata = _messages.StringField(3)
  name = _messages.StringField(4)


class WorkspaceCompilationOverrides(_messages.Message):
  r"""Configures workspace compilation overrides for a repository. Primarily
  used by the UI (`console.cloud.google.com`). `schema_suffix` and
  `table_prefix` can have a special expression - `${workspaceName}`, which
  refers to the workspace name from which the compilation results will be
  created. API callers are expected to resolve the expression in these
  overrides and provide them explicitly in `code_compilation_config` (https://
  cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.reposito
  ries.compilationResults#codecompilationconfig) when creating workspace-
  scoped compilation results.

  Fields:
    defaultDatabase: Optional. The default database (Google Cloud project ID).
    schemaSuffix: Optional. The suffix that should be appended to all schema
      (BigQuery dataset ID) names.
    tablePrefix: Optional. The prefix that should be prepended to all table
      names.
  """

  defaultDatabase = _messages.StringField(1)
  schemaSuffix = _messages.StringField(2)
  tablePrefix = _messages.StringField(3)


class WriteFile(_messages.Message):
  r"""Represents the write file operation (for files added or modified).

  Fields:
    contents: The file's contents.
  """

  contents = _messages.BytesField(1)


class WriteFileRequest(_messages.Message):
  r"""`WriteFile` request message.

  Fields:
    contents: Required. The file's contents.
    path: Required. The file.
  """

  contents = _messages.BytesField(1)
  path = _messages.StringField(2)


class WriteFileResponse(_messages.Message):
  r"""`WriteFile` response message."""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    DataformProjectsLocationsRepositoriesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    DataformProjectsLocationsRepositoriesWorkspacesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
