"""Generated message classes for cloudaicompanion version v1alpha.

The Cloud AI Companion API for Gemini for Google Cloud.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudaicompanion'


class AtlasCitation(_messages.Message):
  r"""Metadata of one citation.

  Fields:
    endIndex: Index in the prediction output where the citation ends
      (exclusive). Must be > start_index and < len(output).
    license: License associated with this recitation. If present, it refers to
      the license of the source of this citation. Possible licenses include
      code licenses, e.g., mit license.
    publicationDate: Publication date associated with this citation. If
      present, it refers to the date at which the source of this citation was
      published. Possible formats are YYYY, YYYY-MM, YYYY-MM-DD.
    startIndex: Index in the prediction output where the citation starts
      (inclusive). Must be >= 0 and < end_index.
    title: Title associated with this citation. If present, it refers to the
      title of the source of this citation. Possible titles include news
      titles, book titles, etc.
    url: URL associated with this citation. If present, this URL links to the
      webpage of the source of this citation. Possible URLs include news
      websites, GitHub repos, etc.
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  publicationDate = _messages.StringField(3)
  startIndex = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  title = _messages.StringField(5)
  url = _messages.StringField(6)


class AtlasCitationMetadata(_messages.Message):
  r"""The schema of citations found in textual prediction outputs. Citations
  originate from various sources and indicate that these contents should be
  cited properly. Next ID: 2

  Fields:
    citations: Metadata of all citations found in this prediction output.
  """

  citations = _messages.MessageField('AtlasCitation', 1, repeated=True)


class AtlasInvalidLink(_messages.Message):
  r"""Next ID: 2

  Fields:
    uri: The URL of the invalid link.
  """

  uri = _messages.StringField(1)


class AtlasLinkValidationMetadata(_messages.Message):
  r"""Next ID: 2

  Fields:
    invalidLinks: List of invalid links.
  """

  invalidLinks = _messages.MessageField('AtlasInvalidLink', 1, repeated=True)


class AtlasNavigationLink(_messages.Message):
  r"""A URL in the Chat panel that'll refresh the left panel to the Cloud
  Console UI page that's directly related to their question/task. See go/duet-
  chat-nav-link for more context. Next ID: 3

  Fields:
    path: Relative path of the Cloud Console page without the domain name.
    title: Title of the Cloud Console page.
  """

  path = _messages.StringField(1)
  title = _messages.StringField(2)


class AtlasRelatedContent(_messages.Message):
  r"""Next ID: 2

  Fields:
    relatedLinks: ALS factuality check links.
  """

  relatedLinks = _messages.MessageField('AtlasRelatedLink', 1, repeated=True)


class AtlasRelatedLink(_messages.Message):
  r"""Next ID: 4

  Fields:
    searchUri: URL for the search result.
    sourceTitle: Title of the information source.
    summary: Summary from the link.
  """

  searchUri = _messages.StringField(1)
  sourceTitle = _messages.StringField(2)
  summary = _messages.StringField(3)


class AttributionContext(_messages.Message):
  r"""Represents citation and attribution context of the output.

  Fields:
    citationMetadata: Optional. Citation metadata of the output
  """

  citationMetadata = _messages.MessageField('CitationMetadata', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BackendResourcesContext(_messages.Message):
  r"""Represents ids of resources that the operation needs to reference or
  target. E.g. for BigQuery SQL generation, this could reference the Dataset
  or Table names (go/backend-resources-context-eg).

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific backend
      resources context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific backend
      resources context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific backend resources context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class BigQueryDatasetReference(_messages.Message):
  r"""A BigQuery dataset is identified by its `project_id`:`dataset_id`.

  Fields:
    datasetId: Optional. The id or name of the BigQuery dataset.
    projectId: Optional. The GCP project id containing the BigQuery dataset.
    tables: Optional. Captures a subset of relevant tables in the dataset. If
      empty, include all tables in the dataset.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  tables = _messages.StringField(3, repeated=True)


class BigQueryTableReference(_messages.Message):
  r"""Reference to a BigQuery table

  Fields:
    datasetId: Optional. Dataset id
    projectId: Optional. Project id
    tableId: Optional. Table id
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  tableId = _messages.StringField(3)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BoolColumn(_messages.Message):
  r"""The bool column values of table/chart to be summarized.

  Fields:
    values: Required. column values of type bool
  """

  values = _messages.BooleanField(1, repeated=True)


class BooleanParameterArray(_messages.Message):
  r"""This message only contains a field of boolean array.

  Fields:
    booleanValues: Boolean array.
  """

  booleanValues = _messages.BooleanField(1, repeated=True)


class CWTranslationReport(_messages.Message):
  r"""CompilerWorks translation output details like translated query,
  warning/error records.

  Fields:
    translatedQuery: Optional. Translated query produced by CW.
    translationErrorRecords: Optional. CW translation error details.
  """

  translatedQuery = _messages.StringField(1)
  translationErrorRecords = _messages.MessageField('TranslationErrorRecord', 2, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ChartData(_messages.Message):
  r"""Chart data.

  Fields:
    chartTitle: Optional. Chart title.
    chartType: Optional. Chart type.
    rawData: Required. Raw chart data.
  """

  chartTitle = _messages.StringField(1)
  chartType = _messages.StringField(2)
  rawData = _messages.MessageField('RawData', 3)


class ChartMetadata(_messages.Message):
  r"""Metadata about the generated chart specification. Used to give more
  details about data points underpinning the chart.

  Fields:
    dataColumns: Optional. List of data columns referenced in chart encoding
      (axes) specifications. These are column names from the input DataModel.
    dataRowsCount: Optional. Total number of data rows.
    originalDataRowsCount: Optional. Total number of data rows before
      truncation.
    prunedDataColumns: Optional. List of data columns got pruned when
      generating chart.
  """

  dataColumns = _messages.StringField(1, repeated=True)
  dataRowsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  originalDataRowsCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  prunedDataColumns = _messages.StringField(4, repeated=True)


class ChartValidation(_messages.Message):
  r"""Validation details about the generated chart specification.

  Enums:
    ValidationStatusValueValuesEnum: Chart validation status.

  Fields:
    errorMessage: Optional. Chart validation error message.
    validationStatus: Chart validation status.
  """

  class ValidationStatusValueValuesEnum(_messages.Enum):
    r"""Chart validation status.

    Values:
      VALIDATION_STATUS_UNSPECIFIED: Unknown error category
      VALIDATION_STATUS_PASSED: Generated Vega Lite is valid
      VALIDATION_STATUS_INVALID_JSON: Generated Vega Lite is in invalid JSON
        format
      VALIDATION_STATUS_MISSING_FIELDS: Generated Vega Lite has missing fields
    """
    VALIDATION_STATUS_UNSPECIFIED = 0
    VALIDATION_STATUS_PASSED = 1
    VALIDATION_STATUS_INVALID_JSON = 2
    VALIDATION_STATUS_MISSING_FIELDS = 3

  errorMessage = _messages.StringField(1)
  validationStatus = _messages.EnumField('ValidationStatusValueValuesEnum', 2)


class ChatContext(_messages.Message):
  r"""Next ID: 6

  Fields:
    history: Optional. History should be in sequence with the first one being
      the oldest user message and alternating authors from there. These are
      used to support multi-turn chatting.
  """

  history = _messages.MessageField('ChatMessage', 1, repeated=True)


class ChatMessage(_messages.Message):
  r"""Next ID: 3

  Enums:
    AuthorValueValuesEnum: The author of the content for this message in the
      chat history.

  Fields:
    author: The author of the content for this message in the chat history.
    content: Text content of the chat message.
  """

  class AuthorValueValuesEnum(_messages.Enum):
    r"""The author of the content for this message in the chat history.

    Values:
      UNKNOWN: Unknown
      USER: Human user
      SYSTEM: The LLM
    """
    UNKNOWN = 0
    USER = 1
    SYSTEM = 2

  author = _messages.EnumField('AuthorValueValuesEnum', 1)
  content = _messages.StringField(2)


class Citation(_messages.Message):
  r"""Citation identifies which parts of content have a license

  Fields:
    endIndex: The index in the suggestion where the citation ends
    license: The applicable license for the citation, for example MIT, or
      omitted if the license type is not known.
    startIndex: The index in the suggestion where the citation begins
    uri: The source uri for the original content
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  startIndex = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  uri = _messages.StringField(4)


class CitationEntry(_messages.Message):
  r"""Metadata of one citation. (named entry because of clash with code.proto)

  Fields:
    endIndex: Index in the prediction output where the citation ends
      (exclusive). Must be > start_index and < len(output).
    license: License associated with this recitation. If present, it refers to
      the license of the source of this citation. Possible licenses include
      code licenses, e.g., mit license.
    publicationDate: Publication date associated with this citation. If
      present, it refers to the date at which the source of this citation was
      published. Possible formats are YYYY, YYYY-MM, YYYY-MM-DD.
    startIndex: Index in the prediction output where the citation starts
      (inclusive). Must be >= 0 and < end_index.
    title: Title associated with this citation. If present, it refers to the
      title of the source of this citation. Possible titles include news
      titles, book titles, etc.
    url: URL associated with this citation. If present, this URL links to the
      webpage of the source of this citation. Possible URLs include news
      websites, GitHub repos, etc.
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  publicationDate = _messages.StringField(3)
  startIndex = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  title = _messages.StringField(5)
  url = _messages.StringField(6)


class CitationMetadata(_messages.Message):
  r"""The schema of citations found in textual prediction outputs. Citations
  originate from various sources and indicate that these contents should be
  cited properly.

  Fields:
    citations: Metadata of all citations found in this prediction output.
  """

  citations = _messages.MessageField('CitationEntry', 1, repeated=True)


class ClientContext(_messages.Message):
  r"""Represents context about the UI client. Must NOT contain customer
  content.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific
      UI/client context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific UI/client
      context.
    name: Optional. Name of the Duet plugin/UI running in the client space
    version: Optional. Duet plugin/UI version
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific UI/client context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)
  name = _messages.StringField(2)
  version = _messages.StringField(3)


class CloudSchedulerConfig(_messages.Message):
  r"""Cloud Scheduler Trigger configuration

  Fields:
    cronTab: Required. The cron tab of cloud scheduler trigger.
    errorMessage: Optional. When the job was deleted from Pantheon UI,
      error_message will be populated when Get/List integrations
    location: Required. The location where associated cloud scheduler job will
      be created
    serviceAccountEmail: Required. Service account used by Cloud Scheduler to
      trigger the integration at scheduled time
  """

  cronTab = _messages.StringField(1)
  errorMessage = _messages.StringField(2)
  location = _messages.StringField(3)
  serviceAccountEmail = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    codeRepositoryIndexId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      code_repository_index_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  codeRepositoryIndexId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, any RepositoryGroups from this
      CodeRepositoryIndex will also be deleted. (Otherwise, the request will
      only work if the CodeRepositoryIndex has no RepositoryGroups.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCodeRepositoryIndexesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    name: Immutable. Identifier. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the CodeRepositoryIndex resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  CreateRequest object.

  Fields:
    parent: Required. Value for parent.
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    repositoryGroupId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and repository_group_id
      from the method_signature of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  repositoryGroupId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  DeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  ListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListRepositoryGroupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  PatchRequest object.

  Fields:
    name: Immutable. Identifier. name of resource
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the RepositoryGroup resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  SetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  TestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudaicompanionProjectsLocationsCompleteChatRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCompleteChatRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    taskCompletionRequest: A TaskCompletionRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  taskCompletionRequest = _messages.MessageField('TaskCompletionRequest', 2)


class CloudaicompanionProjectsLocationsEnablementsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsCreateRequest object.

  Fields:
    enablement: A Enablement resource to be passed as the request body.
    enablementId: Required. The ID to use for the enablement.
    parent: Required. The parent resource where this enablement will be
      created. Format: projects/{project}/locations/{location}
  """

  enablement = _messages.MessageField('Enablement', 1)
  enablementId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudaicompanionProjectsLocationsEnablementsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsDeleteRequest object.

  Fields:
    name: Required. The name of the enablement to delete. Format:
      projects/{project}/locations/{location}/enablement/{enablement_id}
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsEnablementsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsGetRequest object.

  Fields:
    name: Required. The name of the enablement to retrieve. Format:
      projects/{project}/locations/{location}/enablement/{enablement_id}
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsEnablementsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of enablements to return. The
      service may return fewer than this value. If unspecified, at most 100
      enablements will be returned.
    pageToken: Optional. A page token, received from a previous
      `ListEnablements` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListEnablements` must
      match the call that provided the page token.
    parent: Required. The parent resource where this enablement will be
      created. Format: projects/{project}/locations/{location}
    showDeleted: Optional. If true, show soft deleted enablements.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  showDeleted = _messages.BooleanField(4)


class CloudaicompanionProjectsLocationsEnablementsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsPatchRequest object.

  Fields:
    enablement: A Enablement resource to be passed as the request body.
    name: Identifier. The name of the enablement. Format:
      projects/{project}/locations/{location}/enablement/{enablement_id}
    updateMask: Required. The list of fields to update. None of the fields are
      allowed to be updated as of now.
  """

  enablement = _messages.MessageField('Enablement', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudaicompanionProjectsLocationsEnablementsUndeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsEnablementsUndeleteRequest object.

  Fields:
    name: Required. The name of the enablement to undelete. Format:
      projects/{project}/locations/{location}/enablement/{enablement_id}
    undeleteEnablementRequest: A UndeleteEnablementRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteEnablementRequest = _messages.MessageField('UndeleteEnablementRequest', 2)


class CloudaicompanionProjectsLocationsGenerateChatRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGenerateChatRequest object.

  Fields:
    generateChatRequest: A GenerateChatRequest resource to be passed as the
      request body.
    parent: Required. Target project and location to make a call.
  """

  generateChatRequest = _messages.MessageField('GenerateChatRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsGenerateCodeRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGenerateCodeRequest object.

  Fields:
    generateCodeRequest: A GenerateCodeRequest resource to be passed as the
      request body.
    parent: Required. Target project and location to make a call.
  """

  generateCodeRequest = _messages.MessageField('GenerateCodeRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsInferSchemaRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInferSchemaRequest object.

  Fields:
    inferSchemaRequest: A InferSchemaRequest resource to be passed as the
      request body.
    parent: Optional. Active project and location in format
      projects/*/locations/*
  """

  inferSchemaRequest = _messages.MessageField('InferSchemaRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesCompleteChatRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesCompleteChatRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    taskCompletionRequest: A TaskCompletionRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  taskCompletionRequest = _messages.MessageField('TaskCompletionRequest', 2)


class CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest object.

  Fields:
    codeCompletionRequest: A CodeCompletionRequest resource to be passed as
      the request body.
    instance: Required. The full name of the Instance resource for this
      completion request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
  """

  codeCompletionRequest = _messages.MessageField('CodeCompletionRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    taskCompletionRequest: A TaskCompletionRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  taskCompletionRequest = _messages.MessageField('TaskCompletionRequest', 2)


class CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest object.

  Fields:
    codeGenerationRequest: A CodeGenerationRequest resource to be passed as
      the request body.
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
  """

  codeGenerationRequest = _messages.MessageField('CodeGenerationRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesGenerateDataInsightsRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateDataInsightsRequest
  object.

  Fields:
    generateDataInsightsRequest: A GenerateDataInsightsRequest resource to be
      passed as the request body.
    instance: Required. Active project, location, and instance in format
      `projects/*/locations/*/instances/*`.
  """

  generateDataInsightsRequest = _messages.MessageField('GenerateDataInsightsRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesGeneratePythonRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGeneratePythonRequest
  object.

  Fields:
    generatePythonRequest: A GeneratePythonRequest resource to be passed as
      the request body.
    instance: Optional. Active instance in format
      projects/*/locations/*/instances/*
  """

  generatePythonRequest = _messages.MessageField('GeneratePythonRequest', 1)
  instance = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsInstancesGenerateSqlRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateSqlRequest object.

  Fields:
    instance: Required. Active instance in format
      projects/*/locations/*/instances/* Unless `override_project_number` is
      set, the GCP project-id contained by this resource path is assumed to be
      the consumer project and used as an identifier in calls to dependent
      systems such as inference and context retrieval.
    sqlGenRequest: A SqlGenRequest resource to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  sqlGenRequest = _messages.MessageField('SqlGenRequest', 2)


class CloudaicompanionProjectsLocationsInstancesGenerateTextRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateTextRequest object.

  Fields:
    instance: Required. The full name of the Instance resource for this
      generation request. Format:
      `projects/{project}/locations/{location}/instances/{instance}` Use the
      special 'default' name to refer to the default instance.
    textGenerationRequest: A TextGenerationRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  textGenerationRequest = _messages.MessageField('TextGenerationRequest', 2)


class CloudaicompanionProjectsLocationsInstancesGenerateVisualRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesGenerateVisualRequest
  object.

  Fields:
    instance: Optional. Active instance in format
      projects/*/locations/*/instances/*
    visualGenRequest: A VisualGenRequest resource to be passed as the request
      body.
  """

  instance = _messages.StringField(1, required=True)
  visualGenRequest = _messages.MessageField('VisualGenRequest', 2)


class CloudaicompanionProjectsLocationsInstancesSummarizeDataRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsInstancesSummarizeDataRequest object.

  Fields:
    instance: Required. Active project, location, and instance in format
      `projects/*/locations/*/instances/*`.
    summarizeDataRequest: A SummarizeDataRequest resource to be passed as the
      request body.
  """

  instance = _messages.StringField(1, required=True)
  summarizeDataRequest = _messages.MessageField('SummarizeDataRequest', 2)


class CloudaicompanionProjectsLocationsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudaicompanionProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudaicompanionProjectsLocationsTranslateSqlRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsTranslateSqlRequest object.

  Fields:
    parent: Optional. Active project and location in format
      projects/*/locations/*
    sqlTranslateRequest: A SqlTranslateRequest resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  sqlTranslateRequest = _messages.MessageField('SqlTranslateRequest', 2)


class CodeCompletionInput(_messages.Message):
  r"""Input format for Code Completion.

  Fields:
    prefix: Optional. The code/text snippet preceding the code completion
      prediction result.
    suffix: Optional. The code/text snippet following the end of code
      completion prediction result.
  """

  prefix = _messages.StringField(1)
  suffix = _messages.StringField(2)


class CodeCompletionOutput(_messages.Message):
  r"""Prediction output format for Code Completion.

  Fields:
    content: The generated text.
  """

  content = _messages.StringField(1)


class CodeCompletionRequest(_messages.Message):
  r"""Input to code completion.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `instances`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('CodeCompletionInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class CodeCompletionResponse(_messages.Message):
  r"""Output of code completion.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated code output.
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('CodeCompletionOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class CodeGenerationInput(_messages.Message):
  r"""Input format for Code Generation.

  Fields:
    prompt: Optional. The code/text snippet preceding the code generation
      prediction result.
  """

  prompt = _messages.StringField(1)


class CodeGenerationOutput(_messages.Message):
  r"""Prediction output format for Code Generation.

  Fields:
    content: The generated text.
  """

  content = _messages.StringField(1)


class CodeGenerationRequest(_messages.Message):
  r"""Input to code generation.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `instances`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('CodeGenerationInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class CodeGenerationResponse(_messages.Message):
  r"""Output of code generation.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated code output.
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('CodeGenerationOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class CodePrompt(_messages.Message):
  r"""CodePrompt contains the prompt to be passed to the LLM.

  Enums:
    ExperienceValueValuesEnum: Required. The experience pointing to the LLM to
      be used to generate code suggestions.

  Fields:
    additionalFiles: Optional. Additional files to use for in-context
      retrieval for completion only ATM. Files should be ordered from most
      relevant to least relevant.
    expectedSamples: Optional. The maximum number of code suggestions that
      should be returned. A value of 1 is a good starting point.
    experience: Required. The experience pointing to the LLM to be used to
      generate code suggestions.
    experienceOverride: Optional. Overrides Atlas experience param. Only
      requests from CCPA jobs can use that functionality.
    maxOutputTokens: Optional. The maximum number of output tokens that can be
      generated to the prompt. This can range from 1 to 1024. A token is
      approximately 4 characters. A value of 64 is a good starting point.
    prefix: Required. The prefix is the string before any LLM generated text.
      Most prompt engineering should be applied to the prefix.
    stopSequences: Optional. Instructs the model to stop generating code after
      it has generated any of the given sequences.
    suffix: Optional. The suffix is the string after any LLM generated text.
      The suffix should not be set for the GENERATE experience.
    temperature: Optional. The temperature determines how random responses are
      in a range from 0 (deterministic) to 1. A value of 0.2 is a good
      starting point.
  """

  class ExperienceValueValuesEnum(_messages.Enum):
    r"""Required. The experience pointing to the LLM to be used to generate
    code suggestions.

    Values:
      EXPERIENCE_UNSPECIFIED: Unspecified experience.
      COMPLETE: The code completion experience.
      GENERATE: The code generation experience.
      COMPLETE_BIGQUERY: The code completion experience for BigQuery.
      GENERATE_BIGQUERY: The code generation experience for BigQuery.
      COMPLETE_SPANNER: The code completion experience for Spanner.
      GENERATE_SPANNER: The code generation experience for Spanner.
      COMPLETE_CLOUD_SQL: The code completion experience for Cloud SQL.
      GENERATE_CLOUD_SQL: The code generation experience for Cloud SQL.
      GENERATE_LOOKER: The code generation experience for Looker.
      COMPLETE_CP2: The code completion experience, codepoet2 w/ TreeTrim.
      GENERATE_CLOUDRUN_STACKS: The code generation experience for CloudRun
        for stacks configuration.
      GENERATE_LOOKML: The code generation experience for LookML.
      GENERATE_SYNTHETIC_MONITORING: The code generation experience for
        Synthetic Monitoring.
      GENERATE_CODE_TRANSFORMS: The code generation experience for Code
        Transforms.
      INTENT_CLASSIFICATION: The intent classification experience.
      COMPLETE_CLOUDRUN: The code completion experience for Cloud Run
        Functions.
    """
    EXPERIENCE_UNSPECIFIED = 0
    COMPLETE = 1
    GENERATE = 2
    COMPLETE_BIGQUERY = 3
    GENERATE_BIGQUERY = 4
    COMPLETE_SPANNER = 5
    GENERATE_SPANNER = 6
    COMPLETE_CLOUD_SQL = 7
    GENERATE_CLOUD_SQL = 8
    GENERATE_LOOKER = 9
    COMPLETE_CP2 = 10
    GENERATE_CLOUDRUN_STACKS = 11
    GENERATE_LOOKML = 12
    GENERATE_SYNTHETIC_MONITORING = 13
    GENERATE_CODE_TRANSFORMS = 14
    INTENT_CLASSIFICATION = 15
    COMPLETE_CLOUDRUN = 16

  additionalFiles = _messages.MessageField('File', 1, repeated=True)
  expectedSamples = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  experience = _messages.EnumField('ExperienceValueValuesEnum', 3)
  experienceOverride = _messages.StringField(4)
  maxOutputTokens = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  prefix = _messages.StringField(6)
  stopSequences = _messages.StringField(7, repeated=True)
  suffix = _messages.StringField(8)
  temperature = _messages.FloatField(9, variant=_messages.Variant.FLOAT)


class CodeRepositoryIndex(_messages.Message):
  r"""Message describing CodeRepositoryIndex object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    ipRanges: Output only. Ranges of possible IP addresses from which the RAG
      index service will attempt to access linked Git repositories.
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  ipRanges = _messages.StringField(2, repeated=True)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class Column(_messages.Message):
  r"""All relevant information about a column to generate SQL.

  Fields:
    column: Column name.
    dataType: Column datatype.
  """

  column = _messages.StringField(1)
  dataType = _messages.StringField(2)


class ColumnData(_messages.Message):
  r"""The data column of table/chart to be summarized.

  Fields:
    boolColumn: Boolean column
    datetimeColumn: Datetime column
    doubleColumn: Double column
    longColumn: Long column
    nullIndex: Required. Positions of rows where the column value is null.
    stringColumn: String column
  """

  boolColumn = _messages.MessageField('BoolColumn', 1)
  datetimeColumn = _messages.MessageField('DatetimeColumn', 2)
  doubleColumn = _messages.MessageField('DoubleColumn', 3)
  longColumn = _messages.MessageField('LongColumn', 4)
  nullIndex = _messages.IntegerField(5, repeated=True, variant=_messages.Variant.INT32)
  stringColumn = _messages.MessageField('StringColumn', 6)


class ColumnInfo(_messages.Message):
  r"""Column info.

  Enums:
    ColumnTypeValueValuesEnum: Optional. Whether the column is dimension or
      metric.

  Fields:
    columnData: Required. Column data.
    columnName: Optional. Column name.
    columnType: Optional. Whether the column is dimension or metric.
  """

  class ColumnTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Whether the column is dimension or metric.

    Values:
      COLUMN_TYPE_UNSPECIFIED: Unspecified column type.
      COLUMN_TYPE_DIMENSION: Dimension column type.
      COLUMN_TYPE_METRIC: Metric column type.
    """
    COLUMN_TYPE_UNSPECIFIED = 0
    COLUMN_TYPE_DIMENSION = 1
    COLUMN_TYPE_METRIC = 2

  columnData = _messages.MessageField('ColumnData', 1)
  columnName = _messages.StringField(2)
  columnType = _messages.EnumField('ColumnTypeValueValuesEnum', 3)


class ColumnSchema(_messages.Message):
  r"""Captures a columns name, data type, and kind (i.e., dimension, metric,
  etc.)

  Enums:
    KindValueValuesEnum: Optional. The kind of the column.
    ModeValueValuesEnum: Optional. The field's mode, e.g., NULLABLE, REQUIRED,
      REPEATED.
    TypeValueValuesEnum: Optional. The data type of the column's values.

  Fields:
    column: Optional. The column name.
    description: Optional. Textual description of the column.
    kind: Optional. The kind of the column.
    mode: Optional. The field's mode, e.g., NULLABLE, REQUIRED, REPEATED.
    sqlCalculation: Optional. SQL string contain the metric's definition.
    subcolumns: Optional. Schema of sub-columns. A column can have zero or
      more sub-columns.
    type: Optional. The data type of the column's values.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Optional. The kind of the column.

    Values:
      KIND_UNSPECIFIED: Unspecified kind.
      DIMENSION: The column represents a dimension.
      MEASURE: The column represents a measurement.
      NESTED: The column contains a nested schema.
    """
    KIND_UNSPECIFIED = 0
    DIMENSION = 1
    MEASURE = 2
    NESTED = 3

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. The field's mode, e.g., NULLABLE, REQUIRED, REPEATED.

    Values:
      MODE_UNSPECIFIED: Unspecified mode.
      NULLABLE: The field is nullable.
      REQUIRED: The field is required.
      REPEATED: The field is repeated.
    """
    MODE_UNSPECIFIED = 0
    NULLABLE = 1
    REQUIRED = 2
    REPEATED = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The data type of the column's values.

    Values:
      TYPE_UNSPECIFIED: Unspecified
      INT32: int32
      INT64: int64
      UINT32: uint32
      UINT64: uint64
      BOOL: bool
      FLOAT: float
      DOUBLE: double
      STRING: string
      BYTES: bytes
      DATE: dates
      TIMESTAMP: timestamp
      ENUM: enum
      ARRAY: array
      STRUCT: struct (nested)
      PROTO: proto (nested)
      TIME: time
      DATETIME: datetime
      GEOGRAPHY: geography
      NUMERIC: numeric
      BIGNUMERIC: bignumeric
      EXTENDED: extended
      JSON: JSON.
      INTERVAL: INTERVAL value (go/googlesql_interval_type)
      TOKENLIST: tokenlist
      RANGE: range
      GRAPH_ELEMENT: graph element
      MAP: map
      DECIMAL: decimal
      OTHER: other cases
    """
    TYPE_UNSPECIFIED = 0
    INT32 = 1
    INT64 = 2
    UINT32 = 3
    UINT64 = 4
    BOOL = 5
    FLOAT = 6
    DOUBLE = 7
    STRING = 8
    BYTES = 9
    DATE = 10
    TIMESTAMP = 11
    ENUM = 12
    ARRAY = 13
    STRUCT = 14
    PROTO = 15
    TIME = 16
    DATETIME = 17
    GEOGRAPHY = 18
    NUMERIC = 19
    BIGNUMERIC = 20
    EXTENDED = 21
    JSON = 22
    INTERVAL = 23
    TOKENLIST = 24
    RANGE = 25
    GRAPH_ELEMENT = 26
    MAP = 27
    DECIMAL = 28
    OTHER = 29

  column = _messages.StringField(1)
  description = _messages.StringField(2)
  kind = _messages.EnumField('KindValueValuesEnum', 3)
  mode = _messages.EnumField('ModeValueValuesEnum', 4)
  sqlCalculation = _messages.StringField(5)
  subcolumns = _messages.MessageField('ColumnSchema', 6, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class ContextRetrievalError(_messages.Message):
  r"""Error details related to context retrieval request.

  Fields:
    rankingRetrievalError: Error details related to the RankingObjects call.
    tableRetrievalError: Error details related to table retrieval.
  """

  rankingRetrievalError = _messages.MessageField('RankingRetrievalError', 1, repeated=True)
  tableRetrievalError = _messages.MessageField('TableRetrievalError', 2, repeated=True)


class Customization(_messages.Message):
  r"""Customized translation instructions and rules specified by users when
  translating the query.

  Fields:
    instructions: Optional. Prompt instructions for LLM to better understand
      the customization task.
    translationRules: Optional. A list of customized translation rules.
  """

  instructions = _messages.StringField(1)
  translationRules = _messages.MessageField('TranslationRule', 2, repeated=True)


class DataModel(_messages.Message):
  r"""A data model includes all the user's databases and tables available in a
  data anlytics product context with their associated schemas.

  Fields:
    datasets: Optional. The datasets available in the data model.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)


class Database(_messages.Message):
  r"""Captures a database name and it's tables with their associated schemas.

  Fields:
    database: Optional. The database name.
    tables: Optional. The tables in the dataset / database.
  """

  database = _messages.StringField(1)
  tables = _messages.MessageField('Table', 2, repeated=True)


class Dataset(_messages.Message):
  r"""A dataset could be an inline description of a database's table schemas
  or a reference to a BigQuery dataset.

  Fields:
    bigqueryDatasetReference: A reference to the bigquery dataset.
    database: A database.
  """

  bigqueryDatasetReference = _messages.MessageField('BigQueryDatasetReference', 1)
  database = _messages.MessageField('Database', 2)


class DatetimeColumn(_messages.Message):
  r"""The datetime column values of table/chart to be summarized.

  Fields:
    values: Required. Column values of type datetime-string e.g. 02/02/2024:
      03:00pm.
  """

  values = _messages.StringField(1, repeated=True)


class DisplayContext(_messages.Message):
  r"""Represents context about the display requirements of the output.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product specific
      UI/client context.

  Fields:
    additionalContext: Optional. Represents GCP product specific UI/client
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product specific UI/client context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class DoubleColumn(_messages.Message):
  r"""The double column values of table/chart to be summarized.

  Fields:
    values: Required. Column values of type double.
  """

  values = _messages.FloatField(1, repeated=True)


class DoubleParameterArray(_messages.Message):
  r"""This message only contains a field of double number array.

  Fields:
    doubleValues: Double number array.
  """

  doubleValues = _messages.FloatField(1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Enablement(_messages.Message):
  r"""The enablement resource which indicates that a product is enabled for a
  project.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. Create timestamp.
    labels: Optional. Labels as key value pairs.
    name: Identifier. The name of the enablement. Format:
      projects/{project}/locations/{location}/enablement/{enablement_id}
    product: Required. The product that is being enabled.
    purgeTime: Output only. Purge timestamp, set only if the enablement is
      soft deleted.
    updateTime: Output only. Update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  product = _messages.MessageField('Product', 4)
  purgeTime = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class ErrorCatcherConfig(_messages.Message):
  r"""Configuration detail of a error catch task

  Fields:
    description: Optional. User-provided description intended to give more
      business context about the error catcher config.
    errorCatcherId: Required. An error catcher id is string representation for
      the error catcher config. Within a workflow, error_catcher_id uniquely
      identifies an error catcher config among all error catcher configs for
      the workflow
    errorCatcherNumber: Required. A number to uniquely identify each error
      catcher config within the workflow on UI.
    label: Optional. The user created label for a particular error catcher.
      Optional.
    startErrorTasks: Required. The set of start tasks that are to be executed
      for the error catch flow
  """

  description = _messages.StringField(1)
  errorCatcherId = _messages.StringField(2)
  errorCatcherNumber = _messages.StringField(3)
  label = _messages.StringField(4)
  startErrorTasks = _messages.MessageField('NextTask', 5, repeated=True)


class ErrorDetails(_messages.Message):
  r"""During SQL generation, when running into certain types of error, we will
  not fail the entire request. Instead, we save the error details in the
  response and return them to the caller.

  Fields:
    contextRetrievalError: Error details related to context retrieval request.
  """

  contextRetrievalError = _messages.MessageField('ContextRetrievalError', 1)


class EvaluationOptions(_messages.Message):
  r"""Evaluation parameters. Only used in evaluation runs.

  Fields:
    returnRawModelResponse: Optional. Whether to include in the API response
      the raw chart specification generated by the model, before applying
      post-processing steps.
  """

  returnRawModelResponse = _messages.BooleanField(1)


class EventIdMessage(_messages.Message):
  r"""An EventId is a 128 bit identifier that uniquely identifies an event,
  such as a query. The event time recorded to the nearest microsecond, along
  with information about the process generating the event, ensures that all
  EventIds are unique. Details of this EventId are described in a design
  document: http://www/eng/designdocs/sawmill/adlogs.html

  Fields:
    processId: process_id is an integer that identifies the process on this
      machine that generated this event. This id is calculated once when the
      server generates its first event, and may change if the process is
      migrated to a different host. This field has a very specific format
      mandated by the logs collection infrastructure, which is subject to
      change WITHOUT NOTICE. As of 2013-01-09, this format is: uint32
      process_id = (time(NULL) << 24) + (getpid() & 0xFFFFFF); If you are
      generating an extended_pid directly, you MUST use one of the maintained
      library implementations in order to generate it properly: C++
      //borg/borgletlib:extended_pid; call borg::ExtendedPid() Python
      //borg/borgletlib/python:pyextendedpid; call ExtendedPid() Go
      //borg/borgletlib/go:extendedpid; call Get() Java
      //java/com/google/common/logging; call EventId.getPid() If you think
      that you need to parse the values of this field, please contact logs-
      collection-dev@ to discuss your requirement.
    serverIp: server_ip is the IPv4 address or http://go/ghostid of the
      machine running the server that created this event message. This allows
      us to distinguish between events that occur at the same time on
      different servers. Format: 10.1.2.3 is stored as 0x0a010203, and GHostId
      1 as 0x00000001.
    timeUsec: time_usec is the number of microseconds since the epoch (i.e.,
      since 1970-01-01 00:00:00 UTC) as an int64: 1e6 * (unix time) +
      microseconds. Applications must ensure that EventIdMessages have
      increasing times, artificially increasing time_usec to one greater than
      the previous value if necessary. Alternate implementations were
      considered: 1. storing unix time and microseconds separately would
      require a bit more storage, and the convenience of having a single value
      representing the time seemed more useful than having trivial access to a
      unix time. 2. storing unix time in the upper 32 bits would allow for
      more precision - up to 4G events/second, but it wouldn't print nicely as
      a decimal value and it seems unlikely that any single server would ever
      sustain more than 1M events/second. 3. Java-compatible time uses millis
      - this would limit servers to 1000 events per second - too small. Other
      names for this field were considered, including time, time_stamp, and
      utime. We felt that including the units in the name would tend to
      produce more readable code. utime might be interpreted as user time.
  """

  processId = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  serverIp = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  timeUsec = _messages.IntegerField(3)


class EventParameter(_messages.Message):
  r"""This message is used for processing and persisting (when applicable) key
  value pair parameters for each event in the event bus.

  Fields:
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
    value: Values for the defined keys. Each value can either be string, int,
      double or any proto message.
  """

  key = _messages.StringField(1)
  value = _messages.MessageField('ValueType', 2)


class ExperienceContext(_messages.Message):
  r"""The specific Duet product and flow a request belongs to. E.g. Appsheet
  code generation ("/appsheet/generate").

  Fields:
    experience: Required. The Duet experience that this request belongs to.
  """

  experience = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class File(_messages.Message):
  r"""Additional files to be included as part of prompt.

  Enums:
    IncludedReasonValueValuesEnum: Rationale for why this file was included

  Fields:
    content: The content in the file. Can be the entire file or just a
      snippet.
    includedReason: Rationale for why this file was included
    path: The absolute path for a file.
  """

  class IncludedReasonValueValuesEnum(_messages.Enum):
    r"""Rationale for why this file was included

    Values:
      UNKNOWN: Unknown reason.
      CURRENTLY_OPEN: The file is currently open.
      RECENTLY_OPENED: The file is opened recently.
      RECENTLY_EDITED: The file is edited recently.
      COLOCATED: The file is located within the same directory.
      RELATED_FILE: Included based on relation to code around the cursor (e.g:
        could be provided by local IDE analysis)
    """
    UNKNOWN = 0
    CURRENTLY_OPEN = 1
    RECENTLY_OPENED = 2
    RECENTLY_EDITED = 3
    COLOCATED = 4
    RELATED_FILE = 5

  content = _messages.StringField(1)
  includedReason = _messages.EnumField('IncludedReasonValueValuesEnum', 2)
  path = _messages.StringField(3)


class GenerateChatRequest(_messages.Message):
  r"""Next ID: 4

  Fields:
    context: Context for the chat request, including history.
    userMessage: Input from user.
  """

  context = _messages.MessageField('ChatContext', 1)
  userMessage = _messages.StringField(2)


class GenerateChatResponse(_messages.Message):
  r"""Next ID: 7

  Fields:
    blocked: A flag indicating if the input or output was blocked.
    citationMetadata: Citation metadata. 1-1 mapping to `response_chunks`.
    linkValidationMetadata: Link validation metadata. 1-1 mapping to
      `response_chunks`.
    navigationLink: Most relevant Cloud Console link to the response. 1-1
      mapping to `response_chunks`.
    relatedContent: Related content and search links for the chat results. 1-1
      mapping to `response_chunks`.
    responseChunks: List of chat responses.
  """

  blocked = _messages.BooleanField(1)
  citationMetadata = _messages.MessageField('AtlasCitationMetadata', 2, repeated=True)
  linkValidationMetadata = _messages.MessageField('AtlasLinkValidationMetadata', 3, repeated=True)
  navigationLink = _messages.MessageField('AtlasNavigationLink', 4, repeated=True)
  relatedContent = _messages.MessageField('AtlasRelatedContent', 5, repeated=True)
  responseChunks = _messages.MessageField('ResponseChunk', 6, repeated=True)


class GenerateCodeRequest(_messages.Message):
  r"""GenerateCodeRequest is a request for the GenerateCode RPC.

  Fields:
    prompt: Optional. The prompt to be passed to the LLM.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended.
  """

  prompt = _messages.MessageField('CodePrompt', 1)
  requestId = _messages.StringField(2)


class GenerateCodeResponse(_messages.Message):
  r"""GenerateCodeResponse is a response for the GenerateCode RPC.

  Fields:
    suggestions: suggestions contains the generated suggestions.
  """

  suggestions = _messages.MessageField('Suggestion', 1, repeated=True)


class GenerateDataInsightsRequest(_messages.Message):
  r"""Request for data summarization.

  Enums:
    ClientTypeValueValuesEnum: Required. Client ID assigned for the incoming
      request.

  Fields:
    chartData: Chart data.
    clientType: Required. Client ID assigned for the incoming request.
  """

  class ClientTypeValueValuesEnum(_messages.Enum):
    r"""Required. Client ID assigned for the incoming request.

    Values:
      CLIENT_TYPE_UNSPECIFIED: Unspecified client ID.
      DUET_AI_IN_LOOKER_AUTO_SLIDEGEN: Summary and insights in Looker Auto
        Slidegen.
      DATAPORT: Summary and insights in DataPort.
      EVAL_PIPELINE: Summary and insights in Eval Pipeline.
      LOOKER_STUDIO_CONVERSATIONAL_NOTEBOOK: Summary and insights in Looker
        Studio Conversational Notebook.
    """
    CLIENT_TYPE_UNSPECIFIED = 0
    DUET_AI_IN_LOOKER_AUTO_SLIDEGEN = 1
    DATAPORT = 2
    EVAL_PIPELINE = 3
    LOOKER_STUDIO_CONVERSATIONAL_NOTEBOOK = 4

  chartData = _messages.MessageField('ChartData', 1)
  clientType = _messages.EnumField('ClientTypeValueValuesEnum', 2)


class GenerateDataInsightsResponse(_messages.Message):
  r"""Response for the data summarization request.

  Fields:
    responseItems: Data summary response items.
  """

  responseItems = _messages.MessageField('ResponseItem', 1, repeated=True)


class GeneratePythonContext(_messages.Message):
  r"""Context for python code generation

  Enums:
    PythonApiValueValuesEnum: Optional. Specific python API to use for code
      generation

  Fields:
    notebookCells: Optional. Previous cells in the python notebook
    pythonApi: Optional. Specific python API to use for code generation
    pythonApiVersion: Optional. Version of Python API
    pythonVersion: Optional. Version of Python
  """

  class PythonApiValueValuesEnum(_messages.Enum):
    r"""Optional. Specific python API to use for code generation

    Values:
      PYTHON_API_UNSPECIFIED: No specific python API
      PYSPARK: PySpark
      BIG_FRAME: BigQuery's BigFrame
      PANDAS: Pandas
    """
    PYTHON_API_UNSPECIFIED = 0
    PYSPARK = 1
    BIG_FRAME = 2
    PANDAS = 3

  notebookCells = _messages.MessageField('NotebookCell', 1, repeated=True)
  pythonApi = _messages.EnumField('PythonApiValueValuesEnum', 2)
  pythonApiVersion = _messages.StringField(3)
  pythonVersion = _messages.StringField(4)


class GeneratePythonRequest(_messages.Message):
  r"""API for generating Python code from natural language queries This API is
  under development and subject to change

  Fields:
    context: Optional. Client-provided contextual information. The service
      will process and extend this to generate context for the SQL generation
    query: Required. User prompt for python code generation
  """

  context = _messages.MessageField('GeneratePythonContext', 1)
  query = _messages.StringField(2)


class GeneratePythonResponse(_messages.Message):
  r"""API response of Python code generation

  Fields:
    code: Optional. The python code generated
    errors: Optional. Errors encountered during code generation
  """

  code = _messages.StringField(1)
  errors = _messages.StringField(2, repeated=True)


class InferSchemaRequest(_messages.Message):
  r"""Request to infer schema on raw file contents. NOTE: This API is under
  development and SUBJECT TO CHANGE.

  Fields:
    rawFileContents: Required. Raw file contents where schema is inferred
      upon. Currently it is expected that the contents are in CSV format, yet
      this is subject to change.
  """

  rawFileContents = _messages.StringField(1)


class InferSchemaResponse(_messages.Message):
  r"""Response with inferred schema. NOTE: This API is under development and
  SUBJECT TO CHANGE.

  Fields:
    inferredColumnInfo: Optional. A list of inferred column information.
  """

  inferredColumnInfo = _messages.MessageField('InferredColumnInfo', 1, repeated=True)


class InferredColumnInfo(_messages.Message):
  r"""Inferred column information.

  Enums:
    ColumnTypeValueValuesEnum: Optional. Inferred column type.

  Fields:
    columnId: Optional. Id of inferred column.
    columnName: Optional. Inferred column name.
    columnType: Optional. Inferred column type.
  """

  class ColumnTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Inferred column type.

    Values:
      UNKNOWN: Unknown column type.
      STRING: String column type.
      BOOL: Bool column type
      FLOAT64: Float64 column type
      INT64: INT64 column type
      DATE: Date column type
      TIMESTAMP: TIMESTAMP column type
    """
    UNKNOWN = 0
    STRING = 1
    BOOL = 2
    FLOAT64 = 3
    INT64 = 4
    DATE = 5
    TIMESTAMP = 6

  columnId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  columnName = _messages.StringField(2)
  columnType = _messages.EnumField('ColumnTypeValueValuesEnum', 3)


class InputDataContext(_messages.Message):
  r"""Intended to hold customer content over and above what is present in the
  `input` field.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product-specific source
      code context.

  Fields:
    additionalContext: Optional. Represents GCP product-specific source code
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product-specific source code context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class IntParameterArray(_messages.Message):
  r"""This message only contains a field of integer array.

  Fields:
    intValues: Integer array.
  """

  intValues = _messages.IntegerField(1, repeated=True)


class IntegrationBranch(_messages.Message):
  r"""An integration branch skeleton containing basic fields which can be used
  to create an integration branch on the UI.

  Fields:
    branchCondition: The condition for the branch.
    explanation: Explanation of why this integration branch was generated.
    integrationParameters: The newly generated workflow parameters.
    taskConfigs: The newly generated tasks which can be branched into the
      current integration.
  """

  branchCondition = _messages.StringField(1)
  explanation = _messages.StringField(2)
  integrationParameters = _messages.MessageField('IntegrationParameter', 3, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 4, repeated=True)


class IntegrationBranchRequest(_messages.Message):
  r"""The request for generating an integration branch.

  Fields:
    branchCondition: Optional. The condition for the particular branch which
      the user selected.
    integrationParameters: Optional. A list of all the workflow parameters of
      the current integration.
    taskConfigs: Required. A list of all the tasks of the current integration.
  """

  branchCondition = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 3, repeated=True)


class IntegrationBranchResponse(_messages.Message):
  r"""The response containing an integration branch.

  Fields:
    integrationBranch: The integration branch returned by Duet
  """

  integrationBranch = _messages.MessageField('IntegrationBranch', 1)


class IntegrationDocumentRequest(_messages.Message):
  r"""The request for generating description of an integration.

  Fields:
    integrationVersion: Required. The current integrtion on the canvas.
  """

  integrationVersion = _messages.MessageField('IntegrationVersion', 1)


class IntegrationDocumentResponse(_messages.Message):
  r"""The response containing the integration description.

  Fields:
    document: The description of the integration returned by Duet AI.
  """

  document = _messages.StringField(1)


class IntegrationParameter(_messages.Message):
  r"""Integration Parameter is defined in the integration config and are used
  to provide information about data types of the expected parameters and
  provide any default values if needed. They can also be used to add custom
  attributes. These are static in nature and should not be used for dynamic
  event definition.

  Enums:
    DataTypeValueValuesEnum: Type of the parameter.
    InputOutputTypeValueValuesEnum: Specifies the input/output type for the
      parameter.

  Fields:
    dataType: Type of the parameter.
    defaultValue: Default values for the defined keys. Each value can either
      be string, int, double or any proto message or a serialized object.
    displayName: The name (without prefix) to be displayed in the UI for this
      parameter. E.g. if the key is "foo.bar.myName", then the name would be
      "myName".
    inputOutputType: Specifies the input/output type for the parameter.
    isTransient: Whether this parameter is a transient parameter.
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
  """

  class DataTypeValueValuesEnum(_messages.Enum):
    r"""Type of the parameter.

    Values:
      INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED: Unspecified.
      STRING_VALUE: String.
      INT_VALUE: Integer.
      DOUBLE_VALUE: Double Number.
      BOOLEAN_VALUE: Boolean.
      STRING_ARRAY: String Array.
      INT_ARRAY: Integer Array.
      DOUBLE_ARRAY: Double Number Array.
      BOOLEAN_ARRAY: Boolean Array.
      JSON_VALUE: Json.
      PROTO_VALUE: Proto Value (Internal use only).
      PROTO_ARRAY: Proto Array (Internal use only).
    """
    INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED = 0
    STRING_VALUE = 1
    INT_VALUE = 2
    DOUBLE_VALUE = 3
    BOOLEAN_VALUE = 4
    STRING_ARRAY = 5
    INT_ARRAY = 6
    DOUBLE_ARRAY = 7
    BOOLEAN_ARRAY = 8
    JSON_VALUE = 9
    PROTO_VALUE = 10
    PROTO_ARRAY = 11

  class InputOutputTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the input/output type for the parameter.

    Values:
      IN_OUT_TYPE_UNSPECIFIED: Default.
      IN: Input parameters for the integration. EventBus validates that these
        parameters exist in the integrations before execution.
      OUT: Output Parameters for the integration. EventBus will only return
        the integration parameters tagged with OUT in the response back.
      IN_OUT: Input and Output Parameters. These can be used as both input and
        output. EventBus will validate for the existence of these parameters
        before execution and will also return this parameter back in the
        response.
    """
    IN_OUT_TYPE_UNSPECIFIED = 0
    IN = 1
    OUT = 2
    IN_OUT = 3

  dataType = _messages.EnumField('DataTypeValueValuesEnum', 1)
  defaultValue = _messages.MessageField('ValueType', 2)
  displayName = _messages.StringField(3)
  inputOutputType = _messages.EnumField('InputOutputTypeValueValuesEnum', 4)
  isTransient = _messages.BooleanField(5)
  key = _messages.StringField(6)


class IntegrationSkeleton(_messages.Message):
  r"""An integration skeleton containing basic fields which can be used to
  create an integration on the UI.

  Fields:
    explanation: Explanation of why this integration was generated.
    integrationVersion: The integration version containing basic triggers and
      tasks.
    name: The name of the integration.
    tag: Indicate the strategy/methodology used to generate the integration.
  """

  explanation = _messages.StringField(1)
  integrationVersion = _messages.MessageField('IntegrationVersion', 2)
  name = _messages.StringField(3)
  tag = _messages.StringField(4)


class IntegrationSkeletonsResponse(_messages.Message):
  r"""The response containing a list of integrations.

  Fields:
    skeletonIntegrations: The list of integration skeletons returned by Duet
      AI.
  """

  skeletonIntegrations = _messages.MessageField('IntegrationSkeleton', 1, repeated=True)


class IntegrationVersion(_messages.Message):
  r"""The integration version definition.

  Fields:
    description: Optional. The integration description.
    errorCatcherConfigs: Optional. Error Catch Task configuration for the
      integration. It's optional.
    integrationParameters: Optional. Parameters that are expected to be passed
      to the integration when an event is triggered. This consists of all the
      parameters that are expected in the integration execution. This gives
      the user the ability to provide default values, add information like PII
      and also provide data types of each parameter.
    name: Optional. Auto-generated primary key.
    taskConfigs: Optional. Task configuration for the integration. It's
      optional, but the integration doesn't do anything without task_configs.
    triggerConfigs: Optional. Trigger configurations.
  """

  description = _messages.StringField(1)
  errorCatcherConfigs = _messages.MessageField('ErrorCatcherConfig', 2, repeated=True)
  integrationParameters = _messages.MessageField('IntegrationParameter', 3, repeated=True)
  name = _messages.StringField(4)
  taskConfigs = _messages.MessageField('TaskConfig', 5, repeated=True)
  triggerConfigs = _messages.MessageField('TriggerConfig', 6, repeated=True)


class ListCodeRepositoryIndexesResponse(_messages.Message):
  r"""Message for response to listing CodeRepositoryIndexes

  Fields:
    codeRepositoryIndexes: The list of CodeRepositoryIndex
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  codeRepositoryIndexes = _messages.MessageField('CodeRepositoryIndex', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListEnablementsResponse(_messages.Message):
  r"""Response message for ListEnablements.

  Fields:
    enablements: The enablements for the specified project and location.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  enablements = _messages.MessageField('Enablement', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRepositoryGroupsResponse(_messages.Message):
  r"""Message for response to listing RepositoryGroups

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    repositoryGroups: The list of RepositoryGroup
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  repositoryGroups = _messages.MessageField('RepositoryGroup', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LongColumn(_messages.Message):
  r"""The long column values of table/chart to be summarized.

  Fields:
    values: Required. Column values of type long.
  """

  values = _messages.IntegerField(1, repeated=True)


class ModelOptions(_messages.Message):
  r"""Explicit Vertex AI model, parameters to use in handling a request. See
  also https://cloud.google.com/vertex-ai/docs/generative-ai/text/test-text-
  prompts.

  Fields:
    maxOutputTokens: Optional. The max_output_tokens model parameter.
    modelId: Optional. The Vertex AI model to use, e.g., code-bison@001, text-
      bison@001, etc.
    projectId: Optional. The project to use on the Vertex AI model endpoint
      path.
    temperature: Optional. The temperature model parameter.
    topK: Optional. The Top-K model parameter.
    topP: Optional. The Top-P model parameter.
  """

  maxOutputTokens = _messages.FloatField(1)
  modelId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  temperature = _messages.FloatField(4)
  topK = _messages.FloatField(5)
  topP = _messages.FloatField(6)


class NextTask(_messages.Message):
  r"""The task that is next in line to be executed, if the condition specified
  evaluated to true.

  Fields:
    condition: Standard filter expression for this task to become an eligible
      next task.
    description: User-provided description intended to give additional
      business context about the task.
    displayName: User-provided label that is attached to this edge in the UI.
    taskConfigId: ID of the next task.
    taskId: Task number of the next task.
  """

  condition = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  taskConfigId = _messages.StringField(4)
  taskId = _messages.StringField(5)


class NotebookCell(_messages.Message):
  r"""Cell of a python notebook

  Fields:
    codeCell: Code cell type
    textCell: Text cell type
  """

  codeCell = _messages.MessageField('NotebookCodeCell', 1)
  textCell = _messages.MessageField('NotebookTextCell', 2)


class NotebookCodeCell(_messages.Message):
  r"""Code cell type

  Fields:
    code: Optional. Python code
  """

  code = _messages.StringField(1)


class NotebookTextCell(_messages.Message):
  r"""Text cell type

  Fields:
    text: Optional. Text content
  """

  text = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OutputDataContext(_messages.Message):
  r"""Intended to hold LLM-generated content over and above what is present in
  the `predictions` field. E.g. tooltip instructions.

  Messages:
    AdditionalContextValue: Optional. Represents GCP product specific source
      code context.

  Fields:
    additionalContext: Optional. Represents GCP product specific source code
      context.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalContextValue(_messages.Message):
    r"""Optional. Represents GCP product specific source code context.

    Messages:
      AdditionalProperty: An additional property for a AdditionalContextValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContext = _messages.MessageField('AdditionalContextValue', 1)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Product(_messages.Message):
  r"""The product that is being enabled.

  Enums:
    TypeValueValuesEnum: Required. The type of product that is being enabled.

  Fields:
    type: Required. The type of product that is being enabled.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of product that is being enabled.

    Values:
      TYPE_UNSPECIFIED: Unspecified product type.
      GEMINI_CLOUD_ASSIST: Gemini Cloud Assist.
    """
    TYPE_UNSPECIFIED = 0
    GEMINI_CLOUD_ASSIST = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class PromptContext(_messages.Message):
  r"""Context to be passed to the SQLGen server to create relevant SQL
  queries.

  Fields:
    evidenceStatement: Optional. A list of example evidence statements that
      the model should honor in a best effort fashion.
    instructions: Optional. A list of instructions that the model should honor
      in a best effort fashion.
    schemaDetails: Schema details; for now all the tables and views in the
      catalog.
  """

  evidenceStatement = _messages.StringField(1, repeated=True)
  instructions = _messages.StringField(2, repeated=True)
  schemaDetails = _messages.MessageField('SchemaDetails', 3)


class QueryGrammar(_messages.Message):
  r"""Information about the dialect and product to generate SQL in.

  Enums:
    ProductValueValuesEnum: Product of the database. Allows the LLM to know
      what features are supported to generate a query.
    QueryDialectValueValuesEnum: Query dialect.

  Fields:
    product: Product of the database. Allows the LLM to know what features are
      supported to generate a query.
    productVersion: Version of the product.
    queryDialect: Query dialect.
  """

  class ProductValueValuesEnum(_messages.Enum):
    r"""Product of the database. Allows the LLM to know what features are
    supported to generate a query.

    Values:
      PRODUCT_UNSPECIFIED: Unspecified product.
      SPANNER: Spanner.
      BIGQUERY_SQL_EDITOR_C2C: BigQuery SQL Editor Comment to code.
      ALLOYDB: AlloyDB.
      MYSQL: MySql.
      POSTGRESQL: PostgreSQL.
      SQL_SERVER: SQL Server.
      BIGQUERY_SQL_EDITOR_WIDGET: BigQuery SQL Editor Widget.
      BIGQUERY_DATA_CANVAS: BigQuery data canvas.
      ALCHEMIST: Alchemist.
      OBSERVABILITY_ANALYTICS: Observability Analytics.
      ALCHEMIST_LOOKER: Looker backed datasource for Alchemist.
    """
    PRODUCT_UNSPECIFIED = 0
    SPANNER = 1
    BIGQUERY_SQL_EDITOR_C2C = 2
    ALLOYDB = 3
    MYSQL = 4
    POSTGRESQL = 5
    SQL_SERVER = 6
    BIGQUERY_SQL_EDITOR_WIDGET = 7
    BIGQUERY_DATA_CANVAS = 8
    ALCHEMIST = 9
    OBSERVABILITY_ANALYTICS = 10
    ALCHEMIST_LOOKER = 11

  class QueryDialectValueValuesEnum(_messages.Enum):
    r"""Query dialect.

    Values:
      QUERY_DIALECT_ENUM_UNSPECIFIED: Unspecified dialect.
      POSTGRESQL_DIALECT: PostgreSQL.
      MYSQL_DIALECT: MySQL.
      SQL_SERVER_DIALECT: SQL Server.
      GOOGLE_SQL_DIALECT: Google SQL.
      STUDIO_SQL_DIALECT: Studio SQL
    """
    QUERY_DIALECT_ENUM_UNSPECIFIED = 0
    POSTGRESQL_DIALECT = 1
    MYSQL_DIALECT = 2
    SQL_SERVER_DIALECT = 3
    GOOGLE_SQL_DIALECT = 4
    STUDIO_SQL_DIALECT = 5

  product = _messages.EnumField('ProductValueValuesEnum', 1)
  productVersion = _messages.StringField(2)
  queryDialect = _messages.EnumField('QueryDialectValueValuesEnum', 3)


class RankingRetrievalError(_messages.Message):
  r"""Error details related to the ranking call in the
  ContextRetrievalService.

  Fields:
    errorMessage: Error message from the ContextRetrievalService.
  """

  errorMessage = _messages.StringField(1)


class RawData(_messages.Message):
  r"""Raw chart data.

  Fields:
    columnInfo: Required. List of column info.
    rowSize: Required. Number of rows in the chart data.
  """

  columnInfo = _messages.MessageField('ColumnInfo', 1, repeated=True)
  rowSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ReplaceTaskRequest(_messages.Message):
  r"""Message for Replace Task Scenario.

  Fields:
    taskConfig: Required. The current task selected on the UI.
  """

  taskConfig = _messages.MessageField('TaskConfig', 1)


class ReplaceTaskResponse(_messages.Message):
  r"""Response proto for task recommendations.

  Enums:
    TaskTypesValueListEntryValuesEnum:

  Fields:
    taskConfigs: The list of recommended tasks.
    taskTypes: The list of task types.
  """

  class TaskTypesValueListEntryValuesEnum(_messages.Enum):
    r"""TaskTypesValueListEntryValuesEnum enum type.

    Values:
      TASK_TYPE_UNSPECIFIED: Unspecified.
      CONNECTOR_TASK: Connector Task.
      REST_TASK: Rest task.
    """
    TASK_TYPE_UNSPECIFIED = 0
    CONNECTOR_TASK = 1
    REST_TASK = 2

  taskConfigs = _messages.MessageField('TaskConfig', 1, repeated=True)
  taskTypes = _messages.EnumField('TaskTypesValueListEntryValuesEnum', 2, repeated=True)


class Repository(_messages.Message):
  r"""Repository contains RAG indexing settings for the provided Git
  repository

  Fields:
    branchPattern: Required. The Git branch pattern used for indexing in RE2
      syntax. See https://github.com/google/re2/wiki/syntax for syntax.
    remoteUri: Output only. Git Clone HTTPS URI.
    resource: Required. The link to the CloudBuild/DeveloperConnect repository
      resource name or URL to be indexed.
  """

  branchPattern = _messages.StringField(1)
  remoteUri = _messages.StringField(2)
  resource = _messages.StringField(3)


class RepositoryGroup(_messages.Message):
  r"""Message describing RepositoryGroup object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    repositories: Required. List of repositories to group
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  repositories = _messages.MessageField('Repository', 4, repeated=True)
  updateTime = _messages.StringField(5)


class ResponseChunk(_messages.Message):
  r"""Next ID: 3

  Fields:
    markdownResponse: Markdown text response.
  """

  markdownResponse = _messages.StringField(1)


class ResponseItem(_messages.Message):
  r"""Response for the data summarization request.

  Fields:
    summary: Optional. Summary of the data.
  """

  summary = _messages.StringField(1)


class SchemaDetails(_messages.Message):
  r"""Schema details; for now all the tables and views in the catalog. Might
  be extended later for different object types.

  Fields:
    tables: Optional. All the tables in the catalog.
    views: Optional. All the views in the catalog.
  """

  tables = _messages.MessageField('TableInfo', 1, repeated=True)
  views = _messages.MessageField('ViewInfo', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SqlGenCitation(_messages.Message):
  r"""Citation identifies which parts of content have a license

  Fields:
    endIndex: The index in the suggestion where the citation ends
    license: The applicable license for the citation, for example MIT, or
      omitted if the license type is not known.
    startIndex: The index in the suggestion where the citation begins
    uri: The source uri for the original content
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  startIndex = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  uri = _messages.StringField(4)


class SqlGenContext(_messages.Message):
  r"""Context for SQL generation

  Fields:
    database: Optional. The current database that the user is connecting to.
      We will consider this given database while generating query, mainly
      DDL/DML in MySQL as there can be multiple databases in one schema
      information.
    providers: Optional. A list of sources of contextual information to be
      used when answering
    queryGrammar: Optional. Information on how to generate the SQL query based
      on dialect and product.
  """

  database = _messages.StringField(1)
  providers = _messages.MessageField('SqlGenContextProvider', 2, repeated=True)
  queryGrammar = _messages.MessageField('QueryGrammar', 3)


class SqlGenContextProvider(_messages.Message):
  r"""Context provider for SQL generation

  Fields:
    promptContext: Information about various tables and views in the schema
      that may relate to the user question.
    schemaSearch: Specifies a search of accessible tables for tables relevant
      to the query
    tableReference: Specifies a particular table that may be relevant to the
      query
  """

  promptContext = _messages.MessageField('PromptContext', 1)
  schemaSearch = _messages.MessageField('SqlGenSchemaSearch', 2)
  tableReference = _messages.MessageField('SqlGenTableReference', 3)


class SqlGenRequest(_messages.Message):
  r"""API for generating SQL from natural language queries This API is under
  development and subject to change

  Enums:
    ClientValueValuesEnum: Optional. Client for SqlGen. The service will
      choose the atlas_experience_name based on the client. DEPRECATED
      2024-07-08: use `context.query_grammar.{query_grammar,product}` instead.

  Fields:
    client: Optional. Client for SqlGen. The service will choose the
      atlas_experience_name based on the client. DEPRECATED 2024-07-08: use
      `context.query_grammar.{query_grammar,product}` instead.
    context: Optional. Client-provided contextual information. The service
      will process and extend this to generate context for the SQL generation
    overrideProjectNumber: Optional. Override project number. Used by products
      that send their producer project in the `instance` field but need to
      pass on the originating customer's project number as an identifier in
      calls to dependent systems such as inference and context retrieval.
    parent: Optional. Active project and location in format
      projects/*/locations/* DEPRECATED 2024-02-16: use `instance` instead.
    query: Required. User query for sql generation
  """

  class ClientValueValuesEnum(_messages.Enum):
    r"""Optional. Client for SqlGen. The service will choose the
    atlas_experience_name based on the client. DEPRECATED 2024-07-08: use
    `context.query_grammar.{query_grammar,product}` instead.

    Values:
      SQL_GEN_CLIENT_UNSPECIFIED: Unspecified client.
      BIGQUERY_QUERY_EDITOR: BigQuery query editor client.
      BIGQUERY_DATA_CANVAS: BigQuery data canvas client.
      ALCHEMIST: Alchemist client.
    """
    SQL_GEN_CLIENT_UNSPECIFIED = 0
    BIGQUERY_QUERY_EDITOR = 1
    BIGQUERY_DATA_CANVAS = 2
    ALCHEMIST = 3

  client = _messages.EnumField('ClientValueValuesEnum', 1)
  context = _messages.MessageField('SqlGenContext', 2)
  overrideProjectNumber = _messages.StringField(3)
  parent = _messages.StringField(4)
  query = _messages.StringField(5)


class SqlGenResponse(_messages.Message):
  r"""API for generating SQL from natural language queries NEXT ID: 5

  Fields:
    anarresId: Unique ID to identify this request. Will be logged in Anarres
      logs.
    citations: Citations for generated suggestions that contain licensed code
    errorDetails: Optional. Error details inside SQL generation workflow.
    sql: Required. The generated SQL that, when executed, should answer the
      query
  """

  anarresId = _messages.MessageField('EventIdMessage', 1)
  citations = _messages.MessageField('SqlGenCitation', 2, repeated=True)
  errorDetails = _messages.MessageField('ErrorDetails', 3)
  sql = _messages.StringField(4)


class SqlGenSchemaSearch(_messages.Message):
  r"""Specification for a search of relevant table schema"""


class SqlGenTableReference(_messages.Message):
  r"""Reference to a SQL table

  Fields:
    bigqueryTableReference: Optional. BigQuery table reference
  """

  bigqueryTableReference = _messages.MessageField('BigQueryTableReference', 1)


class SqlTranslateRequest(_messages.Message):
  r"""API for translating a SQL query from source dialect to target dialect.
  This API is under development and subject to change.

  Enums:
    SourceDialectValueValuesEnum: Optional. The source SQL dialect of the
      query.
    TargetDialectValueValuesEnum: Optional. The target SQL dialect to
      translate to.

  Fields:
    query: Required. The query to be translated.
    sourceDialect: Optional. The source SQL dialect of the query.
    targetDialect: Optional. The target SQL dialect to translate to.
    translationContext: Optional. The contextual information used when
      translating the query.
  """

  class SourceDialectValueValuesEnum(_messages.Enum):
    r"""Optional. The source SQL dialect of the query.

    Values:
      SQL_TRANSLATE_SOURCE_DIALECT_UNSPECIFIED: SQL translate source dialect
        unspecified.
      ORACLE: Oracle SQL.
      MYSQL: MySQL.
    """
    SQL_TRANSLATE_SOURCE_DIALECT_UNSPECIFIED = 0
    ORACLE = 1
    MYSQL = 2

  class TargetDialectValueValuesEnum(_messages.Enum):
    r"""Optional. The target SQL dialect to translate to.

    Values:
      SQL_TRANSLATE_TARGET_DIALECT_UNSPECIFIED: SQL translate target dialect
        unspecified.
      BIGQUERY: BigQuery SQL.
    """
    SQL_TRANSLATE_TARGET_DIALECT_UNSPECIFIED = 0
    BIGQUERY = 1

  query = _messages.StringField(1)
  sourceDialect = _messages.EnumField('SourceDialectValueValuesEnum', 2)
  targetDialect = _messages.EnumField('TargetDialectValueValuesEnum', 3)
  translationContext = _messages.MessageField('TranslationContext', 4)


class SqlTranslateResponse(_messages.Message):
  r"""API for translating a SQL query from source dialect to target dialect.
  This API is under development and subject to change.

  Fields:
    translatedQuery: Required. Translated SQL query
  """

  translatedQuery = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringColumn(_messages.Message):
  r"""The string column values of table/chart to be summarized.

  Fields:
    values: Required. Column values of type string.
  """

  values = _messages.StringField(1, repeated=True)


class StringParameterArray(_messages.Message):
  r"""This message only contains a field of string array.

  Fields:
    stringValues: String array.
  """

  stringValues = _messages.StringField(1, repeated=True)


class Suggestion(_messages.Message):
  r"""Suggestion is a generated suggestion.

  Fields:
    citations: Citations for generated suggestions that contain licensed code
    content: content is the generated contents.
    score: Relative confidence in this suggestions. Higher is better.
  """

  citations = _messages.MessageField('Citation', 1, repeated=True)
  content = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class SummarizeDataRequest(_messages.Message):
  r"""Request for data summarization.

  Enums:
    ClientTypeValueValuesEnum: Required. Client ID assigned for the incoming
      request.

  Fields:
    chartData: Chart data.
    clientType: Required. Client ID assigned for the incoming request.
  """

  class ClientTypeValueValuesEnum(_messages.Enum):
    r"""Required. Client ID assigned for the incoming request.

    Values:
      CLIENT_TYPE_UNSPECIFIED: Unspecified client ID.
      DUET_AI_IN_LOOKER_AUTO_SLIDEGEN: Summary and insights in Looker Auto
        Slidegen.
      DATAPORT: Summary and insights in DataPort.
      EVAL_PIPELINE: Summary and insights in Eval Pipeline.
      LOOKER_STUDIO_CONVERSATIONAL_NOTEBOOK: Summary and insights in Looker
        Studio Conversational Notebook.
    """
    CLIENT_TYPE_UNSPECIFIED = 0
    DUET_AI_IN_LOOKER_AUTO_SLIDEGEN = 1
    DATAPORT = 2
    EVAL_PIPELINE = 3
    LOOKER_STUDIO_CONVERSATIONAL_NOTEBOOK = 4

  chartData = _messages.MessageField('ChartData', 1)
  clientType = _messages.EnumField('ClientTypeValueValuesEnum', 2)


class SummarizeDataResponse(_messages.Message):
  r"""Response for the data summarization request.

  Fields:
    responseItems: Data summary response items.
  """

  responseItems = _messages.MessageField('ResponseItem', 1, repeated=True)


class Table(_messages.Message):
  r"""LINT.IfChange Captures a table's name and schema.

  Fields:
    description: Optional. A user-friendly description of this table.
    schema: Optional. The table schema, i.e., column definitions.
    table: Identifier. The unique identifier for the table reference. Names
      are case-sensitive. Example for BigQuery Table:
      `projects/{project}/datasets/{dataset}/tables/{table}`.
  """

  description = _messages.StringField(1)
  schema = _messages.MessageField('TableSchema', 2)
  table = _messages.StringField(3)


class TableInfo(_messages.Message):
  r"""All relevant information about a table to generate SQL.

  Fields:
    columns: Optional. Table columns.
    table: Table name.
  """

  columns = _messages.MessageField('Column', 1, repeated=True)
  table = _messages.StringField(2)


class TableRetrievalError(_messages.Message):
  r"""Error details related to table retrieval.

  Fields:
    errorMessage: Table retrieval eror message, e.g. table not found, user
      doesn't have permission, etcs.
    table: Table name format:
      project_id/{project_id}/dataset_id/{dataset_id}/table_id/{table_id}
  """

  errorMessage = _messages.StringField(1)
  table = _messages.StringField(2)


class TableSchema(_messages.Message):
  r"""Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.

  Fields:
    columns: Optional. The unified GoogleSQL-like schema of columns.
  """

  columns = _messages.MessageField('ColumnSchema', 1, repeated=True)


class TaskCompletionInput(_messages.Message):
  r"""Input format for Task completion/multi-turn chat coversation.

  Fields:
    messages: Optional. Chat messages between 2 users. The messages are
      ordered by time with the zed value (0) being the oldest message.
    preamble: Text that should be provided to the model first to ground the
      response.
  """

  messages = _messages.MessageField('TaskCompletionMessage', 1, repeated=True)
  preamble = _messages.StringField(2)


class TaskCompletionMessage(_messages.Message):
  r"""Represents a single message.

  Fields:
    author: Author tag for the turn.
    content: Text content of the task completion/chat message.
  """

  author = _messages.StringField(1)
  content = _messages.StringField(2)


class TaskCompletionOutput(_messages.Message):
  r"""Output format for task completion/multi-turn chat.

  Fields:
    messages: The task completion/chat result generated from given message.
  """

  messages = _messages.MessageField('TaskCompletionMessage', 1, repeated=True)


class TaskCompletionRequest(_messages.Message):
  r"""Input for task completion.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `instances`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('TaskCompletionInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class TaskCompletionResponse(_messages.Message):
  r"""Output of task completion.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The task completion/chat output.
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('TaskCompletionOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class TaskConfig(_messages.Message):
  r"""The task configuration details. This is not the implementation of Task.
  There might be multiple TaskConfigs for the same Task.

  Enums:
    ExternalTaskTypeValueValuesEnum: Optional. External task type of the task

  Messages:
    ParametersValue: Optional. The customized parameters the user can pass to
      this task.

  Fields:
    description: Optional. User-provided description intended to give
      additional business context about the task.
    displayName: Optional. User-provided label that is attached to this
      TaskConfig in the UI.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    externalTaskType: Optional. External task type of the task
    nextTasks: Optional. The set of tasks that are next in line to be executed
      as per the execution graph defined for the parent event, specified by
      `event_config_id`. Each of these next tasks are executed only if the
      condition associated with them evaluates to true.
    parameters: Optional. The customized parameters the user can pass to this
      task.
    task: Optional. The name for the task.
    taskId: Required. The identifier of this task within its parent event
      config, specified by the client. This should be unique among all the
      tasks belong to the same event config. We use this field as the
      identifier to find next tasks (via field `next_tasks.task_id`).
  """

  class ExternalTaskTypeValueValuesEnum(_messages.Enum):
    r"""Optional. External task type of the task

    Values:
      EXTERNAL_TASK_TYPE_UNSPECIFIED: Default value. External task type is not
        specified
      NORMAL_TASK: Tasks belongs to the normal task flows
      ERROR_TASK: Task belongs to the error catch task flows
    """
    EXTERNAL_TASK_TYPE_UNSPECIFIED = 0
    NORMAL_TASK = 1
    ERROR_TASK = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The customized parameters the user can pass to this task.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A EventParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('EventParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  externalTaskType = _messages.EnumField('ExternalTaskTypeValueValuesEnum', 4)
  nextTasks = _messages.MessageField('NextTask', 5, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 6)
  task = _messages.StringField(7)
  taskId = _messages.StringField(8)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TextGenerationInput(_messages.Message):
  r"""Input format for Text Generation.

  Fields:
    prompt: The text snippet to make the predictions on.
  """

  prompt = _messages.StringField(1)


class TextGenerationOutput(_messages.Message):
  r"""Output format for Text Generation.

  Fields:
    content: The result generated from input text.
  """

  content = _messages.StringField(1)


class TextGenerationRequest(_messages.Message):
  r"""Input for text generation.

  Fields:
    backendResourcesContext: The GCP resources that the code generation
      process needs to reference
    clientContext: Client context (e.g. IDE name, version, etc)
    experienceContext: Duet product context -- required
    input: Represents the raw input for inference. It will be modified as part
      of prompt engineering and other transforms before it is consumed by the
      LLM.
    inputDataContext: Additional user content not captured in the `instances`
      field above
  """

  backendResourcesContext = _messages.MessageField('BackendResourcesContext', 1)
  clientContext = _messages.MessageField('ClientContext', 2)
  experienceContext = _messages.MessageField('ExperienceContext', 3)
  input = _messages.MessageField('TextGenerationInput', 4)
  inputDataContext = _messages.MessageField('InputDataContext', 5)


class TextGenerationResponse(_messages.Message):
  r"""Output of text generation.

  Fields:
    attributionContext: Attribution context
    displayContext: Output display context
    output: The generated text output
    outputDataContext: Additional generated data
  """

  attributionContext = _messages.MessageField('AttributionContext', 1)
  displayContext = _messages.MessageField('DisplayContext', 2)
  output = _messages.MessageField('TextGenerationOutput', 3)
  outputDataContext = _messages.MessageField('OutputDataContext', 4)


class TranslationContext(_messages.Message):
  r"""A TranslationContext object.

  Fields:
    customization: Optional. User customized translation context.
    cwTranslationReport: Optional. Translation report generated by
      CompilerWorks.
    translationRules: Optional. A list of translation rules used when
      translating the query. Deprecated, use `user_customization` instead.
  """

  customization = _messages.MessageField('Customization', 1)
  cwTranslationReport = _messages.MessageField('CWTranslationReport', 2)
  translationRules = _messages.MessageField('TranslationRule', 3, repeated=True)


class TranslationErrorRecord(_messages.Message):
  r"""Details about an error record.

  Fields:
    errorCategory: Optional. Category of the error.
    errorMessage: Optional. Detailed message of the error.
  """

  errorCategory = _messages.StringField(1)
  errorMessage = _messages.StringField(2)


class TranslationRule(_messages.Message):
  r"""Rules or examples to follow when translating the query.

  Fields:
    input: Optional. Input pattern.
    output: Optional. Output pattern
  """

  input = _messages.StringField(1)
  output = _messages.StringField(2)


class TriggerConfig(_messages.Message):
  r"""Configuration detail of a trigger.

  Enums:
    TriggerTypeValueValuesEnum: Optional. Type of trigger

  Messages:
    PropertiesValue: Optional. Configurable properties of the trigger, not to
      be confused with integration parameters. E.g. "name" is a property for
      API triggers and "subscription" is a property for Pub/sub triggers.

  Fields:
    cloudSchedulerConfig: Optional. Cloud Scheduler Trigger related metadata
    description: Optional. User-provided description intended to give
      additional business context about the task.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    label: Optional. The user created label for a particular trigger.
    properties: Optional. Configurable properties of the trigger, not to be
      confused with integration parameters. E.g. "name" is a property for API
      triggers and "subscription" is a property for Pub/sub triggers.
    startTasks: Optional. Set of tasks numbers from where the integration
      execution is started by this trigger. If this is empty, then integration
      is executed with default start tasks. In the list of start tasks, none
      of two tasks can have direct ancestor-descendant relationships (i.e. in
      a same integration execution graph).
    trigger: Optional. Name of the trigger. Example: "API Trigger", "Cloud Pub
      Sub Trigger" When set will be sent out to monitoring dashabord for
      tracking purpose.
    triggerId: Optional. The backend trigger ID.
    triggerNumber: Required. A number to uniquely identify each trigger config
      within the integration on UI.
    triggerType: Optional. Type of trigger
  """

  class TriggerTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of trigger

    Values:
      TRIGGER_TYPE_UNSPECIFIED: Unknown.
      CRON: Trigger by scheduled time.
      API: Trigger by API call.
      SFDC_CHANNEL: Trigger by Salesforce Channel.
      CLOUD_PUBSUB_EXTERNAL: Trigger by Pub/Sub external.
      SFDC_CDC_CHANNEL: SFDC Channel Trigger for CDC.
      CLOUD_SCHEDULER: Trigger by Cloud Scheduler job.
      INTEGRATION_CONNECTOR_TRIGGER: Trigger by Connector Event
      PRIVATE_TRIGGER: Trigger for private workflow
    """
    TRIGGER_TYPE_UNSPECIFIED = 0
    CRON = 1
    API = 2
    SFDC_CHANNEL = 3
    CLOUD_PUBSUB_EXTERNAL = 4
    SFDC_CDC_CHANNEL = 5
    CLOUD_SCHEDULER = 6
    INTEGRATION_CONNECTOR_TRIGGER = 7
    PRIVATE_TRIGGER = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. Configurable properties of the trigger, not to be confused
    with integration parameters. E.g. "name" is a property for API triggers
    and "subscription" is a property for Pub/sub triggers.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudSchedulerConfig = _messages.MessageField('CloudSchedulerConfig', 1)
  description = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  label = _messages.StringField(4)
  properties = _messages.MessageField('PropertiesValue', 5)
  startTasks = _messages.MessageField('NextTask', 6, repeated=True)
  trigger = _messages.StringField(7)
  triggerId = _messages.StringField(8)
  triggerNumber = _messages.StringField(9)
  triggerType = _messages.EnumField('TriggerTypeValueValuesEnum', 10)


class UndeleteEnablementRequest(_messages.Message):
  r"""Request message for UndeleteEnablement."""


class ValueType(_messages.Message):
  r"""The type of the parameter.

  Fields:
    booleanArray: Boolean Array.
    booleanValue: Boolean.
    doubleArray: Double Number Array.
    doubleValue: Double Number.
    intArray: Integer Array.
    intValue: Integer.
    jsonValue: Json.
    stringArray: String Array.
    stringValue: String.
  """

  booleanArray = _messages.MessageField('BooleanParameterArray', 1)
  booleanValue = _messages.BooleanField(2)
  doubleArray = _messages.MessageField('DoubleParameterArray', 3)
  doubleValue = _messages.FloatField(4)
  intArray = _messages.MessageField('IntParameterArray', 5)
  intValue = _messages.IntegerField(6)
  jsonValue = _messages.StringField(7)
  stringArray = _messages.MessageField('StringParameterArray', 8)
  stringValue = _messages.StringField(9)


class ViewInfo(_messages.Message):
  r"""All relevant information about a view to generate SQL.

  Fields:
    columns: Optional. View columns.
    view: View name.
  """

  columns = _messages.MessageField('Column', 1, repeated=True)
  view = _messages.StringField(2)


class VisualGenRequest(_messages.Message):
  r"""Request to generate a chart specification based on a natural language
  description and a user's data-model (tables, columns, types). NOTE: This API
  is under development and SUBJECT TO CHANGE. For the time being, the only
  intended clients are Looker Studio, Dataport, and BigQuery Studio and the
  targeted visualization framework is Vega-Lite.

  Enums:
    VisualizationFrameworkValueValuesEnum: Optional. The target visualization
      framework for the generated or updated chart. Vega-Lite is the default
      framework.

  Fields:
    additionalContext: Optional. History of previous user queries and service
      responses in the same session (e.g., during a chart specification
      refinement session). To be maintained by the client for the time being.
      Even entries represent queries and odd entries represent the
      corresponding service responses.
    dataModel: Optional. The data model available in the client's context.
    evaluationOptions: Optional. Evaluation parameters. Only used in
      evaluation runs.
    existingChartSpec: Optional. If specified, the service assumes that the NL
      query is to update this existing chart (e.g., style refinements, axes
      sorting, interpolation, etc.)
    modelOptions: Optional. The Vertex AI model and model parameters to use
      for chart generation.
    nlQuery: Required. The end user's natural language query.
    parent: Optional. Active project and location in format
      projects/*/locations/*
    sampleDataCsv: Optional. Sample data in CSV format. This can be the result
      of executing a SQL query in the context of the data model above, i.e.,
      it can be the result of a query that joins together multiple tables. If
      no data is available in the client context, clients can populate a CSV
      header row with hints about the relevant data model fields that can
      serve as chart encodings (e.g., axes).
    visualizationFramework: Optional. The target visualization framework for
      the generated or updated chart. Vega-Lite is the default framework.
  """

  class VisualizationFrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. The target visualization framework for the generated or
    updated chart. Vega-Lite is the default framework.

    Values:
      VISUALIZATION_FRAMEWORK_UNSPECIFIED: Unknown framework
      VISUALIZATION_FRAMEWORK_VEGA_LITE: Vega-Lite framework (the default)
      VISUALIZATION_FRAMEWORK_HIGHCHARTS: Highcharts framework (experimental)
    """
    VISUALIZATION_FRAMEWORK_UNSPECIFIED = 0
    VISUALIZATION_FRAMEWORK_VEGA_LITE = 1
    VISUALIZATION_FRAMEWORK_HIGHCHARTS = 2

  additionalContext = _messages.StringField(1, repeated=True)
  dataModel = _messages.MessageField('DataModel', 2)
  evaluationOptions = _messages.MessageField('EvaluationOptions', 3)
  existingChartSpec = _messages.StringField(4)
  modelOptions = _messages.MessageField('ModelOptions', 5)
  nlQuery = _messages.StringField(6)
  parent = _messages.StringField(7)
  sampleDataCsv = _messages.StringField(8)
  visualizationFramework = _messages.EnumField('VisualizationFrameworkValueValuesEnum', 9)


class VisualGenResponse(_messages.Message):
  r"""Chart specification response.

  Enums:
    FrameworkValueValuesEnum: Optional. Visualization framework (deprecated).
    VisualizationFrameworkValueValuesEnum: Optional. Visualization framework.

  Fields:
    chartMetadata: Optional. Metadata of the generated chart spec.
    chartSpec: Optional. Chart specification
    chartValidation: Optional. Validation of the generated chart spec.
    framework: Optional. Visualization framework (deprecated).
    rawChartSpec: Optional. Raw model response. Only returned in evaluation
      runs.
    visualizationFramework: Optional. Visualization framework.
  """

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. Visualization framework (deprecated).

    Values:
      UNKNOWN: Unknown framework
      VEGA_LITE: Vega-Lite framework
    """
    UNKNOWN = 0
    VEGA_LITE = 1

  class VisualizationFrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. Visualization framework.

    Values:
      VISUALIZATION_FRAMEWORK_UNSPECIFIED: Unknown framework
      VISUALIZATION_FRAMEWORK_VEGA_LITE: Vega-Lite framework (the default)
      VISUALIZATION_FRAMEWORK_HIGHCHARTS: Highcharts framework (experimental)
    """
    VISUALIZATION_FRAMEWORK_UNSPECIFIED = 0
    VISUALIZATION_FRAMEWORK_VEGA_LITE = 1
    VISUALIZATION_FRAMEWORK_HIGHCHARTS = 2

  chartMetadata = _messages.MessageField('ChartMetadata', 1)
  chartSpec = _messages.StringField(2)
  chartValidation = _messages.MessageField('ChartValidation', 3)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 4)
  rawChartSpec = _messages.StringField(5)
  visualizationFramework = _messages.EnumField('VisualizationFrameworkValueValuesEnum', 6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
