"""Generated message classes for networkmanagement version v1alpha1.

The Network Management API provides a collection of network performance
monitoring and diagnostic capabilities.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'networkmanagement'


class AbortInfo(_messages.Message):
  r"""Details of the final state "abort" and associated resource.

  Enums:
    CauseValueValuesEnum: Causes that the analysis is aborted.

  Fields:
    cause: Causes that the analysis is aborted.
    ipAddress: IP address that caused the abort.
    projectsMissingPermission: List of project IDs the user specified in the
      request but lacks access to. In this case, analysis is aborted with the
      PERMISSION_DENIED cause.
    resourceUri: URI of the resource that caused the abort.
  """

  class CauseValueValuesEnum(_messages.Enum):
    r"""Causes that the analysis is aborted.

    Values:
      CAUSE_UNSPECIFIED: Cause is unspecified.
      UNKNOWN_NETWORK: Aborted due to unknown network. Deprecated, not used in
        the new tests.
      UNKNOWN_PROJECT: Aborted because no project information can be derived
        from the test input. Deprecated, not used in the new tests.
      NO_EXTERNAL_IP: Aborted because traffic is sent from a public IP to an
        instance without an external IP. Deprecated, not used in the new
        tests.
      UNINTENDED_DESTINATION: Aborted because none of the traces matches
        destination information specified in the input test request.
        Deprecated, not used in the new tests.
      SOURCE_ENDPOINT_NOT_FOUND: Aborted because the source endpoint could not
        be found. Deprecated, not used in the new tests.
      MISMATCHED_SOURCE_NETWORK: Aborted because the source network does not
        match the source endpoint. Deprecated, not used in the new tests.
      DESTINATION_ENDPOINT_NOT_FOUND: Aborted because the destination endpoint
        could not be found. Deprecated, not used in the new tests.
      MISMATCHED_DESTINATION_NETWORK: Aborted because the destination network
        does not match the destination endpoint. Deprecated, not used in the
        new tests.
      UNKNOWN_IP: Aborted because no endpoint with the packet's destination IP
        address is found.
      GOOGLE_MANAGED_SERVICE_UNKNOWN_IP: Aborted because no endpoint with the
        packet's destination IP is found in the Google-managed project.
      SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK: Aborted because the source IP
        address doesn't belong to any of the subnets of the source VPC
        network.
      PERMISSION_DENIED: Aborted because user lacks permission to access all
        or part of the network configurations required to run the test.
      PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS: Aborted because user lacks
        permission to access Cloud NAT configs required to run the test.
      PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS: Aborted because user lacks
        permission to access Network endpoint group endpoint configs required
        to run the test.
      NO_SOURCE_LOCATION: Aborted because no valid source or destination
        endpoint is derived from the input test request.
      INVALID_ARGUMENT: Aborted because the source or destination endpoint
        specified in the request is invalid. Some examples: - The request
        might contain malformed resource URI, project ID, or IP address. - The
        request might contain inconsistent information (for example, the
        request might include both the instance and the network, but the
        instance might not have a NIC in that network).
      TRACE_TOO_LONG: Aborted because the number of steps in the trace exceeds
        a certain limit. It might be caused by a routing loop.
      INTERNAL_ERROR: Aborted due to internal server error.
      UNSUPPORTED: Aborted because the test scenario is not supported.
      MISMATCHED_IP_VERSION: Aborted because the source and destination
        resources have no common IP version.
      GKE_KONNECTIVITY_PROXY_UNSUPPORTED: Aborted because the connection
        between the control plane and the node of the source cluster is
        initiated by the node and managed by the Konnectivity proxy.
      RESOURCE_CONFIG_NOT_FOUND: Aborted because expected resource
        configuration was missing.
      VM_INSTANCE_CONFIG_NOT_FOUND: Aborted because expected VM instance
        configuration was missing.
      NETWORK_CONFIG_NOT_FOUND: Aborted because expected network configuration
        was missing.
      FIREWALL_CONFIG_NOT_FOUND: Aborted because expected firewall
        configuration was missing.
      ROUTE_CONFIG_NOT_FOUND: Aborted because expected route configuration was
        missing.
      GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT: Aborted because a PSC
        endpoint selection for the Google-managed service is ambiguous
        (several PSC endpoints satisfy test input).
      SOURCE_PSC_CLOUD_SQL_UNSUPPORTED: Aborted because tests with a PSC-based
        Cloud SQL instance as a source are not supported.
      SOURCE_FORWARDING_RULE_UNSUPPORTED: Aborted because tests with a
        forwarding rule as a source are not supported.
      NON_ROUTABLE_IP_ADDRESS: Aborted because one of the endpoints is a non-
        routable IP address (loopback, link-local, etc).
      UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT: Aborted due to an unknown issue
        in the Google-managed project.
      UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG: Aborted due to an unsupported
        configuration of the Google-managed project.
    """
    CAUSE_UNSPECIFIED = 0
    UNKNOWN_NETWORK = 1
    UNKNOWN_PROJECT = 2
    NO_EXTERNAL_IP = 3
    UNINTENDED_DESTINATION = 4
    SOURCE_ENDPOINT_NOT_FOUND = 5
    MISMATCHED_SOURCE_NETWORK = 6
    DESTINATION_ENDPOINT_NOT_FOUND = 7
    MISMATCHED_DESTINATION_NETWORK = 8
    UNKNOWN_IP = 9
    GOOGLE_MANAGED_SERVICE_UNKNOWN_IP = 10
    SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK = 11
    PERMISSION_DENIED = 12
    PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS = 13
    PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS = 14
    NO_SOURCE_LOCATION = 15
    INVALID_ARGUMENT = 16
    TRACE_TOO_LONG = 17
    INTERNAL_ERROR = 18
    UNSUPPORTED = 19
    MISMATCHED_IP_VERSION = 20
    GKE_KONNECTIVITY_PROXY_UNSUPPORTED = 21
    RESOURCE_CONFIG_NOT_FOUND = 22
    VM_INSTANCE_CONFIG_NOT_FOUND = 23
    NETWORK_CONFIG_NOT_FOUND = 24
    FIREWALL_CONFIG_NOT_FOUND = 25
    ROUTE_CONFIG_NOT_FOUND = 26
    GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT = 27
    SOURCE_PSC_CLOUD_SQL_UNSUPPORTED = 28
    SOURCE_FORWARDING_RULE_UNSUPPORTED = 29
    NON_ROUTABLE_IP_ADDRESS = 30
    UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT = 31
    UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG = 32

  cause = _messages.EnumField('CauseValueValuesEnum', 1)
  ipAddress = _messages.StringField(2)
  projectsMissingPermission = _messages.StringField(3, repeated=True)
  resourceUri = _messages.StringField(4)


class AppEngineVersionEndpoint(_messages.Message):
  r"""Wrapper for the App Engine service version attributes.

  Fields:
    uri: An [App Engine](https://cloud.google.com/appengine) [service
      version](https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services.versions) name.
  """

  uri = _messages.StringField(1)


class AppEngineVersionInfo(_messages.Message):
  r"""For display only. Metadata associated with an App Engine version.

  Fields:
    displayName: Name of an App Engine version.
    environment: App Engine execution environment for a version.
    runtime: Runtime of the App Engine version.
    uri: URI of an App Engine version.
  """

  displayName = _messages.StringField(1)
  environment = _messages.StringField(2)
  runtime = _messages.StringField(3)
  uri = _messages.StringField(4)


class Appliance(_messages.Message):
  r"""Appliance represents a deployable unit within 3P integration manager.

  Enums:
    TypeValueValuesEnum: Required. The type of the networked Appliance being
      deployed. Used to capture potential differences in deployments between
      types of appliances. Currently only FIREWALL OUT OF BAND deployment is
      supported now, but future values may include SWG (secure web gateway) or
      WAF (web application firewall) with both in-line and Out of band
      deployments.

  Messages:
    AnnotationsValue: Optional. Set of annotations ( ) to allow for custom
      metadata associated with the Appliance resource.

  Fields:
    annotations: Optional. Set of annotations ( ) to allow for custom metadata
      associated with the Appliance resource.
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A text description of the third party appliance
      resource. Might include details such as product features, vendor
      information, and pricing. Character set is UTF-8 and is limited to 4096
      characters.
    displayName: Optional. Name of the third party appliance.
    eulaUri: Optional. A URL to the End User License Agreement provided by the
      third party appliance vendor.
    externalLicenseInfo: Optional. Information about the License type of the
      third party appliance.
    imageVersion: Optional. Version of the Vendor Image of the Firewall VM to
      be deployed, e.g.: 9.1.3
    name: Required. Name of the Appliance resource. It matches the pattern
      `projects/{project}/locations/{location}/appliances/` and must be
      unique.
    partner: Optional. Name of the third party vendor providing the appliance.
    type: Required. The type of the networked Appliance being deployed. Used
      to capture potential differences in deployments between types of
      appliances. Currently only FIREWALL OUT OF BAND deployment is supported
      now, but future values may include SWG (secure web gateway) or WAF (web
      application firewall) with both in-line and Out of band deployments.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the networked Appliance being deployed. Used to
    capture potential differences in deployments between types of appliances.
    Currently only FIREWALL OUT OF BAND deployment is supported now, but
    future values may include SWG (secure web gateway) or WAF (web application
    firewall) with both in-line and Out of band deployments.

    Values:
      TYPE_UNSPECIFIED: Default value.
      OUT_OF_BAND_FIREWALL: A firewall appliance deployed out of band.
      INLINE_FIREWALL: A firewall appliance deployed inline.
    """
    TYPE_UNSPECIFIED = 0
    OUT_OF_BAND_FIREWALL = 1
    INLINE_FIREWALL = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Set of annotations ( ) to allow for custom metadata
    associated with the Appliance resource.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  eulaUri = _messages.StringField(5)
  externalLicenseInfo = _messages.StringField(6)
  imageVersion = _messages.StringField(7)
  name = _messages.StringField(8)
  partner = _messages.StringField(9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    ignoreChildExemptions: A boolean attribute.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  ignoreChildExemptions = _messages.BooleanField(2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    bindingId: A string attribute.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('Expr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.
    PermissionTypeValueValuesEnum: The type associated with the permission.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline. Will be deprecated once the migration to PermissionType is
      complete (b/201806118).
    logName: The log_name to populate in the Cloud Audit Record.
    permissionType: The type associated with the permission.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type associated with the permission.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: Permissions that gate reading resource configuration or
        metadata.
      ADMIN_WRITE: Permissions that gate modification of resource
        configuration or metadata.
      DATA_READ: Permissions that gate reading user-provided data.
      DATA_WRITE: Permissions that gate writing user-provided data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  authorizationLoggingOptions = _messages.MessageField('AuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)
  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 3)


class CloudFunctionEndpoint(_messages.Message):
  r"""Wrapper for Cloud Function attributes.

  Fields:
    uri: A [Cloud Function](https://cloud.google.com/functions) name.
  """

  uri = _messages.StringField(1)


class CloudFunctionInfo(_messages.Message):
  r"""For display only. Metadata associated with a Cloud Function.

  Fields:
    displayName: Name of a Cloud Function.
    location: Location in which the Cloud Function is deployed.
    uri: URI of a Cloud Function.
    versionId: Latest successfully deployed version id of the Cloud Function.
  """

  displayName = _messages.StringField(1)
  location = _messages.StringField(2)
  uri = _messages.StringField(3)
  versionId = _messages.IntegerField(4)


class CloudRunRevisionEndpoint(_messages.Message):
  r"""Wrapper for Cloud Run revision attributes.

  Fields:
    uri: A [Cloud Run](https://cloud.google.com/run) [revision](https://cloud.
      google.com/run/docs/reference/rest/v1/namespaces.revisions/get) URI. The
      format is: projects/{project}/locations/{location}/revisions/{revision}
  """

  uri = _messages.StringField(1)


class CloudRunRevisionInfo(_messages.Message):
  r"""For display only. Metadata associated with a Cloud Run revision.

  Fields:
    displayName: Name of a Cloud Run revision.
    location: Location in which this revision is deployed.
    serviceName: ID of Cloud Run Service this revision belongs to. Was never
      set, is not exported to v1 proto and public protos. Do not export to
      v1beta1 public proto.
    serviceUri: URI of Cloud Run service this revision belongs to.
    uri: URI of a Cloud Run revision.
  """

  displayName = _messages.StringField(1)
  location = _messages.StringField(2)
  serviceName = _messages.StringField(3)
  serviceUri = _messages.StringField(4)
  uri = _messages.StringField(5)


class CloudSQLInstanceInfo(_messages.Message):
  r"""For display only. Metadata associated with a Cloud SQL instance.

  Fields:
    displayName: Name of a Cloud SQL instance.
    externalIp: External IP address of a Cloud SQL instance.
    internalIp: Internal IP address of a Cloud SQL instance.
    networkUri: URI of a Cloud SQL instance network or empty string if the
      instance does not have one.
    region: Region in which the Cloud SQL instance is running.
    uri: URI of a Cloud SQL instance.
  """

  displayName = _messages.StringField(1)
  externalIp = _messages.StringField(2)
  internalIp = _messages.StringField(3)
  networkUri = _messages.StringField(4)
  region = _messages.StringField(5)
  uri = _messages.StringField(6)


class Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext
        (go/security-realms). When used with IN, the condition indicates "any
        of the request's realms match one of the given values; with NOT_IN,
        "none of the realms match any of the given values". Note that a value
        can be: - 'self:campus' (i.e., clients that are in the same campus) -
        'self:metro' (i.e., clients that are in the same metro) - 'self:cloud-
        region' (i.e., allow connections from clients that are in the same
        cloud region) - 'self:prod-region' (i.e., allow connections from
        clients that are in the same prod region) - 'guardians' (i.e., allow
        connections from its guardian realms. See go/security-realms-
        glossary#guardian for more information.) - 'cryto_core_guardians'
        (i.e., allow connections from its crypto core guardian realms. See
        go/security-realms-glossary#guardian for more information.) Crypto
        Core coverage is a super-set of Default coverage, containing
        information about coverage between higher tier data centers (e.g.,
        YAWNs). Most services should use Default coverage and only use Crypto
        Core coverage if the service is involved in greenfield turnup of new
        higher tier data centers (e.g., credential infrastructure, machine/job
        management systems, etc.). - 'self' [DEPRECATED] (i.e., allow
        connections from clients that are in the same security realm, which is
        currently but not guaranteed to be campus-sized) - a realm (e.g.,
        'campus-abc') - a realm group (e.g., 'realms-for-borg-cell-xx', see:
        go/realm-groups) A match is determined by a realm group membership
        check performed by a RealmAclRep object (go/realm-acl-howto). It is
        not permitted to grant access based on the *absence* of a realm, so
        realm conditions can only be used in a "positive" context (e.g.,
        ALLOW/IN or DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        security.credentials.JustificationType, e.g. "MANUAL_STRING". It is
        not permitted to grant access based on the *absence* of a
        justification, so justification conditions can only be used in a
        "positive" context (e.g., ALLOW/IN or DENY/NOT_IN). Multiple
        justifications, e.g., a Buganizer ID and a manually-entered reason,
        are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      CREDS_ASSERTION: EXPERIMENTAL -- DO NOT USE. The conditions can only be
        used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6
    CREDS_ASSERTION = 7

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class ConfigChange(_messages.Message):
  r"""ConfigChange defines one specific operation (defined by UpdateType) of a
  given configuration type. The content of the update is encoded in JSON
  format in config_body.

  Enums:
    UpdateTypeValueValuesEnum: Specify the type of the config change.

  Fields:
    assetType: Indicates the type of the config change. The type of the asset.
      Example: `compute.googleapis.com/Firewall` See [Supported asset
      types](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types) for more information. Currently only supports: (1)
      compute.googleapis.com/Firewall
    baseConfigBody: Output only. Specifies original configuration in
      stringified JSON format. Base configuration which is populated by
      backend when simulation is run or rerun.
    configBody: Deprecated: Specifies the detailed configuration in JSON
      format. Alternate Solution: Please use proposed_config_body field
      instead.
    configId: Deprecated: Config identifier (for DELETE operation).If fetching
      data please extract config_id or selfLink from the base_config_body. If
      passing data in request body please pass config_id/selfLink in the
      proposed_config_body.
    proposedConfigBody: Specifies proposed configuration in stringified JSON
      format.
    updateType: Specify the type of the config change.
  """

  class UpdateTypeValueValuesEnum(_messages.Enum):
    r"""Specify the type of the config change.

    Values:
      UPDATE_TYPE_UNSPECIFIED: Default update type.
      INSERT: Indicates the update type is insertion.
      DELETE: Indicates the update type is deletion.
      UPDATE: Indicates the update type is modification.
    """
    UPDATE_TYPE_UNSPECIFIED = 0
    INSERT = 1
    DELETE = 2
    UPDATE = 3

  assetType = _messages.StringField(1)
  baseConfigBody = _messages.StringField(2)
  configBody = _messages.StringField(3)
  configId = _messages.StringField(4)
  proposedConfigBody = _messages.StringField(5)
  updateType = _messages.EnumField('UpdateTypeValueValuesEnum', 6)


class ConnectivityTestSimulationData(_messages.Message):
  r"""Message for simulation data of connectivity test."""


class ConnectivityTestSimulationResult(_messages.Message):
  r"""ConnectivityTestSimulationResult contains results for a single
  connectivity test from two network configurations, i.e. original and
  proposed network configurations.

  Fields:
    baseConfigResult: Reachability details (result+traces) for the base
      config.
    destination: Destination endpoint.
    proposedConfigResult: Reachability details (result+traces) for the
      proposed config.
    protocol: Protocol name.
    resultsDiffer: Whether base and proposed config results are different.
    source: Source endpoint.
    testUri: Full resource path (i.e. uri) of the connectivity test using the
      form: 'projects/{project}/locations/{location}/connectivityTestSimulatio
      nResults/{result}'
  """

  baseConfigResult = _messages.MessageField('ReachabilityDetails', 1)
  destination = _messages.MessageField('Endpoint', 2)
  proposedConfigResult = _messages.MessageField('ReachabilityDetails', 3)
  protocol = _messages.StringField(4)
  resultsDiffer = _messages.BooleanField(5)
  source = _messages.MessageField('Endpoint', 6)
  testUri = _messages.StringField(7)


class CounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended. Field names
  correspond to IAM request parameters and field values are their respective
  values. Supported field names: - "authority", which is "[token]" if
  IAMContext.token is present, otherwise the value of
  IAMContext.authority_selector if present, and otherwise a representation of
  IAMContext.principal; or - "iam_principal", a representation of
  IAMContext.principal even if a token or authority selector is present; or -
  "" (empty string), resulting in a counter with no fields. Examples: counter
  { metric: "/debug_access_count" field: "iam_principal" } ==> increment
  counter /iam/policy/debug_access_count {iam_principal=[value of
  IAMContext.principal]}

  Fields:
    customFields: Custom fields.
    field: The field value to attribute.
    metric: The metric to update.
  """

  customFields = _messages.MessageField('CustomField', 1, repeated=True)
  field = _messages.StringField(2)
  metric = _messages.StringField(3)


class CustomField(_messages.Message):
  r"""Custom fields. These can be used to create a counter with arbitrary
  field/value pairs. See: go/rpcsp-custom-fields.

  Fields:
    name: Name is the field name.
    value: Value is the field value. It is important that in contrast to the
      CounterOptions.field, the value here is a constant that is not derived
      from the IAMContext.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum:

  Fields:
    isDirectAuth: Indicates that access was granted by a regular grant policy
    logMode: A LogModeValueValuesEnum attribute.
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""LogModeValueValuesEnum enum type.

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds. If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  isDirectAuth = _messages.BooleanField(1)
  logMode = _messages.EnumField('LogModeValueValuesEnum', 2)


class DeliverInfo(_messages.Message):
  r"""Details of the final state "deliver" and associated resource.

  Enums:
    TargetValueValuesEnum: Target type where the packet is delivered to.

  Fields:
    ipAddress: IP address of the target (if applicable).
    pscGoogleApiTarget: PSC Google API target the packet is delivered to (if
      applicable).
    resourceUri: URI of the resource that the packet is delivered to.
    storageBucket: Name of the Cloud Storage Bucket the packet is delivered to
      (if applicable).
    target: Target type where the packet is delivered to.
  """

  class TargetValueValuesEnum(_messages.Enum):
    r"""Target type where the packet is delivered to.

    Values:
      TARGET_UNSPECIFIED: Target not specified.
      INSTANCE: Target is a Compute Engine instance.
      INTERNET: Target is the internet.
      GOOGLE_API: Target is a Google API.
      GKE_MASTER: Target is a Google Kubernetes Engine cluster master.
      CLOUD_SQL_INSTANCE: Target is a Cloud SQL instance.
      PSC_PUBLISHED_SERVICE: Target is a published service that uses [Private
        Service Connect](https://cloud.google.com/vpc/docs/configure-private-
        service-connect-services).
      PSC_GOOGLE_API: Target is Google APIs that use [Private Service
        Connect](https://cloud.google.com/vpc/docs/configure-private-service-
        connect-apis).
      PSC_VPC_SC: Target is a VPC-SC that uses [Private Service
        Connect](https://cloud.google.com/vpc/docs/configure-private-service-
        connect-apis).
      SERVERLESS_NEG: Target is a serverless network endpoint group.
      STORAGE_BUCKET: Target is a Cloud Storage bucket.
      PRIVATE_NETWORK: Target is a private network. Used only for return
        traces.
      CLOUD_FUNCTION: Target is a Cloud Function. Used only for return traces.
      APP_ENGINE_VERSION: Target is a App Engine service version. Used only
        for return traces.
      CLOUD_RUN_REVISION: Target is a Cloud Run revision. Used only for return
        traces.
      GOOGLE_MANAGED_SERVICE: Target is a Google-managed service. Used only
        for return traces.
    """
    TARGET_UNSPECIFIED = 0
    INSTANCE = 1
    INTERNET = 2
    GOOGLE_API = 3
    GKE_MASTER = 4
    CLOUD_SQL_INSTANCE = 5
    PSC_PUBLISHED_SERVICE = 6
    PSC_GOOGLE_API = 7
    PSC_VPC_SC = 8
    SERVERLESS_NEG = 9
    STORAGE_BUCKET = 10
    PRIVATE_NETWORK = 11
    CLOUD_FUNCTION = 12
    APP_ENGINE_VERSION = 13
    CLOUD_RUN_REVISION = 14
    GOOGLE_MANAGED_SERVICE = 15

  ipAddress = _messages.StringField(1)
  pscGoogleApiTarget = _messages.StringField(2)
  resourceUri = _messages.StringField(3)
  storageBucket = _messages.StringField(4)
  target = _messages.EnumField('TargetValueValuesEnum', 5)


class Deployment(_messages.Message):
  r"""Deployment represents information about a third party appliance
  deployment.

  Fields:
    mirroredTrafficConfig: Config to include if deployment will an out-of-band
      topology.
    name: Required. Name of the Deployment resource. It matches the pattern
      `projects/{project}/locations/{location}/deployments/{deployment}` and
      must be unique.
  """

  mirroredTrafficConfig = _messages.MessageField('OutOfBandDeploymentConfig', 1)
  name = _messages.StringField(2)


class DropInfo(_messages.Message):
  r"""Details of the final state "drop" and associated resource.

  Enums:
    CauseValueValuesEnum: Cause that the packet is dropped.

  Fields:
    cause: Cause that the packet is dropped.
    destinationIp: Destination IP address of the dropped packet (if relevant).
    region: Region of the dropped packet (if relevant).
    resourceUri: URI of the resource that caused the drop.
    sourceIp: Source IP address of the dropped packet (if relevant).
  """

  class CauseValueValuesEnum(_messages.Enum):
    r"""Cause that the packet is dropped.

    Values:
      CAUSE_UNSPECIFIED: Cause is unspecified.
      UNKNOWN_EXTERNAL_ADDRESS: Destination external address cannot be
        resolved to a known target. If the address is used in a Google Cloud
        project, provide the project ID as test input.
      FOREIGN_IP_DISALLOWED: A Compute Engine instance can only send or
        receive a packet with a foreign IP address if ip_forward is enabled.
      FIREWALL_RULE: Dropped due to a firewall rule, unless allowed due to
        connection tracking.
      NO_ROUTE: Dropped due to no matching routes.
      ROUTE_BLACKHOLE: Dropped due to invalid route. Route's next hop is a
        blackhole.
      ROUTE_WRONG_NETWORK: Packet is sent to a wrong (unintended) network.
        Example: you trace a packet from VM1:Network1 to VM2:Network2,
        however, the route configured in Network1 sends the packet destined
        for VM2's IP address to Network3.
      ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED: Route's next hop IP address
        cannot be resolved to a GCP resource.
      ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND: Route's next hop resource is not
        found.
      ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK: Route's next hop instance doesn't
        have a NIC in the route's network.
      ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP: Route's next hop IP address is
        not a primary IP address of the next hop instance.
      ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH: Route's next hop forwarding
        rule doesn't match next hop IP address.
      ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED: Route's next hop VPN tunnel
        is down (does not have valid IKE SAs).
      ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID: Route's next hop forwarding
        rule type is invalid (it's not a forwarding rule of the internal
        passthrough load balancer).
      NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS: Packet is sent from the
        Internet to the private IPv6 address.
      VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH: The packet does not match a policy-
        based VPN tunnel local selector.
      VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH: The packet does not match a policy-
        based VPN tunnel remote selector.
      PRIVATE_TRAFFIC_TO_INTERNET: Packet with internal destination address
        sent to the internet gateway.
      PRIVATE_GOOGLE_ACCESS_DISALLOWED: Instance with only an internal IP
        address tries to access Google API and services, but private Google
        access is not enabled in the subnet.
      PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED: Source endpoint tries
        to access Google API and services through the VPN tunnel to another
        network, but Private Google Access needs to be enabled in the source
        endpoint network.
      NO_EXTERNAL_ADDRESS: Instance with only an internal IP address tries to
        access external hosts, but Cloud NAT is not enabled in the subnet,
        unless special configurations on a VM allow this connection.
      UNKNOWN_INTERNAL_ADDRESS: Destination internal address cannot be
        resolved to a known target. If this is a shared VPC scenario, verify
        if the service project ID is provided as test input. Otherwise, verify
        if the IP address is being used in the project.
      FORWARDING_RULE_MISMATCH: Forwarding rule's protocol and ports do not
        match the packet header.
      FORWARDING_RULE_NO_INSTANCES: Forwarding rule does not have backends
        configured.
      FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK: Firewalls block
        the health check probes to the backends and cause the backends to be
        unavailable for traffic from the load balancer. For more details, see
        [Health check firewall rules](https://cloud.google.com/load-
        balancing/docs/health-checks#firewall_rules).
      INSTANCE_NOT_RUNNING: Packet is sent from or to a Compute Engine
        instance that is not in a running state.
      GKE_CLUSTER_NOT_RUNNING: Packet sent from or to a GKE cluster that is
        not in running state.
      CLOUD_SQL_INSTANCE_NOT_RUNNING: Packet sent from or to a Cloud SQL
        instance that is not in running state.
      TRAFFIC_TYPE_BLOCKED: The type of traffic is blocked and the user cannot
        configure a firewall rule to enable it. See [Always blocked
        traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic)
        for more details.
      GKE_MASTER_UNAUTHORIZED_ACCESS: Access to Google Kubernetes Engine
        cluster master's endpoint is not authorized. See [Access to the
        cluster endpoints](https://cloud.google.com/kubernetes-
        engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
        for more details.
      CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS: Access to the Cloud SQL instance
        endpoint is not authorized. See [Authorizing with authorized
        networks](https://cloud.google.com/sql/docs/mysql/authorize-networks)
        for more details.
      DROPPED_INSIDE_GKE_SERVICE: Packet was dropped inside Google Kubernetes
        Engine Service.
      DROPPED_INSIDE_CLOUD_SQL_SERVICE: Packet was dropped inside Cloud SQL
        Service.
      GOOGLE_MANAGED_SERVICE_NO_PEERING: Packet was dropped because there is
        no peering between the originating network and the Google Managed
        Services Network.
      GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT: Packet was dropped because the
        Google-managed service uses Private Service Connect (PSC), but the PSC
        endpoint is not found in the project.
      GKE_PSC_ENDPOINT_MISSING: Packet was dropped because the GKE cluster
        uses Private Service Connect (PSC), but the PSC endpoint is not found
        in the project.
      CLOUD_SQL_INSTANCE_NO_IP_ADDRESS: Packet was dropped because the Cloud
        SQL instance has neither a private nor a public IP address.
      GKE_CONTROL_PLANE_REGION_MISMATCH: Packet was dropped because a GKE
        cluster private endpoint is unreachable from a region different from
        the cluster's region.
      PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION: Packet sent from a
        public GKE cluster control plane to a private IP address.
      GKE_CONTROL_PLANE_NO_ROUTE: Packet was dropped because there is no route
        from a GKE cluster control plane to a destination network.
      CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC: Packet sent from
        a Cloud SQL instance to an external IP address is not allowed. The
        Cloud SQL instance is not configured to send packets to external IP
        addresses.
      PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION: Packet sent from a
        Cloud SQL instance with only a public IP address to a private IP
        address.
      CLOUD_SQL_INSTANCE_NO_ROUTE: Packet was dropped because there is no
        route from a Cloud SQL instance to a destination network.
      CLOUD_SQL_CONNECTOR_REQUIRED: Packet was dropped because the Cloud SQL
        instance requires all connections to use Cloud SQL connectors and to
        target the Cloud SQL proxy port (3307).
      CLOUD_FUNCTION_NOT_ACTIVE: Packet could be dropped because the Cloud
        Function is not in an active status.
      VPC_CONNECTOR_NOT_SET: Packet could be dropped because no VPC connector
        is set.
      VPC_CONNECTOR_NOT_RUNNING: Packet could be dropped because the VPC
        connector is not in a running state.
      VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED: Packet could be dropped
        because the traffic from the serverless service to the VPC connector
        is not allowed.
      VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED: Packet could be dropped
        because the health check traffic to the VPC connector is not allowed.
      FORWARDING_RULE_REGION_MISMATCH: Packet could be dropped because it was
        sent from a different region to a regional forwarding without global
        access.
      PSC_CONNECTION_NOT_ACCEPTED: The Private Service Connect endpoint is in
        a project that is not approved to connect to the service.
      PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK: The packet is sent to the
        Private Service Connect endpoint over the peering, but [it's not
        supported](https://cloud.google.com/vpc/docs/configure-private-
        service-connect-services#on-premises).
      PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS: The packet is sent to the
        Private Service Connect backend (network endpoint group), but the
        producer PSC forwarding rule does not have global access enabled.
      PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS: The packet is sent to
        the Private Service Connect backend (network endpoint group), but the
        producer PSC forwarding rule has multiple ports specified.
      CLOUD_SQL_PSC_NEG_UNSUPPORTED: The packet is sent to the Private Service
        Connect backend (network endpoint group) targeting a Cloud SQL service
        attachment, but this configuration is not supported.
      NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT: No NAT subnets are defined
        for the PSC service attachment.
      PSC_TRANSITIVITY_NOT_PROPAGATED: PSC endpoint is accessed via NCC, but
        PSC transitivity configuration is not yet propagated.
      HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED: The packet sent from the hybrid
        NEG proxy matches a non-dynamic route, but such a configuration is not
        supported.
      HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED: The packet sent from the
        hybrid NEG proxy matches a dynamic route with a next hop in a
        different region, but such a configuration is not supported.
      CLOUD_RUN_REVISION_NOT_READY: Packet sent from a Cloud Run revision that
        is not ready.
      DROPPED_INSIDE_PSC_SERVICE_PRODUCER: Packet was dropped inside Private
        Service Connect service producer.
      LOAD_BALANCER_HAS_NO_PROXY_SUBNET: Packet sent to a load balancer, which
        requires a proxy-only subnet and the subnet is not found.
      CLOUD_NAT_NO_ADDRESSES: Packet sent to Cloud Nat without active NAT IPs.
      ROUTING_LOOP: Packet is stuck in a routing loop.
      DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE: Packet is dropped due to an
        unspecified reason inside a Google-managed service. Used only for
        return traces.
      LOAD_BALANCER_BACKEND_INVALID_NETWORK: Packet is dropped due to a load
        balancer backend instance not having a network interface in the
        network expected by the load balancer.
    """
    CAUSE_UNSPECIFIED = 0
    UNKNOWN_EXTERNAL_ADDRESS = 1
    FOREIGN_IP_DISALLOWED = 2
    FIREWALL_RULE = 3
    NO_ROUTE = 4
    ROUTE_BLACKHOLE = 5
    ROUTE_WRONG_NETWORK = 6
    ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED = 7
    ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND = 8
    ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK = 9
    ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP = 10
    ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH = 11
    ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED = 12
    ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID = 13
    NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS = 14
    VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH = 15
    VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH = 16
    PRIVATE_TRAFFIC_TO_INTERNET = 17
    PRIVATE_GOOGLE_ACCESS_DISALLOWED = 18
    PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED = 19
    NO_EXTERNAL_ADDRESS = 20
    UNKNOWN_INTERNAL_ADDRESS = 21
    FORWARDING_RULE_MISMATCH = 22
    FORWARDING_RULE_NO_INSTANCES = 23
    FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK = 24
    INSTANCE_NOT_RUNNING = 25
    GKE_CLUSTER_NOT_RUNNING = 26
    CLOUD_SQL_INSTANCE_NOT_RUNNING = 27
    TRAFFIC_TYPE_BLOCKED = 28
    GKE_MASTER_UNAUTHORIZED_ACCESS = 29
    CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS = 30
    DROPPED_INSIDE_GKE_SERVICE = 31
    DROPPED_INSIDE_CLOUD_SQL_SERVICE = 32
    GOOGLE_MANAGED_SERVICE_NO_PEERING = 33
    GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT = 34
    GKE_PSC_ENDPOINT_MISSING = 35
    CLOUD_SQL_INSTANCE_NO_IP_ADDRESS = 36
    GKE_CONTROL_PLANE_REGION_MISMATCH = 37
    PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION = 38
    GKE_CONTROL_PLANE_NO_ROUTE = 39
    CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC = 40
    PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION = 41
    CLOUD_SQL_INSTANCE_NO_ROUTE = 42
    CLOUD_SQL_CONNECTOR_REQUIRED = 43
    CLOUD_FUNCTION_NOT_ACTIVE = 44
    VPC_CONNECTOR_NOT_SET = 45
    VPC_CONNECTOR_NOT_RUNNING = 46
    VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED = 47
    VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED = 48
    FORWARDING_RULE_REGION_MISMATCH = 49
    PSC_CONNECTION_NOT_ACCEPTED = 50
    PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK = 51
    PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS = 52
    PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS = 53
    CLOUD_SQL_PSC_NEG_UNSUPPORTED = 54
    NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT = 55
    PSC_TRANSITIVITY_NOT_PROPAGATED = 56
    HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED = 57
    HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED = 58
    CLOUD_RUN_REVISION_NOT_READY = 59
    DROPPED_INSIDE_PSC_SERVICE_PRODUCER = 60
    LOAD_BALANCER_HAS_NO_PROXY_SUBNET = 61
    CLOUD_NAT_NO_ADDRESSES = 62
    ROUTING_LOOP = 63
    DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE = 64
    LOAD_BALANCER_BACKEND_INVALID_NETWORK = 65

  cause = _messages.EnumField('CauseValueValuesEnum', 1)
  destinationIp = _messages.StringField(2)
  region = _messages.StringField(3)
  resourceUri = _messages.StringField(4)
  sourceIp = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Endpoint(_messages.Message):
  r"""Source or destination of the Connectivity Test.

  Enums:
    ForwardingRuleTargetValueValuesEnum: Output only. Specifies the type of
      the target of the forwarding rule.
    LoadBalancerTypeValueValuesEnum: Output only. Type of the load balancer
      the forwarding rule points to.
    NetworkTypeValueValuesEnum: Type of the network where the endpoint is
      located. Applicable only to source endpoint, as destination network type
      can be inferred from the source.

  Fields:
    appEngineVersion: An [App Engine](https://cloud.google.com/appengine)
      [service version](https://cloud.google.com/appengine/docs/admin-
      api/reference/rest/v1/apps.services.versions).
    cloudFunction: A [Cloud Function](https://cloud.google.com/functions).
    cloudRunRevision: A [Cloud Run](https://cloud.google.com/run) [revision](h
      ttps://cloud.google.com/run/docs/reference/rest/v1/namespaces.revisions/
      get)
    cloudSqlInstance: A [Cloud SQL](https://cloud.google.com/sql) instance
      URI.
    forwardingRule: A forwarding rule and its corresponding IP address
      represent the frontend configuration of a Google Cloud load balancer.
      Forwarding rules are also used for protocol forwarding, Private Service
      Connect and other network services to provide forwarding information in
      the control plane. Format:
      projects/{project}/global/forwardingRules/{id} or
      projects/{project}/regions/{region}/forwardingRules/{id}
    forwardingRuleTarget: Output only. Specifies the type of the target of the
      forwarding rule.
    gkeMasterCluster: A cluster URI for [Google Kubernetes Engine
      master](https://cloud.google.com/kubernetes-
      engine/docs/concepts/cluster-architecture).
    instance: A Compute Engine instance URI.
    ipAddress: The IP address of the endpoint, which can be an external or
      internal IP.
    loadBalancerId: Output only. ID of the load balancer the forwarding rule
      points to. Empty for forwarding rules not related to load balancers.
    loadBalancerType: Output only. Type of the load balancer the forwarding
      rule points to.
    network: A Compute Engine network URI.
    networkType: Type of the network where the endpoint is located. Applicable
      only to source endpoint, as destination network type can be inferred
      from the source.
    port: The IP protocol port of the endpoint. Only applicable when protocol
      is TCP or UDP.
    projectId: Project ID where the endpoint is located. The Project ID can be
      derived from the URI if you provide a VM instance or network URI. The
      following are two cases where you must provide the project ID: 1. Only
      the IP address is specified, and the IP address is within a Google Cloud
      project. 2. When you are using Shared VPC and the IP address that you
      provide is from the service project. In this case, the network that the
      IP address resides in is defined in the host project.
  """

  class ForwardingRuleTargetValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies the type of the target of the forwarding rule.

    Values:
      FORWARDING_RULE_TARGET_UNSPECIFIED: Forwarding rule target is unknown.
      INSTANCE: Compute Engine instance for protocol forwarding.
      LOAD_BALANCER: Load Balancer. The specific type can be found from
        load_balancer_type.
      VPN_GATEWAY: Classic Cloud VPN Gateway.
      PSC: Forwarding Rule is a Private Service Connect endpoint.
    """
    FORWARDING_RULE_TARGET_UNSPECIFIED = 0
    INSTANCE = 1
    LOAD_BALANCER = 2
    VPN_GATEWAY = 3
    PSC = 4

  class LoadBalancerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of the load balancer the forwarding rule points to.

    Values:
      LOAD_BALANCER_TYPE_UNSPECIFIED: Forwarding rule points to a different
        target than a load balancer or a load balancer type is unknown.
      HTTPS_ADVANCED_LOAD_BALANCER: Global external HTTP(S) load balancer.
      HTTPS_LOAD_BALANCER: Global external HTTP(S) load balancer (classic)
      REGIONAL_HTTPS_LOAD_BALANCER: Regional external HTTP(S) load balancer.
      INTERNAL_HTTPS_LOAD_BALANCER: Internal HTTP(S) load balancer.
      SSL_PROXY_LOAD_BALANCER: External SSL proxy load balancer.
      TCP_PROXY_LOAD_BALANCER: External TCP proxy load balancer.
      INTERNAL_TCP_PROXY_LOAD_BALANCER: Internal regional TCP proxy load
        balancer.
      NETWORK_LOAD_BALANCER: External TCP/UDP Network load balancer.
      LEGACY_NETWORK_LOAD_BALANCER: Target-pool based external TCP/UDP Network
        load balancer.
      TCP_UDP_INTERNAL_LOAD_BALANCER: Internal TCP/UDP load balancer.
    """
    LOAD_BALANCER_TYPE_UNSPECIFIED = 0
    HTTPS_ADVANCED_LOAD_BALANCER = 1
    HTTPS_LOAD_BALANCER = 2
    REGIONAL_HTTPS_LOAD_BALANCER = 3
    INTERNAL_HTTPS_LOAD_BALANCER = 4
    SSL_PROXY_LOAD_BALANCER = 5
    TCP_PROXY_LOAD_BALANCER = 6
    INTERNAL_TCP_PROXY_LOAD_BALANCER = 7
    NETWORK_LOAD_BALANCER = 8
    LEGACY_NETWORK_LOAD_BALANCER = 9
    TCP_UDP_INTERNAL_LOAD_BALANCER = 10

  class NetworkTypeValueValuesEnum(_messages.Enum):
    r"""Type of the network where the endpoint is located. Applicable only to
    source endpoint, as destination network type can be inferred from the
    source.

    Values:
      NETWORK_TYPE_UNSPECIFIED: Default type if unspecified.
      GCP_NETWORK: A network hosted within Google Cloud. To receive more
        detailed output, specify the URI for the source or destination
        network.
      NON_GCP_NETWORK: A network hosted outside of Google Cloud. This can be
        an on-premises network, or a network hosted by another cloud provider.
    """
    NETWORK_TYPE_UNSPECIFIED = 0
    GCP_NETWORK = 1
    NON_GCP_NETWORK = 2

  appEngineVersion = _messages.MessageField('AppEngineVersionEndpoint', 1)
  cloudFunction = _messages.MessageField('CloudFunctionEndpoint', 2)
  cloudRunRevision = _messages.MessageField('CloudRunRevisionEndpoint', 3)
  cloudSqlInstance = _messages.StringField(4)
  forwardingRule = _messages.StringField(5)
  forwardingRuleTarget = _messages.EnumField('ForwardingRuleTargetValueValuesEnum', 6)
  gkeMasterCluster = _messages.StringField(7)
  instance = _messages.StringField(8)
  ipAddress = _messages.StringField(9)
  loadBalancerId = _messages.StringField(10)
  loadBalancerType = _messages.EnumField('LoadBalancerTypeValueValuesEnum', 11)
  network = _messages.StringField(12)
  networkType = _messages.EnumField('NetworkTypeValueValuesEnum', 13)
  port = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  projectId = _messages.StringField(15)


class EndpointInfo(_messages.Message):
  r"""For display only. The specification of the endpoints for the test.
  EndpointInfo is derived from source and destination Endpoint and validated
  by the backend data plane model.

  Fields:
    destinationIp: Destination IP address.
    destinationNetworkUri: URI of the network where this packet is sent to.
    destinationPort: Destination port. Only valid when protocol is TCP or UDP.
    protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
    sourceAgentUri: URI of the source telemetry agent this packet originates
      from.
    sourceIp: Source IP address.
    sourceNetworkUri: URI of the network where this packet originates from.
    sourcePort: Source port. Only valid when protocol is TCP or UDP.
  """

  destinationIp = _messages.StringField(1)
  destinationNetworkUri = _messages.StringField(2)
  destinationPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  protocol = _messages.StringField(4)
  sourceAgentUri = _messages.StringField(5)
  sourceIp = _messages.StringField(6)
  sourceNetworkUri = _messages.StringField(7)
  sourcePort = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FirewallInfo(_messages.Message):
  r"""For display only. Metadata associated with a VPC firewall rule, an
  implied VPC firewall rule, or a hierarchical firewall policy rule.

  Enums:
    FirewallRuleTypeValueValuesEnum: The firewall rule's type.

  Fields:
    action: Possible values: ALLOW, DENY, APPLY_SECURITY_PROFILE_GROUP
    direction: Possible values: INGRESS, EGRESS
    displayName: The display name of the VPC firewall rule. This field is not
      applicable to hierarchical firewall policy rules.
    firewallRuleType: The firewall rule's type.
    networkUri: The URI of the VPC network that the firewall rule is
      associated with. This field is not applicable to hierarchical firewall
      policy rules.
    policy: The hierarchical firewall policy that this rule is associated
      with. This field is not applicable to VPC firewall rules.
    priority: The priority of the firewall rule.
    targetServiceAccounts: The target service accounts specified by the
      firewall rule.
    targetTags: The target tags defined by the VPC firewall rule. This field
      is not applicable to hierarchical firewall policy rules.
    uri: The URI of the VPC firewall rule. This field is not applicable to
      implied firewall rules or hierarchical firewall policy rules.
  """

  class FirewallRuleTypeValueValuesEnum(_messages.Enum):
    r"""The firewall rule's type.

    Values:
      FIREWALL_RULE_TYPE_UNSPECIFIED: Unspecified type.
      HIERARCHICAL_FIREWALL_POLICY_RULE: Hierarchical firewall policy rule.
        For details, see [Hierarchical firewall policies
        overview](https://cloud.google.com/vpc/docs/firewall-policies).
      VPC_FIREWALL_RULE: VPC firewall rule. For details, see [VPC firewall
        rules overview](https://cloud.google.com/vpc/docs/firewalls).
      IMPLIED_VPC_FIREWALL_RULE: Implied VPC firewall rule. For details, see
        [Implied rules](https://cloud.google.com/vpc/docs/firewalls#default_fi
        rewall_rules).
      SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE: Implicit firewall rules
        that are managed by serverless VPC access to allow ingress access.
        They are not visible in the Google Cloud console. For details, see
        [VPC connector's implicit
        rules](https://cloud.google.com/functions/docs/networking/connecting-
        vpc#restrict-access).
      NETWORK_FIREWALL_POLICY_RULE: Global network firewall policy rule. For
        details, see [Network firewall
        policies](https://cloud.google.com/vpc/docs/network-firewall-
        policies).
      NETWORK_REGIONAL_FIREWALL_POLICY_RULE: Regional network firewall policy
        rule. For details, see [Regional network firewall
        policies](https://cloud.google.com/firewall/docs/regional-firewall-
        policies).
      UNSUPPORTED_FIREWALL_POLICY_RULE: Firewall policy rule containing
        attributes not yet supported in Connectivity tests. Firewall analysis
        is skipped if such a rule can potentially be matched. Please see the
        [list of unsupported configurations](https://cloud.google.com/network-
        intelligence-center/docs/connectivity-
        tests/concepts/overview#unsupported-configs).
      TRACKING_STATE: Tracking state for response traffic created when request
        traffic goes through allow firewall rule. For details, see [firewall
        rules specifications](https://cloud.google.com/firewall/docs/firewalls
        #specifications)
    """
    FIREWALL_RULE_TYPE_UNSPECIFIED = 0
    HIERARCHICAL_FIREWALL_POLICY_RULE = 1
    VPC_FIREWALL_RULE = 2
    IMPLIED_VPC_FIREWALL_RULE = 3
    SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE = 4
    NETWORK_FIREWALL_POLICY_RULE = 5
    NETWORK_REGIONAL_FIREWALL_POLICY_RULE = 6
    UNSUPPORTED_FIREWALL_POLICY_RULE = 7
    TRACKING_STATE = 8

  action = _messages.StringField(1)
  direction = _messages.StringField(2)
  displayName = _messages.StringField(3)
  firewallRuleType = _messages.EnumField('FirewallRuleTypeValueValuesEnum', 4)
  networkUri = _messages.StringField(5)
  policy = _messages.StringField(6)
  priority = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  targetServiceAccounts = _messages.StringField(8, repeated=True)
  targetTags = _messages.StringField(9, repeated=True)
  uri = _messages.StringField(10)


class ForwardInfo(_messages.Message):
  r"""Details of the final state "forward" and associated resource.

  Enums:
    TargetValueValuesEnum: Target type where this packet is forwarded to.

  Fields:
    ipAddress: IP address of the target (if applicable).
    resourceUri: URI of the resource that the packet is forwarded to.
    target: Target type where this packet is forwarded to.
  """

  class TargetValueValuesEnum(_messages.Enum):
    r"""Target type where this packet is forwarded to.

    Values:
      TARGET_UNSPECIFIED: Target not specified.
      PEERING_VPC: Forwarded to a VPC peering network.
      VPN_GATEWAY: Forwarded to a Cloud VPN gateway.
      INTERCONNECT: Forwarded to a Cloud Interconnect connection.
      GKE_MASTER: Forwarded to a Google Kubernetes Engine Container cluster
        master.
      IMPORTED_CUSTOM_ROUTE_NEXT_HOP: Forwarded to the next hop of a custom
        route imported from a peering VPC.
      CLOUD_SQL_INSTANCE: Forwarded to a Cloud SQL instance.
      ANOTHER_PROJECT: Forwarded to a VPC network in another project.
      NCC_HUB: Forwarded to an NCC Hub.
      ROUTER_APPLIANCE: Forwarded to a router appliance.
    """
    TARGET_UNSPECIFIED = 0
    PEERING_VPC = 1
    VPN_GATEWAY = 2
    INTERCONNECT = 3
    GKE_MASTER = 4
    IMPORTED_CUSTOM_ROUTE_NEXT_HOP = 5
    CLOUD_SQL_INSTANCE = 6
    ANOTHER_PROJECT = 7
    NCC_HUB = 8
    ROUTER_APPLIANCE = 9

  ipAddress = _messages.StringField(1)
  resourceUri = _messages.StringField(2)
  target = _messages.EnumField('TargetValueValuesEnum', 3)


class ForwardingRuleInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine forwarding
  rule.

  Fields:
    displayName: Name of the forwarding rule.
    loadBalancerName: Name of the load balancer the forwarding rule belongs
      to. Empty for forwarding rules not related to load balancers (like PSC
      forwarding rules).
    matchedPortRange: Port range defined in the forwarding rule that matches
      the packet.
    matchedProtocol: Protocol defined in the forwarding rule that matches the
      packet.
    networkUri: Network URI.
    pscGoogleApiTarget: PSC Google API target this forwarding rule targets (if
      applicable).
    pscServiceAttachmentUri: URI of the PSC service attachment this forwarding
      rule targets (if applicable).
    region: Region of the forwarding rule. Set only for regional forwarding
      rules.
    target: Target type of the forwarding rule.
    uri: URI of the forwarding rule.
    vip: VIP of the forwarding rule.
  """

  displayName = _messages.StringField(1)
  loadBalancerName = _messages.StringField(2)
  matchedPortRange = _messages.StringField(3)
  matchedProtocol = _messages.StringField(4)
  networkUri = _messages.StringField(5)
  pscGoogleApiTarget = _messages.StringField(6)
  pscServiceAttachmentUri = _messages.StringField(7)
  region = _messages.StringField(8)
  target = _messages.StringField(9)
  uri = _messages.StringField(10)
  vip = _messages.StringField(11)


class GKEMasterInfo(_messages.Message):
  r"""For display only. Metadata associated with a Google Kubernetes Engine
  (GKE) cluster master.

  Fields:
    clusterNetworkUri: URI of a GKE cluster network.
    clusterUri: URI of a GKE cluster.
    externalIp: External IP address of a GKE cluster master.
    internalIp: Internal IP address of a GKE cluster master.
  """

  clusterNetworkUri = _messages.StringField(1)
  clusterUri = _messages.StringField(2)
  externalIp = _messages.StringField(3)
  internalIp = _messages.StringField(4)


class GoogleServiceInfo(_messages.Message):
  r"""For display only. Details of a Google Service sending packets to a VPC
  network. Although the source IP might be a publicly routable address, some
  Google Services use special routes within Google production infrastructure
  to reach Compute Engine Instances.
  https://cloud.google.com/vpc/docs/routes#special_return_paths

  Enums:
    GoogleServiceTypeValueValuesEnum: Recognized type of a Google Service.

  Fields:
    googleServiceType: Recognized type of a Google Service.
    sourceIp: Source IP address.
  """

  class GoogleServiceTypeValueValuesEnum(_messages.Enum):
    r"""Recognized type of a Google Service.

    Values:
      GOOGLE_SERVICE_TYPE_UNSPECIFIED: Unspecified Google Service.
      IAP: Identity aware proxy. https://cloud.google.com/iap/docs/using-tcp-
        forwarding
      GFE_PROXY_OR_HEALTH_CHECK_PROBER: One of two services sharing IP ranges:
        * Load Balancer proxy * Centralized Health Check prober
        https://cloud.google.com/load-balancing/docs/firewall-rules
      CLOUD_DNS: Connectivity from Cloud DNS to forwarding targets or
        alternate name servers that use private routing.
        https://cloud.google.com/dns/docs/zones/forwarding-zones#firewall-
        rules https://cloud.google.com/dns/docs/policies#firewall-rules
      GOOGLE_API: private.googleapis.com and restricted.googleapis.com
      GOOGLE_API_PSC: Google API via Private Service Connect.
        https://cloud.google.com/vpc/docs/configure-private-service-connect-
        apis
      GOOGLE_API_VPC_SC: Google API via VPC Service Controls.
        https://cloud.google.com/vpc/docs/configure-private-service-connect-
        apis
    """
    GOOGLE_SERVICE_TYPE_UNSPECIFIED = 0
    IAP = 1
    GFE_PROXY_OR_HEALTH_CHECK_PROBER = 2
    CLOUD_DNS = 3
    GOOGLE_API = 4
    GOOGLE_API_PSC = 5
    GOOGLE_API_VPC_SC = 6

  googleServiceType = _messages.EnumField('GoogleServiceTypeValueValuesEnum', 1)
  sourceIp = _messages.StringField(2)


class InstanceInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine instance.

  Fields:
    displayName: Name of a Compute Engine instance.
    externalIp: External IP address of the network interface.
    interface: Name of the network interface of a Compute Engine instance.
    internalIp: Internal IP address of the network interface.
    networkTags: Network tags configured on the instance.
    networkUri: URI of a Compute Engine network.
    pscNetworkAttachmentUri: URI of the PSC network attachment the NIC is
      attached to (if relevant).
    serviceAccount: Service account authorized for the instance.
    uri: URI of a Compute Engine instance.
  """

  displayName = _messages.StringField(1)
  externalIp = _messages.StringField(2)
  interface = _messages.StringField(3)
  internalIp = _messages.StringField(4)
  networkTags = _messages.StringField(5, repeated=True)
  networkUri = _messages.StringField(6)
  pscNetworkAttachmentUri = _messages.StringField(7)
  serviceAccount = _messages.StringField(8)
  uri = _messages.StringField(9)


class ListAppliancesResponse(_messages.Message):
  r"""The list of appliances as requested by the user.

  Fields:
    appliances: List of Appliance resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  appliances = _messages.MessageField('Appliance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeploymentsResponse(_messages.Message):
  r"""The list of deployments as requested by the user.

  Fields:
    deployments: List of Deployment resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSimulationsResponse(_messages.Message):
  r"""Message for response to listing Simulations

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    simulations: The list of Simulation
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  simulations = _messages.MessageField('Simulation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class LoadBalancerBackend(_messages.Message):
  r"""For display only. Metadata associated with a specific load balancer
  backend.

  Enums:
    HealthCheckFirewallStateValueValuesEnum: State of the health check
      firewall configuration.

  Fields:
    displayName: Name of a Compute Engine instance or network endpoint.
    healthCheckAllowingFirewallRules: A list of firewall rule URIs allowing
      probes from health check IP ranges.
    healthCheckBlockingFirewallRules: A list of firewall rule URIs blocking
      probes from health check IP ranges.
    healthCheckFirewallState: State of the health check firewall
      configuration.
    uri: URI of a Compute Engine instance or network endpoint.
  """

  class HealthCheckFirewallStateValueValuesEnum(_messages.Enum):
    r"""State of the health check firewall configuration.

    Values:
      HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED: State is unspecified. Default
        state if not populated.
      CONFIGURED: There are configured firewall rules to allow health check
        probes to the backend.
      MISCONFIGURED: There are firewall rules configured to allow partial
        health check ranges or block all health check ranges. If a health
        check probe is sent from denied IP ranges, the health check to the
        backend will fail. Then, the backend will be marked unhealthy and will
        not receive traffic sent to the load balancer.
    """
    HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED = 0
    CONFIGURED = 1
    MISCONFIGURED = 2

  displayName = _messages.StringField(1)
  healthCheckAllowingFirewallRules = _messages.StringField(2, repeated=True)
  healthCheckBlockingFirewallRules = _messages.StringField(3, repeated=True)
  healthCheckFirewallState = _messages.EnumField('HealthCheckFirewallStateValueValuesEnum', 4)
  uri = _messages.StringField(5)


class LoadBalancerBackendInfo(_messages.Message):
  r"""For display only. Metadata associated with the load balancer backend.

  Enums:
    HealthCheckFirewallsConfigStateValueValuesEnum: Output only. Health check
      firewalls configuration state for the backend. This is a result of the
      static firewall analysis (verifying that health check traffic from
      required IP ranges to the backend is allowed or not). The backend might
      still be unhealthy even if these firewalls are configured. Please refer
      to the documentation for more information:
      https://cloud.google.com/load-balancing/docs/firewall-rules

  Fields:
    backendBucketUri: URI of the backend bucket this backend targets (if
      applicable).
    backendServiceUri: URI of the backend service this backend belongs to (if
      applicable).
    healthCheckFirewallsConfigState: Output only. Health check firewalls
      configuration state for the backend. This is a result of the static
      firewall analysis (verifying that health check traffic from required IP
      ranges to the backend is allowed or not). The backend might still be
      unhealthy even if these firewalls are configured. Please refer to the
      documentation for more information: https://cloud.google.com/load-
      balancing/docs/firewall-rules
    healthCheckUri: URI of the health check attached to this backend (if
      applicable).
    instanceGroupUri: URI of the instance group this backend belongs to (if
      applicable).
    instanceUri: URI of the backend instance (if applicable). Populated for
      instance group backends, and zonal NEG backends.
    name: Display name of the backend. For example, it might be an instance
      name for the instance group backends, or an IP address and port for
      zonal network endpoint group backends.
    networkEndpointGroupUri: URI of the network endpoint group this backend
      belongs to (if applicable).
    pscGoogleApiTarget: PSC Google API target this PSC NEG backend targets (if
      applicable).
    pscServiceAttachmentUri: URI of the PSC service attachment this PSC NEG
      backend targets (if applicable).
  """

  class HealthCheckFirewallsConfigStateValueValuesEnum(_messages.Enum):
    r"""Output only. Health check firewalls configuration state for the
    backend. This is a result of the static firewall analysis (verifying that
    health check traffic from required IP ranges to the backend is allowed or
    not). The backend might still be unhealthy even if these firewalls are
    configured. Please refer to the documentation for more information:
    https://cloud.google.com/load-balancing/docs/firewall-rules

    Values:
      HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED: Configuration state
        unspecified. It usually means that the backend has no health check
        attached, or there was an unexpected configuration error preventing
        Connectivity tests from verifying health check configuration.
      FIREWALLS_CONFIGURED: Firewall rules (policies) allowing health check
        traffic from all required IP ranges to the backend are configured.
      FIREWALLS_PARTIALLY_CONFIGURED: Firewall rules (policies) allow health
        check traffic only from a part of required IP ranges.
      FIREWALLS_NOT_CONFIGURED: Firewall rules (policies) deny health check
        traffic from all required IP ranges to the backend.
      FIREWALLS_UNSUPPORTED: The network contains firewall rules of
        unsupported types, so Connectivity tests were not able to verify
        health check configuration status. Please refer to the documentation
        for the list of unsupported configurations:
        https://cloud.google.com/network-intelligence-
        center/docs/connectivity-tests/concepts/overview#unsupported-configs
    """
    HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED = 0
    FIREWALLS_CONFIGURED = 1
    FIREWALLS_PARTIALLY_CONFIGURED = 2
    FIREWALLS_NOT_CONFIGURED = 3
    FIREWALLS_UNSUPPORTED = 4

  backendBucketUri = _messages.StringField(1)
  backendServiceUri = _messages.StringField(2)
  healthCheckFirewallsConfigState = _messages.EnumField('HealthCheckFirewallsConfigStateValueValuesEnum', 3)
  healthCheckUri = _messages.StringField(4)
  instanceGroupUri = _messages.StringField(5)
  instanceUri = _messages.StringField(6)
  name = _messages.StringField(7)
  networkEndpointGroupUri = _messages.StringField(8)
  pscGoogleApiTarget = _messages.StringField(9)
  pscServiceAttachmentUri = _messages.StringField(10)


class LoadBalancerInfo(_messages.Message):
  r"""For display only. Metadata associated with a load balancer.

  Enums:
    BackendTypeValueValuesEnum: Type of load balancer's backend configuration.
    LoadBalancerTypeValueValuesEnum: Type of the load balancer.

  Fields:
    backendType: Type of load balancer's backend configuration.
    backendUri: Backend configuration URI.
    backends: Information for the loadbalancer backends.
    healthCheckUri: URI of the health check for the load balancer. Deprecated
      and no longer populated as different load balancer backends might have
      different health checks.
    loadBalancerType: Type of the load balancer.
  """

  class BackendTypeValueValuesEnum(_messages.Enum):
    r"""Type of load balancer's backend configuration.

    Values:
      BACKEND_TYPE_UNSPECIFIED: Type is unspecified.
      BACKEND_SERVICE: Backend Service as the load balancer's backend.
      TARGET_POOL: Target Pool as the load balancer's backend.
      TARGET_INSTANCE: Target Instance as the load balancer's backend.
    """
    BACKEND_TYPE_UNSPECIFIED = 0
    BACKEND_SERVICE = 1
    TARGET_POOL = 2
    TARGET_INSTANCE = 3

  class LoadBalancerTypeValueValuesEnum(_messages.Enum):
    r"""Type of the load balancer.

    Values:
      LOAD_BALANCER_TYPE_UNSPECIFIED: Type is unspecified.
      INTERNAL_TCP_UDP: Internal TCP/UDP load balancer.
      NETWORK_TCP_UDP: Network TCP/UDP load balancer.
      HTTP_PROXY: HTTP(S) proxy load balancer.
      TCP_PROXY: TCP proxy load balancer.
      SSL_PROXY: SSL proxy load balancer.
    """
    LOAD_BALANCER_TYPE_UNSPECIFIED = 0
    INTERNAL_TCP_UDP = 1
    NETWORK_TCP_UDP = 2
    HTTP_PROXY = 3
    TCP_PROXY = 4
    SSL_PROXY = 5

  backendType = _messages.EnumField('BackendTypeValueValuesEnum', 1)
  backendUri = _messages.StringField(2)
  backends = _messages.MessageField('LoadBalancerBackend', 3, repeated=True)
  healthCheckUri = _messages.StringField(4)
  loadBalancerType = _messages.EnumField('LoadBalancerTypeValueValuesEnum', 5)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class NatInfo(_messages.Message):
  r"""For display only. Metadata associated with NAT.

  Enums:
    TypeValueValuesEnum: Type of NAT.

  Fields:
    natGatewayName: The name of Cloud NAT Gateway. Only valid when type is
      CLOUD_NAT.
    networkUri: URI of the network where NAT translation takes place.
    newDestinationIp: Destination IP address after NAT translation.
    newDestinationPort: Destination port after NAT translation. Only valid
      when protocol is TCP or UDP.
    newSourceIp: Source IP address after NAT translation.
    newSourcePort: Source port after NAT translation. Only valid when protocol
      is TCP or UDP.
    oldDestinationIp: Destination IP address before NAT translation.
    oldDestinationPort: Destination port before NAT translation. Only valid
      when protocol is TCP or UDP.
    oldSourceIp: Source IP address before NAT translation.
    oldSourcePort: Source port before NAT translation. Only valid when
      protocol is TCP or UDP.
    protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
    routerUri: Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
    type: Type of NAT.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of NAT.

    Values:
      TYPE_UNSPECIFIED: Type is unspecified.
      INTERNAL_TO_EXTERNAL: From Compute Engine instance's internal address to
        external address.
      EXTERNAL_TO_INTERNAL: From Compute Engine instance's external address to
        internal address.
      CLOUD_NAT: Cloud NAT Gateway.
      PRIVATE_SERVICE_CONNECT: Private service connect NAT.
    """
    TYPE_UNSPECIFIED = 0
    INTERNAL_TO_EXTERNAL = 1
    EXTERNAL_TO_INTERNAL = 2
    CLOUD_NAT = 3
    PRIVATE_SERVICE_CONNECT = 4

  natGatewayName = _messages.StringField(1)
  networkUri = _messages.StringField(2)
  newDestinationIp = _messages.StringField(3)
  newDestinationPort = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  newSourceIp = _messages.StringField(5)
  newSourcePort = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  oldDestinationIp = _messages.StringField(7)
  oldDestinationPort = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  oldSourceIp = _messages.StringField(9)
  oldSourcePort = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  protocol = _messages.StringField(11)
  routerUri = _messages.StringField(12)
  type = _messages.EnumField('TypeValueValuesEnum', 13)


class NetworkInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine network.

  Fields:
    displayName: Name of a Compute Engine network.
    matchedIpRange: The IP range that matches the test.
    uri: URI of a Compute Engine network.
  """

  displayName = _messages.StringField(1)
  matchedIpRange = _messages.StringField(2)
  uri = _messages.StringField(3)


class NetworkmanagementProjectsLocationsAppliancesGetRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsAppliancesGetRequest object.

  Fields:
    name: Required. A name of the Appliance to get. Must be in the format
      `projects/{project}/locations/{location}/appliances/{appliance}`.
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsAppliancesListRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsAppliancesListRequest object.

  Fields:
    pageSize: Maximum number of Appliances to return per call.
    pageToken: The value returned by the last `ListAppliancesResponse`
      Indicates that this is a continuation of a prior `ListAppliances` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the Appliance should
      be listed, specified in the format
      `projects/{project}/locations/{location}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkmanagementProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: The identifier for this deployment instance.
    parent: Required. The project and location where the Deployment should be
      created, specified in the format
      `projects/{project}/locations/{location}`.
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkmanagementProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. name of the deployment to be deleted
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the Deployment to get. Must be in the format
      `projects/{project}/locations/{location}/deployments/{deployment}`.
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsDeploymentsListRequest object.

  Fields:
    pageSize: Maximum number of Deployments to return per call. If
      unspecified, will default to 10. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: The value returned by the last `ListDeploymentsResponse`
      Indicates that this is a continuation of a prior `ListDeployments` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the Deployments
      should be listed, specified in the format
      `projects/{project}/locations/{location}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkmanagementProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: Required. Name of the Deployment resource. It matches the pattern
      `projects/{project}/locations/{location}/deployments/{deployment}` and
      must be unique.
    updateMask: update mask
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkmanagementProjectsLocationsGetRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsListRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class NetworkmanagementProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkmanagementProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkmanagementProjectsLocationsSimulationsCreateRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsCreateRequest object.

  Fields:
    parent: Required. The parent resource of the Simulation:
      `projects/{project_id}/locations/global`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    simulation: A Simulation resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  simulation = _messages.MessageField('Simulation', 3)


class NetworkmanagementProjectsLocationsSimulationsDeleteRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkmanagementProjectsLocationsSimulationsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkmanagementProjectsLocationsSimulationsGetRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class NetworkmanagementProjectsLocationsSimulationsListRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListSimulationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkmanagementProjectsLocationsSimulationsPatchRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsPatchRequest object.

  Fields:
    name: Unique name of the resource using the form:
      `projects/{project_id}/locations/global/simulations/{simulation_id}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    simulation: A Simulation resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Simulation resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  simulation = _messages.MessageField('Simulation', 3)
  updateMask = _messages.StringField(4)


class NetworkmanagementProjectsLocationsSimulationsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkmanagementProjectsLocationsSimulationsTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkmanagementProjectsLocationsSimulationsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OutOfBandDeploymentConfig(_messages.Message):
  r"""Config used to deploy an out of band appliance topology.

  Fields:
    applianceId: The id returned by our get appliance methods that identifies
      the appliance that will be deployed.
    applianceLoginSshKey: The public ssh key that will be used to log into the
      appliance.
    bootstrapParams: The bootstrap parameters that will be passed to appliance
      on first boot. The format for bootstrap parameters will depend on the
      appliance vendor and will vary. TODO (http://b/242734886): Add links to
      docs once they are in place.
    machineType: The GCP machine type the appliance vm will be installed on.
      Example: e2-standard-4 See
      https://cloud.google.com/compute/docs/machine-types for more
      information. TODO (http://b/242734886): Add links to docs once they are
      in place (in this case, verify the above link is what we want for the
      final link).
    managementSubnet: The name of an existing subnet the appliance's
      management interface should connect to. This must be a subnet that
      exists in the vpc specified in the 'management_vpc' field. This field
      must be set if 'management_vpc' is set.
    managementSubnetCidrRange: The cidr range the appliance's management
      interface should get its ip from. Either this should be set, or
      management_vpc and management_subnet should both be set. Example:
      25.72.12.0/24
    managementVpc: The name of an existing vpc that the appliance's management
      interface should connect to.
    maxInstances: The maximum number of instances of the appliance that should
      be running at any time.
    minInstances: The minimum number of instances of the appliance that should
      be running at any time.
    namingPrefix: A user specified string that will be prefixed to names of
      resources we create on their behalf.
    trafficSubnetCidrRange: The cidr range that specifies the traffic that
      should be directed to the appliance. Example: 25.72.12.0/24
    zones: The zones the appliance group will be deployed to. TODO
      (http://b/242734886): Add links to docs once they are in place.
  """

  applianceId = _messages.StringField(1)
  applianceLoginSshKey = _messages.StringField(2)
  bootstrapParams = _messages.StringField(3)
  machineType = _messages.StringField(4)
  managementSubnet = _messages.StringField(5)
  managementSubnetCidrRange = _messages.StringField(6)
  managementVpc = _messages.StringField(7)
  maxInstances = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  minInstances = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  namingPrefix = _messages.StringField(10)
  trafficSubnetCidrRange = _messages.StringField(11)
  zones = _messages.StringField(12, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  rules = _messages.MessageField('Rule', 4, repeated=True)
  version = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class ProxyConnectionInfo(_messages.Message):
  r"""For display only. Metadata associated with ProxyConnection.

  Fields:
    networkUri: URI of the network where connection is proxied.
    newDestinationIp: Destination IP address of a new connection.
    newDestinationPort: Destination port of a new connection. Only valid when
      protocol is TCP or UDP.
    newSourceIp: Source IP address of a new connection.
    newSourcePort: Source port of a new connection. Only valid when protocol
      is TCP or UDP.
    oldDestinationIp: Destination IP address of an original connection
    oldDestinationPort: Destination port of an original connection. Only valid
      when protocol is TCP or UDP.
    oldSourceIp: Source IP address of an original connection.
    oldSourcePort: Source port of an original connection. Only valid when
      protocol is TCP or UDP.
    protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
    subnetUri: Uri of proxy subnet.
  """

  networkUri = _messages.StringField(1)
  newDestinationIp = _messages.StringField(2)
  newDestinationPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  newSourceIp = _messages.StringField(4)
  newSourcePort = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  oldDestinationIp = _messages.StringField(6)
  oldDestinationPort = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  oldSourceIp = _messages.StringField(8)
  oldSourcePort = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  protocol = _messages.StringField(10)
  subnetUri = _messages.StringField(11)


class ReachabilityDetails(_messages.Message):
  r"""Results of the configuration analysis from the last run of the test.

  Enums:
    ResultValueValuesEnum: The overall result of the test's configuration
      analysis.

  Fields:
    error: The details of a failure or a cancellation of reachability
      analysis.
    result: The overall result of the test's configuration analysis.
    traces: Result may contain a list of traces if a test has multiple
      possible paths in the network, such as when destination endpoint is a
      load balancer with multiple backends.
    verifyTime: The time of the configuration analysis.
  """

  class ResultValueValuesEnum(_messages.Enum):
    r"""The overall result of the test's configuration analysis.

    Values:
      RESULT_UNSPECIFIED: No result was specified.
      REACHABLE: Possible scenarios are: * The configuration analysis
        determined that a packet originating from the source is expected to
        reach the destination. * The analysis didn't complete because the user
        lacks permission for some of the resources in the trace. However, at
        the time the user's permission became insufficient, the trace had been
        successful so far.
      UNREACHABLE: A packet originating from the source is expected to be
        dropped before reaching the destination.
      AMBIGUOUS: The source and destination endpoints do not uniquely identify
        the test location in the network, and the reachability result contains
        multiple traces. For some traces, a packet could be delivered, and for
        others, it would not be. This result is also assigned to configuration
        analysis of return path if on its own it should be REACHABLE, but
        configuration analysis of forward path is AMBIGUOUS.
      UNDETERMINED: The configuration analysis did not complete. Possible
        reasons are: * A permissions error occurred--for example, the user
        might not have read permission for all of the resources named in the
        test. * An internal error occurred. * The analyzer received an invalid
        or unsupported argument or was unable to identify a known endpoint.
    """
    RESULT_UNSPECIFIED = 0
    REACHABLE = 1
    UNREACHABLE = 2
    AMBIGUOUS = 3
    UNDETERMINED = 4

  error = _messages.MessageField('Status', 1)
  result = _messages.EnumField('ResultValueValuesEnum', 2)
  traces = _messages.MessageField('Trace', 3, repeated=True)
  verifyTime = _messages.StringField(4)


class RouteInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine route.

  Enums:
    NextHopTypeValueValuesEnum: Type of next hop.
    RouteScopeValueValuesEnum: Indicates where route is applicable.
    RouteTypeValueValuesEnum: Type of route.

  Fields:
    destIpRange: Destination IP range of the route.
    destPortRanges: Destination port ranges of the route. Policy based routes
      only.
    displayName: Name of a route.
    instanceTags: Instance tags of the route.
    nccHubUri: URI of a NCC Hub. NCC_HUB routes only.
    nccSpokeUri: URI of a NCC Spoke. NCC_HUB routes only.
    networkUri: URI of a Compute Engine network. NETWORK routes only.
    nextHop: Next hop of the route.
    nextHopType: Type of next hop.
    priority: Priority of the route.
    protocols: Protocols of the route. Policy based routes only.
    routeScope: Indicates where route is applicable.
    routeType: Type of route.
    srcIpRange: Source IP address range of the route. Policy based routes
      only.
    srcPortRanges: Source port ranges of the route. Policy based routes only.
    uri: URI of a route. Dynamic, peering static and peering dynamic routes do
      not have an URI. Advertised route from Google Cloud VPC to on-premises
      network also does not have an URI.
  """

  class NextHopTypeValueValuesEnum(_messages.Enum):
    r"""Type of next hop.

    Values:
      NEXT_HOP_TYPE_UNSPECIFIED: Unspecified type. Default value.
      NEXT_HOP_IP: Next hop is an IP address.
      NEXT_HOP_INSTANCE: Next hop is a Compute Engine instance.
      NEXT_HOP_NETWORK: Next hop is a VPC network gateway.
      NEXT_HOP_PEERING: Next hop is a peering VPC.
      NEXT_HOP_INTERCONNECT: Next hop is an interconnect.
      NEXT_HOP_VPN_TUNNEL: Next hop is a VPN tunnel.
      NEXT_HOP_VPN_GATEWAY: Next hop is a VPN gateway. This scenario only
        happens when tracing connectivity from an on-premises network to
        Google Cloud through a VPN. The analysis simulates a packet departing
        from the on-premises network through a VPN tunnel and arriving at a
        Cloud VPN gateway.
      NEXT_HOP_INTERNET_GATEWAY: Next hop is an internet gateway.
      NEXT_HOP_BLACKHOLE: Next hop is blackhole; that is, the next hop either
        does not exist or is not running.
      NEXT_HOP_ILB: Next hop is the forwarding rule of an Internal Load
        Balancer.
      NEXT_HOP_ROUTER_APPLIANCE: Next hop is a [router appliance
        instance](https://cloud.google.com/network-connectivity/docs/network-
        connectivity-center/concepts/ra-overview).
      NEXT_HOP_NCC_HUB: Next hop is an NCC hub.
    """
    NEXT_HOP_TYPE_UNSPECIFIED = 0
    NEXT_HOP_IP = 1
    NEXT_HOP_INSTANCE = 2
    NEXT_HOP_NETWORK = 3
    NEXT_HOP_PEERING = 4
    NEXT_HOP_INTERCONNECT = 5
    NEXT_HOP_VPN_TUNNEL = 6
    NEXT_HOP_VPN_GATEWAY = 7
    NEXT_HOP_INTERNET_GATEWAY = 8
    NEXT_HOP_BLACKHOLE = 9
    NEXT_HOP_ILB = 10
    NEXT_HOP_ROUTER_APPLIANCE = 11
    NEXT_HOP_NCC_HUB = 12

  class RouteScopeValueValuesEnum(_messages.Enum):
    r"""Indicates where route is applicable.

    Values:
      ROUTE_SCOPE_UNSPECIFIED: Unspecified scope. Default value.
      NETWORK: Route is applicable to packets in Network.
      NCC_HUB: Route is applicable to packets using NCC Hub's routing table.
    """
    ROUTE_SCOPE_UNSPECIFIED = 0
    NETWORK = 1
    NCC_HUB = 2

  class RouteTypeValueValuesEnum(_messages.Enum):
    r"""Type of route.

    Values:
      ROUTE_TYPE_UNSPECIFIED: Unspecified type. Default value.
      SUBNET: Route is a subnet route automatically created by the system.
      STATIC: Static route created by the user, including the default route to
        the internet.
      DYNAMIC: Dynamic route exchanged between BGP peers.
      PEERING_SUBNET: A subnet route received from peering network.
      PEERING_STATIC: A static route received from peering network.
      PEERING_DYNAMIC: A dynamic route received from peering network.
      POLICY_BASED: Policy based route.
    """
    ROUTE_TYPE_UNSPECIFIED = 0
    SUBNET = 1
    STATIC = 2
    DYNAMIC = 3
    PEERING_SUBNET = 4
    PEERING_STATIC = 5
    PEERING_DYNAMIC = 6
    POLICY_BASED = 7

  destIpRange = _messages.StringField(1)
  destPortRanges = _messages.StringField(2, repeated=True)
  displayName = _messages.StringField(3)
  instanceTags = _messages.StringField(4, repeated=True)
  nccHubUri = _messages.StringField(5)
  nccSpokeUri = _messages.StringField(6)
  networkUri = _messages.StringField(7)
  nextHop = _messages.StringField(8)
  nextHopType = _messages.EnumField('NextHopTypeValueValuesEnum', 9)
  priority = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  protocols = _messages.StringField(11, repeated=True)
  routeScope = _messages.EnumField('RouteScopeValueValuesEnum', 12)
  routeType = _messages.EnumField('RouteTypeValueValuesEnum', 13)
  srcIpRange = _messages.StringField(14)
  srcPortRanges = _messages.StringField(15, repeated=True)
  uri = _messages.StringField(16)


class Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of CheckPolicy for any entries
      that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class ServerlessNegInfo(_messages.Message):
  r"""For display only. Metadata associated with the serverless network
  endpoint group backend.

  Fields:
    negUri: URI of the serverless network endpoint group.
  """

  negUri = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class ShadowedFirewallSimulationData(_messages.Message):
  r"""Message for simulation data of shadowed firewall analysis."""


class ShadowedFirewallSimulationResult(_messages.Message):
  r"""ShadowedFirewallSimulationResult contains results for shadowed firewall
  analysis from two network configurations, i.e. original and proposed network
  configurations.

  Fields:
    baseConfigResults: Results for simulating shadowed firewall analysis with
      original network configurations. There can be more than one shadowing
      relation for a particular shadowing firewall.
    firewall: Relative resource path (i.e. uri) of the firewall rule that is
      getting shadowed:
      'projects/{project_id}/{location}/firewalls/{firewall_name}'
    network: Relative resource path (i.e. uri) of the network in which the
      shadowed firewall belongs:
      'projects/{project_id}/{location}/networks/{network_name}'
    proposedConfigResults: Results for simulating shadowed firewall analysis
      with proposed network configurations. There can be more than one
      shadowing relation for a particular shadowing firewall.
    resultsDiffer: Indicates if the results from running shadowed firewall
      analysis with the original network configurations and with the proposed
      network configurations differ.
  """

  baseConfigResults = _messages.MessageField('ShadowingInfo', 1, repeated=True)
  firewall = _messages.StringField(2)
  network = _messages.StringField(3)
  proposedConfigResults = _messages.MessageField('ShadowingInfo', 4, repeated=True)
  resultsDiffer = _messages.BooleanField(5)


class ShadowingInfo(_messages.Message):
  r"""ShadowingInfo defines a list of firewalls that are causing shadowing for
  a particular firewall.

  Fields:
    shadowingFirewalls: Relative resource path (i.e. uri) of the resource that
      is causing shadowing:
      'projects/{project_id}/{location}/firewalls/{firewall_name}'
  """

  shadowingFirewalls = _messages.StringField(1, repeated=True)


class Simulation(_messages.Message):
  r"""Message describing Simulation object

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    baseConfig: Deprecated: Base configuration which is populated by backend
      when simulation is run or rerun. Please use config_changes field
      instead.
    configChanges: Group of resource configuration changes that needs to be
      simulated together.
    connectivityTestSimulationData: Connectivity test data to simulate.
    createTime: Output only. Creation timestamp.
    creationOnly: Only creates a simulation resource without triggering the
      simulation analysis.
    labels: Labels as key value pairs.
    name: Unique name of the resource using the form:
      `projects/{project_id}/locations/global/simulations/{simulation_id}`
    proposedConfig: Deprecated: Proposed configuration diff which defines a
      group of resource configuration changes that need to be simulated
      together. Please use config_changes field instead.
    shadowedFirewallSimulationData: Shadowed firewall test data to simulate.
    simulationResult: Simulation result.
    updateTime: Output only. Update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  baseConfig = _messages.MessageField('ConfigChange', 1, repeated=True)
  configChanges = _messages.MessageField('ConfigChange', 2, repeated=True)
  connectivityTestSimulationData = _messages.MessageField('ConnectivityTestSimulationData', 3)
  createTime = _messages.StringField(4)
  creationOnly = _messages.BooleanField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  proposedConfig = _messages.MessageField('ConfigChange', 8, repeated=True)
  shadowedFirewallSimulationData = _messages.MessageField('ShadowedFirewallSimulationData', 9)
  simulationResult = _messages.MessageField('SimulationResult', 10)
  updateTime = _messages.StringField(11)


class SimulationResult(_messages.Message):
  r"""SimulationResult provides the simulation result for corresponding
  simulation resource.

  Enums:
    OperationStateValueValuesEnum: Specify the Simulation state.

  Fields:
    connectivityTestSimulationResult: Connectivity test simulation results
      showing diff for each test with pagination.
    executionDuration: Simulation execution duration including a start time
      and an end time.
    operationState: Specify the Simulation state.
    shadowedFirewallSimulationResult: Shadowed firewall simulation results
      showing diff with pagination.
    snapshotTime: Timestamp for data model snapshot used for simulation.
  """

  class OperationStateValueValuesEnum(_messages.Enum):
    r"""Specify the Simulation state.

    Values:
      OPERATION_STATE_UNSPECIFIED: Default operation state.
      INITIALIZED: Indicates simulation was just initialized.
      SUCCEEDED: Indicates simulation succeeded.
      FAILED: Indicates simulation failed.
      ABORTED: Indicates simulation was aborted.
    """
    OPERATION_STATE_UNSPECIFIED = 0
    INITIALIZED = 1
    SUCCEEDED = 2
    FAILED = 3
    ABORTED = 4

  connectivityTestSimulationResult = _messages.MessageField('ConnectivityTestSimulationResult', 1, repeated=True)
  executionDuration = _messages.StringField(2)
  operationState = _messages.EnumField('OperationStateValueValuesEnum', 3)
  shadowedFirewallSimulationResult = _messages.MessageField('ShadowedFirewallSimulationResult', 4, repeated=True)
  snapshotTime = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Step(_messages.Message):
  r"""A simulated forwarding path is composed of multiple steps. Each step has
  a well-defined state and an associated configuration.

  Enums:
    StateValueValuesEnum: Each step is in one of the pre-defined states.

  Fields:
    abort: Display information of the final state "abort" and reason.
    appEngineVersion: Display information of an App Engine service version.
    causesDrop: This is a step that leads to the final state Drop.
    cloudFunction: Display information of a Cloud Function.
    cloudRunRevision: Display information of a Cloud Run revision.
    cloudSqlInstance: Display information of a Cloud SQL instance.
    deliver: Display information of the final state "deliver" and reason.
    description: A description of the step. Usually this is a summary of the
      state.
    drop: Display information of the final state "drop" and reason.
    endpoint: Display information of the source and destination under
      analysis. The endpoint information in an intermediate state may differ
      with the initial input, as it might be modified by state like NAT, or
      Connection Proxy.
    firewall: Display information of a Compute Engine firewall rule.
    forward: Display information of the final state "forward" and reason.
    forwardingRule: Display information of a Compute Engine forwarding rule.
    gkeMaster: Display information of a Google Kubernetes Engine cluster
      master.
    googleService: Display information of a Google service
    instance: Display information of a Compute Engine instance.
    loadBalancer: Display information of the load balancers. Deprecated in
      favor of the `load_balancer_backend_info` field, not used in new tests.
    loadBalancerBackendInfo: Display information of a specific load balancer
      backend.
    nat: Display information of a NAT.
    network: Display information of a Google Cloud network.
    projectId: Project ID that contains the configuration this step is
      validating.
    proxyConnection: Display information of a ProxyConnection.
    route: Display information of a Compute Engine route.
    serverlessNeg: Display information of a Serverless network endpoint group
      backend. Used only for return traces.
    state: Each step is in one of the pre-defined states.
    storageBucket: Display information of a Storage Bucket. Used only for
      return traces.
    vpcConnector: Display information of a VPC connector.
    vpnGateway: Display information of a Compute Engine VPN gateway.
    vpnTunnel: Display information of a Compute Engine VPN tunnel.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Each step is in one of the pre-defined states.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      START_FROM_INSTANCE: Initial state: packet originating from a Compute
        Engine instance. An InstanceInfo is populated with starting instance
        information.
      START_FROM_INTERNET: Initial state: packet originating from the
        internet. The endpoint information is populated.
      START_FROM_GOOGLE_SERVICE: Initial state: packet originating from a
        Google service. The google_service information is populated.
      START_FROM_PRIVATE_NETWORK: Initial state: packet originating from a VPC
        or on-premises network with internal source IP. If the source is a VPC
        network visible to the user, a NetworkInfo is populated with details
        of the network.
      START_FROM_GKE_MASTER: Initial state: packet originating from a Google
        Kubernetes Engine cluster master. A GKEMasterInfo is populated with
        starting instance information.
      START_FROM_CLOUD_SQL_INSTANCE: Initial state: packet originating from a
        Cloud SQL instance. A CloudSQLInstanceInfo is populated with starting
        instance information.
      START_FROM_CLOUD_FUNCTION: Initial state: packet originating from a
        Cloud Function. A CloudFunctionInfo is populated with starting
        function information.
      START_FROM_APP_ENGINE_VERSION: Initial state: packet originating from an
        App Engine service version. An AppEngineVersionInfo is populated with
        starting version information.
      START_FROM_CLOUD_RUN_REVISION: Initial state: packet originating from a
        Cloud Run revision. A CloudRunRevisionInfo is populated with starting
        revision information.
      START_FROM_STORAGE_BUCKET: Initial state: packet originating from a
        Storage Bucket. Used only for return traces. The storage_bucket
        information is populated.
      START_FROM_PSC_PUBLISHED_SERVICE: Initial state: packet originating from
        a published service that uses Private Service Connect. Used only for
        return traces.
      START_FROM_SERVERLESS_NEG: Initial state: packet originating from a
        serverless network endpoint group backend. Used only for return
        traces. The serverless_neg information is populated.
      APPLY_INGRESS_FIREWALL_RULE: Config checking state: verify ingress
        firewall rule.
      APPLY_EGRESS_FIREWALL_RULE: Config checking state: verify egress
        firewall rule.
      APPLY_ROUTE: Config checking state: verify route.
      APPLY_FORWARDING_RULE: Config checking state: match forwarding rule.
      ANALYZE_LOAD_BALANCER_BACKEND: Config checking state: verify load
        balancer backend configuration.
      SPOOFING_APPROVED: Config checking state: packet sent or received under
        foreign IP address and allowed.
      ARRIVE_AT_INSTANCE: Forwarding state: arriving at a Compute Engine
        instance.
      ARRIVE_AT_INTERNAL_LOAD_BALANCER: Forwarding state: arriving at a
        Compute Engine internal load balancer. Deprecated in favor of the
        `ANALYZE_LOAD_BALANCER_BACKEND` state, not used in new tests.
      ARRIVE_AT_EXTERNAL_LOAD_BALANCER: Forwarding state: arriving at a
        Compute Engine external load balancer. Deprecated in favor of the
        `ANALYZE_LOAD_BALANCER_BACKEND` state, not used in new tests.
      ARRIVE_AT_VPN_GATEWAY: Forwarding state: arriving at a Cloud VPN
        gateway.
      ARRIVE_AT_VPN_TUNNEL: Forwarding state: arriving at a Cloud VPN tunnel.
      ARRIVE_AT_VPC_CONNECTOR: Forwarding state: arriving at a VPC connector.
      NAT: Transition state: packet header translated.
      PROXY_CONNECTION: Transition state: original connection is terminated
        and a new proxied connection is initiated.
      DELIVER: Final state: packet could be delivered.
      DROP: Final state: packet could be dropped.
      FORWARD: Final state: packet could be forwarded to a network with an
        unknown configuration.
      ABORT: Final state: analysis is aborted.
      VIEWER_PERMISSION_MISSING: Special state: viewer of the test result does
        not have permission to see the configuration in this step.
    """
    STATE_UNSPECIFIED = 0
    START_FROM_INSTANCE = 1
    START_FROM_INTERNET = 2
    START_FROM_GOOGLE_SERVICE = 3
    START_FROM_PRIVATE_NETWORK = 4
    START_FROM_GKE_MASTER = 5
    START_FROM_CLOUD_SQL_INSTANCE = 6
    START_FROM_CLOUD_FUNCTION = 7
    START_FROM_APP_ENGINE_VERSION = 8
    START_FROM_CLOUD_RUN_REVISION = 9
    START_FROM_STORAGE_BUCKET = 10
    START_FROM_PSC_PUBLISHED_SERVICE = 11
    START_FROM_SERVERLESS_NEG = 12
    APPLY_INGRESS_FIREWALL_RULE = 13
    APPLY_EGRESS_FIREWALL_RULE = 14
    APPLY_ROUTE = 15
    APPLY_FORWARDING_RULE = 16
    ANALYZE_LOAD_BALANCER_BACKEND = 17
    SPOOFING_APPROVED = 18
    ARRIVE_AT_INSTANCE = 19
    ARRIVE_AT_INTERNAL_LOAD_BALANCER = 20
    ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 21
    ARRIVE_AT_VPN_GATEWAY = 22
    ARRIVE_AT_VPN_TUNNEL = 23
    ARRIVE_AT_VPC_CONNECTOR = 24
    NAT = 25
    PROXY_CONNECTION = 26
    DELIVER = 27
    DROP = 28
    FORWARD = 29
    ABORT = 30
    VIEWER_PERMISSION_MISSING = 31

  abort = _messages.MessageField('AbortInfo', 1)
  appEngineVersion = _messages.MessageField('AppEngineVersionInfo', 2)
  causesDrop = _messages.BooleanField(3)
  cloudFunction = _messages.MessageField('CloudFunctionInfo', 4)
  cloudRunRevision = _messages.MessageField('CloudRunRevisionInfo', 5)
  cloudSqlInstance = _messages.MessageField('CloudSQLInstanceInfo', 6)
  deliver = _messages.MessageField('DeliverInfo', 7)
  description = _messages.StringField(8)
  drop = _messages.MessageField('DropInfo', 9)
  endpoint = _messages.MessageField('EndpointInfo', 10)
  firewall = _messages.MessageField('FirewallInfo', 11)
  forward = _messages.MessageField('ForwardInfo', 12)
  forwardingRule = _messages.MessageField('ForwardingRuleInfo', 13)
  gkeMaster = _messages.MessageField('GKEMasterInfo', 14)
  googleService = _messages.MessageField('GoogleServiceInfo', 15)
  instance = _messages.MessageField('InstanceInfo', 16)
  loadBalancer = _messages.MessageField('LoadBalancerInfo', 17)
  loadBalancerBackendInfo = _messages.MessageField('LoadBalancerBackendInfo', 18)
  nat = _messages.MessageField('NatInfo', 19)
  network = _messages.MessageField('NetworkInfo', 20)
  projectId = _messages.StringField(21)
  proxyConnection = _messages.MessageField('ProxyConnectionInfo', 22)
  route = _messages.MessageField('RouteInfo', 23)
  serverlessNeg = _messages.MessageField('ServerlessNegInfo', 24)
  state = _messages.EnumField('StateValueValuesEnum', 25)
  storageBucket = _messages.MessageField('StorageBucketInfo', 26)
  vpcConnector = _messages.MessageField('VpcConnectorInfo', 27)
  vpnGateway = _messages.MessageField('VpnGatewayInfo', 28)
  vpnTunnel = _messages.MessageField('VpnTunnelInfo', 29)


class StorageBucketInfo(_messages.Message):
  r"""For display only. Metadata associated with Storage Bucket.

  Fields:
    bucket: Cloud Storage Bucket name.
  """

  bucket = _messages.StringField(1)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Trace(_messages.Message):
  r"""Trace represents one simulated packet forwarding path. * Each trace
  contains multiple ordered steps. * Each step is in a particular state with
  associated configuration. * State is categorized as final or non-final
  states. * Each final state has a reason associated. * Each trace must end
  with a final state (the last step). ```
  |---------------------Trace----------------------| Step1(State) Step2(State)
  --- StepN(State(final)) ```

  Fields:
    endpointInfo: Derived from the source and destination endpoints definition
      specified by user request, and validated by the data plane model. If
      there are multiple traces starting from different source locations, then
      the endpoint_info may be different between traces.
    forwardTraceId: ID of trace. For forward traces, this ID is unique for
      each trace. For return traces, it matches ID of associated forward
      trace. A single forward trace can be associated with none, one or more
      than one return trace.
    steps: A trace of a test contains multiple steps from the initial state to
      the final state (delivered, dropped, forwarded, or aborted). The steps
      are ordered by the processing sequence within the simulated network
      state machine. It is critical to preserve the order of the steps and
      avoid reordering or sorting them.
  """

  endpointInfo = _messages.MessageField('EndpointInfo', 1)
  forwardTraceId = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  steps = _messages.MessageField('Step', 3, repeated=True)


class VpcConnectorInfo(_messages.Message):
  r"""For display only. Metadata associated with a VPC connector.

  Fields:
    displayName: Name of a VPC connector.
    location: Location in which the VPC connector is deployed.
    uri: URI of a VPC connector.
  """

  displayName = _messages.StringField(1)
  location = _messages.StringField(2)
  uri = _messages.StringField(3)


class VpnGatewayInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine VPN gateway.

  Fields:
    displayName: Name of a VPN gateway.
    ipAddress: IP address of the VPN gateway.
    networkUri: URI of a Compute Engine network where the VPN gateway is
      configured.
    region: Name of a Google Cloud region where this VPN gateway is
      configured.
    uri: URI of a VPN gateway.
    vpnTunnelUri: A VPN tunnel that is associated with this VPN gateway. There
      may be multiple VPN tunnels configured on a VPN gateway, and only the
      one relevant to the test is displayed.
  """

  displayName = _messages.StringField(1)
  ipAddress = _messages.StringField(2)
  networkUri = _messages.StringField(3)
  region = _messages.StringField(4)
  uri = _messages.StringField(5)
  vpnTunnelUri = _messages.StringField(6)


class VpnTunnelInfo(_messages.Message):
  r"""For display only. Metadata associated with a Compute Engine VPN tunnel.

  Enums:
    RoutingTypeValueValuesEnum: Type of the routing policy.

  Fields:
    displayName: Name of a VPN tunnel.
    networkUri: URI of a Compute Engine network where the VPN tunnel is
      configured.
    region: Name of a Google Cloud region where this VPN tunnel is configured.
    remoteGateway: URI of a VPN gateway at remote end of the tunnel.
    remoteGatewayIp: Remote VPN gateway's IP address.
    routingType: Type of the routing policy.
    sourceGateway: URI of the VPN gateway at local end of the tunnel.
    sourceGatewayIp: Local VPN gateway's IP address.
    uri: URI of a VPN tunnel.
  """

  class RoutingTypeValueValuesEnum(_messages.Enum):
    r"""Type of the routing policy.

    Values:
      ROUTING_TYPE_UNSPECIFIED: Unspecified type. Default value.
      ROUTE_BASED: Route based VPN.
      POLICY_BASED: Policy based routing.
      DYNAMIC: Dynamic (BGP) routing.
    """
    ROUTING_TYPE_UNSPECIFIED = 0
    ROUTE_BASED = 1
    POLICY_BASED = 2
    DYNAMIC = 3

  displayName = _messages.StringField(1)
  networkUri = _messages.StringField(2)
  region = _messages.StringField(3)
  remoteGateway = _messages.StringField(4)
  remoteGatewayIp = _messages.StringField(5)
  routingType = _messages.EnumField('RoutingTypeValueValuesEnum', 6)
  sourceGateway = _messages.StringField(7)
  sourceGatewayIp = _messages.StringField(8)
  uri = _messages.StringField(9)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    NetworkmanagementProjectsLocationsSimulationsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
