# -*- coding: utf-8 -*- #
# Copyright 2024 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Util functions for commands for MembershipFeature resource."""

from googlecloudsdk.calliope import base


MEMBERSHIP_FEATURE_PROJECT_ALLOWLIST = ('yufans-test')


def UseMembershipFeatureV2(project, release_track):
  """Returns whether to use MembershipFeature v2 API."""
  return (
      release_track is base.ReleaseTrack.ALPHA
      and project in MEMBERSHIP_FEATURE_PROJECT_ALLOWLIST
  )
