// Code generated by go generate; DO NOT EDIT.
package stripe

import "errors"

type Permission int

const (
    Invalid Permission = iota
    ConnectedAccountRead Permission = iota
    AccountLinkWrite Permission = iota
    ApplePayDomainRead Permission = iota
    ApplePayDomainWrite Permission = iota
    ApplicationFeeRead Permission = iota
    ApplicationFeeWrite Permission = iota
    BalanceRead Permission = iota
    BalanceTransactionSourceRead Permission = iota
    BillingClockRead Permission = iota
    BillingClockWrite Permission = iota
    ChargeRead Permission = iota
    ChargeWrite Permission = iota
    CheckoutSessionRead Permission = iota
    CheckoutSessionWrite Permission = iota
    TerminalConfigurationRead Permission = iota
    TerminalConfigurationWrite Permission = iota
    TerminalConnectionTokenWrite Permission = iota
    CouponRead Permission = iota
    CouponWrite Permission = iota
    CreditNoteRead Permission = iota
    CreditNoteWrite Permission = iota
    CustomerPortalRead Permission = iota
    CustomerPortalWrite Permission = iota
    CustomerRead Permission = iota
    CustomerWrite Permission = iota
    DisputeRead Permission = iota
    DisputeWrite Permission = iota
    EditLinkWrite Permission = iota
    ElementsWrite Permission = iota
    EventRead Permission = iota
    FileRead Permission = iota
    FileWrite Permission = iota
    InvoiceRead Permission = iota
    InvoiceWrite Permission = iota
    IssuingAuthorizationRead Permission = iota
    IssuingAuthorizationWrite Permission = iota
    IssuingCardRead Permission = iota
    IssuingCardWrite Permission = iota
    IssuingCardholderRead Permission = iota
    IssuingCardholderWrite Permission = iota
    IssuingDisputeRead Permission = iota
    IssuingDisputeWrite Permission = iota
    IssuingTransactionRead Permission = iota
    IssuingTransactionWrite Permission = iota
    TerminalLocationRead Permission = iota
    TerminalLocationWrite Permission = iota
    MandateRead Permission = iota
    MandateWrite Permission = iota
    OrderRead Permission = iota
    OrderWrite Permission = iota
    PaymentIntentRead Permission = iota
    PaymentIntentWrite Permission = iota
    PaymentLinksRead Permission = iota
    PaymentLinksWrite Permission = iota
    PaymentMethodRead Permission = iota
    PaymentMethodWrite Permission = iota
    PayoutRead Permission = iota
    PayoutWrite Permission = iota
    PlanRead Permission = iota
    PlanWrite Permission = iota
    ProductRead Permission = iota
    ProductWrite Permission = iota
    PromotionCodeRead Permission = iota
    PromotionCodeWrite Permission = iota
    QuoteRead Permission = iota
    QuoteWrite Permission = iota
    TerminalReaderRead Permission = iota
    TerminalReaderWrite Permission = iota
    ReportRunsAndReportTypesRead Permission = iota
    ReviewRead Permission = iota
    ReviewWrite Permission = iota
    SecretWrite Permission = iota
    SetupIntentRead Permission = iota
    SetupIntentWrite Permission = iota
    ShippingRateRead Permission = iota
    ShippingRateWrite Permission = iota
    SkuRead Permission = iota
    SkuWrite Permission = iota
    SourceRead Permission = iota
    SourceWrite Permission = iota
    SubscriptionRead Permission = iota
    SubscriptionWrite Permission = iota
    TaxRateRead Permission = iota
    TaxRateWrite Permission = iota
    TaxSettingsRead Permission = iota
    TaxSettingsWrite Permission = iota
    TaxCalculationsAndTransactionsRead Permission = iota
    TaxCalculationsAndTransactionsWrite Permission = iota
    TokenRead Permission = iota
    TokenWrite Permission = iota
    TopUpRead Permission = iota
    TopUpWrite Permission = iota
    TransferRead Permission = iota
    TransferWrite Permission = iota
    UsageRecordRead Permission = iota
    UsageRecordWrite Permission = iota
    UserEmailRead Permission = iota
    WebhookRead Permission = iota
    WebhookWrite Permission = iota
    IssuingCardSensitiveRead Permission = iota
    FundingInstructionRead Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        ConnectedAccountRead: "connected_account_read",
        AccountLinkWrite: "account_link_write",
        ApplePayDomainRead: "apple_pay_domain_read",
        ApplePayDomainWrite: "apple_pay_domain_write",
        ApplicationFeeRead: "application_fee_read",
        ApplicationFeeWrite: "application_fee_write",
        BalanceRead: "balance_read",
        BalanceTransactionSourceRead: "balance_transaction_source_read",
        BillingClockRead: "billing_clock_read",
        BillingClockWrite: "billing_clock_write",
        ChargeRead: "charge_read",
        ChargeWrite: "charge_write",
        CheckoutSessionRead: "checkout_session_read",
        CheckoutSessionWrite: "checkout_session_write",
        TerminalConfigurationRead: "terminal_configuration_read",
        TerminalConfigurationWrite: "terminal_configuration_write",
        TerminalConnectionTokenWrite: "terminal_connection_token_write",
        CouponRead: "coupon_read",
        CouponWrite: "coupon_write",
        CreditNoteRead: "credit_note_read",
        CreditNoteWrite: "credit_note_write",
        CustomerPortalRead: "customer_portal_read",
        CustomerPortalWrite: "customer_portal_write",
        CustomerRead: "customer_read",
        CustomerWrite: "customer_write",
        DisputeRead: "dispute_read",
        DisputeWrite: "dispute_write",
        EditLinkWrite: "edit_link_write",
        ElementsWrite: "elements_write",
        EventRead: "event_read",
        FileRead: "file_read",
        FileWrite: "file_write",
        InvoiceRead: "invoice_read",
        InvoiceWrite: "invoice_write",
        IssuingAuthorizationRead: "issuing_authorization_read",
        IssuingAuthorizationWrite: "issuing_authorization_write",
        IssuingCardRead: "issuing_card_read",
        IssuingCardWrite: "issuing_card_write",
        IssuingCardholderRead: "issuing_cardholder_read",
        IssuingCardholderWrite: "issuing_cardholder_write",
        IssuingDisputeRead: "issuing_dispute_read",
        IssuingDisputeWrite: "issuing_dispute_write",
        IssuingTransactionRead: "issuing_transaction_read",
        IssuingTransactionWrite: "issuing_transaction_write",
        TerminalLocationRead: "terminal_location_read",
        TerminalLocationWrite: "terminal_location_write",
        MandateRead: "mandate_read",
        MandateWrite: "mandate_write",
        OrderRead: "order_read",
        OrderWrite: "order_write",
        PaymentIntentRead: "payment_intent_read",
        PaymentIntentWrite: "payment_intent_write",
        PaymentLinksRead: "payment_links_read",
        PaymentLinksWrite: "payment_links_write",
        PaymentMethodRead: "payment_method_read",
        PaymentMethodWrite: "payment_method_write",
        PayoutRead: "payout_read",
        PayoutWrite: "payout_write",
        PlanRead: "plan_read",
        PlanWrite: "plan_write",
        ProductRead: "product_read",
        ProductWrite: "product_write",
        PromotionCodeRead: "promotion_code_read",
        PromotionCodeWrite: "promotion_code_write",
        QuoteRead: "quote_read",
        QuoteWrite: "quote_write",
        TerminalReaderRead: "terminal_reader_read",
        TerminalReaderWrite: "terminal_reader_write",
        ReportRunsAndReportTypesRead: "report_runs_and_report_types_read",
        ReviewRead: "review_read",
        ReviewWrite: "review_write",
        SecretWrite: "secret_write",
        SetupIntentRead: "setup_intent_read",
        SetupIntentWrite: "setup_intent_write",
        ShippingRateRead: "shipping_rate_read",
        ShippingRateWrite: "shipping_rate_write",
        SkuRead: "sku_read",
        SkuWrite: "sku_write",
        SourceRead: "source_read",
        SourceWrite: "source_write",
        SubscriptionRead: "subscription_read",
        SubscriptionWrite: "subscription_write",
        TaxRateRead: "tax_rate_read",
        TaxRateWrite: "tax_rate_write",
        TaxSettingsRead: "tax_settings_read",
        TaxSettingsWrite: "tax_settings_write",
        TaxCalculationsAndTransactionsRead: "tax_calculations_and_transactions_read",
        TaxCalculationsAndTransactionsWrite: "tax_calculations_and_transactions_write",
        TokenRead: "token_read",
        TokenWrite: "token_write",
        TopUpRead: "top_up_read",
        TopUpWrite: "top_up_write",
        TransferRead: "transfer_read",
        TransferWrite: "transfer_write",
        UsageRecordRead: "usage_record_read",
        UsageRecordWrite: "usage_record_write",
        UserEmailRead: "user_email_read",
        WebhookRead: "webhook_read",
        WebhookWrite: "webhook_write",
        IssuingCardSensitiveRead: "issuing_card_sensitive_read",
        FundingInstructionRead: "funding_instruction_read",
    }

    StringToPermission = map[string]Permission{
        "connected_account_read": ConnectedAccountRead,
        "account_link_write": AccountLinkWrite,
        "apple_pay_domain_read": ApplePayDomainRead,
        "apple_pay_domain_write": ApplePayDomainWrite,
        "application_fee_read": ApplicationFeeRead,
        "application_fee_write": ApplicationFeeWrite,
        "balance_read": BalanceRead,
        "balance_transaction_source_read": BalanceTransactionSourceRead,
        "billing_clock_read": BillingClockRead,
        "billing_clock_write": BillingClockWrite,
        "charge_read": ChargeRead,
        "charge_write": ChargeWrite,
        "checkout_session_read": CheckoutSessionRead,
        "checkout_session_write": CheckoutSessionWrite,
        "terminal_configuration_read": TerminalConfigurationRead,
        "terminal_configuration_write": TerminalConfigurationWrite,
        "terminal_connection_token_write": TerminalConnectionTokenWrite,
        "coupon_read": CouponRead,
        "coupon_write": CouponWrite,
        "credit_note_read": CreditNoteRead,
        "credit_note_write": CreditNoteWrite,
        "customer_portal_read": CustomerPortalRead,
        "customer_portal_write": CustomerPortalWrite,
        "customer_read": CustomerRead,
        "customer_write": CustomerWrite,
        "dispute_read": DisputeRead,
        "dispute_write": DisputeWrite,
        "edit_link_write": EditLinkWrite,
        "elements_write": ElementsWrite,
        "event_read": EventRead,
        "file_read": FileRead,
        "file_write": FileWrite,
        "invoice_read": InvoiceRead,
        "invoice_write": InvoiceWrite,
        "issuing_authorization_read": IssuingAuthorizationRead,
        "issuing_authorization_write": IssuingAuthorizationWrite,
        "issuing_card_read": IssuingCardRead,
        "issuing_card_write": IssuingCardWrite,
        "issuing_cardholder_read": IssuingCardholderRead,
        "issuing_cardholder_write": IssuingCardholderWrite,
        "issuing_dispute_read": IssuingDisputeRead,
        "issuing_dispute_write": IssuingDisputeWrite,
        "issuing_transaction_read": IssuingTransactionRead,
        "issuing_transaction_write": IssuingTransactionWrite,
        "terminal_location_read": TerminalLocationRead,
        "terminal_location_write": TerminalLocationWrite,
        "mandate_read": MandateRead,
        "mandate_write": MandateWrite,
        "order_read": OrderRead,
        "order_write": OrderWrite,
        "payment_intent_read": PaymentIntentRead,
        "payment_intent_write": PaymentIntentWrite,
        "payment_links_read": PaymentLinksRead,
        "payment_links_write": PaymentLinksWrite,
        "payment_method_read": PaymentMethodRead,
        "payment_method_write": PaymentMethodWrite,
        "payout_read": PayoutRead,
        "payout_write": PayoutWrite,
        "plan_read": PlanRead,
        "plan_write": PlanWrite,
        "product_read": ProductRead,
        "product_write": ProductWrite,
        "promotion_code_read": PromotionCodeRead,
        "promotion_code_write": PromotionCodeWrite,
        "quote_read": QuoteRead,
        "quote_write": QuoteWrite,
        "terminal_reader_read": TerminalReaderRead,
        "terminal_reader_write": TerminalReaderWrite,
        "report_runs_and_report_types_read": ReportRunsAndReportTypesRead,
        "review_read": ReviewRead,
        "review_write": ReviewWrite,
        "secret_write": SecretWrite,
        "setup_intent_read": SetupIntentRead,
        "setup_intent_write": SetupIntentWrite,
        "shipping_rate_read": ShippingRateRead,
        "shipping_rate_write": ShippingRateWrite,
        "sku_read": SkuRead,
        "sku_write": SkuWrite,
        "source_read": SourceRead,
        "source_write": SourceWrite,
        "subscription_read": SubscriptionRead,
        "subscription_write": SubscriptionWrite,
        "tax_rate_read": TaxRateRead,
        "tax_rate_write": TaxRateWrite,
        "tax_settings_read": TaxSettingsRead,
        "tax_settings_write": TaxSettingsWrite,
        "tax_calculations_and_transactions_read": TaxCalculationsAndTransactionsRead,
        "tax_calculations_and_transactions_write": TaxCalculationsAndTransactionsWrite,
        "token_read": TokenRead,
        "token_write": TokenWrite,
        "top_up_read": TopUpRead,
        "top_up_write": TopUpWrite,
        "transfer_read": TransferRead,
        "transfer_write": TransferWrite,
        "usage_record_read": UsageRecordRead,
        "usage_record_write": UsageRecordWrite,
        "user_email_read": UserEmailRead,
        "webhook_read": WebhookRead,
        "webhook_write": WebhookWrite,
        "issuing_card_sensitive_read": IssuingCardSensitiveRead,
        "funding_instruction_read": FundingInstructionRead,
    }

    PermissionIDs = map[Permission]int{
        ConnectedAccountRead: 1,
        AccountLinkWrite: 2,
        ApplePayDomainRead: 3,
        ApplePayDomainWrite: 4,
        ApplicationFeeRead: 5,
        ApplicationFeeWrite: 6,
        BalanceRead: 7,
        BalanceTransactionSourceRead: 8,
        BillingClockRead: 9,
        BillingClockWrite: 10,
        ChargeRead: 11,
        ChargeWrite: 12,
        CheckoutSessionRead: 13,
        CheckoutSessionWrite: 14,
        TerminalConfigurationRead: 15,
        TerminalConfigurationWrite: 16,
        TerminalConnectionTokenWrite: 17,
        CouponRead: 18,
        CouponWrite: 19,
        CreditNoteRead: 20,
        CreditNoteWrite: 21,
        CustomerPortalRead: 22,
        CustomerPortalWrite: 23,
        CustomerRead: 24,
        CustomerWrite: 25,
        DisputeRead: 26,
        DisputeWrite: 27,
        EditLinkWrite: 28,
        ElementsWrite: 29,
        EventRead: 30,
        FileRead: 31,
        FileWrite: 32,
        InvoiceRead: 33,
        InvoiceWrite: 34,
        IssuingAuthorizationRead: 35,
        IssuingAuthorizationWrite: 36,
        IssuingCardRead: 37,
        IssuingCardWrite: 38,
        IssuingCardholderRead: 39,
        IssuingCardholderWrite: 40,
        IssuingDisputeRead: 41,
        IssuingDisputeWrite: 42,
        IssuingTransactionRead: 43,
        IssuingTransactionWrite: 44,
        TerminalLocationRead: 45,
        TerminalLocationWrite: 46,
        MandateRead: 47,
        MandateWrite: 48,
        OrderRead: 49,
        OrderWrite: 50,
        PaymentIntentRead: 51,
        PaymentIntentWrite: 52,
        PaymentLinksRead: 53,
        PaymentLinksWrite: 54,
        PaymentMethodRead: 55,
        PaymentMethodWrite: 56,
        PayoutRead: 57,
        PayoutWrite: 58,
        PlanRead: 59,
        PlanWrite: 60,
        ProductRead: 61,
        ProductWrite: 62,
        PromotionCodeRead: 63,
        PromotionCodeWrite: 64,
        QuoteRead: 65,
        QuoteWrite: 66,
        TerminalReaderRead: 67,
        TerminalReaderWrite: 68,
        ReportRunsAndReportTypesRead: 69,
        ReviewRead: 70,
        ReviewWrite: 71,
        SecretWrite: 72,
        SetupIntentRead: 73,
        SetupIntentWrite: 74,
        ShippingRateRead: 75,
        ShippingRateWrite: 76,
        SkuRead: 77,
        SkuWrite: 78,
        SourceRead: 79,
        SourceWrite: 80,
        SubscriptionRead: 81,
        SubscriptionWrite: 82,
        TaxRateRead: 83,
        TaxRateWrite: 84,
        TaxSettingsRead: 85,
        TaxSettingsWrite: 86,
        TaxCalculationsAndTransactionsRead: 87,
        TaxCalculationsAndTransactionsWrite: 88,
        TokenRead: 89,
        TokenWrite: 90,
        TopUpRead: 91,
        TopUpWrite: 92,
        TransferRead: 93,
        TransferWrite: 94,
        UsageRecordRead: 95,
        UsageRecordWrite: 96,
        UserEmailRead: 97,
        WebhookRead: 98,
        WebhookWrite: 99,
        IssuingCardSensitiveRead: 100,
        FundingInstructionRead: 101,
    }

    IdToPermission = map[int]Permission{
        1: ConnectedAccountRead,
        2: AccountLinkWrite,
        3: ApplePayDomainRead,
        4: ApplePayDomainWrite,
        5: ApplicationFeeRead,
        6: ApplicationFeeWrite,
        7: BalanceRead,
        8: BalanceTransactionSourceRead,
        9: BillingClockRead,
        10: BillingClockWrite,
        11: ChargeRead,
        12: ChargeWrite,
        13: CheckoutSessionRead,
        14: CheckoutSessionWrite,
        15: TerminalConfigurationRead,
        16: TerminalConfigurationWrite,
        17: TerminalConnectionTokenWrite,
        18: CouponRead,
        19: CouponWrite,
        20: CreditNoteRead,
        21: CreditNoteWrite,
        22: CustomerPortalRead,
        23: CustomerPortalWrite,
        24: CustomerRead,
        25: CustomerWrite,
        26: DisputeRead,
        27: DisputeWrite,
        28: EditLinkWrite,
        29: ElementsWrite,
        30: EventRead,
        31: FileRead,
        32: FileWrite,
        33: InvoiceRead,
        34: InvoiceWrite,
        35: IssuingAuthorizationRead,
        36: IssuingAuthorizationWrite,
        37: IssuingCardRead,
        38: IssuingCardWrite,
        39: IssuingCardholderRead,
        40: IssuingCardholderWrite,
        41: IssuingDisputeRead,
        42: IssuingDisputeWrite,
        43: IssuingTransactionRead,
        44: IssuingTransactionWrite,
        45: TerminalLocationRead,
        46: TerminalLocationWrite,
        47: MandateRead,
        48: MandateWrite,
        49: OrderRead,
        50: OrderWrite,
        51: PaymentIntentRead,
        52: PaymentIntentWrite,
        53: PaymentLinksRead,
        54: PaymentLinksWrite,
        55: PaymentMethodRead,
        56: PaymentMethodWrite,
        57: PayoutRead,
        58: PayoutWrite,
        59: PlanRead,
        60: PlanWrite,
        61: ProductRead,
        62: ProductWrite,
        63: PromotionCodeRead,
        64: PromotionCodeWrite,
        65: QuoteRead,
        66: QuoteWrite,
        67: TerminalReaderRead,
        68: TerminalReaderWrite,
        69: ReportRunsAndReportTypesRead,
        70: ReviewRead,
        71: ReviewWrite,
        72: SecretWrite,
        73: SetupIntentRead,
        74: SetupIntentWrite,
        75: ShippingRateRead,
        76: ShippingRateWrite,
        77: SkuRead,
        78: SkuWrite,
        79: SourceRead,
        80: SourceWrite,
        81: SubscriptionRead,
        82: SubscriptionWrite,
        83: TaxRateRead,
        84: TaxRateWrite,
        85: TaxSettingsRead,
        86: TaxSettingsWrite,
        87: TaxCalculationsAndTransactionsRead,
        88: TaxCalculationsAndTransactionsWrite,
        89: TokenRead,
        90: TokenWrite,
        91: TopUpRead,
        92: TopUpWrite,
        93: TransferRead,
        94: TransferWrite,
        95: UsageRecordRead,
        96: UsageRecordWrite,
        97: UserEmailRead,
        98: WebhookRead,
        99: WebhookWrite,
        100: IssuingCardSensitiveRead,
        101: FundingInstructionRead,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
