// Code generated by go generate; DO NOT EDIT.
package mysql

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Alter Permission = iota
    AlterRoutine Permission = iota
    AllowNonexistentDefiner Permission = iota
    ApplicationPasswordAdmin Permission = iota
    AuditAbortExempt Permission = iota
    AuditAdmin Permission = iota
    AuthenticationPolicyAdmin Permission = iota
    BackupAdmin Permission = iota
    BinlogAdmin Permission = iota
    BinlogEncryptionAdmin Permission = iota
    CloneAdmin Permission = iota
    ConnectionAdmin Permission = iota
    Create Permission = iota
    CreateRole Permission = iota
    CreateRoutine Permission = iota
    CreateTablespace Permission = iota
    CreateTemporaryTables Permission = iota
    CreateUser Permission = iota
    CreateView Permission = iota
    Delete Permission = iota
    Drop Permission = iota
    DropRole Permission = iota
    EncryptionKeyAdmin Permission = iota
    Event Permission = iota
    Execute Permission = iota
    File Permission = iota
    FirewallAdmin Permission = iota
    FirewallExempt Permission = iota
    FirewallUser Permission = iota
    FlushOptimizerCosts Permission = iota
    FlushStatus Permission = iota
    FlushTables Permission = iota
    FlushUserResources Permission = iota
    GrantOption Permission = iota
    GroupReplicationAdmin Permission = iota
    GroupReplicationStream Permission = iota
    Index Permission = iota
    InnodbRedoLogArchive Permission = iota
    InnodbRedoLogEnable Permission = iota
    Insert Permission = iota
    LockingTables Permission = iota
    MaskingDictionariesAdmin Permission = iota
    NdbStoredUser Permission = iota
    PasswordlessUserAdmin Permission = iota
    PersistRoVariablesAdmin Permission = iota
    Process Permission = iota
    Proxy Permission = iota
    References Permission = iota
    Reload Permission = iota
    ReplicationApplier Permission = iota
    ReplicationClient Permission = iota
    ReplicationSlave Permission = iota
    ReplicationSlaveAdmin Permission = iota
    ResourceGroupAdmin Permission = iota
    ResourceGroupUser Permission = iota
    RoleAdmin Permission = iota
    Select Permission = iota
    SensitiveVariablesObserver Permission = iota
    ServiceConnectionAdmin Permission = iota
    SessionVariablesAdmin Permission = iota
    SetAnyDefiner Permission = iota
    SetUserId Permission = iota
    ShowDatabases Permission = iota
    ShowRoutine Permission = iota
    ShowView Permission = iota
    Shutdown Permission = iota
    SkipQueryRewrite Permission = iota
    Super Permission = iota
    SystemUser Permission = iota
    SystemVariablesAdmin Permission = iota
    TableEncryptionAdmin Permission = iota
    TelemetryLogAdmin Permission = iota
    TpConnectionAdmin Permission = iota
    TransactionGtidTag Permission = iota
    Trigger Permission = iota
    Update Permission = iota
    Usage Permission = iota
    VersionTokenAdmin Permission = iota
    XaRecoverAdmin Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Alter: "alter",
        AlterRoutine: "alter_routine",
        AllowNonexistentDefiner: "allow_nonexistent_definer",
        ApplicationPasswordAdmin: "application_password_admin",
        AuditAbortExempt: "audit_abort_exempt",
        AuditAdmin: "audit_admin",
        AuthenticationPolicyAdmin: "authentication_policy_admin",
        BackupAdmin: "backup_admin",
        BinlogAdmin: "binlog_admin",
        BinlogEncryptionAdmin: "binlog_encryption_admin",
        CloneAdmin: "clone_admin",
        ConnectionAdmin: "connection_admin",
        Create: "create",
        CreateRole: "create_role",
        CreateRoutine: "create_routine",
        CreateTablespace: "create_tablespace",
        CreateTemporaryTables: "create_temporary_tables",
        CreateUser: "create_user",
        CreateView: "create_view",
        Delete: "delete",
        Drop: "drop",
        DropRole: "drop_role",
        EncryptionKeyAdmin: "encryption_key_admin",
        Event: "event",
        Execute: "execute",
        File: "file",
        FirewallAdmin: "firewall_admin",
        FirewallExempt: "firewall_exempt",
        FirewallUser: "firewall_user",
        FlushOptimizerCosts: "flush_optimizer_costs",
        FlushStatus: "flush_status",
        FlushTables: "flush_tables",
        FlushUserResources: "flush_user_resources",
        GrantOption: "grant_option",
        GroupReplicationAdmin: "group_replication_admin",
        GroupReplicationStream: "group_replication_stream",
        Index: "index",
        InnodbRedoLogArchive: "innodb_redo_log_archive",
        InnodbRedoLogEnable: "innodb_redo_log_enable",
        Insert: "insert",
        LockingTables: "locking_tables",
        MaskingDictionariesAdmin: "masking_dictionaries_admin",
        NdbStoredUser: "ndb_stored_user",
        PasswordlessUserAdmin: "passwordless_user_admin",
        PersistRoVariablesAdmin: "persist_ro_variables_admin",
        Process: "process",
        Proxy: "proxy",
        References: "references",
        Reload: "reload",
        ReplicationApplier: "replication_applier",
        ReplicationClient: "replication_client",
        ReplicationSlave: "replication_slave",
        ReplicationSlaveAdmin: "replication_slave_admin",
        ResourceGroupAdmin: "resource_group_admin",
        ResourceGroupUser: "resource_group_user",
        RoleAdmin: "role_admin",
        Select: "select",
        SensitiveVariablesObserver: "sensitive_variables_observer",
        ServiceConnectionAdmin: "service_connection_admin",
        SessionVariablesAdmin: "session_variables_admin",
        SetAnyDefiner: "set_any_definer",
        SetUserId: "set_user_id",
        ShowDatabases: "show_databases",
        ShowRoutine: "show_routine",
        ShowView: "show_view",
        Shutdown: "shutdown",
        SkipQueryRewrite: "skip_query_rewrite",
        Super: "super",
        SystemUser: "system_user",
        SystemVariablesAdmin: "system_variables_admin",
        TableEncryptionAdmin: "table_encryption_admin",
        TelemetryLogAdmin: "telemetry_log_admin",
        TpConnectionAdmin: "tp_connection_admin",
        TransactionGtidTag: "transaction_gtid_tag",
        Trigger: "trigger",
        Update: "update",
        Usage: "usage",
        VersionTokenAdmin: "version_token_admin",
        XaRecoverAdmin: "xa_recover_admin",
    }

    StringToPermission = map[string]Permission{
        "alter": Alter,
        "alter_routine": AlterRoutine,
        "allow_nonexistent_definer": AllowNonexistentDefiner,
        "application_password_admin": ApplicationPasswordAdmin,
        "audit_abort_exempt": AuditAbortExempt,
        "audit_admin": AuditAdmin,
        "authentication_policy_admin": AuthenticationPolicyAdmin,
        "backup_admin": BackupAdmin,
        "binlog_admin": BinlogAdmin,
        "binlog_encryption_admin": BinlogEncryptionAdmin,
        "clone_admin": CloneAdmin,
        "connection_admin": ConnectionAdmin,
        "create": Create,
        "create_role": CreateRole,
        "create_routine": CreateRoutine,
        "create_tablespace": CreateTablespace,
        "create_temporary_tables": CreateTemporaryTables,
        "create_user": CreateUser,
        "create_view": CreateView,
        "delete": Delete,
        "drop": Drop,
        "drop_role": DropRole,
        "encryption_key_admin": EncryptionKeyAdmin,
        "event": Event,
        "execute": Execute,
        "file": File,
        "firewall_admin": FirewallAdmin,
        "firewall_exempt": FirewallExempt,
        "firewall_user": FirewallUser,
        "flush_optimizer_costs": FlushOptimizerCosts,
        "flush_status": FlushStatus,
        "flush_tables": FlushTables,
        "flush_user_resources": FlushUserResources,
        "grant_option": GrantOption,
        "group_replication_admin": GroupReplicationAdmin,
        "group_replication_stream": GroupReplicationStream,
        "index": Index,
        "innodb_redo_log_archive": InnodbRedoLogArchive,
        "innodb_redo_log_enable": InnodbRedoLogEnable,
        "insert": Insert,
        "locking_tables": LockingTables,
        "masking_dictionaries_admin": MaskingDictionariesAdmin,
        "ndb_stored_user": NdbStoredUser,
        "passwordless_user_admin": PasswordlessUserAdmin,
        "persist_ro_variables_admin": PersistRoVariablesAdmin,
        "process": Process,
        "proxy": Proxy,
        "references": References,
        "reload": Reload,
        "replication_applier": ReplicationApplier,
        "replication_client": ReplicationClient,
        "replication_slave": ReplicationSlave,
        "replication_slave_admin": ReplicationSlaveAdmin,
        "resource_group_admin": ResourceGroupAdmin,
        "resource_group_user": ResourceGroupUser,
        "role_admin": RoleAdmin,
        "select": Select,
        "sensitive_variables_observer": SensitiveVariablesObserver,
        "service_connection_admin": ServiceConnectionAdmin,
        "session_variables_admin": SessionVariablesAdmin,
        "set_any_definer": SetAnyDefiner,
        "set_user_id": SetUserId,
        "show_databases": ShowDatabases,
        "show_routine": ShowRoutine,
        "show_view": ShowView,
        "shutdown": Shutdown,
        "skip_query_rewrite": SkipQueryRewrite,
        "super": Super,
        "system_user": SystemUser,
        "system_variables_admin": SystemVariablesAdmin,
        "table_encryption_admin": TableEncryptionAdmin,
        "telemetry_log_admin": TelemetryLogAdmin,
        "tp_connection_admin": TpConnectionAdmin,
        "transaction_gtid_tag": TransactionGtidTag,
        "trigger": Trigger,
        "update": Update,
        "usage": Usage,
        "version_token_admin": VersionTokenAdmin,
        "xa_recover_admin": XaRecoverAdmin,
    }

    PermissionIDs = map[Permission]int{
        Alter: 1,
        AlterRoutine: 2,
        AllowNonexistentDefiner: 3,
        ApplicationPasswordAdmin: 4,
        AuditAbortExempt: 5,
        AuditAdmin: 6,
        AuthenticationPolicyAdmin: 7,
        BackupAdmin: 8,
        BinlogAdmin: 9,
        BinlogEncryptionAdmin: 10,
        CloneAdmin: 11,
        ConnectionAdmin: 12,
        Create: 13,
        CreateRole: 14,
        CreateRoutine: 15,
        CreateTablespace: 16,
        CreateTemporaryTables: 17,
        CreateUser: 18,
        CreateView: 19,
        Delete: 20,
        Drop: 21,
        DropRole: 22,
        EncryptionKeyAdmin: 23,
        Event: 24,
        Execute: 25,
        File: 26,
        FirewallAdmin: 27,
        FirewallExempt: 28,
        FirewallUser: 29,
        FlushOptimizerCosts: 30,
        FlushStatus: 31,
        FlushTables: 32,
        FlushUserResources: 33,
        GrantOption: 34,
        GroupReplicationAdmin: 35,
        GroupReplicationStream: 36,
        Index: 37,
        InnodbRedoLogArchive: 38,
        InnodbRedoLogEnable: 39,
        Insert: 40,
        LockingTables: 41,
        MaskingDictionariesAdmin: 42,
        NdbStoredUser: 43,
        PasswordlessUserAdmin: 44,
        PersistRoVariablesAdmin: 45,
        Process: 46,
        Proxy: 47,
        References: 48,
        Reload: 49,
        ReplicationApplier: 50,
        ReplicationClient: 51,
        ReplicationSlave: 52,
        ReplicationSlaveAdmin: 53,
        ResourceGroupAdmin: 54,
        ResourceGroupUser: 55,
        RoleAdmin: 56,
        Select: 57,
        SensitiveVariablesObserver: 58,
        ServiceConnectionAdmin: 59,
        SessionVariablesAdmin: 60,
        SetAnyDefiner: 61,
        SetUserId: 62,
        ShowDatabases: 63,
        ShowRoutine: 64,
        ShowView: 65,
        Shutdown: 66,
        SkipQueryRewrite: 67,
        Super: 68,
        SystemUser: 69,
        SystemVariablesAdmin: 70,
        TableEncryptionAdmin: 71,
        TelemetryLogAdmin: 72,
        TpConnectionAdmin: 73,
        TransactionGtidTag: 74,
        Trigger: 75,
        Update: 76,
        Usage: 77,
        VersionTokenAdmin: 78,
        XaRecoverAdmin: 79,
    }

    IdToPermission = map[int]Permission{
        1: Alter,
        2: AlterRoutine,
        3: AllowNonexistentDefiner,
        4: ApplicationPasswordAdmin,
        5: AuditAbortExempt,
        6: AuditAdmin,
        7: AuthenticationPolicyAdmin,
        8: BackupAdmin,
        9: BinlogAdmin,
        10: BinlogEncryptionAdmin,
        11: CloneAdmin,
        12: ConnectionAdmin,
        13: Create,
        14: CreateRole,
        15: CreateRoutine,
        16: CreateTablespace,
        17: CreateTemporaryTables,
        18: CreateUser,
        19: CreateView,
        20: Delete,
        21: Drop,
        22: DropRole,
        23: EncryptionKeyAdmin,
        24: Event,
        25: Execute,
        26: File,
        27: FirewallAdmin,
        28: FirewallExempt,
        29: FirewallUser,
        30: FlushOptimizerCosts,
        31: FlushStatus,
        32: FlushTables,
        33: FlushUserResources,
        34: GrantOption,
        35: GroupReplicationAdmin,
        36: GroupReplicationStream,
        37: Index,
        38: InnodbRedoLogArchive,
        39: InnodbRedoLogEnable,
        40: Insert,
        41: LockingTables,
        42: MaskingDictionariesAdmin,
        43: NdbStoredUser,
        44: PasswordlessUserAdmin,
        45: PersistRoVariablesAdmin,
        46: Process,
        47: Proxy,
        48: References,
        49: Reload,
        50: ReplicationApplier,
        51: ReplicationClient,
        52: ReplicationSlave,
        53: ReplicationSlaveAdmin,
        54: ResourceGroupAdmin,
        55: ResourceGroupUser,
        56: RoleAdmin,
        57: Select,
        58: SensitiveVariablesObserver,
        59: ServiceConnectionAdmin,
        60: SessionVariablesAdmin,
        61: SetAnyDefiner,
        62: SetUserId,
        63: ShowDatabases,
        64: ShowRoutine,
        65: ShowView,
        66: Shutdown,
        67: SkipQueryRewrite,
        68: Super,
        69: SystemUser,
        70: SystemVariablesAdmin,
        71: TableEncryptionAdmin,
        72: TelemetryLogAdmin,
        73: TpConnectionAdmin,
        74: TransactionGtidTag,
        75: Trigger,
        76: Update,
        77: Usage,
        78: VersionTokenAdmin,
        79: XaRecoverAdmin,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
