// Code generated by go generate; DO NOT EDIT.
package privatekey

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Digitalsignature Permission = iota
    Nonrepudiation Permission = iota
    Keyencipherment Permission = iota
    Dataencipherment Permission = iota
    Keyagreement Permission = iota
    Certificatesigning Permission = iota
    Crlsigning Permission = iota
    Encipheronly Permission = iota
    Decipheronly Permission = iota
    Serverauth Permission = iota
    Clientauth Permission = iota
    Codesigning Permission = iota
    Emailprotection Permission = iota
    Timestamping Permission = iota
    Ocspsigning Permission = iota
    Clone Permission = iota
    Push Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Digitalsignature: "DigitalSignature",
        Nonrepudiation: "NonRepudiation",
        Keyencipherment: "KeyEncipherment",
        Dataencipherment: "DataEncipherment",
        Keyagreement: "KeyAgreement",
        Certificatesigning: "CertificateSigning",
        Crlsigning: "CRLSigning",
        Encipheronly: "EncipherOnly",
        Decipheronly: "DecipherOnly",
        Serverauth: "ServerAuth",
        Clientauth: "ClientAuth",
        Codesigning: "CodeSigning",
        Emailprotection: "EmailProtection",
        Timestamping: "TimeStamping",
        Ocspsigning: "OCSPSigning",
        Clone: "Clone",
        Push: "Push",
    }

    StringToPermission = map[string]Permission{
        "DigitalSignature": Digitalsignature,
        "NonRepudiation": Nonrepudiation,
        "KeyEncipherment": Keyencipherment,
        "DataEncipherment": Dataencipherment,
        "KeyAgreement": Keyagreement,
        "CertificateSigning": Certificatesigning,
        "CRLSigning": Crlsigning,
        "EncipherOnly": Encipheronly,
        "DecipherOnly": Decipheronly,
        "ServerAuth": Serverauth,
        "ClientAuth": Clientauth,
        "CodeSigning": Codesigning,
        "EmailProtection": Emailprotection,
        "TimeStamping": Timestamping,
        "OCSPSigning": Ocspsigning,
        "Clone": Clone,
        "Push": Push,
    }

    PermissionIDs = map[Permission]int{
        Digitalsignature: 1,
        Nonrepudiation: 2,
        Keyencipherment: 3,
        Dataencipherment: 4,
        Keyagreement: 5,
        Certificatesigning: 6,
        Crlsigning: 7,
        Encipheronly: 8,
        Decipheronly: 9,
        Serverauth: 10,
        Clientauth: 11,
        Codesigning: 12,
        Emailprotection: 13,
        Timestamping: 14,
        Ocspsigning: 15,
        Clone: 16,
        Push: 17,
    }

    IdToPermission = map[int]Permission{
        1: Digitalsignature,
        2: Nonrepudiation,
        3: Keyencipherment,
        4: Dataencipherment,
        5: Keyagreement,
        6: Certificatesigning,
        7: Crlsigning,
        8: Encipheronly,
        9: Decipheronly,
        10: Serverauth,
        11: Clientauth,
        12: Codesigning,
        13: Emailprotection,
        14: Timestamping,
        15: Ocspsigning,
        16: Clone,
        17: Push,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
