Please feel free to open a discussion, submit issues, fork the repository, and send pull requests. We appreciate your contribution to the project and want to ensure a welcoming and productive environment for all contributors. To maintain a high-quality codebase, we ask that you follow these guidelines:

- **Use GitHub Discussions**: If you have a question or want to discuss a topic that is not a bug report or feature request, please use the [GitHub Discussions](https://github.com/umputun/spot/discussions) feature for the project. This helps to keep the issue tracker focused on actionable items and provides a dedicated space for community discussions.
- **Create an issue**: Before starting any work, please create an issue to discuss your proposal. This allows the community and maintainers to provide guidance and avoid duplication of efforts. When creating an issue, please provide a clear and concise description of the problem or feature you are proposing, along with any relevant details.
- **Fork the repository**: Once you have discussed your proposal and received approval, fork the repository and create a branch with a descriptive name related to the issue you are addressing.
- **Follow coding standards**: Write clean, maintainable code that adheres to the project's coding standards and style guidelines. Make sure to run `go fmt` on your code before committing to ensure consistent formatting.
- **Write tests**: Ensure that your changes are well-tested. Add new tests for any new features or bug fixes, and ensure that all tests pass using go test before submitting a pull request.
- **Update documentation**: If your changes involve modifications to the API or the addition of new features, make sure to update the relevant documentation accordingly. This includes comments in the code, user guides, and API documentation.
- **Submit a pull request**: After you have committed and pushed your changes to your fork, submit a pull request to the main repository. Make sure to reference the related issue in the pull request description. A maintainer will review your changes and provide feedback. If necessary, make any requested changes and resubmit the pull request.
- **Be patient**: Maintainers are volunteers and may not be able to review your pull request immediately. Please be patient and respectful while waiting for feedback.

By following these guidelines, you help to ensure a smooth and efficient contribution process that benefits the entire community. Thank you for your interest in contributing to the project!
