# Put the line below in ~/.zshrc:
#
#   eval "$(jump shell zsh)"
#
# The following lines are autogenerated:

__jump_chpwd() {
  jump chdir
}

function __jump_z_complete() {
  [[ "${#words[@]}" -eq "${CURRENT}" ]] || return 0

  if [[ "${#words[@]}" -eq 2 ]]; then
    if [[ -n $(echo ${~words[2]}*(/N)) ]]; then
      _cd -/
    elif [[ "${words[2]}" != */* ]]; then
      local hint="$(jump hint "${words[2]}" | head -1)"
      [[ -n "$hint" ]] && compadd -U -S '' -- "$hint"
    fi
  else
    local -a hints=("${(@f)$(jump hint "${words[2,-1]}")}")
    [[ ${#hints[@]} -gt 0 ]] && compadd -U -S '' -a hints
  fi
}

__jump_base_dir() {
  local base_dir="$JUMP_BASED_PATH"
  if [ -z "$base_dir" ]; then
    base_dir="$(command git rev-parse --show-toplevel 2>/dev/null)"
  fi
  echo "$base_dir"
}

{{.Bind}}() {
  case "$1" in
    "..")
      builtin cd ..
      ;;
    "-")
      builtin cd -
      ;;
    ".")
      local dir="$(jump cd "$(__jump_base_dir)" ${@:2})"
      test -d "$dir" && builtin cd "$dir"
      ;;
    *)
      local dir="$(jump cd $@)"
      test -d "$dir" && builtin cd "$dir"
      ;;
  esac
}

typeset -gaU chpwd_functions
chpwd_functions+=__jump_chpwd

[[ "${+functions[compdef]}" -ne 0 ]] && compdef __jump_z_complete {{.Bind}}
