{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='volumeAttachment', url='', help='"VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.\\n\\nVolumeAttachment objects are non-namespaced."'),
  '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
  metadata: {
    '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
    withAnnotations(annotations): { metadata+: { annotations: annotations } },
    '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
    withAnnotationsMixin(annotations): { metadata+: { annotations+: annotations } },
    '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
    withCreationTimestamp(creationTimestamp): { metadata+: { creationTimestamp: creationTimestamp } },
    '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
    withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } },
    '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
    withDeletionTimestamp(deletionTimestamp): { metadata+: { deletionTimestamp: deletionTimestamp } },
    '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
    withFinalizers(finalizers): { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } },
    '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
    withFinalizersMixin(finalizers): { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } },
    '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
    withGenerateName(generateName): { metadata+: { generateName: generateName } },
    '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
    withGeneration(generation): { metadata+: { generation: generation } },
    '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
    withLabels(labels): { metadata+: { labels: labels } },
    '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
    withLabelsMixin(labels): { metadata+: { labels+: labels } },
    '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
    withManagedFields(managedFields): { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } },
    '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
    withManagedFieldsMixin(managedFields): { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } },
    '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { metadata+: { name: name } },
    '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { metadata+: { namespace: namespace } },
    '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
    withOwnerReferences(ownerReferences): { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } },
    '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
    withOwnerReferencesMixin(ownerReferences): { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } },
    '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
    withResourceVersion(resourceVersion): { metadata+: { resourceVersion: resourceVersion } },
    '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
    withSelfLink(selfLink): { metadata+: { selfLink: selfLink } },
    '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
    withUid(uid): { metadata+: { uid: uid } },
  },
  '#new':: d.fn(help='new returns an instance of VolumeAttachment', args=[d.arg(name='name', type=d.T.string)]),
  new(name): {
    apiVersion: 'storage.k8s.io/v1',
    kind: 'VolumeAttachment',
  } + self.metadata.withName(name=name),
  '#spec':: d.obj(help='"VolumeAttachmentSpec is the specification of a VolumeAttachment request."'),
  spec: {
    '#source':: d.obj(help='"VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set."'),
    source: {
      '#inlineVolumeSpec':: d.obj(help='"PersistentVolumeSpec is the specification of a persistent volume."'),
      inlineVolumeSpec: {
        '#awsElasticBlockStore':: d.obj(help='"Represents a Persistent Disk resource in AWS.\\n\\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling."'),
        awsElasticBlockStore: {
          '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { awsElasticBlockStore+: { fsType: fsType } } } } },
          '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty)."', args=[d.arg(name='partition', type=d.T.integer)]),
          withPartition(partition): { spec+: { source+: { inlineVolumeSpec+: { awsElasticBlockStore+: { partition: partition } } } } },
          '#withReadOnly':: d.fn(help='"readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { awsElasticBlockStore+: { readOnly: readOnly } } } } },
          '#withVolumeID':: d.fn(help='"volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='volumeID', type=d.T.string)]),
          withVolumeID(volumeID): { spec+: { source+: { inlineVolumeSpec+: { awsElasticBlockStore+: { volumeID: volumeID } } } } },
        },
        '#azureDisk':: d.obj(help='"AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod."'),
        azureDisk: {
          '#withCachingMode':: d.fn(help='"cachingMode is the Host Caching mode: None, Read Only, Read Write."', args=[d.arg(name='cachingMode', type=d.T.string)]),
          withCachingMode(cachingMode): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { cachingMode: cachingMode } } } } },
          '#withDiskName':: d.fn(help='"diskName is the Name of the data disk in the blob storage"', args=[d.arg(name='diskName', type=d.T.string)]),
          withDiskName(diskName): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { diskName: diskName } } } } },
          '#withDiskURI':: d.fn(help='"diskURI is the URI of data disk in the blob storage"', args=[d.arg(name='diskURI', type=d.T.string)]),
          withDiskURI(diskURI): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { diskURI: diskURI } } } } },
          '#withFsType':: d.fn(help='"fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { fsType: fsType } } } } },
          '#withKind':: d.fn(help='"kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared"', args=[d.arg(name='kind', type=d.T.string)]),
          withKind(kind): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { kind: kind } } } } },
          '#withReadOnly':: d.fn(help='"readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { azureDisk+: { readOnly: readOnly } } } } },
        },
        '#azureFile':: d.obj(help='"AzureFile represents an Azure File Service mount on the host and bind mount to the pod."'),
        azureFile: {
          '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { azureFile+: { readOnly: readOnly } } } } },
          '#withSecretName':: d.fn(help='"secretName is the name of secret that contains Azure Storage Account Name and Key"', args=[d.arg(name='secretName', type=d.T.string)]),
          withSecretName(secretName): { spec+: { source+: { inlineVolumeSpec+: { azureFile+: { secretName: secretName } } } } },
          '#withSecretNamespace':: d.fn(help='"secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod"', args=[d.arg(name='secretNamespace', type=d.T.string)]),
          withSecretNamespace(secretNamespace): { spec+: { source+: { inlineVolumeSpec+: { azureFile+: { secretNamespace: secretNamespace } } } } },
          '#withShareName':: d.fn(help='"shareName is the azure Share Name"', args=[d.arg(name='shareName', type=d.T.string)]),
          withShareName(shareName): { spec+: { source+: { inlineVolumeSpec+: { azureFile+: { shareName: shareName } } } } },
        },
        '#cephfs':: d.obj(help='"Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling."'),
        cephfs: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withMonitors':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
          withMonitors(monitors): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } } } } },
          '#withMonitorsMixin':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
          withMonitorsMixin(monitors): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } } } } },
          '#withPath':: d.fn(help='"path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /"', args=[d.arg(name='path', type=d.T.string)]),
          withPath(path): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { path: path } } } } },
          '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { readOnly: readOnly } } } } },
          '#withSecretFile':: d.fn(help='"secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='secretFile', type=d.T.string)]),
          withSecretFile(secretFile): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { secretFile: secretFile } } } } },
          '#withUser':: d.fn(help='"user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
          withUser(user): { spec+: { source+: { inlineVolumeSpec+: { cephfs+: { user: user } } } } },
        },
        '#cinder':: d.obj(help='"Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling."'),
        cinder: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { cinder+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { cinder+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withFsType':: d.fn(help='"fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { cinder+: { fsType: fsType } } } } },
          '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { cinder+: { readOnly: readOnly } } } } },
          '#withVolumeID':: d.fn(help='"volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='volumeID', type=d.T.string)]),
          withVolumeID(volumeID): { spec+: { source+: { inlineVolumeSpec+: { cinder+: { volumeID: volumeID } } } } },
        },
        '#claimRef':: d.obj(help='"ObjectReference contains enough information to let you inspect or modify the referred object."'),
        claimRef: {
          '#withApiVersion':: d.fn(help='"API version of the referent."', args=[d.arg(name='apiVersion', type=d.T.string)]),
          withApiVersion(apiVersion): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { apiVersion: apiVersion } } } } },
          '#withFieldPath':: d.fn(help='"If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \\"spec.containers{name}\\" (where \\"name\\" refers to the name of the container that triggered the event) or if no container name is specified \\"spec.containers[2]\\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object."', args=[d.arg(name='fieldPath', type=d.T.string)]),
          withFieldPath(fieldPath): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { fieldPath: fieldPath } } } } },
          '#withKind':: d.fn(help='"Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"', args=[d.arg(name='kind', type=d.T.string)]),
          withKind(kind): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { kind: kind } } } } },
          '#withName':: d.fn(help='"Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
          withName(name): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { name: name } } } } },
          '#withNamespace':: d.fn(help='"Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"', args=[d.arg(name='namespace', type=d.T.string)]),
          withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { namespace: namespace } } } } },
          '#withResourceVersion':: d.fn(help='"Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
          withResourceVersion(resourceVersion): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { resourceVersion: resourceVersion } } } } },
          '#withUid':: d.fn(help='"UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"', args=[d.arg(name='uid', type=d.T.string)]),
          withUid(uid): { spec+: { source+: { inlineVolumeSpec+: { claimRef+: { uid: uid } } } } },
        },
        '#csi':: d.obj(help='"Represents storage that is managed by an external CSI volume driver (Beta feature)"'),
        csi: {
          '#controllerExpandSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          controllerExpandSecretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { csi+: { controllerExpandSecretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { csi+: { controllerExpandSecretRef+: { namespace: namespace } } } } } },
          },
          '#controllerPublishSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          controllerPublishSecretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { csi+: { controllerPublishSecretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { csi+: { controllerPublishSecretRef+: { namespace: namespace } } } } } },
          },
          '#nodeExpandSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          nodeExpandSecretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodeExpandSecretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodeExpandSecretRef+: { namespace: namespace } } } } } },
          },
          '#nodePublishSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          nodePublishSecretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodePublishSecretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodePublishSecretRef+: { namespace: namespace } } } } } },
          },
          '#nodeStageSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          nodeStageSecretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodeStageSecretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { csi+: { nodeStageSecretRef+: { namespace: namespace } } } } } },
          },
          '#withDriver':: d.fn(help='"driver is the name of the driver to use for this volume. Required."', args=[d.arg(name='driver', type=d.T.string)]),
          withDriver(driver): { spec+: { source+: { inlineVolumeSpec+: { csi+: { driver: driver } } } } },
          '#withFsType':: d.fn(help='"fsType to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\"."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { csi+: { fsType: fsType } } } } },
          '#withReadOnly':: d.fn(help='"readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write)."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { csi+: { readOnly: readOnly } } } } },
          '#withVolumeAttributes':: d.fn(help='"volumeAttributes of the volume to publish."', args=[d.arg(name='volumeAttributes', type=d.T.object)]),
          withVolumeAttributes(volumeAttributes): { spec+: { source+: { inlineVolumeSpec+: { csi+: { volumeAttributes: volumeAttributes } } } } },
          '#withVolumeAttributesMixin':: d.fn(help='"volumeAttributes of the volume to publish."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='volumeAttributes', type=d.T.object)]),
          withVolumeAttributesMixin(volumeAttributes): { spec+: { source+: { inlineVolumeSpec+: { csi+: { volumeAttributes+: volumeAttributes } } } } },
          '#withVolumeHandle':: d.fn(help='"volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required."', args=[d.arg(name='volumeHandle', type=d.T.string)]),
          withVolumeHandle(volumeHandle): { spec+: { source+: { inlineVolumeSpec+: { csi+: { volumeHandle: volumeHandle } } } } },
        },
        '#fc':: d.obj(help='"Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling."'),
        fc: {
          '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { fc+: { fsType: fsType } } } } },
          '#withLun':: d.fn(help='"lun is Optional: FC target lun number"', args=[d.arg(name='lun', type=d.T.integer)]),
          withLun(lun): { spec+: { source+: { inlineVolumeSpec+: { fc+: { lun: lun } } } } },
          '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { fc+: { readOnly: readOnly } } } } },
          '#withTargetWWNs':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"', args=[d.arg(name='targetWWNs', type=d.T.array)]),
          withTargetWWNs(targetWWNs): { spec+: { source+: { inlineVolumeSpec+: { fc+: { targetWWNs: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } } } } },
          '#withTargetWWNsMixin':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='targetWWNs', type=d.T.array)]),
          withTargetWWNsMixin(targetWWNs): { spec+: { source+: { inlineVolumeSpec+: { fc+: { targetWWNs+: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } } } } },
          '#withWwids':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."', args=[d.arg(name='wwids', type=d.T.array)]),
          withWwids(wwids): { spec+: { source+: { inlineVolumeSpec+: { fc+: { wwids: if std.isArray(v=wwids) then wwids else [wwids] } } } } },
          '#withWwidsMixin':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='wwids', type=d.T.array)]),
          withWwidsMixin(wwids): { spec+: { source+: { inlineVolumeSpec+: { fc+: { wwids+: if std.isArray(v=wwids) then wwids else [wwids] } } } } },
        },
        '#flexVolume':: d.obj(help='"FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin."'),
        flexVolume: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withDriver':: d.fn(help='"driver is the name of the driver to use for this volume."', args=[d.arg(name='driver', type=d.T.string)]),
          withDriver(driver): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { driver: driver } } } } },
          '#withFsType':: d.fn(help='"fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". The default filesystem depends on FlexVolume script."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { fsType: fsType } } } } },
          '#withOptions':: d.fn(help='"options is Optional: this field holds extra command options if any."', args=[d.arg(name='options', type=d.T.object)]),
          withOptions(options): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { options: options } } } } },
          '#withOptionsMixin':: d.fn(help='"options is Optional: this field holds extra command options if any."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='options', type=d.T.object)]),
          withOptionsMixin(options): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { options+: options } } } } },
          '#withReadOnly':: d.fn(help='"readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { flexVolume+: { readOnly: readOnly } } } } },
        },
        '#flocker':: d.obj(help='"Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling."'),
        flocker: {
          '#withDatasetName':: d.fn(help='"datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated"', args=[d.arg(name='datasetName', type=d.T.string)]),
          withDatasetName(datasetName): { spec+: { source+: { inlineVolumeSpec+: { flocker+: { datasetName: datasetName } } } } },
          '#withDatasetUUID':: d.fn(help='"datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset"', args=[d.arg(name='datasetUUID', type=d.T.string)]),
          withDatasetUUID(datasetUUID): { spec+: { source+: { inlineVolumeSpec+: { flocker+: { datasetUUID: datasetUUID } } } } },
        },
        '#gcePersistentDisk':: d.obj(help='"Represents a Persistent Disk resource in Google Compute Engine.\\n\\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling."'),
        gcePersistentDisk: {
          '#withFsType':: d.fn(help='"fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { gcePersistentDisk+: { fsType: fsType } } } } },
          '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='partition', type=d.T.integer)]),
          withPartition(partition): { spec+: { source+: { inlineVolumeSpec+: { gcePersistentDisk+: { partition: partition } } } } },
          '#withPdName':: d.fn(help='"pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='pdName', type=d.T.string)]),
          withPdName(pdName): { spec+: { source+: { inlineVolumeSpec+: { gcePersistentDisk+: { pdName: pdName } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { gcePersistentDisk+: { readOnly: readOnly } } } } },
        },
        '#glusterfs':: d.obj(help='"Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling."'),
        glusterfs: {
          '#withEndpoints':: d.fn(help='"endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='endpoints', type=d.T.string)]),
          withEndpoints(endpoints): { spec+: { source+: { inlineVolumeSpec+: { glusterfs+: { endpoints: endpoints } } } } },
          '#withEndpointsNamespace':: d.fn(help='"endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='endpointsNamespace', type=d.T.string)]),
          withEndpointsNamespace(endpointsNamespace): { spec+: { source+: { inlineVolumeSpec+: { glusterfs+: { endpointsNamespace: endpointsNamespace } } } } },
          '#withPath':: d.fn(help='"path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='path', type=d.T.string)]),
          withPath(path): { spec+: { source+: { inlineVolumeSpec+: { glusterfs+: { path: path } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { glusterfs+: { readOnly: readOnly } } } } },
        },
        '#hostPath':: d.obj(help='"Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling."'),
        hostPath: {
          '#withPath':: d.fn(help='"path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='path', type=d.T.string)]),
          withPath(path): { spec+: { source+: { inlineVolumeSpec+: { hostPath+: { path: path } } } } },
          '#withType':: d.fn(help='"type for HostPath Volume Defaults to \\"\\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='type', type=d.T.string)]),
          withType(type): { spec+: { source+: { inlineVolumeSpec+: { hostPath+: { type: type } } } } },
        },
        '#iscsi':: d.obj(help='"ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling."'),
        iscsi: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withChapAuthDiscovery':: d.fn(help='"chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication"', args=[d.arg(name='chapAuthDiscovery', type=d.T.boolean)]),
          withChapAuthDiscovery(chapAuthDiscovery): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { chapAuthDiscovery: chapAuthDiscovery } } } } },
          '#withChapAuthSession':: d.fn(help='"chapAuthSession defines whether support iSCSI Session CHAP authentication"', args=[d.arg(name='chapAuthSession', type=d.T.boolean)]),
          withChapAuthSession(chapAuthSession): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { chapAuthSession: chapAuthSession } } } } },
          '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi"', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { fsType: fsType } } } } },
          '#withInitiatorName':: d.fn(help='"initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection."', args=[d.arg(name='initiatorName', type=d.T.string)]),
          withInitiatorName(initiatorName): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { initiatorName: initiatorName } } } } },
          '#withIqn':: d.fn(help='"iqn is Target iSCSI Qualified Name."', args=[d.arg(name='iqn', type=d.T.string)]),
          withIqn(iqn): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { iqn: iqn } } } } },
          '#withIscsiInterface':: d.fn(help="\"iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).\"", args=[d.arg(name='iscsiInterface', type=d.T.string)]),
          withIscsiInterface(iscsiInterface): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { iscsiInterface: iscsiInterface } } } } },
          '#withLun':: d.fn(help='"lun is iSCSI Target Lun number."', args=[d.arg(name='lun', type=d.T.integer)]),
          withLun(lun): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { lun: lun } } } } },
          '#withPortals':: d.fn(help='"portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='portals', type=d.T.array)]),
          withPortals(portals): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { portals: if std.isArray(v=portals) then portals else [portals] } } } } },
          '#withPortalsMixin':: d.fn(help='"portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='portals', type=d.T.array)]),
          withPortalsMixin(portals): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { portals+: if std.isArray(v=portals) then portals else [portals] } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { readOnly: readOnly } } } } },
          '#withTargetPortal':: d.fn(help='"targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='targetPortal', type=d.T.string)]),
          withTargetPortal(targetPortal): { spec+: { source+: { inlineVolumeSpec+: { iscsi+: { targetPortal: targetPortal } } } } },
        },
        '#local':: d.obj(help='"Local represents directly-attached storage with node affinity (Beta feature)"'),
        'local': {
          '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". The default value is to auto-select a filesystem if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { 'local'+: { fsType: fsType } } } } },
          '#withPath':: d.fn(help='"path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...)."', args=[d.arg(name='path', type=d.T.string)]),
          withPath(path): { spec+: { source+: { inlineVolumeSpec+: { 'local'+: { path: path } } } } },
        },
        '#nfs':: d.obj(help='"Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling."'),
        nfs: {
          '#withPath':: d.fn(help='"path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='path', type=d.T.string)]),
          withPath(path): { spec+: { source+: { inlineVolumeSpec+: { nfs+: { path: path } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { nfs+: { readOnly: readOnly } } } } },
          '#withServer':: d.fn(help='"server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='server', type=d.T.string)]),
          withServer(server): { spec+: { source+: { inlineVolumeSpec+: { nfs+: { server: server } } } } },
        },
        '#nodeAffinity':: d.obj(help='"VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from."'),
        nodeAffinity: {
          '#required':: d.obj(help='"A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms."'),
          required: {
            '#withNodeSelectorTerms':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
            withNodeSelectorTerms(nodeSelectorTerms): { spec+: { source+: { inlineVolumeSpec+: { nodeAffinity+: { required+: { nodeSelectorTerms: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } },
            '#withNodeSelectorTermsMixin':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
            withNodeSelectorTermsMixin(nodeSelectorTerms): { spec+: { source+: { inlineVolumeSpec+: { nodeAffinity+: { required+: { nodeSelectorTerms+: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } },
          },
        },
        '#photonPersistentDisk':: d.obj(help='"Represents a Photon Controller persistent disk resource."'),
        photonPersistentDisk: {
          '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { photonPersistentDisk+: { fsType: fsType } } } } },
          '#withPdID':: d.fn(help='"pdID is the ID that identifies Photon Controller persistent disk"', args=[d.arg(name='pdID', type=d.T.string)]),
          withPdID(pdID): { spec+: { source+: { inlineVolumeSpec+: { photonPersistentDisk+: { pdID: pdID } } } } },
        },
        '#portworxVolume':: d.obj(help='"PortworxVolumeSource represents a Portworx volume resource."'),
        portworxVolume: {
          '#withFsType':: d.fn(help='"fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { portworxVolume+: { fsType: fsType } } } } },
          '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { portworxVolume+: { readOnly: readOnly } } } } },
          '#withVolumeID':: d.fn(help='"volumeID uniquely identifies a Portworx volume"', args=[d.arg(name='volumeID', type=d.T.string)]),
          withVolumeID(volumeID): { spec+: { source+: { inlineVolumeSpec+: { portworxVolume+: { volumeID: volumeID } } } } },
        },
        '#quobyte':: d.obj(help='"Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling."'),
        quobyte: {
          '#withGroup':: d.fn(help='"group to map volume access to Default is no group"', args=[d.arg(name='group', type=d.T.string)]),
          withGroup(group): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { group: group } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { readOnly: readOnly } } } } },
          '#withRegistry':: d.fn(help='"registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes"', args=[d.arg(name='registry', type=d.T.string)]),
          withRegistry(registry): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { registry: registry } } } } },
          '#withTenant':: d.fn(help='"tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin"', args=[d.arg(name='tenant', type=d.T.string)]),
          withTenant(tenant): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { tenant: tenant } } } } },
          '#withUser':: d.fn(help='"user to map volume access to Defaults to serivceaccount user"', args=[d.arg(name='user', type=d.T.string)]),
          withUser(user): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { user: user } } } } },
          '#withVolume':: d.fn(help='"volume is a string that references an already created Quobyte volume by name."', args=[d.arg(name='volume', type=d.T.string)]),
          withVolume(volume): { spec+: { source+: { inlineVolumeSpec+: { quobyte+: { volume: volume } } } } },
        },
        '#rbd':: d.obj(help='"Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling."'),
        rbd: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd"', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { fsType: fsType } } } } },
          '#withImage':: d.fn(help='"image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='image', type=d.T.string)]),
          withImage(image): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { image: image } } } } },
          '#withKeyring':: d.fn(help='"keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='keyring', type=d.T.string)]),
          withKeyring(keyring): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { keyring: keyring } } } } },
          '#withMonitors':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
          withMonitors(monitors): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } } } } },
          '#withMonitorsMixin':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
          withMonitorsMixin(monitors): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } } } } },
          '#withPool':: d.fn(help='"pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='pool', type=d.T.string)]),
          withPool(pool): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { pool: pool } } } } },
          '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { readOnly: readOnly } } } } },
          '#withUser':: d.fn(help='"user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
          withUser(user): { spec+: { source+: { inlineVolumeSpec+: { rbd+: { user: user } } } } },
        },
        '#scaleIO':: d.obj(help='"ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume"'),
        scaleIO: {
          '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
          secretRef: {
            '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { secretRef+: { namespace: namespace } } } } } },
          },
          '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Default is \\"xfs\\', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { fsType: fsType } } } } },
          '#withGateway':: d.fn(help='"gateway is the host address of the ScaleIO API Gateway."', args=[d.arg(name='gateway', type=d.T.string)]),
          withGateway(gateway): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { gateway: gateway } } } } },
          '#withProtectionDomain':: d.fn(help='"protectionDomain is the name of the ScaleIO Protection Domain for the configured storage."', args=[d.arg(name='protectionDomain', type=d.T.string)]),
          withProtectionDomain(protectionDomain): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { protectionDomain: protectionDomain } } } } },
          '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { readOnly: readOnly } } } } },
          '#withSslEnabled':: d.fn(help='"sslEnabled is the flag to enable/disable SSL communication with Gateway, default false"', args=[d.arg(name='sslEnabled', type=d.T.boolean)]),
          withSslEnabled(sslEnabled): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { sslEnabled: sslEnabled } } } } },
          '#withStorageMode':: d.fn(help='"storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned."', args=[d.arg(name='storageMode', type=d.T.string)]),
          withStorageMode(storageMode): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { storageMode: storageMode } } } } },
          '#withStoragePool':: d.fn(help='"storagePool is the ScaleIO Storage Pool associated with the protection domain."', args=[d.arg(name='storagePool', type=d.T.string)]),
          withStoragePool(storagePool): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { storagePool: storagePool } } } } },
          '#withSystem':: d.fn(help='"system is the name of the storage system as configured in ScaleIO."', args=[d.arg(name='system', type=d.T.string)]),
          withSystem(system): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { system: system } } } } },
          '#withVolumeName':: d.fn(help='"volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source."', args=[d.arg(name='volumeName', type=d.T.string)]),
          withVolumeName(volumeName): { spec+: { source+: { inlineVolumeSpec+: { scaleIO+: { volumeName: volumeName } } } } },
        },
        '#storageos':: d.obj(help='"Represents a StorageOS persistent volume resource."'),
        storageos: {
          '#secretRef':: d.obj(help='"ObjectReference contains enough information to let you inspect or modify the referred object."'),
          secretRef: {
            '#withApiVersion':: d.fn(help='"API version of the referent."', args=[d.arg(name='apiVersion', type=d.T.string)]),
            withApiVersion(apiVersion): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { apiVersion: apiVersion } } } } } },
            '#withFieldPath':: d.fn(help='"If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \\"spec.containers{name}\\" (where \\"name\\" refers to the name of the container that triggered the event) or if no container name is specified \\"spec.containers[2]\\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object."', args=[d.arg(name='fieldPath', type=d.T.string)]),
            withFieldPath(fieldPath): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { fieldPath: fieldPath } } } } } },
            '#withKind':: d.fn(help='"Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"', args=[d.arg(name='kind', type=d.T.string)]),
            withKind(kind): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { kind: kind } } } } } },
            '#withName':: d.fn(help='"Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
            withName(name): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { name: name } } } } } },
            '#withNamespace':: d.fn(help='"Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"', args=[d.arg(name='namespace', type=d.T.string)]),
            withNamespace(namespace): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { namespace: namespace } } } } } },
            '#withResourceVersion':: d.fn(help='"Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
            withResourceVersion(resourceVersion): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { resourceVersion: resourceVersion } } } } } },
            '#withUid':: d.fn(help='"UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"', args=[d.arg(name='uid', type=d.T.string)]),
            withUid(uid): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { secretRef+: { uid: uid } } } } } },
          },
          '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { fsType: fsType } } } } },
          '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
          withReadOnly(readOnly): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { readOnly: readOnly } } } } },
          '#withVolumeName':: d.fn(help='"volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace."', args=[d.arg(name='volumeName', type=d.T.string)]),
          withVolumeName(volumeName): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { volumeName: volumeName } } } } },
          '#withVolumeNamespace':: d.fn(help="\"volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \\\"default\\\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.\"", args=[d.arg(name='volumeNamespace', type=d.T.string)]),
          withVolumeNamespace(volumeNamespace): { spec+: { source+: { inlineVolumeSpec+: { storageos+: { volumeNamespace: volumeNamespace } } } } },
        },
        '#vsphereVolume':: d.obj(help='"Represents a vSphere volume resource."'),
        vsphereVolume: {
          '#withFsType':: d.fn(help='"fsType is filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
          withFsType(fsType): { spec+: { source+: { inlineVolumeSpec+: { vsphereVolume+: { fsType: fsType } } } } },
          '#withStoragePolicyID':: d.fn(help='"storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName."', args=[d.arg(name='storagePolicyID', type=d.T.string)]),
          withStoragePolicyID(storagePolicyID): { spec+: { source+: { inlineVolumeSpec+: { vsphereVolume+: { storagePolicyID: storagePolicyID } } } } },
          '#withStoragePolicyName':: d.fn(help='"storagePolicyName is the storage Policy Based Management (SPBM) profile name."', args=[d.arg(name='storagePolicyName', type=d.T.string)]),
          withStoragePolicyName(storagePolicyName): { spec+: { source+: { inlineVolumeSpec+: { vsphereVolume+: { storagePolicyName: storagePolicyName } } } } },
          '#withVolumePath':: d.fn(help='"volumePath is the path that identifies vSphere volume vmdk"', args=[d.arg(name='volumePath', type=d.T.string)]),
          withVolumePath(volumePath): { spec+: { source+: { inlineVolumeSpec+: { vsphereVolume+: { volumePath: volumePath } } } } },
        },
        '#withAccessModes':: d.fn(help='"accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes"', args=[d.arg(name='accessModes', type=d.T.array)]),
        withAccessModes(accessModes): { spec+: { source+: { inlineVolumeSpec+: { accessModes: if std.isArray(v=accessModes) then accessModes else [accessModes] } } } },
        '#withAccessModesMixin':: d.fn(help='"accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='accessModes', type=d.T.array)]),
        withAccessModesMixin(accessModes): { spec+: { source+: { inlineVolumeSpec+: { accessModes+: if std.isArray(v=accessModes) then accessModes else [accessModes] } } } },
        '#withCapacity':: d.fn(help="\"capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity\"", args=[d.arg(name='capacity', type=d.T.object)]),
        withCapacity(capacity): { spec+: { source+: { inlineVolumeSpec+: { capacity: capacity } } } },
        '#withCapacityMixin':: d.fn(help="\"capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='capacity', type=d.T.object)]),
        withCapacityMixin(capacity): { spec+: { source+: { inlineVolumeSpec+: { capacity+: capacity } } } },
        '#withMountOptions':: d.fn(help='"mountOptions is the list of mount options, e.g. [\\"ro\\", \\"soft\\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options"', args=[d.arg(name='mountOptions', type=d.T.array)]),
        withMountOptions(mountOptions): { spec+: { source+: { inlineVolumeSpec+: { mountOptions: if std.isArray(v=mountOptions) then mountOptions else [mountOptions] } } } },
        '#withMountOptionsMixin':: d.fn(help='"mountOptions is the list of mount options, e.g. [\\"ro\\", \\"soft\\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='mountOptions', type=d.T.array)]),
        withMountOptionsMixin(mountOptions): { spec+: { source+: { inlineVolumeSpec+: { mountOptions+: if std.isArray(v=mountOptions) then mountOptions else [mountOptions] } } } },
        '#withPersistentVolumeReclaimPolicy':: d.fn(help='"persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming"', args=[d.arg(name='persistentVolumeReclaimPolicy', type=d.T.string)]),
        withPersistentVolumeReclaimPolicy(persistentVolumeReclaimPolicy): { spec+: { source+: { inlineVolumeSpec+: { persistentVolumeReclaimPolicy: persistentVolumeReclaimPolicy } } } },
        '#withStorageClassName':: d.fn(help='"storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass."', args=[d.arg(name='storageClassName', type=d.T.string)]),
        withStorageClassName(storageClassName): { spec+: { source+: { inlineVolumeSpec+: { storageClassName: storageClassName } } } },
        '#withVolumeAttributesClassName':: d.fn(help='"Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is an alpha field and requires enabling VolumeAttributesClass feature."', args=[d.arg(name='volumeAttributesClassName', type=d.T.string)]),
        withVolumeAttributesClassName(volumeAttributesClassName): { spec+: { source+: { inlineVolumeSpec+: { volumeAttributesClassName: volumeAttributesClassName } } } },
        '#withVolumeMode':: d.fn(help='"volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec."', args=[d.arg(name='volumeMode', type=d.T.string)]),
        withVolumeMode(volumeMode): { spec+: { source+: { inlineVolumeSpec+: { volumeMode: volumeMode } } } },
      },
      '#withPersistentVolumeName':: d.fn(help='"persistentVolumeName represents the name of the persistent volume to attach."', args=[d.arg(name='persistentVolumeName', type=d.T.string)]),
      withPersistentVolumeName(persistentVolumeName): { spec+: { source+: { persistentVolumeName: persistentVolumeName } } },
    },
    '#withAttacher':: d.fn(help='"attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName()."', args=[d.arg(name='attacher', type=d.T.string)]),
    withAttacher(attacher): { spec+: { attacher: attacher } },
    '#withNodeName':: d.fn(help='"nodeName represents the node that the volume should be attached to."', args=[d.arg(name='nodeName', type=d.T.string)]),
    withNodeName(nodeName): { spec+: { nodeName: nodeName } },
  },
  '#mixin': 'ignore',
  mixin: self,
}
