{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='apiResource', url='', help='"APIResource specifies the name of a resource and whether it is namespaced."'),
  '#withCategories':: d.fn(help="\"categories is a list of the grouped resources this resource belongs to (e.g. 'all')\"", args=[d.arg(name='categories', type=d.T.array)]),
  withCategories(categories): { categories: if std.isArray(v=categories) then categories else [categories] },
  '#withCategoriesMixin':: d.fn(help="\"categories is a list of the grouped resources this resource belongs to (e.g. 'all')\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='categories', type=d.T.array)]),
  withCategoriesMixin(categories): { categories+: if std.isArray(v=categories) then categories else [categories] },
  '#withGroup':: d.fn(help='"group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale\\"."', args=[d.arg(name='group', type=d.T.string)]),
  withGroup(group): { group: group },
  '#withKind':: d.fn(help="\"kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')\"", args=[d.arg(name='kind', type=d.T.string)]),
  withKind(kind): { kind: kind },
  '#withName':: d.fn(help='"name is the plural name of the resource."', args=[d.arg(name='name', type=d.T.string)]),
  withName(name): { name: name },
  '#withNamespaced':: d.fn(help='"namespaced indicates if a resource is namespaced or not."', args=[d.arg(name='namespaced', type=d.T.boolean)]),
  withNamespaced(namespaced): { namespaced: namespaced },
  '#withShortNames':: d.fn(help='"shortNames is a list of suggested short names of the resource."', args=[d.arg(name='shortNames', type=d.T.array)]),
  withShortNames(shortNames): { shortNames: if std.isArray(v=shortNames) then shortNames else [shortNames] },
  '#withShortNamesMixin':: d.fn(help='"shortNames is a list of suggested short names of the resource."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='shortNames', type=d.T.array)]),
  withShortNamesMixin(shortNames): { shortNames+: if std.isArray(v=shortNames) then shortNames else [shortNames] },
  '#withSingularName':: d.fn(help='"singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface."', args=[d.arg(name='singularName', type=d.T.string)]),
  withSingularName(singularName): { singularName: singularName },
  '#withStorageVersionHash':: d.fn(help='"The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates."', args=[d.arg(name='storageVersionHash', type=d.T.string)]),
  withStorageVersionHash(storageVersionHash): { storageVersionHash: storageVersionHash },
  '#withVerbs':: d.fn(help='"verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)"', args=[d.arg(name='verbs', type=d.T.array)]),
  withVerbs(verbs): { verbs: if std.isArray(v=verbs) then verbs else [verbs] },
  '#withVerbsMixin':: d.fn(help='"verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='verbs', type=d.T.array)]),
  withVerbsMixin(verbs): { verbs+: if std.isArray(v=verbs) then verbs else [verbs] },
  '#withVersion':: d.fn(help="\"version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource's group)\\\".\"", args=[d.arg(name='version', type=d.T.string)]),
  withVersion(version): { version: version },
  '#mixin': 'ignore',
  mixin: self,
}
