{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='validatingAdmissionPolicySpec', url='', help='"ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy."'),
  '#matchConstraints':: d.obj(help='"MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)"'),
  matchConstraints: {
    '#namespaceSelector':: d.obj(help='"A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects."'),
    namespaceSelector: {
      '#withMatchExpressions':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressions(matchExpressions): { matchConstraints+: { namespaceSelector+: { matchExpressions: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchExpressionsMixin':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressionsMixin(matchExpressions): { matchConstraints+: { namespaceSelector+: { matchExpressions+: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchLabels':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabels(matchLabels): { matchConstraints+: { namespaceSelector+: { matchLabels: matchLabels } } },
      '#withMatchLabelsMixin':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabelsMixin(matchLabels): { matchConstraints+: { namespaceSelector+: { matchLabels+: matchLabels } } },
    },
    '#objectSelector':: d.obj(help='"A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects."'),
    objectSelector: {
      '#withMatchExpressions':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressions(matchExpressions): { matchConstraints+: { objectSelector+: { matchExpressions: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchExpressionsMixin':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressionsMixin(matchExpressions): { matchConstraints+: { objectSelector+: { matchExpressions+: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchLabels':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabels(matchLabels): { matchConstraints+: { objectSelector+: { matchLabels: matchLabels } } },
      '#withMatchLabelsMixin':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabelsMixin(matchLabels): { matchConstraints+: { objectSelector+: { matchLabels+: matchLabels } } },
    },
    '#withExcludeResourceRules':: d.fn(help='"ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)"', args=[d.arg(name='excludeResourceRules', type=d.T.array)]),
    withExcludeResourceRules(excludeResourceRules): { matchConstraints+: { excludeResourceRules: if std.isArray(v=excludeResourceRules) then excludeResourceRules else [excludeResourceRules] } },
    '#withExcludeResourceRulesMixin':: d.fn(help='"ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='excludeResourceRules', type=d.T.array)]),
    withExcludeResourceRulesMixin(excludeResourceRules): { matchConstraints+: { excludeResourceRules+: if std.isArray(v=excludeResourceRules) then excludeResourceRules else [excludeResourceRules] } },
    '#withMatchPolicy':: d.fn(help='"matchPolicy defines how the \\"MatchResources\\" list is used to match incoming requests. Allowed values are \\"Exact\\" or \\"Equivalent\\".\\n\\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \\"rules\\" only included `apiGroups:[\\"apps\\"], apiVersions:[\\"v1\\"], resources: [\\"deployments\\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\\n\\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \\"rules\\" only included `apiGroups:[\\"apps\\"], apiVersions:[\\"v1\\"], resources: [\\"deployments\\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\\n\\nDefaults to \\"Equivalent\\', args=[d.arg(name='matchPolicy', type=d.T.string)]),
    withMatchPolicy(matchPolicy): { matchConstraints+: { matchPolicy: matchPolicy } },
    '#withResourceRules':: d.fn(help='"ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule."', args=[d.arg(name='resourceRules', type=d.T.array)]),
    withResourceRules(resourceRules): { matchConstraints+: { resourceRules: if std.isArray(v=resourceRules) then resourceRules else [resourceRules] } },
    '#withResourceRulesMixin':: d.fn(help='"ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='resourceRules', type=d.T.array)]),
    withResourceRulesMixin(resourceRules): { matchConstraints+: { resourceRules+: if std.isArray(v=resourceRules) then resourceRules else [resourceRules] } },
  },
  '#paramKind':: d.obj(help='"ParamKind is a tuple of Group Kind and Version."'),
  paramKind: {
    '#withApiVersion':: d.fn(help='"APIVersion is the API group version the resources belong to. In format of \\"group/version\\". Required."', args=[d.arg(name='apiVersion', type=d.T.string)]),
    withApiVersion(apiVersion): { paramKind+: { apiVersion: apiVersion } },
    '#withKind':: d.fn(help='"Kind is the API kind the resources belong to. Required."', args=[d.arg(name='kind', type=d.T.string)]),
    withKind(kind): { paramKind+: { kind: kind } },
  },
  '#withAuditAnnotations':: d.fn(help='"auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required."', args=[d.arg(name='auditAnnotations', type=d.T.array)]),
  withAuditAnnotations(auditAnnotations): { auditAnnotations: if std.isArray(v=auditAnnotations) then auditAnnotations else [auditAnnotations] },
  '#withAuditAnnotationsMixin':: d.fn(help='"auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='auditAnnotations', type=d.T.array)]),
  withAuditAnnotationsMixin(auditAnnotations): { auditAnnotations+: if std.isArray(v=auditAnnotations) then auditAnnotations else [auditAnnotations] },
  '#withFailurePolicy':: d.fn(help='"failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\\n\\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\\n\\nfailurePolicy does not define how validations that evaluate to false are handled.\\n\\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\\n\\nAllowed values are Ignore or Fail. Defaults to Fail."', args=[d.arg(name='failurePolicy', type=d.T.string)]),
  withFailurePolicy(failurePolicy): { failurePolicy: failurePolicy },
  '#withMatchConditions':: d.fn(help='"MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\\n\\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\\n\\nThe exact matching logic is (in order):\\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\\n  3. If any matchCondition evaluates to an error (but none are FALSE):\\n     - If failurePolicy=Fail, reject the request\\n     - If failurePolicy=Ignore, the policy is skipped"', args=[d.arg(name='matchConditions', type=d.T.array)]),
  withMatchConditions(matchConditions): { matchConditions: if std.isArray(v=matchConditions) then matchConditions else [matchConditions] },
  '#withMatchConditionsMixin':: d.fn(help='"MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\\n\\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\\n\\nThe exact matching logic is (in order):\\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\\n  3. If any matchCondition evaluates to an error (but none are FALSE):\\n     - If failurePolicy=Fail, reject the request\\n     - If failurePolicy=Ignore, the policy is skipped"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchConditions', type=d.T.array)]),
  withMatchConditionsMixin(matchConditions): { matchConditions+: if std.isArray(v=matchConditions) then matchConditions else [matchConditions] },
  '#withValidations':: d.fn(help='"Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required."', args=[d.arg(name='validations', type=d.T.array)]),
  withValidations(validations): { validations: if std.isArray(v=validations) then validations else [validations] },
  '#withValidationsMixin':: d.fn(help='"Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='validations', type=d.T.array)]),
  withValidationsMixin(validations): { validations+: if std.isArray(v=validations) then validations else [validations] },
  '#withVariables':: d.fn(help='"Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\\n\\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic."', args=[d.arg(name='variables', type=d.T.array)]),
  withVariables(variables): { variables: if std.isArray(v=variables) then variables else [variables] },
  '#withVariablesMixin':: d.fn(help='"Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\\n\\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='variables', type=d.T.array)]),
  withVariablesMixin(variables): { variables+: if std.isArray(v=variables) then variables else [variables] },
  '#mixin': 'ignore',
  mixin: self,
}
