// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package threatintelligence provides access to the Threat Intelligence API.
//
// For product documentation, see: https://cloud.google.com/threatintelligence/docs/reference/rest
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/threatintelligence/v1beta"
//	...
//	ctx := context.Background()
//	threatintelligenceService, err := threatintelligence.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	threatintelligenceService, err := threatintelligence.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	threatintelligenceService, err := threatintelligence.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package threatintelligence // import "google.golang.org/api/threatintelligence/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "threatintelligence:v1beta"
const apiName = "threatintelligence"
const apiVersion = "v1beta"
const basePath = "https://threatintelligence.googleapis.com/"
const basePathTemplate = "https://threatintelligence.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://threatintelligence.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Alerts = NewProjectsAlertsService(s)
	rs.Configurations = NewProjectsConfigurationsService(s)
	rs.Findings = NewProjectsFindingsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Alerts *ProjectsAlertsService

	Configurations *ProjectsConfigurationsService

	Findings *ProjectsFindingsService
}

func NewProjectsAlertsService(s *Service) *ProjectsAlertsService {
	rs := &ProjectsAlertsService{s: s}
	rs.Documents = NewProjectsAlertsDocumentsService(s)
	return rs
}

type ProjectsAlertsService struct {
	s *Service

	Documents *ProjectsAlertsDocumentsService
}

func NewProjectsAlertsDocumentsService(s *Service) *ProjectsAlertsDocumentsService {
	rs := &ProjectsAlertsDocumentsService{s: s}
	return rs
}

type ProjectsAlertsDocumentsService struct {
	s *Service
}

func NewProjectsConfigurationsService(s *Service) *ProjectsConfigurationsService {
	rs := &ProjectsConfigurationsService{s: s}
	rs.Revisions = NewProjectsConfigurationsRevisionsService(s)
	return rs
}

type ProjectsConfigurationsService struct {
	s *Service

	Revisions *ProjectsConfigurationsRevisionsService
}

func NewProjectsConfigurationsRevisionsService(s *Service) *ProjectsConfigurationsRevisionsService {
	rs := &ProjectsConfigurationsRevisionsService{s: s}
	return rs
}

type ProjectsConfigurationsRevisionsService struct {
	s *Service
}

func NewProjectsFindingsService(s *Service) *ProjectsFindingsService {
	rs := &ProjectsFindingsService{s: s}
	return rs
}

type ProjectsFindingsService struct {
	s *Service
}

// AffectedSoftware: The software that is affected by the vulnerability.
type AffectedSoftware struct {
	// Product: Optional. The product of the software.
	Product string `json:"product,omitempty"`
	// Vendor: Optional. The vendor of the software.
	Vendor string `json:"vendor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Product") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Product") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AffectedSoftware) MarshalJSON() ([]byte, error) {
	type NoMethod AffectedSoftware
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Alert: Stateful object representing a group of Findings. Key feature to an
// Alert is that it expresses the user's intent towards the findings of that
// group, even those that haven't occurred yet.
type Alert struct {
	// AiSummary: Optional. AI summary of the finding.
	AiSummary string `json:"aiSummary,omitempty"`
	// Assets: Output only. Assets that are impacted by this alert.
	Assets []string `json:"assets,omitempty"`
	// Audit: Output only. Audit information for the alert.
	Audit *Audit `json:"audit,omitempty"`
	// Configurations: Output only. The resource names of the Configurations bound
	// to this alert. Format: projects/{project}/configurations/{configuration}
	Configurations []string `json:"configurations,omitempty"`
	// Detail: Output only. Details object for the alert, not all alerts will have
	// a details object.
	Detail *AlertDetail `json:"detail,omitempty"`
	// DisplayName: Output only. A short title for the alert.
	DisplayName string `json:"displayName,omitempty"`
	// DuplicateOf: Output only. alert name of the alert this alert is a duplicate
	// of. Format: projects/{project}/alerts/{alert}
	DuplicateOf string `json:"duplicateOf,omitempty"`
	// DuplicatedBy: Output only. alert names of the alerts that are duplicates of
	// this alert. Format: projects/{project}/alerts/{alert}
	DuplicatedBy []string `json:"duplicatedBy,omitempty"`
	// Etag: Optional. If included when updating an alert, this should be set to
	// the current etag of the alert. If the etags do not match, the update will be
	// rejected and an ABORTED error will be returned.
	Etag string `json:"etag,omitempty"`
	// ExternalId: Output only. External ID for the alert. This is used internally
	// to provide protection against out of order updates.
	ExternalId string `json:"externalId,omitempty"`
	// Findings: Output only. Findings that are covered by this alert.
	Findings []string `json:"findings,omitempty"`
	// Name: Identifier. Server generated name for the alert. format is
	// projects/{project}/alerts/{alert}
	Name string `json:"name,omitempty"`
	// PriorityAnalysis: Output only. High-Precision Priority Analysis for the
	// alert.
	PriorityAnalysis *PriorityAnalysis `json:"priorityAnalysis,omitempty"`
	// RelevanceAnalysis: Output only. High-Precision Relevance Analysis verdict
	// for the alert.
	RelevanceAnalysis *RelevanceAnalysis `json:"relevanceAnalysis,omitempty"`
	// SeverityAnalysis: Output only. High-Precision Severity Analysis for the
	// alert.
	SeverityAnalysis *SeverityAnalysis `json:"severityAnalysis,omitempty"`
	// State: Output only. State of the alert.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value, should never be set.
	//   "NEW" - alert is new.
	//   "READ" - alert was read by a human.
	//   "TRIAGED" - alert has been triaged.
	//   "ESCALATED" - alert has been escalated.
	//   "RESOLVED" - alert has been resolved.
	//   "DUPLICATE" - alert is a duplicate of another alert.
	//   "FALSE_POSITIVE" - alert is a false positive and should be ignored.
	//   "NOT_ACTIONABLE" - alert is not actionable.
	//   "BENIGN" - alert is benign.
	//   "TRACKED_EXTERNALLY" - alert is tracked externally.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AiSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AiSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Alert) MarshalJSON() ([]byte, error) {
	type NoMethod Alert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AlertDetail: Container for different types of alert details.
type AlertDetail struct {
	// DataLeak: Data Leak alert detail type.
	DataLeak *DataLeakAlertDetail `json:"dataLeak,omitempty"`
	// DetailType: Output only. Name of the detail type. Will be set by the server
	// during creation to the name of the field that is set in the detail union.
	DetailType string `json:"detailType,omitempty"`
	// InitialAccessBroker: Initial Access Broker alert detail type.
	InitialAccessBroker *InitialAccessBrokerAlertDetail `json:"initialAccessBroker,omitempty"`
	// InsiderThreat: Insider Threat alert detail type.
	InsiderThreat *InsiderThreatAlertDetail `json:"insiderThreat,omitempty"`
	// SuspiciousDomain: Domain Monitoring alert detail type.
	SuspiciousDomain *SuspiciousDomainAlertDetail `json:"suspiciousDomain,omitempty"`
	// TargetTechnology: Technology Watchlist alert detail type.
	TargetTechnology *TargetTechnologyAlertDetail `json:"targetTechnology,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataLeak") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataLeak") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod AlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AlertDocument: A document that is associated with an alert.
type AlertDocument struct {
	// AiSummary: Output only. AI summary of the finding.
	AiSummary string `json:"aiSummary,omitempty"`
	// Author: Output only. The author of the document.
	Author string `json:"author,omitempty"`
	// CollectionTime: Output only. Time when the origin source collected the
	// intel.
	CollectionTime string `json:"collectionTime,omitempty"`
	// Content: Output only. The content of the document.
	Content string `json:"content,omitempty"`
	// CreateTime: Output only. The time the document was created.
	CreateTime string `json:"createTime,omitempty"`
	// IngestTime: Output only. Time when GTI received the intel.
	IngestTime string `json:"ingestTime,omitempty"`
	// LanguageCode: Output only. The language code of the document.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Identifier. Server generated name for the alert document. format is
	// projects/{project}/alerts/{alert}/documents/{document}
	Name string `json:"name,omitempty"`
	// Source: Output only. Source of the intel item, e.g. DarkMarket.
	Source string `json:"source,omitempty"`
	// SourceUpdateTime: Output only. Time when the intel was last updated by the
	// source.
	SourceUpdateTime string `json:"sourceUpdateTime,omitempty"`
	// SourceUri: Output only. URI of the intel item from the source.
	SourceUri string `json:"sourceUri,omitempty"`
	// Title: Output only. The title of the document, if available.
	Title string `json:"title,omitempty"`
	// Translation: Output only. The translation of the document, if available.
	Translation *AlertDocumentTranslation `json:"translation,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AiSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AiSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AlertDocument) MarshalJSON() ([]byte, error) {
	type NoMethod AlertDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AlertDocumentTranslation: The translation of an alert document.
type AlertDocumentTranslation struct {
	// TranslatedContent: Output only. The translated content of the document.
	TranslatedContent string `json:"translatedContent,omitempty"`
	// TranslatedTitle: Output only. The translated title of the document.
	TranslatedTitle string `json:"translatedTitle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranslatedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranslatedContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AlertDocumentTranslation) MarshalJSON() ([]byte, error) {
	type NoMethod AlertDocumentTranslation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssetDiscoveryConfig: Customer defined Configuration for asset discovery.
type AssetDiscoveryConfig struct {
	// LastScanCompleteTime: Output only. Timestamp of the last scan completed.
	// This field is set by the system and cannot be modified by the user.
	LastScanCompleteTime string `json:"lastScanCompleteTime,omitempty"`
	// LastScanStartTime: Output only. Timestamp of the last scan started - used
	// for scheduling the next scan. This field is set by the system and cannot be
	// modified by the user.
	LastScanStartTime string `json:"lastScanStartTime,omitempty"`
	// ScanFrequency: Required. Frequency at which the scheduled discovery scan
	// should be run. If not specified, the default frequency is DAILY.
	//
	// Possible values:
	//   "ASSET_DISCOVERY_SCAN_FREQUENCY_UNSPECIFIED" - Default value, should never
	// be set.
	//   "ON_DEMAND" - Scan is triggered on demand.
	//   "WEEKLY" - Scan is triggered weekly.
	//   "DAILY" - Scan is triggered daily.
	//   "MONTHLY" - Scan is triggered monthly.
	ScanFrequency string `json:"scanFrequency,omitempty"`
	// ScopeExclusionAssets: Optional. Seed assets that are out of scope for the
	// scheduled discovery scan.
	ScopeExclusionAssets []*AssetDiscoverySeed `json:"scopeExclusionAssets,omitempty"`
	// SeedAssets: Required. Seed assets for the scheduled discovery scan. At least
	// one seed asset is required.
	SeedAssets []*AssetDiscoverySeed `json:"seedAssets,omitempty"`
	// Workflow: Required. Workflow to be used for the scheduled discovery scan. If
	// not specified, the default workflow is EXTERNAL_DISCOVERY.
	//
	// Possible values:
	//   "ASSET_DISCOVERY_WORKFLOW_UNSPECIFIED" - Default value, should never be
	// set.
	//   "EXTERNAL_DISCOVERY" - Discovery workflow that only discovers external
	// facing assets.
	//   "EXTERNAL_DISCOVERY_AND_ASSESSMENT" - Discovery workflow that discovers
	// external facing assets and generates relevant alerts on them.
	//   "MOBILE_APP_DISCOVERY" - Discovery workflow that discovers mobile app
	// assets.
	Workflow string `json:"workflow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastScanCompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastScanCompleteTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetDiscoveryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssetDiscoveryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssetDiscoverySeed: Seed assets for asset discovery.
type AssetDiscoverySeed struct {
	// SeedType: Required. Type of the seed asset.
	//
	// Possible values:
	//   "ASSET_DISCOVERY_SEED_TYPE_UNSPECIFIED" - Default value, should never be
	// set.
	//   "IP_ADDRESS" - Seed asset is an IP address.
	//   "NETWORK_SERVICE" - Seed asset is a network service.
	SeedType string `json:"seedType,omitempty"`
	// SeedValue: Required. Value for the seed asset. Could be an IP address,
	// network service, email addresses, etc.
	SeedValue string `json:"seedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SeedType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SeedType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetDiscoverySeed) MarshalJSON() ([]byte, error) {
	type NoMethod AssetDiscoverySeed
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Association: Represents an association with a vulnerability.
type Association struct {
	// Id: Required. The ID of the association.
	Id string `json:"id,omitempty"`
	// Type: Required. The type of the association.
	//
	// Possible values:
	//   "THREAT_INTEL_OBJECT_TYPE_UNSPECIFIED" - Unspecified object type.
	//   "THREAT_INTEL_OBJECT_TYPE_THREAT_ACTOR" - Threat actor object type.
	//   "THREAT_INTEL_OBJECT_TYPE_MALWARE" - Malware object type.
	//   "THREAT_INTEL_OBJECT_TYPE_REPORT" - Report object type.
	//   "THREAT_INTEL_OBJECT_TYPE_CAMPAIGN" - Campaign object type.
	//   "THREAT_INTEL_OBJECT_TYPE_IOC_COLLECTION" - IoC Collection object type.
	//   "THREAT_INTEL_OBJECT_TYPE_SOFTWARE_AND_TOOLKITS" - Software and toolkits
	// object type.
	//   "THREAT_INTEL_OBJECT_TYPE_VULNERABILITY" - Vulnerability object type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Association) MarshalJSON() ([]byte, error) {
	type NoMethod Association
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Audit: Tracks basic CRUD facts.
type Audit struct {
	// CreateTime: Output only. Time of creation.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Agent that created or updated the record, could be a
	// UserId or a JobId.
	Creator string `json:"creator,omitempty"`
	// UpdateTime: Output only. Time of creation or last update.
	UpdateTime string `json:"updateTime,omitempty"`
	// Updater: Output only. Agent that last updated the record, could be a UserId
	// or a JobId.
	Updater string `json:"updater,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Audit) MarshalJSON() ([]byte, error) {
	type NoMethod Audit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompromisedCredentialsFindingDetail: Sample compromised credential detail.
type CompromisedCredentialsFindingDetail struct {
	// Author: Optional. Reference to the author this detail was extracted from.
	// This is deprecated and will be removed.
	Author string `json:"author,omitempty"`
	// CredentialService: Optional. Claimed site the credential is intended for.
	CredentialService string `json:"credentialService,omitempty"`
	// DarkWebDoc: Optional. Reference to the dark web document. This is deprecated
	// and will be removed.
	DarkWebDoc string `json:"darkWebDoc,omitempty"`
	// ExternalReferenceUri: Optional. This will contain a link to the external
	// reference for this credential. If set, this is a link back to the DTM
	// product to allow customers to get additional context about this finding.
	ExternalReferenceUri string `json:"externalReferenceUri,omitempty"`
	// FileDump: Optional. If the source of the credential was from a file dump
	// this will contain the name of the file the credential was found in. This can
	// be used by customers for context on where the credential was found and to
	// try to find other references to the file in the wild.
	FileDump string `json:"fileDump,omitempty"`
	// FileDumpHashes: Optional. A list of hashes of the file dump. These will be
	// prefixed with the algorithm. Example: "sha256:"
	FileDumpHashes []string `json:"fileDumpHashes,omitempty"`
	// FileDumpSizeBytes: Optional. If file_dump is set this will contain the size
	// of the dump file in bytes. File dumps can be very large.
	FileDumpSizeBytes int64 `json:"fileDumpSizeBytes,omitempty,string"`
	// Forum: Optional. Reference to the forum this detail was extracted from. This
	// is deprecated and will be removed.
	Forum string `json:"forum,omitempty"`
	// MalwareFamily: Optional. This will indicate the malware family that leaked
	// this credential, if known.
	MalwareFamily string `json:"malwareFamily,omitempty"`
	// PostedTime: Optional. This indicates our best guess as to when the
	// credential was leaked to the particular venue that triggered this finding.
	// This is not necessarily the time the credential was actually leaked and it
	// may not always be be accurate.
	PostedTime string `json:"postedTime,omitempty"`
	// SourceUri: Optional. If the source of a credential is publicly addressable
	// this will contain a uri to the where the credential was found.
	SourceUri string `json:"sourceUri,omitempty"`
	// UserKey: Required. This field will always be set and will be used to
	// identify the user named in the credential leak. In cases where customers are
	// authorized to see the actual user key this will be set to the actual user
	// key. In cases where the customer is not authorized to see the actual user
	// key this will be set to a hash of the user key. The hashed value is an
	// intentionally opaque value that is not intended to be used for any other
	// purpose than to uniquely identify the user in the context of this specific
	// customer, service domain, and user name. Example: "user@example.com" or
	// "redacted:".
	UserKey string `json:"userKey,omitempty"`
	// UserSecretEvidence: Optional. Claimed evidence of the password/secret. This
	// will always be hashed. In the event where the plaintext password is known it
	// will be set to "redacted:" where the same hash will be presented when the
	// same password is found for the same organization for the same service.
	// Redaction is done by hashing the password with a salt that is unique to the
	// customer organization and service. In the event where the plaintext password
	// is not known it will be set to ":" where the algorithm is the hash algorithm
	// used and the hash is the hash of the password using that algorithm. In the
	// event we don't know the exact algorithm used we will set it to "hashed:".
	UserSecretEvidence string `json:"userSecretEvidence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Author") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Author") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompromisedCredentialsFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod CompromisedCredentialsFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Configuration: A configuration represents a behavior an engine should follow
// when producing new findings.
type Configuration struct {
	// Audit: Output only. Audit information for the configuration.
	Audit *Audit `json:"audit,omitempty"`
	// Description: Optional. A description of the configuration.
	Description string `json:"description,omitempty"`
	// Detail: Required. Domain specific details for the configuration.
	Detail *ConfigurationDetail `json:"detail,omitempty"`
	// DisplayName: Output only. Human readable name for the configuration.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. Server generated name for the configuration. format is
	// vaults/{vault}/configurations/{configuration}
	Name string `json:"name,omitempty"`
	// Provider: Required. Name of the service that provides the configuration.
	Provider string `json:"provider,omitempty"`
	// State: Optional. State of the configuration.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Configuration state is unspecified. This is not
	// expected to occur.
	//   "ENABLED" - Configuration is enabled for the customer.
	//   "DISABLED" - Configuration is disabled for the customer.
	//   "DEPRECATED" - Configuration is deprecated, no new configs are allowed to
	// be created.
	State string `json:"state,omitempty"`
	// Version: Optional. A user-manipulatable version. Does not adhere to a
	// specific format
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Audit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audit") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Configuration) MarshalJSON() ([]byte, error) {
	type NoMethod Configuration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigurationDetail: Wrapper class that contains the union struct for all
// the various configuration detail specific classes.
type ConfigurationDetail struct {
	// AssetDiscovery: Asset Discovery detail config.
	AssetDiscovery *AssetDiscoveryConfig `json:"assetDiscovery,omitempty"`
	// CustomerProfile: Customer Profile detail config.
	CustomerProfile *CustomerProfileConfig `json:"customerProfile,omitempty"`
	// DetailType: Output only. Name of the detail type. Will be set by the server
	// during creation to the name of the field that is set in the detail union.
	DetailType string `json:"detailType,omitempty"`
	// DomainMonitoring: Domain Monitoring detail config.
	DomainMonitoring *DomainMonitoringConfig `json:"domainMonitoring,omitempty"`
	// InitialAccessBroker: Initial Access Broker (IAB) detail config.
	InitialAccessBroker *InitialAccessBrokerConfig `json:"initialAccessBroker,omitempty"`
	// TechnologyWatchlist: Technology Watchlist detail config.
	TechnologyWatchlist *TechnologyWatchListConfig `json:"technologyWatchlist,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssetDiscovery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetDiscovery") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigurationDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigurationDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigurationRevision: A ConfigurationRevision is a snapshot of a
// Configuration at a point in time. It is immutable.
type ConfigurationRevision struct {
	// CreateTime: Output only. The time the Revision was created
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the ConfigurationRevision Format:
	// vaults//configurations//revisions/ OR projects//configurations//revisions/
	Name string `json:"name,omitempty"`
	// Snapshot: The snapshot of the configuration
	Snapshot *Configuration `json:"snapshot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigurationRevision) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigurationRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileCitation: Citation information for the customer profile.
type CustomerProfileCitation struct {
	// CitationId: Required. The citation id for the citation. Should be unique
	// within the profile.
	CitationId string `json:"citationId,omitempty"`
	// Document: Required. The name of the document the citation is from.
	Document string `json:"document,omitempty"`
	// RetrievalTime: The time the citation was retrieved.
	RetrievalTime string `json:"retrievalTime,omitempty"`
	// Source: Required. The source of the citation.
	Source string `json:"source,omitempty"`
	// Uri: Optional. The url of the citation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileCitation) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileCitedString: A string with citation ids.
type CustomerProfileCitedString struct {
	// CitationIds: Optional. The citation ids for the string.
	CitationIds []string `json:"citationIds,omitempty"`
	// Value: Required. The value of the string.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileCitedString) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileCitedString
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileCompany: Company information for the customer profile.
type CustomerProfileCompany struct {
	// CitationIds: Optional. The citation ids for the company.
	CitationIds []string `json:"citationIds,omitempty"`
	// Company: Required. The name of the company.
	Company string `json:"company,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileCompany) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileCompany
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileConfig: CustomerProfileConfig is the configuration for the
// customer profile.
type CustomerProfileConfig struct {
	// Citations: Optional. Citations for the organization profile.
	Citations []*CustomerProfileCitation `json:"citations,omitempty"`
	// ContactInfo: Optional. Contact information for the organization.
	ContactInfo []*CustomerProfileContactInfo `json:"contactInfo,omitempty"`
	// Executives: Optional. Executives of the organization.
	Executives []*CustomerProfilePerson `json:"executives,omitempty"`
	// Industries: Optional. The industries the organization is involved in.
	Industries []*CustomerProfileIndustry `json:"industries,omitempty"`
	// Locations: Optional. Locations the organization is present or conducts
	// business in.
	Locations []*CustomerProfileLocation `json:"locations,omitempty"`
	// Org: Required. The name of the organization.
	Org string `json:"org,omitempty"`
	// OrgSummary: Optional. A summary of the organization.
	OrgSummary string `json:"orgSummary,omitempty"`
	// ParentCompanies: Optional. The parent companies of the organization.
	ParentCompanies []*CustomerProfileCompany `json:"parentCompanies,omitempty"`
	// Products: Optional. Product information for the organization.
	Products []*CustomerProfileProduct `json:"products,omitempty"`
	// SecurityConsiderations: Optional. Security considerations for the
	// organization.
	SecurityConsiderations *CustomerProfileSecurityConsiderations `json:"securityConsiderations,omitempty"`
	// Summary: Optional. A summarized version of the customer profile.
	Summary *CustomerProfileSummary `json:"summary,omitempty"`
	// TechnologyPresence: Optional. Technology presence of the organization.
	TechnologyPresence string `json:"technologyPresence,omitempty"`
	// WebPresences: Optional. Web presence of the organization.
	WebPresences []*CustomerProfileWebPresence `json:"webPresences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileContactInfo: Contact information for the customer profile.
type CustomerProfileContactInfo struct {
	// Address: The address of the contact.
	Address string `json:"address,omitempty"`
	// CitationIds: Optional. The citation ids for the contact information.
	CitationIds []string `json:"citationIds,omitempty"`
	// Email: The email address of the contact.
	Email string `json:"email,omitempty"`
	// Label: Optional. The name of the contact.
	Label string `json:"label,omitempty"`
	// Other: The other contact information.
	Other string `json:"other,omitempty"`
	// Phone: The phone number of the contact.
	Phone string `json:"phone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileContactInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileContactInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileIndustry: Industry information for the customer profile.
type CustomerProfileIndustry struct {
	// CitationIds: Optional. The citation ids for the industry.
	CitationIds []string `json:"citationIds,omitempty"`
	// Industry: Required. The name of the industry.
	Industry string `json:"industry,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileIndustry) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileIndustry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileLocation: Location information for the customer profile.
type CustomerProfileLocation struct {
	// Address: Required. The address of the location.
	Address string `json:"address,omitempty"`
	// Brand: Required. The brand of the location.
	Brand string `json:"brand,omitempty"`
	// CitationIds: Optional. The citation ids for the location.
	CitationIds []string `json:"citationIds,omitempty"`
	// FacilityType: Optional. The type of location.
	FacilityType string `json:"facilityType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileLocation) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfilePerson: Person information for the customer profile.
type CustomerProfilePerson struct {
	// CitationIds: Optional. The citation ids for the person.
	CitationIds []string `json:"citationIds,omitempty"`
	// Name: Required. The name of the person.
	Name string `json:"name,omitempty"`
	// Title: Optional. The title of the person.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfilePerson) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfilePerson
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileProduct: Product information for the customer profile.
type CustomerProfileProduct struct {
	// Brand: Required. The brand of the product.
	Brand string `json:"brand,omitempty"`
	// CitationIds: Optional. The citation ids for the product.
	CitationIds []string `json:"citationIds,omitempty"`
	// Product: Required. The name of the product.
	Product string `json:"product,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileProduct) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileProduct
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileSecurityConsiderations: Security considerations for the
// customer profile.
type CustomerProfileSecurityConsiderations struct {
	// Considerations: Optional. A series of considerations for the security of the
	// organization, such as "high risk of compromise" or "vulnerable to
	// cyberbullying".
	Considerations []string `json:"considerations,omitempty"`
	// Note: Optional. A note about the security considerations.
	Note string `json:"note,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Considerations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Considerations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileSecurityConsiderations) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileSecurityConsiderations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileSummary: A summarized version of the customer profile.
// Generated by the backend.
type CustomerProfileSummary struct {
	// AreaServed: Optional. The area the customer serves.
	AreaServed *CustomerProfileCitedString `json:"areaServed,omitempty"`
	// Brands: Optional. A narrative summary of brands.
	Brands *CustomerProfileCitedString `json:"brands,omitempty"`
	// EntityType: Optional. The entity type of the customer.
	EntityType *CustomerProfileCitedString `json:"entityType,omitempty"`
	// Founded: Optional. The date the customer was founded.
	Founded *CustomerProfileCitedString `json:"founded,omitempty"`
	// Headquarters: Optional. The headquarters of the customer.
	Headquarters *CustomerProfileCitedString `json:"headquarters,omitempty"`
	// Industry: Optional. The industry the customer is in.
	Industry *CustomerProfileCitedString `json:"industry,omitempty"`
	// KeyPeopleSummary: Optional. A narrative summary of key people.
	KeyPeopleSummary *CustomerProfileCitedString `json:"keyPeopleSummary,omitempty"`
	// ParentCompany: Optional. The parent company of the customer.
	ParentCompany *CustomerProfileCitedString `json:"parentCompany,omitempty"`
	// PrimaryWebsite: Optional. The primary website of the customer.
	PrimaryWebsite *CustomerProfileCitedString `json:"primaryWebsite,omitempty"`
	// ProductsSummary: Optional. A narrative summary of products.
	ProductsSummary *CustomerProfileCitedString `json:"productsSummary,omitempty"`
	// ServicesSummary: Optional. A narrative summary of services.
	ServicesSummary *CustomerProfileCitedString `json:"servicesSummary,omitempty"`
	// Title: Optional. The official name of the customer.
	Title *CustomerProfileCitedString `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AreaServed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AreaServed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileSummary) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomerProfileWebPresence: Web presence information for the customer
// profile.
type CustomerProfileWebPresence struct {
	// CitationIds: Optional. The citation ids for the web presence.
	CitationIds []string `json:"citationIds,omitempty"`
	// Domain: Required. The domain name of the web presence.
	Domain string `json:"domain,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerProfileWebPresence) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerProfileWebPresence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataLeakAlertDetail: Captures the specific details of Data Leak alert.
type DataLeakAlertDetail struct {
	// DiscoveryDocumentIds: Required. Array of ids to accommodate multiple
	// discovery documents
	DiscoveryDocumentIds []string `json:"discoveryDocumentIds,omitempty"`
	// Severity: Required. Data Leak specific severity This will be the string
	// representation of the DataLeakFindingDetail.Severityenum. (e.g., "LOW",
	// "MEDIUM", "HIGH", "CRITICAL")
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryDocumentIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryDocumentIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataLeakAlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod DataLeakAlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataLeakFindingDetail: A detail object for a Data Leak finding.
type DataLeakFindingDetail struct {
	// DocumentId: Required. The unique identifier of the document that triggered
	// the Data Leak finding. This ID can be used to retrieve the content of the
	// document for further analysis.
	DocumentId string `json:"documentId,omitempty"`
	// MatchScore: Required. Reference to the match score of the Data Leak finding.
	// This is a float value greater than 0 and less than or equal to 1 calculated
	// by the matching engine based on the similarity of the document and the user
	// provided configurations.
	MatchScore float64 `json:"matchScore,omitempty"`
	// Severity: Required. The severity of the Data Leak finding. This indicates
	// the potential impact of the threat.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value, should never be set.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataLeakFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod DataLeakFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DataLeakFindingDetail) UnmarshalJSON(data []byte) error {
	type NoMethod DataLeakFindingDetail
	var s1 struct {
		MatchScore gensupport.JSONFloat64 `json:"matchScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchScore = float64(s1.MatchScore)
	return nil
}

// DomainMonitoringConfig: Any account-level configuration options will go
// here.
type DomainMonitoringConfig struct {
	// Domains: The domains to use as "seeds" for Suspicious Domain Monitoring.
	Domains []*DomainMonitoringDomain `json:"domains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domains") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DomainMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainMonitoringDomain: A Domain Monitoring "domain"
type DomainMonitoringDomain struct {
	// Domain: The domain name to match against.
	Domain string `json:"domain,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainMonitoringDomain) MarshalJSON() ([]byte, error) {
	type NoMethod DomainMonitoringDomain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityProfile: EntityProfile represents the structured profile of a customer
// entity, containing key identifiers and descriptive attributes optimized for
// contextual matching against threat intelligence, particularly Initial Access
// Broker (IAB) offerings.
type EntityProfile struct {
	// Countries: Optional. List of specific countries of operation. Purpose:
	// Essential for matching geographically targeted threats (e.g., actor
	// specifies victims in 'DE'). Use ISO 3166-1 alpha-2 codes (e.g., "US", "GB",
	// "JP", "DE").
	Countries []string `json:"countries,omitempty"`
	// Domains: Required. List of primary internet domain names associated with the
	// entity. Purpose: Crucial for explicit matching against domains mentioned in
	// threat intel and can inform semantic matching. Must contain at least one
	// domain. Example: ["acme.com", "acme.co.uk"]
	Domains []string `json:"domains,omitempty"`
	// Industries: Optional. List of primary industry sectors the entity operates
	// within. Purpose: Crucial for matching industry-specific threats and
	// understanding attacker motivation. Use standardized GTI Industry
	// Classification values. Example: ["Technology", "Financial Services",
	// "Healthcare"]
	Industries []string `json:"industries,omitempty"`
	// Name: Required. Canonical name of the entity (e.g., the legal company name).
	// Purpose: Primary identifier for the customer.
	Name string `json:"name,omitempty"`
	// OperationalAreas: Optional. Specific geographic areas of *significant*
	// operational concentration or strategic importance below the country level,
	// if clearly identifiable and relevant. Purpose: Useful for highly localized
	// threats, less commonly populated than `countries`. Example: ["Silicon
	// Valley", "Frankfurt am Main Metropolitan Region"]
	OperationalAreas []string `json:"operationalAreas,omitempty"`
	// ProfileSummary: Required. A concise, machine-generated (e.g., LLM) or
	// human-curated summary of the entity. Purpose: Captures the semantic essence
	// for embedding generation and similarity matching. Should synthesize key
	// aspects like core business, scale, and market. Example: "Acme Corporation is
	// a large, US-based multinational conglomerate operating..."
	ProfileSummary string `json:"profileSummary,omitempty"`
	// Regions: Optional. List of primary geopolitical regions where the entity has
	// significant operations. Purpose: Filters geographically relevant threats.
	// Use standardized names or codes where possible (e.g., "North America",
	// "EMEA", "APAC", UN M49 codes).
	Regions []string `json:"regions,omitempty"`
	// SubIndustries: Optional. List of more granular sub-industries, if applicable
	// and known. Purpose: Provides finer-grained context for more specific threat
	// matching. Should align with GTI classifications if possible. Example:
	// ["Semiconductors", "Cloud Computing Services", "Investment Banking"]
	SubIndustries []string `json:"subIndustries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Countries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Countries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityProfile) MarshalJSON() ([]byte, error) {
	type NoMethod EntityProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnumerateAlertFacetsResponse: Response message for EnumerateAlertFacets.
type EnumerateAlertFacetsResponse struct {
	// Facets: List of facets and the counts.
	Facets []*Facet `json:"facets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Facets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Facets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnumerateAlertFacetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EnumerateAlertFacetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Evidence: Details the evidence used to determine the relevance verdict.
type Evidence struct {
	// CommonThemes: A list of semantic themes or concepts found to be common,
	// related, or aligned between the sources, supporting the verdict.
	CommonThemes []string `json:"commonThemes,omitempty"`
	// DistinctThemes: A list of semantic themes or descriptions unique to one
	// source or semantically distant.
	DistinctThemes []string `json:"distinctThemes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonThemes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonThemes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Evidence) MarshalJSON() ([]byte, error) {
	type NoMethod Evidence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Facet: Facet represents a sub element of a resource for filtering. The
// results from this method are used to populate the filterable facets in the
// UI.
type Facet struct {
	// Facet: Name of the facet. This is also the string that needs to be used in
	// the filtering expression.
	Facet string `json:"facet,omitempty"`
	// FacetCounts: List of counts for the facet (if categorical).
	FacetCounts []*FacetCount `json:"facetCounts,omitempty"`
	// FacetType: The type of the facet. Options include "string", "int", "float",
	// "bool", "enum", "timestamp", "user" and are useful to show the right sort of
	// UI controls when building a AIP-160 style filtering string.
	FacetType string `json:"facetType,omitempty"`
	// MaxValue: Max value of the facet stringified based on type. Will be
	// populated and formatted the same as min_value.
	MaxValue string `json:"maxValue,omitempty"`
	// MinValue: Min value of the facet stringified based on type. This is only
	// populated for facets that have a clear ordering, for types like enum it will
	// be left empty. Timestamps will be formatted using RFC3339.
	MinValue string `json:"minValue,omitempty"`
	// TotalCount: Total number of records that contain this facet with ANY value.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Facet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Facet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Facet) MarshalJSON() ([]byte, error) {
	type NoMethod Facet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FacetCount: FacetCount represents a count of records with each facet value.
type FacetCount struct {
	// Count: Count of records with the value.
	Count int64 `json:"count,omitempty"`
	// Value: Value of the facet stringified. Timestamps will be formatted using
	// RFC3339.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FacetCount) MarshalJSON() ([]byte, error) {
	type NoMethod FacetCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Finding: A ‘stateless’ and a point in time event that a check produced a
// result of interest.
type Finding struct {
	// AiSummary: Optional. AI summary of the finding.
	AiSummary string `json:"aiSummary,omitempty"`
	// Alert: Optional. Name of the alert that this finding is bound to.
	Alert string `json:"alert,omitempty"`
	// Asset: Optional. Optional - asset name if known. Format:
	// vaults/{vault}/assets/{asset}
	Asset string `json:"asset,omitempty"`
	// Audit: Output only. Audit data about the finding.
	Audit *Audit `json:"audit,omitempty"`
	// Configurations: Optional. Configuration names that are bound to this
	// finding.
	Configurations []string `json:"configurations,omitempty"`
	// Detail: Required. Holder of the domain specific details of the finding.
	Detail *FindingDetail `json:"detail,omitempty"`
	// DisplayName: Required. A short descriptive title for the finding <= 250
	// chars. EX: "Actor 'baddy' offering $1000 for credentials of 'goodguy'".
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Optional. Optional - name of the issue that this finding is bound to.
	// Format: vaults/{vault}/issues/{issue}
	Issue string `json:"issue,omitempty"`
	// Name: Identifier. Server generated name for the finding (leave clear during
	// creation). Format: vaults/{vault}/findings/{finding}
	Name string `json:"name,omitempty"`
	// Provider: Required. Logical source of this finding (name of the sub-engine).
	Provider string `json:"provider,omitempty"`
	// RelevanceAnalysis: Output only. High-Precision Relevance Analysis verdict
	// for the finding.
	RelevanceAnalysis *RelevanceAnalysis `json:"relevanceAnalysis,omitempty"`
	// ReoccurrenceTimes: Output only. When identical finding (same labels and same
	// details) has re-occurred.
	ReoccurrenceTimes []string `json:"reoccurrenceTimes,omitempty"`
	// Severity: Optional. Deprecated: Use the `severity_analysis` field instead.
	// Base severity score from the finding source.
	Severity float64 `json:"severity,omitempty"`
	// SeverityAnalysis: Output only. High-Precision Severity Analysis verdict for
	// the finding.
	SeverityAnalysis *SeverityAnalysis `json:"severityAnalysis,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AiSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AiSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Finding) MarshalJSON() ([]byte, error) {
	type NoMethod Finding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Finding) UnmarshalJSON(data []byte) error {
	type NoMethod Finding
	var s1 struct {
		Severity gensupport.JSONFloat64 `json:"severity"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Severity = float64(s1.Severity)
	return nil
}

// FindingDetail: Wrapper class that contains the union struct for all the
// various findings detail specific classes.
type FindingDetail struct {
	// CompromisedCredentials: Compromised Credentials detail type.
	CompromisedCredentials *CompromisedCredentialsFindingDetail `json:"compromisedCredentials,omitempty"`
	// DataLeak: Data Leak finding detail type.
	DataLeak *DataLeakFindingDetail `json:"dataLeak,omitempty"`
	// DetailType: Output only. Name of the detail type. Will be set by the server
	// during creation to the name of the field that is set in the detail union.
	DetailType string `json:"detailType,omitempty"`
	// InbandVulnerability: Inband vulnerability detail type.
	InbandVulnerability *InbandVulnerabilityFindingDetail `json:"inbandVulnerability,omitempty"`
	// InitialAccessBroker: Initial Access Broker finding detail type.
	InitialAccessBroker *InitialAccessBrokerFindingDetail `json:"initialAccessBroker,omitempty"`
	// InsiderThreat: Insider Threat finding detail type.
	InsiderThreat *InsiderThreatFindingDetail `json:"insiderThreat,omitempty"`
	// Misconfiguration: Misconfiguration finding detail type.
	Misconfiguration *MisconfigurationFindingDetail `json:"misconfiguration,omitempty"`
	// SuspiciousDomain: Domain Monitoring finding detail type.
	SuspiciousDomain *SuspiciousDomainFindingDetail `json:"suspiciousDomain,omitempty"`
	// TargetTechnology: Technology Watchlist finding detail type.
	TargetTechnology *TargetTechnologyFindingDetail `json:"targetTechnology,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompromisedCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompromisedCredentials") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod FindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InbandVulnerability: Fleshed out vulnerability object that includes enough
// details to fill out a vulnerability specific view for an issue.
type InbandVulnerability struct {
	// AffectedSoftware: Optional. The software that is affected by the
	// vulnerability.
	AffectedSoftware []*AffectedSoftware `json:"affectedSoftware,omitempty"`
	// Authors: Optional. The authors of the vulnerability detection.
	Authors []string `json:"authors,omitempty"`
	// CveId: Required. The CVE ID of the vulnerability.
	CveId string `json:"cveId,omitempty"`
	// CvssV31Score: Required. The CVSS V3.1 score (Base score)for the
	// vulnerability. ( )
	CvssV31Score float64 `json:"cvssV31Score,omitempty"`
	// CvssV31ScoreTemporal: Optional. Temporal CVSS V3.1 score for the
	// vulnerability.
	CvssV31ScoreTemporal float64 `json:"cvssV31ScoreTemporal,omitempty"`
	// Description: Optional. The human readable description. This can be basic
	// HTML formatted text.
	Description string `json:"description,omitempty"`
	// DisclosureTime: Optional. The date the vulnerability was first disclosed.
	DisclosureTime string `json:"disclosureTime,omitempty"`
	// ExploitationState: Optional. Exploitation state of the vulnerability, for
	// example "Available".
	ExploitationState string `json:"exploitationState,omitempty"`
	// ExternalVulnerabilityId: Required. The external ID of the vulnerability.
	ExternalVulnerabilityId string `json:"externalVulnerabilityId,omitempty"`
	// IsExploitedWild: Optional. Whether this is exploited in the wild.
	IsExploitedWild bool `json:"isExploitedWild,omitempty"`
	// ReferenceUrls: Optional. Reference URLs to the vulnerability.
	ReferenceUrls []string `json:"referenceUrls,omitempty"`
	// Remediation: Optional. The human readable remediation recommendation. This
	// can be basic HTML formatted text.
	Remediation string `json:"remediation,omitempty"`
	// RiskRating: Optional. Risk rating for the vulnerability, for example "High".
	RiskRating string `json:"riskRating,omitempty"`
	// Title: Optional. Human readable name for the vulnerability.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AffectedSoftware") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedSoftware") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InbandVulnerability) MarshalJSON() ([]byte, error) {
	type NoMethod InbandVulnerability
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *InbandVulnerability) UnmarshalJSON(data []byte) error {
	type NoMethod InbandVulnerability
	var s1 struct {
		CvssV31Score         gensupport.JSONFloat64 `json:"cvssV31Score"`
		CvssV31ScoreTemporal gensupport.JSONFloat64 `json:"cvssV31ScoreTemporal"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CvssV31Score = float64(s1.CvssV31Score)
	s.CvssV31ScoreTemporal = float64(s1.CvssV31ScoreTemporal)
	return nil
}

// InbandVulnerabilityFindingDetail: This is a temporary detail type that will
// be used to support vulnerabilities until the engines start using the full
// vulnerability objects. The "Inband" refers to the fact that all
// vulnerability details are included with every finding.
type InbandVulnerabilityFindingDetail struct {
	// FormattedProofDetails: Optional. A short description of the proof of the
	// vulnerability.
	FormattedProofDetails string `json:"formattedProofDetails,omitempty"`
	// RequestUri: Optional. The URI that lead to this detection, if appropriate.
	RequestUri string `json:"requestUri,omitempty"`
	// Vulnerability: Required. Vulnerability metadata.
	Vulnerability *InbandVulnerability `json:"vulnerability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FormattedProofDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FormattedProofDetails") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InbandVulnerabilityFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod InbandVulnerabilityFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InitialAccessBrokerAlertDetail: Captures the specific details of
// InitialAccessBroker (IAB) alert.
type InitialAccessBrokerAlertDetail struct {
	// DiscoveryDocumentIds: Required. Array of ids to accommodate multiple
	// discovery documents
	DiscoveryDocumentIds []string `json:"discoveryDocumentIds,omitempty"`
	// Severity: Required. IAB specific severity
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryDocumentIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryDocumentIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InitialAccessBrokerAlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod InitialAccessBrokerAlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InitialAccessBrokerConfig: InitialAccessBrokerConfig is specific to Initial
// Access Broker (IAB) matching scenarios.
type InitialAccessBrokerConfig struct {
	// EntityProfile: Represents the comprehensive profile of the customer entity
	// used for matching.
	EntityProfile *EntityProfile `json:"entityProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityProfile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InitialAccessBrokerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InitialAccessBrokerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InitialAccessBrokerFindingDetail: A detail object for an Initial Access
// Broker (IAB) finding.
type InitialAccessBrokerFindingDetail struct {
	// DocumentId: Required. The unique identifier of the document that triggered
	// the IAB finding. This ID can be used to retrieve the content of the document
	// for further analysis.
	DocumentId string `json:"documentId,omitempty"`
	// MatchScore: Required. Reference to the match score of the IAB finding. This
	// is a float value between 0 and 1 calculated by the matching engine based on
	// the similarity of the document and the user provided configurations.
	MatchScore float64 `json:"matchScore,omitempty"`
	// Severity: Required. The severity of the IAB finding. This indicates the
	// potential impact of the threat.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED"
	//   "LOW"
	//   "MEDIUM"
	//   "HIGH"
	//   "CRITICAL"
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InitialAccessBrokerFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod InitialAccessBrokerFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *InitialAccessBrokerFindingDetail) UnmarshalJSON(data []byte) error {
	type NoMethod InitialAccessBrokerFindingDetail
	var s1 struct {
		MatchScore gensupport.JSONFloat64 `json:"matchScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchScore = float64(s1.MatchScore)
	return nil
}

// InsiderThreatAlertDetail: Captures the specific details of InsiderThreat
// alert.
type InsiderThreatAlertDetail struct {
	// DiscoveryDocumentIds: Required. Array of ids to accommodate multiple
	// discovery documents
	DiscoveryDocumentIds []string `json:"discoveryDocumentIds,omitempty"`
	// Severity: Required. InsiderThreat specific severity This will be the string
	// representation of the InsiderThreatFindingDetail.Severityenum. (e.g., "LOW",
	// "MEDIUM", "HIGH", "CRITICAL")
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryDocumentIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryDocumentIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsiderThreatAlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod InsiderThreatAlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InsiderThreatFindingDetail: A detail object for a InsiderThreat finding.
type InsiderThreatFindingDetail struct {
	// DocumentId: Required. The unique identifier of the document that triggered
	// the InsiderThreat finding. This ID can be used to retrieve the content of
	// the document for further analysis.
	DocumentId string `json:"documentId,omitempty"`
	// MatchScore: Required. Reference to the match score of the InsiderThreat
	// finding. This is a float value greater than 0 and less than or equal to 1
	// calculated by the matching engine based on the similarity of the document
	// and the user provided configurations.
	MatchScore float64 `json:"matchScore,omitempty"`
	// Severity: Required. The severity of the InsiderThreat finding. This
	// indicates the potential impact of the threat.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value, should never be set.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsiderThreatFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod InsiderThreatFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *InsiderThreatFindingDetail) UnmarshalJSON(data []byte) error {
	type NoMethod InsiderThreatFindingDetail
	var s1 struct {
		MatchScore gensupport.JSONFloat64 `json:"matchScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchScore = float64(s1.MatchScore)
	return nil
}

// ListAlertsResponse: Response message for ListAlerts.
type ListAlertsResponse struct {
	// Alerts: List of alerts.
	Alerts []*Alert `json:"alerts,omitempty"`
	// NextPageToken: Page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Alerts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAlertsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAlertsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConfigurationRevisionsResponse: Response message for
// ListConfigurationRevisions.
type ListConfigurationRevisionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Revisions: The Configuration Revisions associated with the specified
	// Configuration
	Revisions []*ConfigurationRevision `json:"revisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConfigurationRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConfigurationRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConfigurationsResponse: Response message for ListConfigurations.
type ListConfigurationsResponse struct {
	// Configurations: List of configurations.
	Configurations []*Configuration `json:"configurations,omitempty"`
	// NextPageToken: Page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configurations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configurations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConfigurationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConfigurationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFindingsResponse: Response message for ListFindings.
type ListFindingsResponse struct {
	// Findings: List of findings.
	Findings []*Finding `json:"findings,omitempty"`
	// NextPageToken: Page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Findings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Findings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MarkAlertAsBenignRequest: Request message for MarkAlertAsBenign.
type MarkAlertAsBenignRequest struct {
}

// MarkAlertAsDuplicateRequest: Request message for MarkAlertAsDuplicate.
type MarkAlertAsDuplicateRequest struct {
	// DuplicateOf: Optional. Name of the alert to mark as a duplicate of. Format:
	// projects/{project}/alerts/{alert}
	DuplicateOf string `json:"duplicateOf,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateOf") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateOf") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MarkAlertAsDuplicateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MarkAlertAsDuplicateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MarkAlertAsEscalatedRequest: Request message for MarkAlertAsEscalated.
type MarkAlertAsEscalatedRequest struct {
}

// MarkAlertAsFalsePositiveRequest: Request message for
// MarkAlertAsFalsePositive.
type MarkAlertAsFalsePositiveRequest struct {
}

// MarkAlertAsNotActionableRequest: Request message for
// MarkAlertAsNotActionable.
type MarkAlertAsNotActionableRequest struct {
}

// MarkAlertAsReadRequest: Request message for MarkAlertAsRead.
type MarkAlertAsReadRequest struct {
}

// MarkAlertAsResolvedRequest: Request message for MarkAlertAsResolved.
type MarkAlertAsResolvedRequest struct {
}

// MarkAlertAsTrackedExternallyRequest: Request message for
// MarkAlertAsTrackedExternally.
type MarkAlertAsTrackedExternallyRequest struct {
}

// MarkAlertAsTriagedRequest: Request message for MarkAlertAsTriaged.
type MarkAlertAsTriagedRequest struct {
}

// MisconfigurationFindingDetail: Misconfiguration finding detail.
type MisconfigurationFindingDetail struct {
	// MisconfigurationMetadata: Required. The misconfiguration metadata.
	MisconfigurationMetadata *MisconfigurationMetadata `json:"misconfigurationMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MisconfigurationMetadata")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MisconfigurationMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MisconfigurationFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod MisconfigurationFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MisconfigurationMetadata: Misconfiguration metadata.
type MisconfigurationMetadata struct {
	// Description: Optional. Description of the misconfiguration.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. A user-friendly name for the misconfiguration.
	DisplayName string `json:"displayName,omitempty"`
	// MisconfigurationId: Required. The identifier for the misconfiguration. This
	// is an internal name generated by the finding provider.
	MisconfigurationId string `json:"misconfigurationId,omitempty"`
	// References: Optional. References to external resources that provide more
	// information about the misconfiguration.
	References []*MisconfigurationReference `json:"references,omitempty"`
	// Remediation: Optional. Recommended remediation steps for the
	// misconfiguration.
	Remediation string `json:"remediation,omitempty"`
	// VulnerableUri: Optional. The endpoint which was found to have the
	// vulnerability.
	VulnerableUri string `json:"vulnerableUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MisconfigurationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod MisconfigurationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MisconfigurationReference: A reference to an external resource that provides
// more information about a misconfiguration.
type MisconfigurationReference struct {
	// Type: Required. The type of the reference (e.g., "description",
	// "remediation").
	Type string `json:"type,omitempty"`
	// Uri: Required. The URI of the reference.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MisconfigurationReference) MarshalJSON() ([]byte, error) {
	type NoMethod MisconfigurationReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriorityAnalysis: Structured priority analysis for a threat.
type PriorityAnalysis struct {
	// Confidence: The level of confidence in the given verdict.
	//
	// Possible values:
	//   "CONFIDENCE_LEVEL_UNSPECIFIED" - Default value. Confidence level is not
	// specified.
	//   "CONFIDENCE_LEVEL_LOW" - Low confidence in the verdict.
	//   "CONFIDENCE_LEVEL_MEDIUM" - Medium confidence in the verdict.
	//   "CONFIDENCE_LEVEL_HIGH" - High confidence in the verdict.
	Confidence string `json:"confidence,omitempty"`
	// PriorityLevel: The level of Priority.
	//
	// Possible values:
	//   "PRIORITY_LEVEL_UNSPECIFIED" - Default value, should never be set.
	//   "PRIORITY_LEVEL_LOW" - Low Priority.
	//   "PRIORITY_LEVEL_MEDIUM" - Medium Priority.
	//   "PRIORITY_LEVEL_HIGH" - High Priority.
	//   "PRIORITY_LEVEL_CRITICAL" - Critical Priority.
	PriorityLevel string `json:"priorityLevel,omitempty"`
	// Reasoning: Human-readable explanation from the model, detailing why a
	// particular result is considered to have a certain priority.
	Reasoning string `json:"reasoning,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriorityAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod PriorityAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshAlertUriStatusRequest: Request message for FetchAlertUriStatus.
type RefreshAlertUriStatusRequest struct {
}

// RefreshAlertUriStatusResponse: Response message for FetchAlertUriStatus.
type RefreshAlertUriStatusResponse struct {
	// State: Output only. Status of the alert in WebRisk.
	//
	// Possible values:
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_UNSPECIFIED" - Unspecified status.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_NOT_SUBMITTED" - Issue has not been
	// submitted to WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_SUBMITTED" - Issue has been submitted to
	// WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_PROCESSING" - Issue has been submitted
	// to WebRisk and is being processed.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_ADDED" - Issue has been processed by
	// WebRisk and the domain was added to the blocklist.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_REJECTED" - Issue has been processed by
	// WebRisk and was rejected.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshAlertUriStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshAlertUriStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RelevanceAnalysis: Structured relevance analysis for a threat.
type RelevanceAnalysis struct {
	// Confidence: The level of confidence in the given verdict.
	//
	// Possible values:
	//   "CONFIDENCE_LEVEL_UNSPECIFIED" - Default value. Confidence level is not
	// specified.
	//   "CONFIDENCE_LEVEL_LOW" - Low confidence in the verdict.
	//   "CONFIDENCE_LEVEL_MEDIUM" - Medium confidence in the verdict.
	//   "CONFIDENCE_LEVEL_HIGH" - High confidence in the verdict.
	Confidence string `json:"confidence,omitempty"`
	// Evidence: Evidence supporting the verdict, including matched and unmatched
	// items.
	Evidence *Evidence `json:"evidence,omitempty"`
	// Reasoning: Human-readable explanation from the matcher, detailing why a
	// particular result is considered relevant or not relevant.
	Reasoning string `json:"reasoning,omitempty"`
	// RelevanceLevel: The level of relevance.
	//
	// Possible values:
	//   "RELEVANCE_LEVEL_UNSPECIFIED" - Default value, should never be set.
	//   "RELEVANCE_LEVEL_LOW" - Low Relevance.
	//   "RELEVANCE_LEVEL_MEDIUM" - Medium Relevance.
	//   "RELEVANCE_LEVEL_HIGH" - High Relevance.
	RelevanceLevel string `json:"relevanceLevel,omitempty"`
	// Relevant: Indicates whether the threat is considered relevant.
	Relevant bool `json:"relevant,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RelevanceAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod RelevanceAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportAlertUriRequest: Request message for ReportAlertUri.
type ReportAlertUriRequest struct {
}

// ReportAlertUriResponse: Response message for ReportAlertUri.
type ReportAlertUriResponse struct {
	// State: Output only. Status of the alert in WebRisk.
	//
	// Possible values:
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_UNSPECIFIED" - Unspecified status.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_NOT_SUBMITTED" - Issue has not been
	// submitted to WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_SUBMITTED" - Issue has been submitted to
	// WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_PROCESSING" - Issue has been submitted
	// to WebRisk and is being processed.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_ADDED" - Issue has been processed by
	// WebRisk and the domain was added to the blocklist.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_REJECTED" - Issue has been processed by
	// WebRisk and was rejected.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportAlertUriResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReportAlertUriResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchFindingsResponse: Response message for SearchFindings.
type SearchFindingsResponse struct {
	// Findings: List of findings.
	Findings []*Finding `json:"findings,omitempty"`
	// NextPageToken: Page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Findings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Findings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchFindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchFindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeverityAnalysis: Structured severity analysis for a threat.
type SeverityAnalysis struct {
	// Confidence: The level of confidence in the given verdict.
	//
	// Possible values:
	//   "CONFIDENCE_LEVEL_UNSPECIFIED" - Default value. Confidence level is not
	// specified.
	//   "CONFIDENCE_LEVEL_LOW" - Low confidence in the verdict.
	//   "CONFIDENCE_LEVEL_MEDIUM" - Medium confidence in the verdict.
	//   "CONFIDENCE_LEVEL_HIGH" - High confidence in the verdict.
	Confidence string `json:"confidence,omitempty"`
	// Reasoning: Human-readable explanation from the model, detailing why a
	// particular result is considered to have a certain severity.
	Reasoning string `json:"reasoning,omitempty"`
	// SeverityLevel: The level of severity.
	//
	// Possible values:
	//   "SEVERITY_LEVEL_UNSPECIFIED" - Default value, should never be set.
	//   "SEVERITY_LEVEL_LOW" - Low Severity.
	//   "SEVERITY_LEVEL_MEDIUM" - Medium Severity.
	//   "SEVERITY_LEVEL_HIGH" - High Severity.
	SeverityLevel string `json:"severityLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SeverityAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod SeverityAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspiciousDomainAlertDetail: The alert detail for a suspicious domain
// finding.
type SuspiciousDomainAlertDetail struct {
	// Dns: The DNS details of the suspicious domain.
	Dns *SuspiciousDomainDnsDetails `json:"dns,omitempty"`
	// Domain: Required. The suspicious domain name.
	Domain string `json:"domain,omitempty"`
	// GtiDetails: The GTI details of the suspicious domain.
	GtiDetails *SuspiciousDomainGtiDetails `json:"gtiDetails,omitempty"`
	// WebRiskOperation: Output only. Name of Web Risk submission operation.
	WebRiskOperation string `json:"webRiskOperation,omitempty"`
	// WebRiskState: Output only. Status of the Web Risk submission.
	//
	// Possible values:
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_UNSPECIFIED" - Unspecified status.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_NOT_SUBMITTED" - Issue has not been
	// submitted to WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_SUBMITTED" - Issue has been submitted to
	// WebRisk.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_PROCESSING" - Issue has been submitted
	// to WebRisk and is being processed.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_ADDED" - Issue has been processed by
	// WebRisk and the domain was added to the blocklist.
	//   "SUSPICIOUS_DOMAIN_WEB_RISK_STATE_REJECTED" - Issue has been processed by
	// WebRisk and was rejected.
	WebRiskState string `json:"webRiskState,omitempty"`
	// Whois: The whois details of the suspicious domain.
	Whois *SuspiciousDomainWhoIsDetails `json:"whois,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dns") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainAlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainAlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspiciousDomainDnsDetails: The DNS details of the suspicious domain.
type SuspiciousDomainDnsDetails struct {
	// DnsRecords: The DNS records of the suspicious domain.
	DnsRecords []*SuspiciousDomainDnsRecord `json:"dnsRecords,omitempty"`
	// RetrievalTime: The time the DNS details were retrieved.
	RetrievalTime string `json:"retrievalTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsRecords") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsRecords") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainDnsDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainDnsDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspiciousDomainDnsRecord: The DNS record of the suspicious domain.
type SuspiciousDomainDnsRecord struct {
	// Record: The name of the DNS record.
	Record string `json:"record,omitempty"`
	// Ttl: The TTL of the DNS record.
	Ttl int64 `json:"ttl,omitempty"`
	// Type: The type of the DNS record.
	Type string `json:"type,omitempty"`
	// Value: The value of the DNS record.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Record") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Record") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainDnsRecord) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainDnsRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspiciousDomainFindingDetail: A detailed object for a suspicious Domain
// finding.
type SuspiciousDomainFindingDetail struct {
	// Dns: The DNS details of the suspicious domain.
	Dns *SuspiciousDomainDnsDetails `json:"dns,omitempty"`
	// Domain: Required. The suspicious domain name.
	Domain string `json:"domain,omitempty"`
	// GtiDetails: The GTI details of the suspicious domain.
	GtiDetails *SuspiciousDomainGtiDetails `json:"gtiDetails,omitempty"`
	// MatchScore: Required. Reference to the match score of the finding. This is a
	// float value between 0 and 1 calculated by the matching engine.
	MatchScore float64 `json:"matchScore,omitempty"`
	// Severity: Required. The severity of the finding. This indicates the
	// potential impact of the threat.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value, should never be set.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	Severity string `json:"severity,omitempty"`
	// Whois: The whois details of the suspicious domain.
	Whois *SuspiciousDomainWhoIsDetails `json:"whois,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dns") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SuspiciousDomainFindingDetail) UnmarshalJSON(data []byte) error {
	type NoMethod SuspiciousDomainFindingDetail
	var s1 struct {
		MatchScore gensupport.JSONFloat64 `json:"matchScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchScore = float64(s1.MatchScore)
	return nil
}

// SuspiciousDomainGtiDetails: The GTI details of the suspicious domain.
type SuspiciousDomainGtiDetails struct {
	// ThreatScore: The threat score of the suspicious domain. The threat score is
	// a number between 0 and 100.
	ThreatScore int64 `json:"threatScore,omitempty"`
	// Verdict: Output only. The verdict of the suspicious domain.
	//
	// Possible values:
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_UNSPECIFIED" - Unspecified verdict.
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_BENIGN" - Verdict is clean; the entity is
	// considered harmless.
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_UNDETECTED" - Verdict is undetected; no
	// immediate evidence of malicious intent.
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_SUSPICIOUS" - Verdict is suspicious;
	// possible malicious activity detected.
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_MALICIOUS" - Verdict is malicious; high
	// confidence that the entity poses a threat.
	//   "SUSPICIOUS_DOMAIN_GTI_VERDICT_UNKNOWN" - Verdict is not applicable; not
	// able to generate a verdict for this entity.
	Verdict string `json:"verdict,omitempty"`
	// VirustotalUri: VirusTotal link for the domain
	VirustotalUri string `json:"virustotalUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ThreatScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ThreatScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainGtiDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainGtiDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuspiciousDomainWhoIsDetails: The whois details of the suspicious domain.
type SuspiciousDomainWhoIsDetails struct {
	// RetrievalTime: The time the whois details were retrieved.
	RetrievalTime string `json:"retrievalTime,omitempty"`
	// Whois: The whois details of the suspicious domain.
	Whois string `json:"whois,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetrievalTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetrievalTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuspiciousDomainWhoIsDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SuspiciousDomainWhoIsDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TargetTechnologyAlertDetail: Contains details for a technology watchlist
// alert.
type TargetTechnologyAlertDetail struct {
	// VulnerabilityMatch: Optional. The vulnerability match details.
	VulnerabilityMatch *VulnerabilityMatch `json:"vulnerabilityMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VulnerabilityMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VulnerabilityMatch") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TargetTechnologyAlertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod TargetTechnologyAlertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TargetTechnologyFindingDetail: Contains details for a technology watchlist
// finding.
type TargetTechnologyFindingDetail struct {
	// VulnerabilityMatch: Optional. The vulnerability match details.
	VulnerabilityMatch *VulnerabilityMatch `json:"vulnerabilityMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VulnerabilityMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VulnerabilityMatch") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TargetTechnologyFindingDetail) MarshalJSON() ([]byte, error) {
	type NoMethod TargetTechnologyFindingDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TechnologyWatchListAlertThreshold: TechnologyWatchListAlertThreshold
// contains the thresholds for alerting.
type TechnologyWatchListAlertThreshold struct {
	// CvssScoreMinimum: Optional. The minimum cvss V3 score for the alert. Ex:
	// 7.0. Valid range is [0.0, 10.0].
	CvssScoreMinimum float64 `json:"cvssScoreMinimum,omitempty"`
	// EpssScoreMinimum: Optional. The minimum epss score for the alert. Ex: 0.8.
	// Valid range is [0.0, 1.0].
	EpssScoreMinimum float64 `json:"epssScoreMinimum,omitempty"`
	// ExploitationStates: Optional. The exploitation states of the alert.
	//
	// Possible values:
	//   "EXPLOITATION_STATE_UNSPECIFIED" - Unspecified exploitation state.
	//   "EXPLOITATION_STATE_NO_KNOWN" - No known exploitation.
	//   "EXPLOITATION_STATE_REPORTED" - Exploitation has been reported.
	//   "EXPLOITATION_STATE_SUSPECTED" - Exploitation is suspected.
	//   "EXPLOITATION_STATE_CONFIRMED" - Exploitation is confirmed.
	//   "EXPLOITATION_STATE_WIDESPREAD" - Widespread exploitation.
	ExploitationStates []string `json:"exploitationStates,omitempty"`
	// PriorityMinimum: Optional. The minimum priority for the alert.
	//
	// Possible values:
	//   "PRIORITY_UNSPECIFIED" - Unspecified priority.
	//   "P0" - Priority level 0.
	//   "P1" - Priority level 1.
	//   "P2" - Priority level 2.
	//   "P3" - Priority level 3.
	//   "P4" - Priority level 4.
	PriorityMinimum string `json:"priorityMinimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CvssScoreMinimum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CvssScoreMinimum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TechnologyWatchListAlertThreshold) MarshalJSON() ([]byte, error) {
	type NoMethod TechnologyWatchListAlertThreshold
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TechnologyWatchListAlertThreshold) UnmarshalJSON(data []byte) error {
	type NoMethod TechnologyWatchListAlertThreshold
	var s1 struct {
		CvssScoreMinimum gensupport.JSONFloat64 `json:"cvssScoreMinimum"`
		EpssScoreMinimum gensupport.JSONFloat64 `json:"epssScoreMinimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CvssScoreMinimum = float64(s1.CvssScoreMinimum)
	s.EpssScoreMinimum = float64(s1.EpssScoreMinimum)
	return nil
}

// TechnologyWatchListConfig: TechnologyWatchListConfig is the configuration
// for the technology watchlist.
type TechnologyWatchListConfig struct {
	// AlertThreshold: Optional. Alert thresholds to effectively reduce noise.
	AlertThreshold *TechnologyWatchListAlertThreshold `json:"alertThreshold,omitempty"`
	// Technologies: Optional. List of vendor, technology or cpe fingerprint.
	// example: Microsoft office 360 Apache Server 3.5
	// cpe:2.3:a:microsoft:outlook:*:*:*:*:*:*:*:*
	Technologies []string `json:"technologies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TechnologyWatchListConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TechnologyWatchListConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpsertConfigurationResponse: Response message for UpsertConfiguration.
type UpsertConfigurationResponse struct {
	// Configuration: Output only. Created configuration ID with server assigned
	// id.
	Configuration string `json:"configuration,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpsertConfigurationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod UpsertConfigurationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityMatch: Contains details about a vulnerability match.
type VulnerabilityMatch struct {
	// Associations: Optional. Associated threat actors, malware, etc. This is
	// embedded as a snapshot because the details of the association at the time of
	// the vulnerability match are important for context and reporting.
	Associations []*Association `json:"associations,omitempty"`
	// CollectionId: Required. The collection ID of the vulnerability. Ex:
	// "vulnerability--cve-2025-9876".
	CollectionId string `json:"collectionId,omitempty"`
	// CveId: Required. The CVE ID of the vulnerability. Ex: "CVE-2025-9876". See
	// https://www.cve.org/ for more information.
	CveId string `json:"cveId,omitempty"`
	// Cvss3Score: Required. The CVSS v3 score of the vulnerability. Example: 6.4.
	Cvss3Score float64 `json:"cvss3Score,omitempty"`
	// Description: Required. A description of the vulnerability.
	Description string `json:"description,omitempty"`
	// ExploitationState: Required. The exploitation state of the vulnerability.
	//
	// Possible values:
	//   "EXPLOITATION_STATE_UNSPECIFIED" - Unspecified exploitation state.
	//   "EXPLOITATION_STATE_NO_KNOWN" - No known exploitation.
	//   "EXPLOITATION_STATE_REPORTED" - Exploitation has been reported.
	//   "EXPLOITATION_STATE_SUSPECTED" - Exploitation is suspected.
	//   "EXPLOITATION_STATE_CONFIRMED" - Exploitation is confirmed.
	//   "EXPLOITATION_STATE_WIDESPREAD" - Widespread exploitation.
	ExploitationState string `json:"exploitationState,omitempty"`
	// RiskRating: Required. The risk rating of the vulnerability.
	//
	// Possible values:
	//   "RISK_RATING_UNSPECIFIED" - Unspecified risk rating. This is the default
	// value when the risk rating is not set.
	//   "LOW" - Low risk rating.
	//   "MEDIUM" - Medium risk rating.
	//   "HIGH" - High risk rating.
	//   "CRITICAL" - Critical risk rating.
	//   "UNRATED" - The vulnerability has been assessed, but a specific risk
	// rating could not be determined or assigned.
	RiskRating string `json:"riskRating,omitempty"`
	// Technologies: Required. The affected technologies. Ex: "Apache Struts".
	Technologies []string `json:"technologies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Associations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityMatch) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *VulnerabilityMatch) UnmarshalJSON(data []byte) error {
	type NoMethod VulnerabilityMatch
	var s1 struct {
		Cvss3Score gensupport.JSONFloat64 `json:"cvss3Score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cvss3Score = float64(s1.Cvss3Score)
	return nil
}

type ProjectsAlertsBenignCall struct {
	s                        *Service
	name                     string
	markalertasbenignrequest *MarkAlertAsBenignRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Benign: Marks an alert as benign - BENIGN.
//
//   - name: Name of the alert to mark as a benign. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Benign(name string, markalertasbenignrequest *MarkAlertAsBenignRequest) *ProjectsAlertsBenignCall {
	c := &ProjectsAlertsBenignCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasbenignrequest = markalertasbenignrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsBenignCall) Fields(s ...googleapi.Field) *ProjectsAlertsBenignCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsBenignCall) Context(ctx context.Context) *ProjectsAlertsBenignCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsBenignCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsBenignCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasbenignrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:benign")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.benign", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.benign" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsBenignCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.benign", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsDuplicateCall struct {
	s                           *Service
	name                        string
	markalertasduplicaterequest *MarkAlertAsDuplicateRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Duplicate: Marks an alert as a duplicate of another alert. - DUPLICATE.
//
//   - name: Name of the alert to mark as a duplicate. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Duplicate(name string, markalertasduplicaterequest *MarkAlertAsDuplicateRequest) *ProjectsAlertsDuplicateCall {
	c := &ProjectsAlertsDuplicateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasduplicaterequest = markalertasduplicaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsDuplicateCall) Fields(s ...googleapi.Field) *ProjectsAlertsDuplicateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsDuplicateCall) Context(ctx context.Context) *ProjectsAlertsDuplicateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsDuplicateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsDuplicateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasduplicaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:duplicate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.duplicate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.duplicate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsDuplicateCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.duplicate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsEnumerateFacetsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// EnumerateFacets: EnumerateAlertFacets returns the facets and the number of
// alerts that meet the filter criteria and have that value for each facet.
//
// - parent: Parent of the alerts.
func (r *ProjectsAlertsService) EnumerateFacets(parent string) *ProjectsAlertsEnumerateFacetsCall {
	c := &ProjectsAlertsEnumerateFacetsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter on what alerts will be
// enumerated.
func (c *ProjectsAlertsEnumerateFacetsCall) Filter(filter string) *ProjectsAlertsEnumerateFacetsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsEnumerateFacetsCall) Fields(s ...googleapi.Field) *ProjectsAlertsEnumerateFacetsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAlertsEnumerateFacetsCall) IfNoneMatch(entityTag string) *ProjectsAlertsEnumerateFacetsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsEnumerateFacetsCall) Context(ctx context.Context) *ProjectsAlertsEnumerateFacetsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsEnumerateFacetsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsEnumerateFacetsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/alerts:enumerateFacets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.enumerateFacets", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.enumerateFacets" call.
// Any non-2xx status code is an error. Response headers are in either
// *EnumerateAlertFacetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAlertsEnumerateFacetsCall) Do(opts ...googleapi.CallOption) (*EnumerateAlertFacetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EnumerateAlertFacetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.enumerateFacets", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsEscalateCall struct {
	s                           *Service
	name                        string
	markalertasescalatedrequest *MarkAlertAsEscalatedRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Escalate: Marks an alert as escalated - ESCALATED.
//
//   - name: Name of the alert to mark as escalated. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Escalate(name string, markalertasescalatedrequest *MarkAlertAsEscalatedRequest) *ProjectsAlertsEscalateCall {
	c := &ProjectsAlertsEscalateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasescalatedrequest = markalertasescalatedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsEscalateCall) Fields(s ...googleapi.Field) *ProjectsAlertsEscalateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsEscalateCall) Context(ctx context.Context) *ProjectsAlertsEscalateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsEscalateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsEscalateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasescalatedrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:escalate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.escalate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.escalate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsEscalateCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.escalate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsFalsePositiveCall struct {
	s                               *Service
	name                            string
	markalertasfalsepositiverequest *MarkAlertAsFalsePositiveRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// FalsePositive: Marks an alert as a false positive - FALSE_POSITIVE.
//
//   - name: Name of the alert to mark as a false positive. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) FalsePositive(name string, markalertasfalsepositiverequest *MarkAlertAsFalsePositiveRequest) *ProjectsAlertsFalsePositiveCall {
	c := &ProjectsAlertsFalsePositiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasfalsepositiverequest = markalertasfalsepositiverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsFalsePositiveCall) Fields(s ...googleapi.Field) *ProjectsAlertsFalsePositiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsFalsePositiveCall) Context(ctx context.Context) *ProjectsAlertsFalsePositiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsFalsePositiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsFalsePositiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasfalsepositiverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:falsePositive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.falsePositive", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.falsePositive" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsFalsePositiveCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.falsePositive", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an alert by name.
//
// - name: Name of the alert to get. Format: projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Get(name string) *ProjectsAlertsGetCall {
	c := &ProjectsAlertsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsGetCall) Fields(s ...googleapi.Field) *ProjectsAlertsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAlertsGetCall) IfNoneMatch(entityTag string) *ProjectsAlertsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsGetCall) Context(ctx context.Context) *ProjectsAlertsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsGetCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a list of alerts that meet the filter criteria.
//
// - parent: Parent of the alerts. Format: projects/{project}.
func (r *ProjectsAlertsService) List(parent string) *ProjectsAlertsListCall {
	c := &ProjectsAlertsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter criteria.
func (c *ProjectsAlertsListCall) Filter(filter string) *ProjectsAlertsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by criteria in the csv
// format: "field1,field2 desc" or "field1,field2" or "field1 asc, field2".
func (c *ProjectsAlertsListCall) OrderBy(orderBy string) *ProjectsAlertsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *ProjectsAlertsListCall) PageSize(pageSize int64) *ProjectsAlertsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ProjectsAlertsListCall) PageToken(pageToken string) *ProjectsAlertsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsListCall) Fields(s ...googleapi.Field) *ProjectsAlertsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAlertsListCall) IfNoneMatch(entityTag string) *ProjectsAlertsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsListCall) Context(ctx context.Context) *ProjectsAlertsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/alerts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAlertsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAlertsListCall) Do(opts ...googleapi.CallOption) (*ListAlertsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAlertsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAlertsListCall) Pages(ctx context.Context, f func(*ListAlertsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAlertsNotActionableCall struct {
	s                               *Service
	name                            string
	markalertasnotactionablerequest *MarkAlertAsNotActionableRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// NotActionable: Marks an alert as not actionable - NOT_ACTIONABLE.
//
//   - name: Name of the alert to mark as a not actionable. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) NotActionable(name string, markalertasnotactionablerequest *MarkAlertAsNotActionableRequest) *ProjectsAlertsNotActionableCall {
	c := &ProjectsAlertsNotActionableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasnotactionablerequest = markalertasnotactionablerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsNotActionableCall) Fields(s ...googleapi.Field) *ProjectsAlertsNotActionableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsNotActionableCall) Context(ctx context.Context) *ProjectsAlertsNotActionableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsNotActionableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsNotActionableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasnotactionablerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:notActionable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.notActionable", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.notActionable" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsNotActionableCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.notActionable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsReadCall struct {
	s                      *Service
	name                   string
	markalertasreadrequest *MarkAlertAsReadRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Read: Marks an alert as read - READ.
//
//   - name: Name of the alert to mark as read. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Read(name string, markalertasreadrequest *MarkAlertAsReadRequest) *ProjectsAlertsReadCall {
	c := &ProjectsAlertsReadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasreadrequest = markalertasreadrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsReadCall) Fields(s ...googleapi.Field) *ProjectsAlertsReadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsReadCall) Context(ctx context.Context) *ProjectsAlertsReadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsReadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsReadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasreadrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:read")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.read", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.read" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsReadCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.read", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsRefreshUriStatusCall struct {
	s                            *Service
	name                         string
	refreshalerturistatusrequest *RefreshAlertUriStatusRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// RefreshUriStatus: Return the status of a URI submitted to Google WebRisk.
//
// - name: Name of alert to refresh status from WebRisk.
func (r *ProjectsAlertsService) RefreshUriStatus(name string, refreshalerturistatusrequest *RefreshAlertUriStatusRequest) *ProjectsAlertsRefreshUriStatusCall {
	c := &ProjectsAlertsRefreshUriStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.refreshalerturistatusrequest = refreshalerturistatusrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsRefreshUriStatusCall) Fields(s ...googleapi.Field) *ProjectsAlertsRefreshUriStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsRefreshUriStatusCall) Context(ctx context.Context) *ProjectsAlertsRefreshUriStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsRefreshUriStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsRefreshUriStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.refreshalerturistatusrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:refreshUriStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.refreshUriStatus", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.refreshUriStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *RefreshAlertUriStatusResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAlertsRefreshUriStatusCall) Do(opts ...googleapi.CallOption) (*RefreshAlertUriStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RefreshAlertUriStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.refreshUriStatus", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsReportAlertUriCall struct {
	s                     *Service
	name                  string
	reportalerturirequest *ReportAlertUriRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// ReportAlertUri: Report the URI associated with an alert to Google WebRisk.
//
// - name: Name of alert to submit to WebRisk.
func (r *ProjectsAlertsService) ReportAlertUri(name string, reportalerturirequest *ReportAlertUriRequest) *ProjectsAlertsReportAlertUriCall {
	c := &ProjectsAlertsReportAlertUriCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reportalerturirequest = reportalerturirequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsReportAlertUriCall) Fields(s ...googleapi.Field) *ProjectsAlertsReportAlertUriCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsReportAlertUriCall) Context(ctx context.Context) *ProjectsAlertsReportAlertUriCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsReportAlertUriCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsReportAlertUriCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reportalerturirequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:reportAlertUri")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.reportAlertUri", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.reportAlertUri" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReportAlertUriResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAlertsReportAlertUriCall) Do(opts ...googleapi.CallOption) (*ReportAlertUriResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReportAlertUriResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.reportAlertUri", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsResolveCall struct {
	s                          *Service
	name                       string
	markalertasresolvedrequest *MarkAlertAsResolvedRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Resolve: Marks an alert to closed state - RESOLVED.
//
//   - name: Name of the alert to mark as resolved. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Resolve(name string, markalertasresolvedrequest *MarkAlertAsResolvedRequest) *ProjectsAlertsResolveCall {
	c := &ProjectsAlertsResolveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertasresolvedrequest = markalertasresolvedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsResolveCall) Fields(s ...googleapi.Field) *ProjectsAlertsResolveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsResolveCall) Context(ctx context.Context) *ProjectsAlertsResolveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsResolveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsResolveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertasresolvedrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:resolve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.resolve", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.resolve" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsResolveCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.resolve", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsTrackExternallyCall struct {
	s                                   *Service
	name                                string
	markalertastrackedexternallyrequest *MarkAlertAsTrackedExternallyRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// TrackExternally: Marks an alert as tracked externally - TRACKED_EXTERNALLY.
//
//   - name: Name of the alert to mark as tracked externally. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) TrackExternally(name string, markalertastrackedexternallyrequest *MarkAlertAsTrackedExternallyRequest) *ProjectsAlertsTrackExternallyCall {
	c := &ProjectsAlertsTrackExternallyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertastrackedexternallyrequest = markalertastrackedexternallyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsTrackExternallyCall) Fields(s ...googleapi.Field) *ProjectsAlertsTrackExternallyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsTrackExternallyCall) Context(ctx context.Context) *ProjectsAlertsTrackExternallyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsTrackExternallyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsTrackExternallyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertastrackedexternallyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:trackExternally")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.trackExternally", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.trackExternally" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsTrackExternallyCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.trackExternally", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsTriageCall struct {
	s                         *Service
	name                      string
	markalertastriagedrequest *MarkAlertAsTriagedRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Triage: Marks an alert as triaged - TRIAGED.
//
//   - name: Name of the alert to mark as a triaged. Format:
//     projects/{project}/alerts/{alert}.
func (r *ProjectsAlertsService) Triage(name string, markalertastriagedrequest *MarkAlertAsTriagedRequest) *ProjectsAlertsTriageCall {
	c := &ProjectsAlertsTriageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.markalertastriagedrequest = markalertastriagedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsTriageCall) Fields(s ...googleapi.Field) *ProjectsAlertsTriageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsTriageCall) Context(ctx context.Context) *ProjectsAlertsTriageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsTriageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsTriageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.markalertastriagedrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:triage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.triage", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.triage" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsTriageCall) Do(opts ...googleapi.CallOption) (*Alert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.triage", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAlertsDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific document associated with an alert.
//
//   - name: Name of the alert document to get. Format:
//     projects/{project}/alerts/{alert}/documents/{document}.
func (r *ProjectsAlertsDocumentsService) Get(name string) *ProjectsAlertsDocumentsGetCall {
	c := &ProjectsAlertsDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAlertsDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsAlertsDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAlertsDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsAlertsDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAlertsDocumentsGetCall) Context(ctx context.Context) *ProjectsAlertsDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAlertsDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAlertsDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.documents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.alerts.documents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AlertDocument.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAlertsDocumentsGetCall) Do(opts ...googleapi.CallOption) (*AlertDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AlertDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.alerts.documents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsConfigurationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a configuration by name.
//
//   - name: Name of the configuration to get. Format:
//     vaults/{vault}/configurations/{configuration}.
func (r *ProjectsConfigurationsService) Get(name string) *ProjectsConfigurationsGetCall {
	c := &ProjectsConfigurationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsConfigurationsGetCall) Fields(s ...googleapi.Field) *ProjectsConfigurationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsConfigurationsGetCall) IfNoneMatch(entityTag string) *ProjectsConfigurationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsConfigurationsGetCall) Context(ctx context.Context) *ProjectsConfigurationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsConfigurationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsConfigurationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.configurations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Configuration.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsConfigurationsGetCall) Do(opts ...googleapi.CallOption) (*Configuration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Configuration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsConfigurationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a list of configurations that meet the filter criteria.
//
// - parent: Parent of the configuration. Format: vaults/{vault}.
func (r *ProjectsConfigurationsService) List(parent string) *ProjectsConfigurationsListCall {
	c := &ProjectsConfigurationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter criteria.
func (c *ProjectsConfigurationsListCall) Filter(filter string) *ProjectsConfigurationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by criteria in the csv
// format: "field1,field2 desc" or "field1,field2" or "field1 asc, field2".
func (c *ProjectsConfigurationsListCall) OrderBy(orderBy string) *ProjectsConfigurationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *ProjectsConfigurationsListCall) PageSize(pageSize int64) *ProjectsConfigurationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ProjectsConfigurationsListCall) PageToken(pageToken string) *ProjectsConfigurationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsConfigurationsListCall) Fields(s ...googleapi.Field) *ProjectsConfigurationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsConfigurationsListCall) IfNoneMatch(entityTag string) *ProjectsConfigurationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsConfigurationsListCall) Context(ctx context.Context) *ProjectsConfigurationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsConfigurationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsConfigurationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/configurations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.configurations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConfigurationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsConfigurationsListCall) Do(opts ...googleapi.CallOption) (*ListConfigurationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConfigurationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsConfigurationsListCall) Pages(ctx context.Context, f func(*ListConfigurationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsConfigurationsUpsertCall struct {
	s             *Service
	parent        string
	configuration *Configuration
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Upsert: Creates or updates a configuration.
//
// - parent: Parent of the configuration.
func (r *ProjectsConfigurationsService) Upsert(parent string, configuration *Configuration) *ProjectsConfigurationsUpsertCall {
	c := &ProjectsConfigurationsUpsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.configuration = configuration
	return c
}

// PublishTime sets the optional parameter "publishTime": Time that the
// configuration should be considered to have been published. This is an
// advanced feature used when onboarding and bulk loading data from other
// systems. Do not set this field without consulting with the API team.
func (c *ProjectsConfigurationsUpsertCall) PublishTime(publishTime string) *ProjectsConfigurationsUpsertCall {
	c.urlParams_.Set("publishTime", publishTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsConfigurationsUpsertCall) Fields(s ...googleapi.Field) *ProjectsConfigurationsUpsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsConfigurationsUpsertCall) Context(ctx context.Context) *ProjectsConfigurationsUpsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsConfigurationsUpsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsConfigurationsUpsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.configuration)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/configurations:upsert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.upsert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.configurations.upsert" call.
// Any non-2xx status code is an error. Response headers are in either
// *UpsertConfigurationResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsConfigurationsUpsertCall) Do(opts ...googleapi.CallOption) (*UpsertConfigurationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UpsertConfigurationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.upsert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsConfigurationsRevisionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List configuration revisions that meet the filter criteria.
//
// - parent: The name of the Configuration to retrieve Revisions for.
func (r *ProjectsConfigurationsRevisionsService) List(parent string) *ProjectsConfigurationsRevisionsListCall {
	c := &ProjectsConfigurationsRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An AIP-160 filter string
func (c *ProjectsConfigurationsRevisionsListCall) Filter(filter string) *ProjectsConfigurationsRevisionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Specify ordering of response
func (c *ProjectsConfigurationsRevisionsListCall) OrderBy(orderBy string) *ProjectsConfigurationsRevisionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Page Size
func (c *ProjectsConfigurationsRevisionsListCall) PageSize(pageSize int64) *ProjectsConfigurationsRevisionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token provided by
// the API
func (c *ProjectsConfigurationsRevisionsListCall) PageToken(pageToken string) *ProjectsConfigurationsRevisionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsConfigurationsRevisionsListCall) Fields(s ...googleapi.Field) *ProjectsConfigurationsRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsConfigurationsRevisionsListCall) IfNoneMatch(entityTag string) *ProjectsConfigurationsRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsConfigurationsRevisionsListCall) Context(ctx context.Context) *ProjectsConfigurationsRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsConfigurationsRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsConfigurationsRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.revisions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.configurations.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConfigurationRevisionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsConfigurationsRevisionsListCall) Do(opts ...googleapi.CallOption) (*ListConfigurationRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConfigurationRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.configurations.revisions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsConfigurationsRevisionsListCall) Pages(ctx context.Context, f func(*ListConfigurationRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsFindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a finding by name.
//
// - name: Name of the finding to get.
func (r *ProjectsFindingsService) Get(name string) *ProjectsFindingsGetCall {
	c := &ProjectsFindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsFindingsGetCall) Fields(s ...googleapi.Field) *ProjectsFindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsFindingsGetCall) IfNoneMatch(entityTag string) *ProjectsFindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsFindingsGetCall) Context(ctx context.Context) *ProjectsFindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsFindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsFindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.findings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Finding.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsFindingsGetCall) Do(opts ...googleapi.CallOption) (*Finding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Finding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsFindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a list of findings that meet the filter criteria.
//
// - parent: Parent of the findings.
func (r *ProjectsFindingsService) List(parent string) *ProjectsFindingsListCall {
	c := &ProjectsFindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter criteria.
func (c *ProjectsFindingsListCall) Filter(filter string) *ProjectsFindingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by criteria in the csv
// format: "field1,field2 desc" or "field1,field2" or "field1 asc, field2".
func (c *ProjectsFindingsListCall) OrderBy(orderBy string) *ProjectsFindingsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *ProjectsFindingsListCall) PageSize(pageSize int64) *ProjectsFindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ProjectsFindingsListCall) PageToken(pageToken string) *ProjectsFindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsFindingsListCall) Fields(s ...googleapi.Field) *ProjectsFindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsFindingsListCall) IfNoneMatch(entityTag string) *ProjectsFindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsFindingsListCall) Context(ctx context.Context) *ProjectsFindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsFindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsFindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/findings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.findings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFindingsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsFindingsListCall) Do(opts ...googleapi.CallOption) (*ListFindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsFindingsListCall) Pages(ctx context.Context, f func(*ListFindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsFindingsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: SearchFindings is a more powerful version of ListFindings that
// supports complex queries like "findings for issues" using functions such as
// `has_issue` and `has_asset` in the query string. Example to search for
// findings for a specific issue:
// `has_issue("name=\"vaults/vault-12345/issues/issue-12345\"")`)
//
// - parent: Parent of the findings. Format: vaults/{vault}.
func (r *ProjectsFindingsService) Search(parent string) *ProjectsFindingsSearchCall {
	c := &ProjectsFindingsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by criteria in the csv
// format: "field1,field2 desc" or "field1,field2" or "field1 asc, field2".
func (c *ProjectsFindingsSearchCall) OrderBy(orderBy string) *ProjectsFindingsSearchCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *ProjectsFindingsSearchCall) PageSize(pageSize int64) *ProjectsFindingsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ProjectsFindingsSearchCall) PageToken(pageToken string) *ProjectsFindingsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Query on what findings will be
// returned. This supports the same filter criteria as
// FindingService.ListFindings as well as the following relationship queries
// `has_issue` and `has_asset`. Examples: -
// has_issue("name=\"vaults/vault-12345/issues/issue-12345\"") -
// has_asset("name=\"vaults/vault-12345/assets/asset-12345\"")
func (c *ProjectsFindingsSearchCall) Query(query string) *ProjectsFindingsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsFindingsSearchCall) Fields(s ...googleapi.Field) *ProjectsFindingsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsFindingsSearchCall) IfNoneMatch(entityTag string) *ProjectsFindingsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsFindingsSearchCall) Context(ctx context.Context) *ProjectsFindingsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsFindingsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsFindingsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/findings:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "threatintelligence.projects.findings.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchFindingsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsFindingsSearchCall) Do(opts ...googleapi.CallOption) (*SearchFindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchFindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "threatintelligence.projects.findings.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsFindingsSearchCall) Pages(ctx context.Context, f func(*SearchFindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
