// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package hypercomputecluster provides access to the Cluster Director API.
//
// For product documentation, see: https://docs.cloud.google.com/cluster-director/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/hypercomputecluster/v1"
//	...
//	ctx := context.Background()
//	hypercomputeclusterService, err := hypercomputecluster.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	hypercomputeclusterService, err := hypercomputecluster.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	hypercomputeclusterService, err := hypercomputecluster.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package hypercomputecluster // import "google.golang.org/api/hypercomputecluster/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "hypercomputecluster:v1"
const apiName = "hypercomputecluster"
const apiVersion = "v1"
const basePath = "https://hypercomputecluster.googleapis.com/"
const basePathTemplate = "https://hypercomputecluster.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://hypercomputecluster.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Clusters = NewProjectsLocationsClustersService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Clusters *ProjectsLocationsClustersService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsClustersService(s *Service) *ProjectsLocationsClustersService {
	rs := &ProjectsLocationsClustersService{s: s}
	return rs
}

type ProjectsLocationsClustersService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// BootDisk: A Persistent disk (https://cloud.google.com/compute/docs/disks)
// used as the boot disk for a Compute Engine VM instance.
type BootDisk struct {
	// SizeGb: Required. Immutable. Size of the disk in gigabytes. Must be at least
	// 10GB.
	SizeGb int64 `json:"sizeGb,omitempty,string"`
	// Type: Required. Immutable. Persistent disk type
	// (https://cloud.google.com/compute/docs/disks#disk-types), in the format
	// `projects/{project}/zones/{zone}/diskTypes/{disk_type}`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeGb") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeGb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BootDisk) MarshalJSON() ([]byte, error) {
	type NoMethod BootDisk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BucketReference: A reference to a Google Cloud Storage
// (https://cloud.google.com/storage) bucket.
type BucketReference struct {
	// Bucket: Output only. Name of the bucket.
	Bucket string `json:"bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BucketReference) MarshalJSON() ([]byte, error) {
	type NoMethod BucketReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CheckClusterHealth: When set in OperationStep, indicates that cluster health
// check should be performed.
type CheckClusterHealth struct {
}

// Cluster: A collection of virtual machines and connected resources forming a
// high-performance computing cluster capable of running large-scale, tightly
// coupled workloads. A cluster combines a set a compute resources that perform
// computations, storage resources that contain inputs and store outputs, an
// orchestrator that is responsible for assigning jobs to compute resources,
// and network resources that connect everything together.
type Cluster struct {
	// ComputeResources: Optional. Compute resources available to the cluster. Keys
	// specify the ID of the compute resource by which it can be referenced
	// elsewhere, and must conform to RFC-1034
	// (https://datatracker.ietf.org/doc/html/rfc1034) (lower-case, alphanumeric,
	// and at most 63 characters).
	ComputeResources map[string]ComputeResource `json:"computeResources,omitempty"`
	// CreateTime: Output only. Time that the cluster was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User-provided description of the cluster.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Labels
	// (https://cloud.google.com/compute/docs/labeling-resources) applied to the
	// cluster. Labels can be used to organize clusters and to filter them in
	// queries.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Relative resource name (https://google.aip.dev/122) of the
	// cluster, in the format
	// `projects/{project}/locations/{location}/clusters/{cluster}`.
	Name string `json:"name,omitempty"`
	// NetworkResources: Optional. Network resources available to the cluster. Must
	// contain at most one value. Keys specify the ID of the network resource by
	// which it can be referenced elsewhere, and must conform to RFC-1034
	// (https://datatracker.ietf.org/doc/html/rfc1034) (lower-case, alphanumeric,
	// and at most 63 characters).
	NetworkResources map[string]NetworkResource `json:"networkResources,omitempty"`
	// Orchestrator: Optional. Orchestrator that is responsible for scheduling and
	// running jobs on the cluster.
	Orchestrator *Orchestrator `json:"orchestrator,omitempty"`
	// Reconciling: Output only. Indicates whether changes to the cluster are
	// currently in flight. If this is `true`, then the current state might not
	// match the cluster's intended state.
	Reconciling bool `json:"reconciling,omitempty"`
	// StorageResources: Optional. Storage resources available to the cluster. Keys
	// specify the ID of the storage resource by which it can be referenced
	// elsewhere, and must conform to RFC-1034
	// (https://datatracker.ietf.org/doc/html/rfc1034) (lower-case, alphanumeric,
	// and at most 63 characters).
	StorageResources map[string]StorageResource `json:"storageResources,omitempty"`
	// UpdateTime: Output only. Time that the cluster was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ComputeResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeInstance: Details about a Compute Engine instance
// (https://cloud.google.com/compute/docs/instances).
type ComputeInstance struct {
	// Instance: Output only. Name of the VM instance, in the format
	// `projects/{project}/zones/{zone}/instances/{instance}`.
	Instance string `json:"instance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeInstance) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeInstanceSlurmNodeSet: When set in a SlurmNodeSet, indicates that the
// nodeset should be backed by Compute Engine VM instances.
type ComputeInstanceSlurmNodeSet struct {
	// BootDisk: Optional. Boot disk for the compute instance
	BootDisk *BootDisk `json:"bootDisk,omitempty"`
	// Labels: Optional. Labels
	// (https://cloud.google.com/compute/docs/labeling-resources) that should be
	// applied to each VM instance in the nodeset.
	Labels map[string]string `json:"labels,omitempty"`
	// StartupScript: Optional. Startup script
	// (https://cloud.google.com/compute/docs/instances/startup-scripts/linux) to
	// be run on each VM instance in the nodeset. Max 256KB.
	StartupScript string `json:"startupScript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDisk") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDisk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeInstanceSlurmNodeSet) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeInstanceSlurmNodeSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeResource: A resource defining how virtual machines and accelerators
// should be provisioned for the cluster.
type ComputeResource struct {
	// Config: Required. Immutable. Configuration for this compute resource, which
	// describes how it should be created at runtime.
	Config *ComputeResourceConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeResource) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeResourceConfig: Describes how a compute resource should be created at
// runtime.
type ComputeResourceConfig struct {
	// NewFlexStartInstances: Optional. Immutable. If set, indicates that this
	// resource should use flex-start VMs.
	NewFlexStartInstances *NewFlexStartInstancesConfig `json:"newFlexStartInstances,omitempty"`
	// NewOnDemandInstances: Optional. Immutable. If set, indicates that this
	// resource should use on-demand VMs.
	NewOnDemandInstances *NewOnDemandInstancesConfig `json:"newOnDemandInstances,omitempty"`
	// NewReservedInstances: Optional. Immutable. If set, indicates that this
	// resource should use reserved VMs.
	NewReservedInstances *NewReservedInstancesConfig `json:"newReservedInstances,omitempty"`
	// NewSpotInstances: Optional. Immutable. If set, indicates that this resource
	// should use spot VMs.
	NewSpotInstances *NewSpotInstancesConfig `json:"newSpotInstances,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewFlexStartInstances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewFlexStartInstances") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeResourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateFilestoreInstance: When set in OperationStep, indicates that a new
// filestore instance should be created.
type CreateFilestoreInstance struct {
	// Filestore: Output only. Name of the Filestore instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Filestore string `json:"filestore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filestore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filestore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateFilestoreInstance) MarshalJSON() ([]byte, error) {
	type NoMethod CreateFilestoreInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateLoginNode: When set in OperationStep, indicates that a login node
// should be created.
type CreateLoginNode struct {
}

// CreateLustreInstance: When set in OperationStep, indicates that a new lustre
// instance should be created.
type CreateLustreInstance struct {
	// Lustre: Output only. Name of the Managed Lustre instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Lustre string `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Lustre") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Lustre") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateLustreInstance) MarshalJSON() ([]byte, error) {
	type NoMethod CreateLustreInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateNetwork: When set in OperationStep, indicates that a new network
// should be created.
type CreateNetwork struct {
	// Network: Output only. Name of the network to create, in the format
	// `projects/{project}/global/networks/{network}`.
	Network string `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod CreateNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateNodeset: When set in OperationStep, indicates that a nodeset should be
// created.
type CreateNodeset struct {
	// Nodesets: Output only. Name of the nodeset to create
	Nodesets []string `json:"nodesets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Nodesets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Nodesets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateNodeset) MarshalJSON() ([]byte, error) {
	type NoMethod CreateNodeset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateOrchestrator: When set in OperationStep, indicates that an
// orchestrator should be created.
type CreateOrchestrator struct {
}

// CreatePartition: When set in OperationStep, indicates that a partition
// should be created.
type CreatePartition struct {
	// Partitions: Output only. Name of the partition to create
	Partitions []string `json:"partitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Partitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Partitions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreatePartition) MarshalJSON() ([]byte, error) {
	type NoMethod CreatePartition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreatePrivateServiceAccess: When set in OperationStep, indicates that a new
// private service access should be created.
type CreatePrivateServiceAccess struct {
}

// CreateStorageBucket: When set in OperationStep, indicates that a new storage
// bucket should be created.
type CreateStorageBucket struct {
	// Bucket: Output only. Name of the bucket.
	Bucket string `json:"bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateStorageBucket) MarshalJSON() ([]byte, error) {
	type NoMethod CreateStorageBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteFilestoreInstance: When set in OperationStep, indicates that a
// Filestore instance should be deleted.
type DeleteFilestoreInstance struct {
	// Filestore: Output only. Name of the Filestore instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Filestore string `json:"filestore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filestore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filestore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteFilestoreInstance) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteFilestoreInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteLoginNode: When set in OperationStep, indicates that a login node
// should be deleted.
type DeleteLoginNode struct {
}

// DeleteLustreInstance: When set in OperationStep, indicates that a Lustre
// instance should be deleted.
type DeleteLustreInstance struct {
	// Lustre: Output only. Name of the Managed Lustre instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Lustre string `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Lustre") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Lustre") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteLustreInstance) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteLustreInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteNetwork: When set in OperationStep, indicates network deletion step
// with the resource name.
type DeleteNetwork struct {
	// Network: Output only. Name of the network to delete, in the format
	// `projects/{project}/global/networks/{network}`.
	Network string `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteNodeset: When set in OperationStep, indicates that a nodeset should be
// deleted.
type DeleteNodeset struct {
	// Nodesets: Output only. Name of the nodeset to delete
	Nodesets []string `json:"nodesets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Nodesets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Nodesets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteNodeset) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteNodeset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteOrchestrator: When set in OperationStep, indicates that an
// orchestrator should be deleted.
type DeleteOrchestrator struct {
}

// DeletePartition: When set in OperationStep, indicates that a partition
// should be deleted.
type DeletePartition struct {
	// Partitions: Output only. Name of the partition to delete
	Partitions []string `json:"partitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Partitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Partitions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeletePartition) MarshalJSON() ([]byte, error) {
	type NoMethod DeletePartition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeletePrivateServiceAccess: When set in OperationStep, indicates private
// service access deletion step.
type DeletePrivateServiceAccess struct {
}

// DeleteStorageBucket: When set in OperationStep, indicates that Cloud Storage
// bucket should be deleted.
type DeleteStorageBucket struct {
	// Bucket: Output only. Name of the bucket.
	Bucket string `json:"bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteStorageBucket) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteStorageBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExistingBucketConfig: When set in a StorageResourceConfig, indicates that an
// existing Google Cloud Storage (https://cloud.google.com/storage) bucket
// should be imported.
type ExistingBucketConfig struct {
	// Bucket: Required. Immutable. Name of the Cloud Storage bucket to import.
	Bucket string `json:"bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExistingBucketConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExistingBucketConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExistingFilestoreConfig: When set in a StorageResourceConfig, indicates that
// an existing Filestore (https://cloud.google.com/filestore) instance should
// be imported.
type ExistingFilestoreConfig struct {
	// Filestore: Required. Immutable. Name of the Filestore instance to import, in
	// the format `projects/{project}/locations/{location}/instances/{instance}`
	Filestore string `json:"filestore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filestore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filestore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExistingFilestoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExistingFilestoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExistingLustreConfig: When set in a StorageResourceConfig, indicates that an
// existing Managed Lustre (https://cloud.google.com/products/managed-lustre)
// instance should be imported.
type ExistingLustreConfig struct {
	// Lustre: Required. Immutable. Name of the Managed Lustre instance to import,
	// in the format `projects/{project}/locations/{location}/instances/{instance}`
	Lustre string `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Lustre") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Lustre") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExistingLustreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExistingLustreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExistingNetworkConfig: When set in a NetworkResourceConfig, indicates that
// an existing network should be imported.
type ExistingNetworkConfig struct {
	// Network: Required. Immutable. Name of the network to import, in the format
	// `projects/{project}/global/networks/{network}`.
	Network string `json:"network,omitempty"`
	// Subnetwork: Required. Immutable. Particular subnetwork to use, in the format
	// `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExistingNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExistingNetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileShareConfig: Message describing filestore configuration
type FileShareConfig struct {
	// CapacityGb: Required. Size of the filestore in GB. Must be between 1024 and
	// 102400, and must meet scalability requirements described at
	// https://cloud.google.com/filestore/docs/service-tiers.
	CapacityGb int64 `json:"capacityGb,omitempty,string"`
	// FileShare: Required. Filestore share location
	FileShare string `json:"fileShare,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CapacityGb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityGb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileShareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FileShareConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FilestoreReference: A reference to a Filestore
// (https://cloud.google.com/filestore) instance.
type FilestoreReference struct {
	// Filestore: Output only. Name of the Filestore instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Filestore string `json:"filestore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filestore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filestore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FilestoreReference) MarshalJSON() ([]byte, error) {
	type NoMethod FilestoreReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsAutoclassConfig: Message describing Google Cloud Storage autoclass
// configuration
type GcsAutoclassConfig struct {
	// Enabled: Required. Enables Auto-class feature.
	Enabled bool `json:"enabled,omitempty"`
	// TerminalStorageClass: Optional. Terminal storage class of the autoclass
	// bucket
	//
	// Possible values:
	//   "TERMINAL_STORAGE_CLASS_UNSPECIFIED" - Unspecified terminal storage class
	TerminalStorageClass string `json:"terminalStorageClass,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsAutoclassConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcsAutoclassConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsHierarchicalNamespaceConfig: Message describing Google Cloud Storage
// hierarchical namespace configuration
type GcsHierarchicalNamespaceConfig struct {
	// Enabled: Required. Enables hierarchical namespace setup for the bucket.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsHierarchicalNamespaceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GcsHierarchicalNamespaceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListClustersResponse: Response message for ListClusters.
type ListClustersResponse struct {
	// Clusters: Clusters in the specified location.
	Clusters []*Cluster `json:"clusters,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is absent, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClustersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LustreReference: A reference to a Managed Lustre
// (https://cloud.google.com/products/managed-lustre) instance.
type LustreReference struct {
	// Lustre: Output only. Name of the Managed Lustre instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`
	Lustre string `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Lustre") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Lustre") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LustreReference) MarshalJSON() ([]byte, error) {
	type NoMethod LustreReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkReference: A reference to a VPC network
// (https://cloud.google.com/vpc/docs/vpc) in Google Compute Engine.
type NetworkReference struct {
	// Network: Output only. Name of the network, in the format
	// `projects/{project}/global/networks/{network}`.
	Network string `json:"network,omitempty"`
	// Subnetwork: Output only. Name of the particular subnetwork being used by the
	// cluster, in the format
	// `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
	Subnetwork string `json:"subnetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkReference) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkResource: A resource representing a network that connects the various
// components of a cluster together.
type NetworkResource struct {
	// Config: Immutable. Configuration for this network resource, which describes
	// how it should be created or imported. This field only controls how the
	// network resource is initially created or imported. Subsequent changes to the
	// network resource should be made via the resource's API and will not be
	// reflected in the configuration.
	Config *NetworkResourceConfig `json:"config,omitempty"`
	// Network: Reference to a network in Google Compute Engine.
	Network *NetworkReference `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkResource) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkResourceConfig: Describes how a network resource should be
// initialized. Each network resource can either be imported from an existing
// Google Cloud resource or initialized when the cluster is created.
type NetworkResourceConfig struct {
	// ExistingNetwork: Optional. Immutable. If set, indicates that an existing
	// network should be imported.
	ExistingNetwork *ExistingNetworkConfig `json:"existingNetwork,omitempty"`
	// NewNetwork: Optional. Immutable. If set, indicates that a new network should
	// be created.
	NewNetwork *NewNetworkConfig `json:"newNetwork,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExistingNetwork") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExistingNetwork") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkResourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewBucketConfig: When set in a StorageResourceConfig, indicates that a new
// Google Cloud Storage (https://cloud.google.com/storage) bucket should be
// created.
type NewBucketConfig struct {
	// Autoclass: Optional. Immutable. If set, indicates that the bucket should use
	// Autoclass (https://cloud.google.com/storage/docs/autoclass).
	Autoclass *GcsAutoclassConfig `json:"autoclass,omitempty"`
	// Bucket: Required. Immutable. Name of the Cloud Storage bucket to create.
	Bucket string `json:"bucket,omitempty"`
	// HierarchicalNamespace: Optional. Immutable. If set, indicates that the
	// bucket should use hierarchical namespaces
	// (https://cloud.google.com/storage/docs/hns-overview).
	HierarchicalNamespace *GcsHierarchicalNamespaceConfig `json:"hierarchicalNamespace,omitempty"`
	// StorageClass: Optional. Immutable. If set, uses the provided storage class
	// as the bucket's default storage class.
	//
	// Possible values:
	//   "STORAGE_CLASS_UNSPECIFIED" - Not set.
	//   "STANDARD" - Best for data that is frequently accessed.
	//   "NEARLINE" - Low-cost storage for data that is accessed less frequently.
	//   "COLDLINE" - Very low-cost storage for infrequently accessed data.
	//   "ARCHIVE" - Lowest-cost storage for data archiving, online backup, and
	// disaster recovery.
	StorageClass string `json:"storageClass,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Autoclass") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autoclass") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewBucketConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewBucketConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewFilestoreConfig: When set in a StorageResourceConfig, indicates that a
// new Filestore (https://cloud.google.com/filestore) instance should be
// created.
type NewFilestoreConfig struct {
	// Description: Optional. Immutable. Description of the instance. Maximum of
	// 2048 characters.
	Description string `json:"description,omitempty"`
	// FileShares: Required. Immutable. File system shares on the instance. Exactly
	// one file share must be specified.
	FileShares []*FileShareConfig `json:"fileShares,omitempty"`
	// Filestore: Required. Immutable. Name of the Filestore instance to create, in
	// the format `projects/{project}/locations/{location}/instances/{instance}`
	Filestore string `json:"filestore,omitempty"`
	// Protocol: Optional. Immutable. Access protocol to use for all file shares in
	// the instance. Defaults to NFS V3 if not set.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Not set.
	//   "NFSV3" - NFS 3.0.
	//   "NFSV41" - NFS 4.1.
	Protocol string `json:"protocol,omitempty"`
	// Tier: Required. Immutable. Service tier to use for the instance.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Not set.
	//   "ZONAL" - Offers expanded capacity and performance scaling capabilities
	// suitable for high-performance computing application requirements.
	//   "REGIONAL" - Offers features and availability needed for mission-critical,
	// high-performance computing workloads.
	Tier string `json:"tier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewFilestoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewFilestoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewFlexStartInstancesConfig: When set in a ComputeResourceConfig, indicates
// that VM instances should be created using Flex Start
// (https://cloud.google.com/compute/docs/instances/provisioning-models).
type NewFlexStartInstancesConfig struct {
	// MachineType: Required. Immutable. Name of the Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
	// `n2-standard-2`.
	MachineType string `json:"machineType,omitempty"`
	// MaxDuration: Required. Immutable. Specifies the time limit for created
	// instances. Instances will be terminated at the end of this duration.
	MaxDuration string `json:"maxDuration,omitempty"`
	// Zone: Required. Immutable. Name of the zone in which VM instances should
	// run, e.g., `us-central1-a`. Must be in the same region as the cluster, and
	// must match the zone of any other resources specified in the cluster.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewFlexStartInstancesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewFlexStartInstancesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewLustreConfig: When set in a StorageResourceConfig, indicates that a new
// Managed Lustre (https://cloud.google.com/products/managed-lustre) instance
// should be created.
type NewLustreConfig struct {
	// CapacityGb: Required. Immutable. Storage capacity of the instance in
	// gibibytes (GiB). Allowed values are between 18000 and 7632000.
	CapacityGb int64 `json:"capacityGb,omitempty,string"`
	// Description: Optional. Immutable. Description of the Managed Lustre
	// instance. Maximum of 2048 characters.
	Description string `json:"description,omitempty"`
	// Filesystem: Required. Immutable. Filesystem name for this instance. This
	// name is used by client-side tools, including when mounting the instance.
	// Must be 8 characters or less and can only contain letters and numbers.
	Filesystem string `json:"filesystem,omitempty"`
	// Lustre: Required. Immutable. Name of the Managed Lustre instance to create,
	// in the format `projects/{project}/locations/{location}/instances/{instance}`
	Lustre string `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CapacityGb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityGb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewLustreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewLustreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewNetworkConfig: When set in a NetworkResourceConfig, indicates that a new
// network should be created.
type NewNetworkConfig struct {
	// Description: Optional. Immutable. Description of the network. Maximum of
	// 2048 characters.
	Description string `json:"description,omitempty"`
	// Network: Required. Immutable. Name of the network to create, in the format
	// `projects/{project}/global/networks/{network}`.
	Network string `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewNetworkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewOnDemandInstancesConfig: When set in a ComputeResourceConfig, indicates
// that on-demand (i.e., using the standard provisioning model) VM instances
// should be created.
type NewOnDemandInstancesConfig struct {
	// MachineType: Required. Immutable. Name of the Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
	// `n2-standard-2`.
	MachineType string `json:"machineType,omitempty"`
	// Zone: Required. Immutable. Name of the zone in which VM instances should
	// run, e.g., `us-central1-a`. Must be in the same region as the cluster, and
	// must match the zone of any other resources specified in the cluster.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewOnDemandInstancesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewOnDemandInstancesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewReservedInstancesConfig: When set in a ComputeResourceConfig, indicates
// that VM instances should be created from a reservation
// (https://cloud.google.com/compute/docs/instances/reservations-overview).
type NewReservedInstancesConfig struct {
	// Reservation: Optional. Immutable. Name of the reservation from which VM
	// instances should be created, in the format
	// `projects/{project}/zones/{zone}/reservations/{reservation}`.
	Reservation string `json:"reservation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reservation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reservation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewReservedInstancesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewReservedInstancesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NewSpotInstancesConfig: When set in a ComputeResourceConfig, indicates that
// spot VM (https://cloud.google.com/compute/docs/instances/spot) instances
// should be created.
type NewSpotInstancesConfig struct {
	// MachineType: Required. Immutable. Name of the Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
	// `n2-standard-2`.
	MachineType string `json:"machineType,omitempty"`
	// TerminationAction: Optional. Specifies the termination action of the
	// instance
	//
	// Possible values:
	//   "TERMINATION_ACTION_UNSPECIFIED" - Unspecified termination action
	//   "STOP" - Stop the instance
	//   "DELETE" - Delete the instance
	TerminationAction string `json:"terminationAction,omitempty"`
	// Zone: Required. Immutable. Name of the zone in which VM instances should
	// run, e.g., `us-central1-a`. Must be in the same region as the cluster, and
	// must match the zone of any other resources specified in the cluster.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NewSpotInstancesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NewSpotInstancesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Progress: Output only. Progress of the operation.
	Progress *OperationProgress `json:"progress,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationProgress: Message describing the progress of a cluster mutation
// long-running operation. operation.
type OperationProgress struct {
	// Steps: Output only. Steps and status of the operation.
	Steps []*OperationStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Steps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Steps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationProgress) MarshalJSON() ([]byte, error) {
	type NoMethod OperationProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationStep: Message describing the status of a single step in a cluster
// mutation long-running operation.
type OperationStep struct {
	// CheckClusterHealth: Output only. If set, indicates that cluster health check
	// is part of the operation.
	CheckClusterHealth *CheckClusterHealth `json:"checkClusterHealth,omitempty"`
	// CreateFilestoreInstance: Output only. If set, indicates that new Filestore
	// instance creation is part of the operation.
	CreateFilestoreInstance *CreateFilestoreInstance `json:"createFilestoreInstance,omitempty"`
	// CreateLoginNode: Output only. If set, indicates that new login node creation
	// is part of the operation.
	CreateLoginNode *CreateLoginNode `json:"createLoginNode,omitempty"`
	// CreateLustreInstance: Output only. If set, indicates that new Lustre
	// instance creation is part of the operation.
	CreateLustreInstance *CreateLustreInstance `json:"createLustreInstance,omitempty"`
	// CreateNetwork: Output only. If set, indicates that new network creation is
	// part of the operation.
	CreateNetwork *CreateNetwork `json:"createNetwork,omitempty"`
	// CreateNodeset: Output only. If set, indicates that new nodeset creation is
	// part of the operation.
	CreateNodeset *CreateNodeset `json:"createNodeset,omitempty"`
	// CreateOrchestrator: Output only. If set, indicates that orchestrator
	// creation is part of the operation.
	CreateOrchestrator *CreateOrchestrator `json:"createOrchestrator,omitempty"`
	// CreatePartition: Output only. If set, indicates that new partition creation
	// is part of the operation.
	CreatePartition *CreatePartition `json:"createPartition,omitempty"`
	// CreatePrivateServiceAccess: Output only. If set, indicates that new private
	// service access creation is part of the operation.
	CreatePrivateServiceAccess *CreatePrivateServiceAccess `json:"createPrivateServiceAccess,omitempty"`
	// CreateStorageBucket: Output only. If set, indicates that new Cloud Storage
	// bucket creation is part of the operation.
	CreateStorageBucket *CreateStorageBucket `json:"createStorageBucket,omitempty"`
	// DeleteFilestoreInstance: Output only. If set, indicates that Filestore
	// instance deletion is part of the operation.
	DeleteFilestoreInstance *DeleteFilestoreInstance `json:"deleteFilestoreInstance,omitempty"`
	// DeleteLoginNode: Output only. If set, indicates that login node deletion is
	// part of the operation.
	DeleteLoginNode *DeleteLoginNode `json:"deleteLoginNode,omitempty"`
	// DeleteLustreInstance: Output only. If set, indicates that Lustre instance
	// deletion is part of the operation.
	DeleteLustreInstance *DeleteLustreInstance `json:"deleteLustreInstance,omitempty"`
	// DeleteNetwork: Output only. If set, indicates that network deletion is part
	// of the operation.
	DeleteNetwork *DeleteNetwork `json:"deleteNetwork,omitempty"`
	// DeleteNodeset: Output only. If set, indicates that nodeset deletion is part
	// of the operation.
	DeleteNodeset *DeleteNodeset `json:"deleteNodeset,omitempty"`
	// DeleteOrchestrator: Output only. If set, indicates that orchestrator
	// deletion is part of the operation.
	DeleteOrchestrator *DeleteOrchestrator `json:"deleteOrchestrator,omitempty"`
	// DeletePartition: Output only. If set, indicates that partition deletion is
	// part of the operation.
	DeletePartition *DeletePartition `json:"deletePartition,omitempty"`
	// DeletePrivateServiceAccess: Output only. If set, indicates that private
	// service access deletion is part of the operation.
	DeletePrivateServiceAccess *DeletePrivateServiceAccess `json:"deletePrivateServiceAccess,omitempty"`
	// DeleteStorageBucket: Output only. If set, indicates that Cloud Storage
	// bucket deletion is part of the operation.
	DeleteStorageBucket *DeleteStorageBucket `json:"deleteStorageBucket,omitempty"`
	// State: Output only. State of the operation step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "WAITING" - Initial state before step execution starts.
	//   "IN_PROGRESS" - Step execution is running in progress.
	//   "DONE" - Step execution is completed.
	State string `json:"state,omitempty"`
	// UpdateLoginNode: Output only. If set, indicates that login node update is
	// part of the operation.
	UpdateLoginNode *UpdateLoginNode `json:"updateLoginNode,omitempty"`
	// UpdateNodeset: Output only. If set, indicates that nodeset update is part of
	// the operation.
	UpdateNodeset *UpdateNodeset `json:"updateNodeset,omitempty"`
	// UpdateOrchestrator: Output only. If set, indicates that an orchestrator
	// update is part of the operation.
	UpdateOrchestrator *UpdateOrchestrator `json:"updateOrchestrator,omitempty"`
	// UpdatePartition: Output only. If set, indicates that partition update is
	// part of the operation.
	UpdatePartition *UpdatePartition `json:"updatePartition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckClusterHealth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckClusterHealth") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationStep) MarshalJSON() ([]byte, error) {
	type NoMethod OperationStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Orchestrator: The component responsible for scheduling and running workloads
// on the cluster as well as providing the user interface for interacting with
// the cluster at runtime.
type Orchestrator struct {
	// Slurm: Optional. If set, indicates that the cluster should use Slurm as the
	// orchestrator.
	Slurm *SlurmOrchestrator `json:"slurm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Slurm") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Slurm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Orchestrator) MarshalJSON() ([]byte, error) {
	type NoMethod Orchestrator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlurmLoginNodes: Configuration for Slurm login nodes
// (https://slurm.schedmd.com/quickstart_admin.html#login) in the cluster.
// Login nodes are Compute Engine VM instances that allow users to access the
// cluster over SSH.
type SlurmLoginNodes struct {
	// BootDisk: Optional. Boot disk for the login node.
	BootDisk *BootDisk `json:"bootDisk,omitempty"`
	// Count: Required. Number of login node instances to create.
	Count int64 `json:"count,omitempty,string"`
	// EnableOsLogin: Optional. Whether OS Login
	// (https://cloud.google.com/compute/docs/oslogin) should be enabled on login
	// node instances.
	EnableOsLogin bool `json:"enableOsLogin,omitempty"`
	// EnablePublicIps: Optional. Whether login node instances should be assigned
	// external IP addresses
	// (https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
	EnablePublicIps bool `json:"enablePublicIps,omitempty"`
	// Instances: Output only. Information about the login node instances that were
	// created in Compute Engine.
	Instances []*ComputeInstance `json:"instances,omitempty"`
	// Labels: Optional. Labels
	// (https://cloud.google.com/compute/docs/labeling-resources) that should be
	// applied to each login node instance.
	Labels map[string]string `json:"labels,omitempty"`
	// MachineType: Required. Name of the Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-resource) to use for login
	// nodes, e.g. `n2-standard-2`.
	MachineType string `json:"machineType,omitempty"`
	// StartupScript: Optional. Startup script
	// (https://cloud.google.com/compute/docs/instances/startup-scripts/linux) to
	// be run on each login node instance. Max 256KB. The script must complete
	// within the system-defined default timeout of 5 minutes. For tasks that
	// require more time, consider running them in the background using methods
	// such as `&` or `nohup`.
	StartupScript string `json:"startupScript,omitempty"`
	// StorageConfigs: Optional. How storage resources should be mounted on each
	// login node.
	StorageConfigs []*StorageConfig `json:"storageConfigs,omitempty"`
	// Zone: Required. Name of the zone in which login nodes should run, e.g.,
	// `us-central1-a`. Must be in the same region as the cluster, and must match
	// the zone of any other resources specified in the cluster.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDisk") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDisk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlurmLoginNodes) MarshalJSON() ([]byte, error) {
	type NoMethod SlurmLoginNodes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlurmNodeSet: Configuration for Slurm nodesets in the cluster. Nodesets are
// groups of compute nodes used by Slurm that are responsible for running
// workloads submitted to the cluster.
type SlurmNodeSet struct {
	// ComputeId: Optional. ID of the compute resource on which this nodeset will
	// run. Must match a key in the cluster's compute_resources
	// (Cluster.compute_resources).
	ComputeId string `json:"computeId,omitempty"`
	// ComputeInstance: Optional. If set, indicates that the nodeset should be
	// backed by Compute Engine instances.
	ComputeInstance *ComputeInstanceSlurmNodeSet `json:"computeInstance,omitempty"`
	// Id: Required. Identifier for the nodeset, which allows it to be referenced
	// by partitions. Must conform to RFC-1034
	// (https://datatracker.ietf.org/doc/html/rfc1034) (lower-case, alphanumeric,
	// and at most 63 characters).
	Id string `json:"id,omitempty"`
	// MaxDynamicNodeCount: Optional. Controls how many additional nodes a cluster
	// can bring online to handle workloads. Set this value to enable dynamic node
	// creation and limit the number of additional nodes the cluster can bring
	// online. Leave empty if you do not want the cluster to create nodes
	// dynamically, and instead rely only on static nodes.
	MaxDynamicNodeCount int64 `json:"maxDynamicNodeCount,omitempty,string"`
	// StaticNodeCount: Optional. Number of nodes to be statically created for this
	// nodeset. The cluster will attempt to ensure that at least this many nodes
	// exist at all times.
	StaticNodeCount int64 `json:"staticNodeCount,omitempty,string"`
	// StorageConfigs: Optional. How storage resources should be mounted on each
	// compute node.
	StorageConfigs []*StorageConfig `json:"storageConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlurmNodeSet) MarshalJSON() ([]byte, error) {
	type NoMethod SlurmNodeSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlurmOrchestrator: When set in Orchestrator, indicates that the cluster
// should use Slurm (https://slurm.schedmd.com/) as the orchestrator.
type SlurmOrchestrator struct {
	// DefaultPartition: Optional. Default partition to use for submitted jobs that
	// do not explicitly specify a partition. Required if and only if there is more
	// than one partition, in which case it must match the id of one of the
	// partitions.
	DefaultPartition string `json:"defaultPartition,omitempty"`
	// EpilogBashScripts: Optional. Slurm epilog scripts
	// (https://slurm.schedmd.com/prolog_epilog.html), which will be executed by
	// compute nodes whenever a node finishes running a job. Values must not be
	// empty.
	EpilogBashScripts []string `json:"epilogBashScripts,omitempty"`
	// LoginNodes: Required. Configuration for login nodes, which allow users to
	// access the cluster over SSH.
	LoginNodes *SlurmLoginNodes `json:"loginNodes,omitempty"`
	// NodeSets: Required. Configuration of Slurm nodesets, which define groups of
	// compute resources that can be used by Slurm. At least one compute node is
	// required.
	NodeSets []*SlurmNodeSet `json:"nodeSets,omitempty"`
	// Partitions: Required. Configuration of Slurm partitions, which group one or
	// more nodesets. Acts as a queue against which jobs can be submitted. At least
	// one partition is required.
	Partitions []*SlurmPartition `json:"partitions,omitempty"`
	// PrologBashScripts: Optional. Slurm prolog scripts
	// (https://slurm.schedmd.com/prolog_epilog.html), which will be executed by
	// compute nodes before a node begins running a new job. Values must not be
	// empty.
	PrologBashScripts []string `json:"prologBashScripts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultPartition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultPartition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlurmOrchestrator) MarshalJSON() ([]byte, error) {
	type NoMethod SlurmOrchestrator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlurmPartition: Configuration for Slurm partitions in the cluster.
// Partitions are groups of nodesets, and are how clients specify where their
// workloads should be run.
type SlurmPartition struct {
	// Id: Required. ID of the partition, which is how users will identify it. Must
	// conform to RFC-1034 (https://datatracker.ietf.org/doc/html/rfc1034)
	// (lower-case, alphanumeric, and at most 63 characters).
	Id string `json:"id,omitempty"`
	// NodeSetIds: Required. IDs of the nodesets that make up this partition.
	// Values must match SlurmNodeSet.id.
	NodeSetIds []string `json:"nodeSetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlurmPartition) MarshalJSON() ([]byte, error) {
	type NoMethod SlurmPartition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageConfig: Description of how a storage resource should be mounted on a
// VM instance.
type StorageConfig struct {
	// Id: Required. ID of the storage resource to mount, which must match a key in
	// the cluster's storage_resources (Cluster.storage_resources).
	Id string `json:"id,omitempty"`
	// LocalMount: Required. A directory inside the VM instance's file system where
	// the storage resource should be mounted (e.g., `/mnt/share`).
	LocalMount string `json:"localMount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageResource: A resource representing a form of persistent storage that
// is accessible to compute resources in the cluster.
type StorageResource struct {
	// Bucket: Reference to a Google Cloud Storage bucket. Populated if and only if
	// the storage resource was configured to use Google Cloud Storage.
	Bucket *BucketReference `json:"bucket,omitempty"`
	// Config: Required. Immutable. Configuration for this storage resource, which
	// describes how it should be created or imported. This field only controls how
	// the storage resource is initially created or imported. Subsequent changes to
	// the storage resource should be made via the resource's API and will not be
	// reflected in the configuration.
	Config *StorageResourceConfig `json:"config,omitempty"`
	// Filestore: Reference to a Filestore instance. Populated if and only if the
	// storage resource was configured to use Filestore.
	Filestore *FilestoreReference `json:"filestore,omitempty"`
	// Lustre: Reference to a Managed Lustre instance. Populated if and only if the
	// storage resource was configured to use Managed Lustre.
	Lustre *LustreReference `json:"lustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageResource) MarshalJSON() ([]byte, error) {
	type NoMethod StorageResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageResourceConfig: Describes how a storage resource should be
// initialized. Each storage resource can either be imported from an existing
// Google Cloud resource or initialized when the cluster is created.
type StorageResourceConfig struct {
	// ExistingBucket: Optional. Immutable. If set, indicates that an existing
	// Cloud Storage bucket should be imported.
	ExistingBucket *ExistingBucketConfig `json:"existingBucket,omitempty"`
	// ExistingFilestore: Optional. Immutable. If set, indicates that an existing
	// Filestore instance should be imported.
	ExistingFilestore *ExistingFilestoreConfig `json:"existingFilestore,omitempty"`
	// ExistingLustre: Optional. Immutable. If set, indicates that an existing
	// Managed Lustre instance should be imported.
	ExistingLustre *ExistingLustreConfig `json:"existingLustre,omitempty"`
	// NewBucket: Optional. Immutable. If set, indicates that a new Cloud Storage
	// bucket should be created.
	NewBucket *NewBucketConfig `json:"newBucket,omitempty"`
	// NewFilestore: Optional. Immutable. If set, indicates that a new Filestore
	// instance should be created.
	NewFilestore *NewFilestoreConfig `json:"newFilestore,omitempty"`
	// NewLustre: Optional. Immutable. If set, indicates that a new Managed Lustre
	// instance should be created.
	NewLustre *NewLustreConfig `json:"newLustre,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExistingBucket") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExistingBucket") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StorageResourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateLoginNode: When set in OperationStep, indicates that a login node
// should be updated.
type UpdateLoginNode struct {
}

// UpdateNodeset: When set in OperationStep, indicates that a nodeset should be
// updated.
type UpdateNodeset struct {
	// Nodesets: Output only. Name of the nodeset to update
	Nodesets []string `json:"nodesets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Nodesets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Nodesets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateNodeset) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateNodeset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateOrchestrator: When set in OperationStep, indicates that an
// orchestrator should be updated.
type UpdateOrchestrator struct {
}

// UpdatePartition: When set in OperationStep, indicates that a partition
// should be updated.
type UpdatePartition struct {
	// Partitions: Output only. Name of the partition to update
	Partitions []string `json:"partitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Partitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Partitions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdatePartition) MarshalJSON() ([]byte, error) {
	type NoMethod UpdatePartition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsClustersCreateCall struct {
	s          *Service
	parent     string
	cluster    *Cluster
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Cluster in a given project and location.
//
//   - parent: Parent location in which the cluster should be created, in the
//     format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsClustersService) Create(parent string, cluster *Cluster) *ProjectsLocationsClustersCreateCall {
	c := &ProjectsLocationsClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.cluster = cluster
	return c
}

// ClusterId sets the optional parameter "clusterId": Required. ID of the
// cluster to create. Must conform to RFC-1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (lower-case, alphanumeric,
// and at most 63 characters).
func (c *ProjectsLocationsClustersCreateCall) ClusterId(clusterId string) *ProjectsLocationsClustersCreateCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. A random UUID is recommended. This request is idempotent if
// and only if `request_id` is provided.
func (c *ProjectsLocationsClustersCreateCall) RequestId(requestId string) *ProjectsLocationsClustersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.clusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Cluster.
//
//   - name: Name of the cluster to delete, in the format
//     `projects/{project}/locations/{location}/clusters/{cluster}`.
func (r *ProjectsLocationsClustersService) Delete(name string) *ProjectsLocationsClustersDeleteCall {
	c := &ProjectsLocationsClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. A random UUID is recommended. This request is idempotent if
// and only if `request_id` is provided.
func (c *ProjectsLocationsClustersDeleteCall) RequestId(requestId string) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.clusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Cluster.
//
//   - name: Name of the cluster to retrieve, in the format
//     `projects/{project}/locations/{location}/clusters/{cluster}`.
func (r *ProjectsLocationsClustersService) Get(name string) *ProjectsLocationsClustersGetCall {
	c := &ProjectsLocationsClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersGetCall) Context(ctx context.Context) *ProjectsLocationsClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.clusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Cluster.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersGetCall) Do(opts ...googleapi.CallOption) (*Cluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Cluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Clusters in a given project and location.
//
//   - parent: Parent location of the clusters to list, in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsClustersService) List(parent string) *ProjectsLocationsClustersListCall {
	c := &ProjectsLocationsClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter
// (https://google.aip.dev/160) to apply to the returned results.
func (c *ProjectsLocationsClustersListCall) Filter(filter string) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": How to order the resulting
// clusters. Must be one of the following strings: * `name` * `name desc` *
// `create_time` * `create_time desc` If not specified, clusters will be
// returned in an arbitrary order.
func (c *ProjectsLocationsClustersListCall) OrderBy(orderBy string) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of clusters
// to return. The service may return fewer than this value.
func (c *ProjectsLocationsClustersListCall) PageSize(pageSize int64) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous `ListClusters` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListClusters` must
// match the call that provided the page token.
func (c *ProjectsLocationsClustersListCall) PageToken(pageToken string) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersListCall) Context(ctx context.Context) *ProjectsLocationsClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.clusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClustersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsClustersListCall) Do(opts ...googleapi.CallOption) (*ListClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsClustersListCall) Pages(ctx context.Context, f func(*ListClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsClustersPatchCall struct {
	s          *Service
	name       string
	cluster    *Cluster
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single Cluster.
//
//   - name: Identifier. Relative resource name (https://google.aip.dev/122) of
//     the cluster, in the format
//     `projects/{project}/locations/{location}/clusters/{cluster}`.
func (r *ProjectsLocationsClustersService) Patch(name string, cluster *Cluster) *ProjectsLocationsClustersPatchCall {
	c := &ProjectsLocationsClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cluster = cluster
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. A random UUID is recommended. This request is idempotent if
// and only if `request_id` is provided.
func (c *ProjectsLocationsClustersPatchCall) RequestId(requestId string) *ProjectsLocationsClustersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask specifying which
// fields in the cluster to update. All paths must be specified explicitly -
// wildcards are not supported. At least one path must be provided.
func (c *ProjectsLocationsClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.clusters.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.clusters.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "hypercomputecluster.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "hypercomputecluster.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
