/**
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Component, ViewChild } from '@angular/core';
import { ReplConsoleComponent } from './repl_console/repl-console-component';


/**
 * Top level component for the CEL REPL app.
 */
@Component({
  standalone: false,
  selector: 'app-root',
  templateUrl: './app-component.html',
  styleUrls: ['./app-component.scss']
})
export class AppComponent {
  @ViewChild(ReplConsoleComponent)
  private console!: ReplConsoleComponent;

  submitConsole() {
    this.console.submit();
  }
}
