package main

import (
	"fmt"
	"os"
	"strconv"
	"strings"

	"github.com/git-town/git-town/tools/stats_release/connector"
	"github.com/git-town/git-town/tools/stats_release/console"
	"github.com/git-town/git-town/tools/stats_release/data"
	"github.com/git-town/git-town/tools/stats_release/git"
)

func main() {
	if len(os.Args) < 2 {
		fmt.Println("Usage: list_contributors <previous tag>")
		os.Exit(1)
	}
	lastRelease := git.LoadTag(os.Args[1])
	fmt.Printf("previous release %s was on %s\n", console.Green.Styled(lastRelease.Name), console.Cyan.Styled(lastRelease.ISOTime))
	contributors := data.NewUsers()
	gh := connector.NewConnector()

	closed := gh.ClosedIssues(lastRelease.ISOTime)

	fmt.Println("\n\nDETERMINING PARTICIPANTS IN CLOSED ISSUES")
	fmt.Println()
	contributors.AddUsers(gh.IssuesParticipants(closed.Issues, "issue"))

	fmt.Println("\n\nDETERMINING PARTICIPANTS IN CLOSED PULL REQUESTS")
	fmt.Println()
	contributors.AddUsers(gh.IssuesParticipants(closed.PullRequests, "PR"))

	// print statistics
	fmt.Println()
	fmt.Printf("%s shipped pull requests\n", console.Green.Styled(strconv.Itoa(len(closed.PullRequests))))
	fmt.Printf("%s resolved issues\n", console.Green.Styled(strconv.Itoa(len(closed.Issues))))
	users := contributors.Values()
	fmt.Printf("%s contributors:\n", console.Cyan.Styled(strconv.Itoa(len(users))))
	userNames := make([]string, len(users))
	for u, username := range users {
		userNames[u] = "@" + username
	}
	fmt.Println(strings.Join(userNames, ", "))
}
