Feature: sync stacked changes and update proposals

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME   | TYPE    | PARENT | LOCATIONS     |
      | parent | feature | main   | local, origin |
      | child  | feature | parent | local, origin |
      | other  | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE       |
      | main   | local, origin | main commit   |
      | parent | local, origin | parent commit |
      | child  | local, origin | child commit  |
      | other  | local, origin | other commit  |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE           | BODY        | URL                      |
      | 1  | parent        | main          | parent proposal | parent body | https://example.com/pr/1 |
      | 2  | child         | parent        | child proposal  | child body  | https://example.com/pr/2 |
      | 3  | other         | main          | other proposal  | other body  | https://example.com/pr/3 |
    And Git setting "git-town.proposal-breadcrumb" is "stacks"
    And Git setting "git-town.sync-feature-strategy" is "rebase"
    And the current branch is "child"
    When I run "git-town sync --stack"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                                |
      | child  | git fetch --prune --tags                                                               |
      |        | git checkout parent                                                                    |
      | parent | git -c rebase.updateRefs=false rebase --onto main {{ sha-initial 'initial commit' }}   |
      |        | git push --force-with-lease --force-if-includes                                        |
      |        | git checkout child                                                                     |
      | child  | git -c rebase.updateRefs=false rebase --onto parent {{ sha-initial 'initial commit' }} |
      |        | git push --force-with-lease --force-if-includes                                        |
      |        | Finding all proposals for child ... parent                                             |
      |        | Finding proposal from parent into main ... #1 (parent proposal)                        |
      |        | Finding proposal from child into parent ... #2 (child proposal)                        |
      |        | Update body for #2 ... ok                                                              |
      |        | Finding all proposals for other ... main                                               |
      |        | Update body for #3 ... ok                                                              |
      |        | Finding all proposals for parent ... main                                              |
      |        | Finding proposal from child into parent ... #2 (child proposal)                        |
      |        | Update body for #1 ... ok                                                              |
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: parent
      target: main
      body:
        parent body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:
            - https://example.com/pr/2

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/2
      number: 2
      source: child
      target: parent
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - https://example.com/pr/2 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: other
      target: main
      body:
        other body

        <!-- branch-stack-start -->

        <!-- branch-stack-end -->
      """

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                         |
      | child  | git reset --hard {{ sha-initial 'child commit' }}               |
      |        | git push --force-with-lease --force-if-includes                 |
      |        | git checkout parent                                             |
      | parent | git reset --hard {{ sha-initial 'parent commit' }}              |
      |        | git push --force-with-lease --force-if-includes                 |
      |        | git checkout child                                              |
      |        | Finding all proposals for child ... parent                      |
      |        | Finding proposal from parent into main ... #1 (parent proposal) |
      |        | Finding proposal from child into parent ... #2 (child proposal) |
      |        | Finding all proposals for other ... main                        |
      |        | Finding all proposals for parent ... main                       |
    And the initial branches and lineage exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: parent
      target: main
      body:
        parent body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:
            - https://example.com/pr/2

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/2
      number: 2
      source: child
      target: parent
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - https://example.com/pr/2 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: other
      target: main
      body:
        other body

        <!-- branch-stack-start -->

        <!-- branch-stack-end -->
      """
